#ifndef CYGONCE_SAM9_H
#define CYGONCE_SAM9_H
/*=============================================================================
//
//      sam9.h
//
//      Register layout, etc, for Atmel SAM9 CPU
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2003, 2004, 2005, 2007 Free Software Foundation, Inc.      
// Copyright (C) 2003, 2004, 2005, 2007 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2007-09-15
// Purpose:      Atmel SAM9 CPU variant definitions
// Description: 
// Usage:        #include <cyg/hal/sam9.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/hal_arm_arm9_sam9.h>

// On-chip peripherals - Atmel SAM9

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260) || \
    defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

#define SAM9_ECC        0xFFFFE800  // ECC controller
#define SAM9_SDRAM      0xFFFFEA00  // SDRAM controller
#define SAM9_SMC        0xFFFFEC00  // Static Memory controller
#define SAM9_MATRIX     0xFFFFEE00  // Bus Matrix
#define SAM9_CCFG       0xFFFFEF10  // 

#define SAM9_AIC        0xFFFFF000  // Advanced Interrupt Controller
#define SAM9_DEBUG      0xFFFFF200  // Debug uart 
#define SAM9_PIOA       0xFFFFF400  // PIO controller A
#define SAM9_PIOB       0xFFFFF600  // PIO controller B
#define SAM9_PIOC       0xFFFFF800  // PIO controller C
#define SAM9_PMC        0xFFFFFC00  // Power Management Controller
#define SAM9_RST        0xFFFFFD00  // Reset controller
#define SAM9_SHDC       0xFFFFFD10  // Shutdown controller
#define SAM9_RTTC       0xFFFFFD20  // Real Time Timer Controller
#define SAM9_PIT        0xFFFFFD30  // Periodic timer
#define SAM9_WDTC       0xFFFFFD40  // Watchdog
#define SAM9_GPBR       0xFFFFFD50  // General Purpose Backup Registers


#define SAM9_TC0        0xFFFA0000  // Timer/Counter #0
#define SAM9_TC1        0xFFFA0040  // Timer/Counter #1
#define SAM9_TC2        0xFFFA0080  // Timer/Counter #2
#define SAM9_USB        0xFFFA4000  // USB device
#define SAM9_MCI        0xFFFA8000  // Multimedia controller
#define SAM9_TWI        0xFFFAC000  // Two-wire interface
#define SAM9_UART0      0xFFFB0000
#define SAM9_UART1      0xFFFB4000
#define SAM9_UART2      0xFFFB8000
#define SAM9_SSC0       0xFFFBC000  // Synchronous serial controller
#define SAM9_EMAC       0xFFFC4000  // Ethernet SAM9260 only
#define SAM9_SPI        0xFFFC8000  // Serial Peripheral Interface

#define SAM9_UART3      0xFFFD0000
#define SAM9_UART4      0xFFFD4000
#define SAM9_UART5      0xFFFD8000

#define SAM9_TC3        0xFFFDC000  // Timer/Counter #3
#define SAM9_TC4        0xFFFDC040  // Timer/Counter #4
#define SAM9_TC5        0xFFFDC080  // Timer/Counter #5

#define SAM9_SSC1       0xFFFBC000
#define SAM9_SSC2       0xFFFD8000

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#define SAM9_ECC        0xFFFFE000  // ECC controller 0
#define SAM9_SDRAM      0xFFFFE200  // SDRAM controller 0
#define SAM9_SMC        0xFFFFE400  // Static Memory controller 0
#define SAM9_ECC1       0xFFFFE600  // ECC controller 1
#define SAM9_SDRAM1     0xFFFFE800  // SDRAM controller 1
#define SAM9_SMC1       0xFFFFEA00  // Static Memory controller 1
#define SAM9_MATRIX     0xFFFFEC00  // Bus Matrix
#define SAM9_CCFG       0xFFFFED20  // 
#define SAM9_CCFG1      0xFFFFED24  // 
#define SAM9_DEBUG      0xFFFFEE00  // Debug uart

#define SAM9_AIC        0xFFFFF000  // Advanced Interrupt Controller
#define SAM9_PIOA       0xFFFFF200  // PIO controller A
#define SAM9_PIOB       0xFFFFF400  // PIO controller B
#define SAM9_PIOC       0xFFFFF600  // PIO controller C
#define SAM9_PIOD       0xFFFFF800  // PIO controller D
#define SAM9_PIOE       0xFFFFFA00  // PIO controller E
#define SAM9_PMC        0xFFFFFC00  // Power Management Controller
#define SAM9_RST        0xFFFFFD00  // Reset controller
#define SAM9_SHDC       0xFFFFFD10  // Shutdown controller
#define SAM9_RTTC       0xFFFFFD20  // Real Time Timer Controller 0
#define SAM9_PIT        0xFFFFFD30  // Periodic timer
#define SAM9_WDTC       0xFFFFFD40  // Watchdog
#define SAM9_RTTC1      0xFFFFFD50  // Real Time Timer Controller 1
#define SAM9_GPBR       0xFFFFFD60  // General Purpose Backup Registers

#define SAM9_UDB        0xFFF78000  // USB device
#define SAM9_TC0        0xFFF7C000  // Timer/Counter #0
#define SAM9_TC1        0xFFF7C040  // Timer/Counter #1
#define SAM9_TC2        0xFFF7C080  // Timer/Counter #2
#define SAM9_MCI0       0xFFF80000  // Multimedia controller 0
#define SAM9_MCI1       0xFFF84000  // Multimedia controller 1
#define SAM9_TWI        0xFFF88000  // Two-wire interface
#define SAM9_UART0      0xFFF8C000
#define SAM9_UART1      0xFFF90000
#define SAM9_UART2      0xFFF94000
#define SAM9_SSC0       0xFFF98000  // Synchronous serial controller 0
#define SAM9_SSC1       0xFFF9C000  // Synchronous serial controller 1
#define SAM9_AC97       0xFFFA0000  // AC97 controller
#define SAM9_SPI        0xFFFA4000  // Serial Peripheral Interface 0
#define SAM9_SPI1       0xFFFA8000  // Serial Peripheral Interface 1
#define SAM9_CAN0       0xFFFAC000  // CAN Bus Controller
#define SAM9_PWM        0xFFFB8000  // PWM controller
#define SAM9_EMAC       0xFFFBC000  // Ethernet
#define SAM9_ISI        0xFFFC4000  // ISI Controller
#define SAM9_2DGE       0xFFFC8000  // 2D Graphics Engine

#define SAM9_USB        0xFFFA4000  // USB device

// Select specific MCI interface for driver
#define SAM9_MCI        CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263_MCI

#endif

//=============================================================================
// Advanced Interrupt Controller (AIC)

#define _AIC_SMR   (SAM9_AIC+0x0000) // Source Mode Register(s)
#define _AIC_SVR   (SAM9_AIC+0x0080) // Source Vector Register(s)
#define _AIC_IVR   (SAM9_AIC+0x0100) // IRQ Vector Register
#define _AIC_FVR   (SAM9_AIC+0x0104) // FIQ Vector Register
#define _AIC_ISR   (SAM9_AIC+0x0108) // Interrupt Status Register
#define _AIC_IPR   (SAM9_AIC+0x010C) // Interrupt Pending Register
#define _AIC_IMR   (SAM9_AIC+0x0110) // Interrupt Mask Register
#define _AIC_CISR  (SAM9_AIC+0x0114) // Core Interrupt Status Register
#define _AIC_IECR  (SAM9_AIC+0x0120) // Interrupt Enable Command Register
#define _AIC_IDCR  (SAM9_AIC+0x0124) // Interrupt Disable Command Register
#define _AIC_ICCR  (SAM9_AIC+0x0128) // Interrupt Clear Command Register
#define _AIC_ISCR  (SAM9_AIC+0x012C) // Interrupt Set Command Register
#define _AIC_EOICR (SAM9_AIC+0x0130) // End of Interrupt Command Register
#define _AIC_SPU   (SAM9_AIC+0x0134) // Spurious Vector Register
#define _AIC_DCR   (SAM9_AIC+0x0138) // Debug Control Register (Protect)
#define _AIC_FFER  (SAM9_AIC+0x0140) // Fast Forcing Enable Register
#define _AIC_FFDR  (SAM9_AIC+0x0144) // Fast Forcing Disable Register
#define _AIC_FFSR  (SAM9_AIC+0x0148) // Fast Forcing Status Register

// This is the offset from the top of memory to the IVR register.
// It is used in the irq_vector and fiq_vector macros in the platform
// HAL's hal_platform_setup.h to access the interrupt vectors in a single
// instruction from the IRQ and FIQ exception vectors.

#define _AIC_IVR_OFFSET              (0xffffffff-_AIC_IVR+1)
#define _AIC_FVR_OFFSET              (0xffffffff-_AIC_FVR+1)


//=============================================================================
// Power Management Controller (PMC) & Clock Generator (CKGR)

#define _PMC_SCER        (SAM9_PMC+0x00)   // System Clock Enable Register
#define   _PMC_SCER_PCK         (0x1<< 0)      //   Processor Clock
#define   _PMC_SCER_UDP         (0x1<< 1)      //   USB Device Port Clock
#define   _PMC_SCER_MCKUDP      (0x1<< 2)      //   USB Device Port Master Clock Automatic Disable on Suspend
#define   _PMC_SCER_UHP         (0x1<< 4)      //   USB Host Port Clock
#define   _PMC_SCER_PCK0        (0x1<< 8)      //   Programmable Clock Output
#define   _PMC_SCER_PCK1        (0x1<< 9)      //   Programmable Clock Output
#define   _PMC_SCER_PCK2        (0x1<<10)      //   Programmable Clock Output
#define   _PMC_SCER_PCK3        (0x1<<11)      //   Programmable Clock Output
#define   _PMC_SCER_PCK4        (0x1<<12)      //   Programmable Clock Output
#define   _PMC_SCER_PCK5        (0x1<<13)      //   Programmable Clock Output
#define   _PMC_SCER_PCK6        (0x1<<14)      //   Programmable Clock Output
#define   _PMC_SCER_PCK7        (0x1<<15)      //   Programmable Clock Output
#define _PMC_SCDR        (SAM9_PMC+0x04)   // System Clock Disable Register
#define _PMC_SCSR        (SAM9_PMC+0x08)   // System Clock Status Register
#define _PMC_PCER        (SAM9_PMC+0x10)   // Peripheral Clock Enable Register
#define _PMC_PCDR        (SAM9_PMC+0x14)   // Peripheral Clock Disable Register
#define _PMC_PCSR        (SAM9_PMC+0x18)   // Peripheral Clock Status Register
#define _CKGR_MOR        (SAM9_PMC+0x20)   // Main Oscillator Register
#define    _CKGR_MOR_MOSCEN     (0x1<< 0)      //   Main Oscillator Enable
#define    _CKGR_MOR_OSCTEST    (0x1<< 1)      //   Oscillator Test
#define    _CKGR_MOR_OSCOUNT    (0xFF<< 8)     //   Main Oscillator Start-up Time
#define _CKGR_MCFR       (SAM9_PMC+0x24)   // Main Clock Frequency Register
#define    _CKGR_MCFR_MAINF      (0xFFFF<< 0)  //   Main Clock Frequency
#define    _CKGR_MCFR_MAINRDY    (0x1<<16)     //   Main Clock Ready
#define _CKGR_PLLAR      (SAM9_PMC+0x28)   // PLL A Register
#define    _CKGR_PLLAR_DIVA       (0xFF<< 0)   //   Divider Selected
#define            _CKGR_PLLAR_DIVA_0      (0x0) //     Divider output is 0
#define            _CKGR_PLLAR_DIVA_BYPASS (0x1) //     Divider is bypassed
#define    _CKGR_PLLAR_PLLACOUNT  (0x3F<< 8)   //   PLL A Counter
#define    _CKGR_PLLAR_OUTA       (0x3<<14)    //   PLL A Output Frequency Range
#define            _CKGR_PLLAR_OUTA_0 (0x0<<14)
#define            _CKGR_PLLAR_OUTA_1 (0x1<<14)
#define            _CKGR_PLLAR_OUTA_2 (0x2<<14)
#define            _CKGR_PLLAR_OUTA_3 (0x3<<14)
#define    _CKGR_PLLAR_MULA       (0x7FF<<16)  //   PLL A Multiplier
#define    _CKGR_PLLAR_SRCA       (0x1<<29)    //   PLL A Source
#define _CKGR_PLLBR      (SAM9_PMC+0x2C)   // PLL B Register
#define    _CKGR_PLLBR_DIVB       (0xFF<< 0)   //   Divider Selected
#define            _CKGR_PLLBR_DIVB_0      (0x0) //     Divider output is 0
#define            _CKGR_PLLBR_DIVB_BYPASS (0x1) //     Divider is bypassed
#define    _CKGR_PLLBR_PLLBCOUNT  (0x3F<< 8)   //   PLL B Counter
#define    _CKGR_PLLBR_OUTB       (0x3<<14)    //   PLL B Output Frequency Range
#define            _CKGR_PLLBR_OUTB_0 (0x0<<14)
#define            _CKGR_PLLBR_OUTB_1 (0x1<<14)
#define            _CKGR_PLLBR_OUTB_2 (0x2<<14)
#define            _CKGR_PLLBR_OUTB_3 (0x3<<14)
#define    _CKGR_PLLBR_MULB       (0x7FF<<16)  //   PLL B Multiplier
#define    _CKGR_PLLBR_USB_96M    (0x1<<28)    //   Divider for USB Ports
#define    _CKGR_PLLBR_USB_PLL    (0x1<<29)    //   PLL Use
#define _PMC_MCKR        (SAM9_PMC+0x30)   // Master Clock Register
#define    _PMC_MCKR_CSS         (0x3<< 0)     //   Programmable Clock Selection
#define      _PMC_MCKR_CSS_SLOW_CLK        (0x0) //     Slow Clock is selected
#define      _PMC_MCKR_CSS_MAIN_CLK        (0x1) //     Main Clock is selected
#define      _PMC_MCKR_CSS_PLLA_CLK        (0x2) //     Clock from PLL A is selected
#define      _PMC_MCKR_CSS_PLLB_CLK        (0x3) //     Clock from PLL B is selected
#define    _PMC_MCKR_PRES        (0x7<< 2)     //   Programmable Clock Prescaler
#define      _PMC_MCKR_PRES_CLK      (0x0<< 2) //     Selected clock
#define      _PMC_MCKR_PRES_CLK_2    (0x1<< 2) //     Selected clock divided by 2
#define      _PMC_MCKR_PRES_CLK_4    (0x2<< 2) //     Selected clock divided by 4
#define      _PMC_MCKR_PRES_CLK_8    (0x3<< 2) //     Selected clock divided by 8
#define      _PMC_MCKR_PRES_CLK_16   (0x4<< 2) //     Selected clock divided by 16
#define      _PMC_MCKR_PRES_CLK_32   (0x5<< 2) //     Selected clock divided by 32
#define      _PMC_MCKR_PRES_CLK_64   (0x6<< 2) //     Selected clock divided by 64
#define    _PMC_MCKR_MDIV        (0x3<< 8)     //   Master Clock Division
#define      _PMC_MCKR_MDIV_1        (0x0<< 8) //     Processor clock == Master clock
#define      _PMC_MCKR_MDIV_2        (0x1<< 8) //     Processor clock == 2 * Master clock
#define      _PMC_MCKR_MDIV_3        (0x2<< 8) //     Processor clock == 3 * Master clock
#define      _PMC_MCKR_MDIV_4        (0x3<< 8) //     Processor clock == 4 *Master clock
#define _PMC_PCKR0       (SAM9_PMC+0x40)   // Programmable Clock Register
#define _PMC_PCKR1       (SAM9_PMC+0x44)   // Programmable Clock Register
#define _PMC_PCKR2       (SAM9_PMC+0x48)   // Programmable Clock Register
#define _PMC_PCKR3       (SAM9_PMC+0x4C)   // Programmable Clock Register
#define _PMC_PCKR4       (SAM9_PMC+0x50)   // Programmable Clock Register
#define _PMC_PCKR5       (SAM9_PMC+0x54)   // Programmable Clock Register
#define _PMC_PCKR6       (SAM9_PMC+0x58)   // Programmable Clock Register
#define _PMC_PCKR7       (SAM9_PMC+0x5C)   // Programmable Clock Register
#define _PMC_IER         (SAM9_PMC+0x60)   // Interrupt Enable Register
#define    _PMC_IER_MOSCS       (0x1<< 0)      //   MOSC Status/Enable/Disable/Mask
#define    _PMC_IER_LOCKA       (0x1<< 1)      //   PLL A Status/Enable/Disable/Mask
#define    _PMC_IER_LOCKB       (0x1<< 2)      //   PLL B Status/Enable/Disable/Mask
#define    _PMC_IER_MCKRDY      (0x1<< 3)      //   MCK_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK0RDY     (0x1<< 8)      //   PCK0_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK1RDY     (0x1<< 9)      //   PCK1_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK2RDY     (0x1<<10)      //   PCK2_RDY Status/Enable/Disable/Mask
#define    _PMC_IER_PCK3RDY     (0x1<<11)      //   PCK3_RDY Status/Enable/Disable/Mask
#define _PMC_IDR         (SAM9_PMC+0x64)   // Interrupt Disable Register
#define _PMC_SR          (SAM9_PMC+0x68)   // Status Register
#define    _PMC_SR_MOSCS        _PMC_IER_MOSCS
#define    _PMC_SR_LOCKA        _PMC_IER_LOCKA
#define    _PMC_SR_LOCKB        _PMC_IER_LOCKB
#define    _PMC_SR_MCKRDY       _PMC_IER_MCKRDY
#define    _PMC_SR_PCK0RDY      _PMC_IER_PCK0RDY
#define    _PMC_SR_PCK1RDY      _PMC_IER_PCK1RDY
#define    _PMC_SR_PCK2RDY      _PMC_IER_PCK2RDY
#define    _PMC_SR_PCK3RDY      _PMC_IER_PCK3RDY
#define _PMC_IMR         (SAM9_PMC+0x6C)   // Interrupt Mask Register

//=============================================================================
// MATRIX

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260) || \
    defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261) || \
    defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260) || defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#define AT91_MATRIX_MCFG0       0x00    //  Master Configuration Register 0
#define AT91_MATRIX_MCFG1       0x04    //  Master Configuration Register 1
#define AT91_MATRIX_MCFG2       0x08    //  Master Configuration Register 2
#define AT91_MATRIX_MCFG3       0x0c    //  Master Configuration Register 3
#define AT91_MATRIX_MCFG4       0x10    //  Master Configuration Register 4
#define AT91_MATRIX_MCFG5       0x14    //  Master Configuration Register 5
#define AT91_MATRIX_MCFG6       0x18    //  Master Configuration Register 6 - SAM9263 only
#define AT91_MATRIX_MCFG7       0x1c    //  Master Configuration Register 7 - SAM9263 only
#define AT91_MATRIX_MCFG8       0x20    //  Master Configuration Register 8 - SAM9263 only

#define AT91_MATRIX_SCFG0       0x40    //  Slave Configuration Register 0
#define AT91_MATRIX_SCFG1       0x44    //  Slave Configuration Register 1
#define AT91_MATRIX_SCFG2       0x48    //  Slave Configuration Register 2
#define AT91_MATRIX_SCFG3       0x4c    //  Slave Configuration Register 3
#define AT91_MATRIX_SCFG4       0x50    //  Slave Configuration Register 4
#define AT91_MATRIX_SCFG5       0x54    //  Slave Configuration Register 5 - SAM9263 only
#define AT91_MATRIX_SCFG6       0x58    //  Slave Configuration Register 6 - SAM9263 only
#define AT91_MATRIX_SCFG7       0x5c    //  Slave Configuration Register 7 - SAM9263 only

#define AT91_MATRIX_PRAS0       0x80    //  Priority Register A for Slave 0
#define AT91_MATRIX_PRAS1       0x88    //  Priority Register A for Slave 1
#define AT91_MATRIX_PRAS2       0x90    //  Priority Register A for Slave 2
#define AT91_MATRIX_PRAS3       0x98    //  Priority Register A for Slave 3
#define AT91_MATRIX_PRAS4       0xa0    //  Priority Register A for Slave 4
#define AT91_MATRIX_PRAS5       0xa8    //  Priority Register A for Slave 5 - SAM9263 only
#define AT91_MATRIX_PRAS6       0xb0    //  Priority Register A for Slave 6 - SAM9263 only
#define AT91_MATRIX_PRAS7       0xb8    //  Priority Register A for Slave 7 - SAM9263 only

#define AT91_MATRIX_MRCR        0x100   //  Master Remap Control Register
#define AT91_MATRIX_EBICSA      0x11c   //  EBI Chip Select Assignment Register

#define AT91_MATRIX_MCFG_ULBT_INFINITE  0x00  // MCFGx Undefined Length Burst Type - infinite length burst
#define AT91_MATRIX_MCFG_ULBT_SINGLE    0x01  // MCFGx Undefined Length Burst Type - single access
#define AT91_MATRIX_MCFG_ULBT_4BEAT     0x02  // MCFGx Undefined Length Burst Type - four beat burst
#define AT91_MATRIX_MCFG_ULBT_8BEAT     0x03  // MCFGx Undefined Length Burst Type - eight beat burst
#define AT91_MATRIX_MCFG_ULBT_16BEAT    0x04  // MCFGx Undefined Length Burst Type - sixteen beat burst

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

#define AT91_MATRIX_MCFG        0x00    //  Master Configuration Register
#define AT91_MATRIX_SCFG0       0x04    //  Slave Configuration Register 0
#define AT91_MATRIX_SCFG1       0x08    //  Slave Configuration Register 1
#define AT91_MATRIX_SCFG2       0x0c    //  Slave Configuration Register 2
#define AT91_MATRIX_SCFG3       0x10    //  Slave Configuration Register 3
#define AT91_MATRIX_SCFG4       0x14    //  Slave Configuration Register 4
#define AT91_MATRIX_TCMR        0x24    //  Slave 0 Special Function Register
#define AT91_MATRIX_EBICSA      0x30    //  Slave 3 Special Function Register
#define AT91_MATRIX_USBPCR      0x34    //  Slave 4 Special Function Register


#define AT91_MATRIX_MCFG_RCA926I                (1<<0) // Remap Command for ARM926EJ-S Instruction Master
#define AT91_MATRIX_MCFG_RCA926D                (1<<1) // Remap Command for ARM926EJ-S Data Master

#endif

#define AT91_MATRIX_SCFG_SLOT_CYCLE             (0xFF<<0) // Maximum Number of Allowed Cycles for a Burst
#define AT91_MATRIX_SCFG_DEFMSTR_TYPE           (0x3<<16) // Default Master Type

#define AT91_MATRIX_SCFG_DEFMSTR_TYPE_NO_DEFMSTR           (0x0<<16) // No Default Master. 
#define AT91_MATRIX_SCFG_DEFMSTR_TYPE_LAST_DEFMSTR         (0x1<<16) // Last Default Master. 
#define AT91_MATRIX_SCFG_DEFMSTR_TYPE_FIXED_DEFMSTR        (0x2<<16) // Fixed Default Master. 

#define AT91_MATRIX_SCFG_FIXED_DEFMSTR          (0x7<<18) // Fixed Index of Default Master
#define AT91_MATRIX_SCFG_FIXED_DEFMSTR_ARM926I  (0x0<<18) // ARM926EJ-S Instruction Master is Default Master
#define AT91_MATRIX_SCFG_FIXED_DEFMSTR_ARM926D  (0x1<<18) // ARM926EJ-S Data Master is Default Master
#define AT91_MATRIX_SCFG_FIXED_DEFMSTR_HPDC3    (0x2<<18) // HPDC3 Master is Default Master
#define AT91_MATRIX_SCFG_FIXED_DEFMSTR_LCDC     (0x3<<18) // LCDC Master is Default Master
#define AT91_MATRIX_SCFG_FIXED_DEFMSTR_UHP      (0x4<<18) // UHP Master is Default Master

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260) || defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#define AT91_MATRIX_SCFG_ARBT                   (0x3<<24) // Arbitration Type
#define AT91_MATRIX_SCFG_ARBT_RR                (0x0<<24) // Round-Robin Arbitration
#define AT91_MATRIX_SCFG_ARBT_FIXED             (0x1<<24) // Fixed Priority Arbitration

// Priority Register A
#define AT91_MATRIX_PRAS_M0PR                   (0x3<<0)  // Master 0 Priority
#define AT91_MATRIX_PRAS_M1PR                   (0x3<<4)  // Master 1 Priority
#define AT91_MATRIX_PRAS_M2PR                   (0x3<<8)  // Master 2 Priority
#define AT91_MATRIX_PRAS_M3PR                   (0x3<<12) // Master 3 Priority
#define AT91_MATRIX_PRAS_M4PR                   (0x3<<16) // Master 4 Priority
#define AT91_MATRIX_PRAS_M5PR                   (0x3<<20) // Master 5 Priority
#define AT91_MATRIX_PRAS_M6PR                   (0x3<<24) // Master 6 Priority
#define AT91_MATRIX_PRAS_M7PR                   (0x3<<28) // Master 7 Priority

// Priority Register B
#define AT91_MATRIX_PRAS_M8PR                   (0x3<<0)  // Master 8 Priority

#define AT91_MATRIX_MRCR_RCB                    (0x3<<0)  // Master Remap Command bits
#define AT91_MATRIX_MRCR_RCB_DISABLE_0          (0<<0)    //   Disable remapped address decoding for master 0
#define AT91_MATRIX_MRCR_RCB_ENABLE_0           (1<<0)    //   Enable remapped address decoding for master 0
#define AT91_MATRIX_MRCR_RCB_DISABLE_1          (0<<1)    //   Disable remapped address decoding for master 1
#define AT91_MATRIX_MRCR_RCB_ENABLE_1           (1<<1)    //   Enable remapped address decoding for master 1

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

#define AT91_MATRIX_TCMR_ITCM_SIZE              (0xF<<0) // Size of ITCM enabled memory block
#define AT91_MATRIX_TCMR_ITCM_SIZE_0KB          (0x0) // 0 KB (No ITCM Memory)
#define AT91_MATRIX_TCMR_ITCM_SIZE_16KB         (0x5) // 16 KB
#define AT91_MATRIX_TCMR_ITCM_SIZE_32KB         (0x6) // 32 KB
#define AT91_MATRIX_TCMR_ITCM_SIZE_64KB         (0x7) // 64 KB
#define AT91_MATRIX_TCMR_DTCM_SIZE              (0xF<<4) // Size of DTCM enabled memory block
#define AT91_MATRIX_TCMR_DTCM_SIZE_0KB          (0x0<<4) // 0 KB (No DTCM Memory)
#define AT91_MATRIX_TCMR_DTCM_SIZE_16KB         (0x5<<4) // 16 KB
#define AT91_MATRIX_TCMR_DTCM_SIZE_32KB         (0x6<<4) // 32 KB
#define AT91_MATRIX_TCMR_DTCM_SIZE_64KB         (0x7<<4) // 64 KB

#endif


#define AT91_MATRIX_EBICSA_CS1A         (0x1<<1) // Chip Select 1 Assignment
#define AT91_MATRIX_EBICSA_CS1A_SMC     (0x0<<1) // CS1 assigned to the Static Memory Controller.
#define AT91_MATRIX_EBICSA_CS1A_SDRAMC  (0x1<<1) // CS1 assigned to the SDRAM Controller.

#define AT91_MATRIX_EBICSA_CS3A         (0x1<<3) // Chip Select 3 Assignment
#define AT91_MATRIX_EBICSA_CS3A_SMC     (0x0<<3) // CS3 only assigned to the Static Memory Controller and NCS3 behaves as defined by the SMC.
#define AT91_MATRIX_EBICSA_CS3A_SM      (0x1<<3) // CS3 assigned to the Static Memory Controller and the SmartMedia Logic is activated.

#define AT91_MATRIX_EBICSA_CS4A         (0x1<<4) // Chip Select 4 Assignment
#define AT91_MATRIX_EBICSA_CS4A_SMC     (0x0<<4) // CS4 only assigned to the Static Memory Controller and NCS4 behaves as defined by the SMC.
#define AT91_MATRIX_EBICSA_CS4A_CF      (0x1<<4) // CS4 assigned to the Static Memory Controller and the CompactFlash Logic (first slot) is activated.

#define AT91_MATRIX_EBICSA_CS5A         (0x1<<5) // Chip Select 5 Assignment
#define AT91_MATRIX_EBICSA_CS5A_SMC     (0x0<<5) // CS5 only assigned to the Static Memory Controller and NCS5 behaves as defined by the SMC
#define AT91_MATRIX_EBICSA_CS5A_CF      (0x1<<5) // CS5 assigned to the Static Memory Controller and the CompactFlash Logic (second slot) is activated.

#define AT91_MATRIX_EBICSA_DBPUC        (0x1<<8) // Data Bus Pull-up Configuration

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

#define AT91_MATRIX_EBI1CSA_CS1A        (0x1<<1) // Chip Select 1 Assignment
#define AT91_MATRIX_EBI1CSA_CS1A_SMC    (0x0<<1) // CS1 assigned to the Static Memory Controller.
#define AT91_MATRIX_EBI1CSA_CS1A_SDRAMC (0x1<<1) // CS1 assigned to the SDRAM Controller.

#define AT91_MATRIX_EBI1CSA_CS2A        (0x1<<1) // Chip Select 1 Assignment
#define AT91_MATRIX_EBI1CSA_CS2A_SMC    (0x0<<1) // CS2 assigned to the Static Memory Controller.
#define AT91_MATRIX_EBI1CSA_CS2A_SM     (0x1<<3) // CS2 assigned to the Static Memory Controller and the SmartMedia Logic is activated.

#endif

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260) || defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)
#define AT91_MATRIX_EBICSA_VDDIOMSEL    (0x1<<16) // Memory voltage selection: 0=1.8V, 1=3.3V
#endif

#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

#define AT91_MATRIX_USBPCR_PUON         (0x1<<30) // PullUp On
#define AT91_MATRIX_USBPCR_PUIDLE       (0x1<<31) // PullUp Idle

#endif

#endif // if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260) || defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

//=============================================================================
// SDRAM controller

#define AT91_SDRAMC_MR                  (SAM9_SDRAM+0x00)    // Mode Register
#define AT91_SDRAMC_TR                  (SAM9_SDRAM+0x04)    // Refresh Timer Register
#define AT91_SDRAMC_CR                  (SAM9_SDRAM+0x08)    // Configuration Register
#define AT91_SDRAMC_LPR                 (SAM9_SDRAM+0x10)    // Low Power Register
#define AT91_SDRAMC_IER                 (SAM9_SDRAM+0x14)    // Interrupt Enable Register
#define AT91_SDRAMC_IDR                 (SAM9_SDRAM+0x18)    // Interrupt Disable Register
#define AT91_SDRAMC_IMR                 (SAM9_SDRAM+0x1c)    // Interrupt Mask Register
#define AT91_SDRAMC_ISR                 (SAM9_SDRAM+0x20)    // Interrupt Status Register
#define AT91_SDRAMC_MDR                 (SAM9_SDRAM+0x24)    // Memory Device Register

#define AT91_SDRAMC_MR_MODE             (0x7 << 0)           // Command Mode
#define AT91_SDRAMC_MR_MODE_NORMAL_CMD  (0x0)                //   Normal Mode
#define AT91_SDRAMC_MR_MODE_NOP_CMD     (0x1)                //   NOP Command
#define AT91_SDRAMC_MR_MODE_PRCGALL_CMD (0x2)                //   All Banks Precharge Command
#define AT91_SDRAMC_MR_MODE_LMR_CMD     (0x3)                //   Load Mode Register Command
#define AT91_SDRAMC_MR_MODE_RFSH_CMD    (0x4)                //   Auto-Refresh Command
#define AT91_SDRAMC_MR_MODE_ELMR_CMD    (0x5)                //   Extended Load Mode Register Command
#define AT91_SDRAMC_MR_MODE_PWRDWN_CMD  (0x6)                //   Deep Power-Down Command

#define AT91_SDRAMC_TR_COUNT            (0xfff<<0)           // Refresh timer count

#define AT91_SDRAMC_CR_NC               (0x3 << 0)           //   Number of Column Bits
#define AT91_SDRAMC_CR_NC_8             (0x0)                //     8 Bits
#define AT91_SDRAMC_CR_NC_9             (0x1)                //     9 Bits
#define AT91_SDRAMC_CR_NC_10            (0x2)                //     10 Bits
#define AT91_SDRAMC_CR_NC_11            (0x3)                //     11 Bits
#define AT91_SDRAMC_CR_NR               (0x3 << 2)           //   Number of Row Bits
#define AT91_SDRAMC_CR_NR_11            (0x0 << 2)           //     11 Bits
#define AT91_SDRAMC_CR_NR_12            (0x1 << 2)           //     12 Bits
#define AT91_SDRAMC_CR_NR_13            (0x2 << 2)           //     13 Bits
#define AT91_SDRAMC_CR_NB               (0x1 << 4)           //   Number of Banks
#define AT91_SDRAMC_CR_NB_2_BANKS       (0x0 << 4)           //     2 banks
#define AT91_SDRAMC_CR_NB_4_BANKS       (0x1 << 4)           //     4 banks
#define AT91_SDRAMC_CR_CAS              (0x3 << 5)           //   CAS Latency
#define AT91_SDRAMC_CR_CAS_1            (0x1 << 5)           //     1 cycles
#define AT91_SDRAMC_CR_CAS_2            (0x2 << 5)           //     2 cycles
#define AT91_SDRAMC_CR_CAS_3            (0x3 << 5)           //     3 cycles
#define AT91_SDRAMC_CR_DBW              (0x1 << 7)           //   Data Bus Width
#define AT91_SDRAMC_CR_DBW_32           (0x0 << 7)           //     32-bit Data Bus
#define AT91_SDRAMC_CR_DBW_16           (0x1 << 7)           //     16-bit Data Bus
#define AT91_SDRAMC_CR_TWR(_twr)        (((_twr)&0xF) << 8)  //   Write Recovery Delay
#define AT91_SDRAMC_CR_TRC(_trc)        (((_trc)&0xF) << 12) //   Row Cycle Delay
#define AT91_SDRAMC_CR_TRP(_trp)        (((_trp)&0xF) << 16) //   Row Precharge Delay
#define AT91_SDRAMC_CR_TRCD(_trcd)      (((_trcd)&0xF) << 20)//   Row to Column Delay
#define AT91_SDRAMC_CR_TRAS(_tras)      (((_tras)&0xF) << 24)//   Active to Precharge Delay
#define AT91_SDRAMC_CR_TXSR(_txsr)      (((_txsr)&0xF) << 28)//   Exit Self Refresh to Active Delay

#define AT91_SDRAMC_LPR_LPCB            (0x3 << 0)           // Low-Power Configuration Bits
#define AT91_SDRAMC_LPR_LPCB_DISABLE    (0x0 << 0)           //   Low-Power feature inhibited
#define AT91_SDRAMC_LPR_LPCB_REFRESH    (0x1 << 0)           //   Auto self-refresh between accesses
#define AT91_SDRAMC_LPR_LPCB_PWRDWN     (0x2 << 0)           //   Power Down between accesses
#define AT91_SDRAMC_LPR_LPCB_DEEPPWRDWN (0x3 << 0)           //   Deep Power Down

#define AT91_SDRAMC_LPR_PASR            (0x7 << 4)           // Partial Array self-refresh
#define AT91_SDRAMC_LPR_TCSR            (0x3 << 8)           // Temperature Compensated Self-refresh
#define AT91_SDRAMC_LPR_DS              (0x3 << 10)          // Drive Strength
#define AT91_SDRAMC_LPR_TIMEOUT         (0x3 << 12)          // Timeout before low-power mode enabled
#define AT91_SDRAMC_LPR_TIMEOUT_IMM     (0x0 << 12)          //   Enter LP mode immediately after end of transfer
#define AT91_SDRAMC_LPR_TIMEOUT_64      (0x1 << 12)          //   Enter LP mode 64 cycles after end of transfer
#define AT91_SDRAMC_LPR_TIMEOUT_128     (0x2 << 12)          //   Enter LP mode 128 cycles after end of transfer

#define AT91_SDRAMC_IER_RES             (0x1 << 0)           // Refresh Error Status interrupt enable
#define AT91_SDRAMC_IDR_RES             (0x1 << 0)           // Refresh Error Status interrupt disable
#define AT91_SDRAMC_IMR_RES             (0x1 << 0)           // Refresh Error Status interrupt is enabled
#define AT91_SDRAMC_ISR_RES             (0x1 << 0)           // Refresh Error Status interrupt detected

#define AT91_SDRAMC_MDR_MD              (0x3 << 0)           // Memory Device Type
#define AT91_SDRAMC_MDR_MD_SDRAM        (0x0 << 0)           //   SDRAM
#define AT91_SDRAMC_MDR_MD_LPSDRAM      (0x1 << 0)           //   Low-power SDRAM

//=============================================================================
// Static Memory controller

#define AT91_SMC_CS0                    0x00
#define AT91_SMC_CS1                    0x10
#define AT91_SMC_CS2                    0x20
#define AT91_SMC_CS3                    0x30
#define AT91_SMC_CS4                    0x40
#define AT91_SMC_CS5                    0x50
#define AT91_SMC_CS6                    0x60
#define AT91_SMC_CS7                    0x70


#define AT91_SMC_SETUP                  0               //  Setup Register
#define AT91_SMC_PULSE                  4               //  Pulse Register
#define AT91_SMC_CYCLE                  8               //  Cycle Register
#define AT91_SMC_MODE                   12              //  Mode  Register

// Setup Register
#define AT91_SMC_NWESETUP               (0x3F<<0)       // NWE Setup Length
#define AT91_SMC_NCSSETUPWR             (0x3F<<8)       // NCS Setup Length in WRite Access
#define AT91_SMC_NRDSETUP               (0x3F<<16)      // NRD Setup Length
#define AT91_SMC_NCSSETUPRD             (0x3F<<24)      // NCS Setup Length in ReaD Access

// Pulse Register
#define AT91_SMC_NWEPULSE               (0x7F<<0)       // NWE Pulse Length
#define AT91_SMC_NCSPULSEWR             (0x7F<<8)       // NCS Pulse Length in WRite Access
#define AT91_SMC_NRDPULSE               (0x7F<<16)      // NRD Pulse Length
#define AT91_SMC_NCSPULSERD             (0x7F<<24)      // NCS Pulse Length in ReaD Access

// Cycle Register
#define AT91_SMC_NWECYCLE               (0x1FF<<0)      // Total Write Cycle Length
#define AT91_SMC_NRDCYCLE               (0x1FF<<16)     // Total Read Cycle Length

// Mode Register
#define AT91_SMC_MODE_READ              (0x1<<0)        // Read Mode
#define AT91_SMC_MODE_WRITE             (0x1<<1)        // Write Mode
#define AT91_SMC_MODE_NWAIT             (0x3<<5)        // NWAIT Mode
#define AT91_SMC_MODE_NWAIT_DISABLE     (0x0<<5)        // NWAIT disabled.
#define AT91_SMC_MODE_NWAIT_ENABLE_FROZEN (0x2<<5)      // NWAIT enabled in frozen mode.
#define AT91_SMC_MODE_NWAIT_ENABLE_READY (0x3<<5)       // NWAIT enabled in ready mode.
#define AT91_SMC_MODE_BAT               (0x1<<  8)      // Byte Access Type
#define AT91_SMC_MODE_BAT_BYTE_SELECT   (0x0<<8)        // Byte select mode
#define AT91_SMC_MODE_BAT_BYTE_WRITE    (0x1<<8)        // Byte write mode
#define AT91_SMC_MODE_DBW               (0x3<< 12)      // Data Bus Width
#define AT91_SMC_MODE_DBW_8             (0x0<<12)       // 8 bits.
#define AT91_SMC_MODE_DBW_16            (0x1<<12)       // 16 bits.
#define AT91_SMC_MODE_DBW_32            (0x2<<12)       // 32 bits.
#define AT91_SMC_MODE_TDF               (0xF<<16)       // Data Float Time.
#define AT91_SMC_MODE_TDFEN             (0x1<<20)       // TDF Enabled.
#define AT91_SMC_MODE_PMEN              (0x1<<24)       // Page Mode Enabled.
#define AT91_SMC_MODE_PS                (0x3<<28)       // Page Size
#define AT91_SMC_MODE_PS_4              (0x0<<28)       // 4 bytes.
#define AT91_SMC_MODE_PS_8              (0x1<<28)       // 8 bytes.
#define AT91_SMC_MODE_PS_16             (0x2<<28)       // 16 bytes.
#define AT91_SMC_MODE_PS_32             (0x3<<28)       // 32 bytes.


//=============================================================================
// Parallel I/O (PIO) (offsets only because there are more than one)

#define _PIO_PER    0x00  // PIO Enable Register
#define _PIO_PDR    0x04  // PIO Disable Register
#define _PIO_PSR    0x08  // PIO Status Register
#define _PIO_OER    0x10  // Output Enable Register
#define _PIO_ODR    0x14  // Output Disable Registerr
#define _PIO_OSR    0x18  // Output Status Register
#define _PIO_IFER   0x20  // Input Filter Enable Register
#define _PIO_IFDR   0x24  // Input Filter Disable Register
#define _PIO_IFSR   0x28  // Input Filter Status Register
#define _PIO_SODR   0x30  // Set Output Data Register
#define _PIO_CODR   0x34  // Clear Output Data Register
#define _PIO_ODSR   0x38  // Output Data Status Register
#define _PIO_PDSR   0x3C  // Pin Data Status Register
#define _PIO_IER    0x40  // Interrupt Enable Register
#define _PIO_IDR    0x44  // Interrupt Disable Register
#define _PIO_IMR    0x48  // Interrupt Mask Register
#define _PIO_ISR    0x4C  // Interrupt Status Register
#define _PIO_MDER   0x50  // Multi-driver Enable Register
#define _PIO_MDDR   0x54  // Multi-driver Disable Register
#define _PIO_MDSR   0x58  // Multi-driver Status Register
#define _PIO_PUDR   0x60  // Pull-up Disable Register
#define _PIO_PUER   0x64  // Pull-up Enable Register
#define _PIO_PUSR   0x68  // Pad Pull-up Status Register
#define _PIO_ASR    0x70  // Select A Register
#define _PIO_BSR    0x74  // Select B Register
#define _PIO_ABSR   0x78  // AB Select Status Register
#define _PIO_OWER   0x80  // Output Write Enable Register
#define _PIO_OWDR   0x84  // Output Write Disable Register
#define _PIO_OWSR   0x88  // Output Write Status Register

// Incorrect register names, preserved for compatibility
#define _PIO_PPUDR  0x60  // Pull-up Disable Register
#define _PIO_PPUER  0x64  // Pull-up Enable Register
#define _PIO_PPUSR  0x68  // Pad Pull-up Status Register

//=============================================================================
// UART (offsets only because there are more than one)

#define _UART_CR            0x0000  // Control register
#define    _UART_CR_RSTRX    (0x1<< 2) // Reset Receiver
#define    _UART_CR_RSTTX    (0x1<< 3) // Reset Transmitter
#define    _UART_CR_RXEN     (0x1<< 4) // Receiver Enable
#define    _UART_CR_RXDIS    (0x1<< 5) // Receiver Disable
#define    _UART_CR_TXEN     (0x1<< 6) // Transmitter Enable
#define    _UART_CR_TXDIS    (0x1<< 7) // Transmitter Disable
#define    _UART_CR_RSTSTA   (0x1<< 8) // Reset Status Bits
#define    _UART_CR_STTBRK   (0x1<< 9) // Start Break
#define    _UART_CR_STPBRK   (0x1<<10) // Stop Break
#define    _UART_CR_STTTO    (0x1<<11) // Start Time-out
#define    _UART_CR_SENDA    (0x1<<12) // Send Address
#define    _UART_CR_RSTIT    (0x1<<13) // Reset Iterations
#define    _UART_CR_RSTNACK  (0x1<<14) // Reset Non Acknowledge
#define    _UART_CR_RETTO    (0x1<<15) // Rearm Time-out
#define    _UART_CR_DTREN    (0x1<<16) // Data Terminal ready Enable
#define    _UART_CR_DTRDIS   (0x1<<17) // Data Terminal ready Disable
#define    _UART_CR_RTSEN    (0x1<<18) // Request to Send enable
#define    _UART_CR_RTSDIS   (0x1<<19) // Request to Send Disable
#define _UART_MR            0x0004  // Mode register
#define    _UART_MR_USMODE       (0xF<< 0) // Usart mode
#define       _UART_MR_USMODE_NORMAL     (0x0) // Normal
#define       _UART_MR_USMODE_RS485      (0x1) // RS485
#define       _UART_MR_USMODE_HWHSH      (0x2) // Hardware Handshaking
#define       _UART_MR_USMODE_MODEM      (0x3) // Modem
#define       _UART_MR_USMODE_ISO7816_0  (0x4) // ISO7816 protocol: T = 0
#define       _UART_MR_USMODE_ISO7816_1  (0x6) // ISO7816 protocol: T = 1
#define       _UART_MR_USMODE_IRDA       (0x8) // IrDA
#define       _UART_MR_USMODE_SWHSH      (0xC) // Software Handshaking
#define    _UART_MR_CLKS         (0x3<< 4) // Clock Selection (Baud Rate generator Input Clock
#define       _UART_MR_CLKS_CLOCK        (0x0<< 4) // Clock
#define       _UART_MR_CLKS_FDIV1        (0x1<< 4) // fdiv1
#define       _UART_MR_CLKS_SLOW         (0x2<< 4) // slow_clock (ARM)
#define       _UART_MR_CLKS_EXT          (0x3<< 4) // External (SCK)
#define    _UART_MR_CHRL         (0x3<< 6) // Clock Selection (Baud Rate generator Input Clock
#define       _UART_MR_CHRL_5_BITS       (0x0<< 6) // Character Length: 5 bits
#define       _UART_MR_CHRL_6_BITS       (0x1<< 6) // Character Length: 6 bits
#define       _UART_MR_CHRL_7_BITS       (0x2<< 6) // Character Length: 7 bits
#define       _UART_MR_CHRL_8_BITS       (0x3<< 6) // Character Length: 8 bits
#define    _UART_MR_SYNC         (0x1<< 8) // Synchronous Mode Select
#define    _UART_MR_PAR          (0x7<< 9) // Parity type
#define       _UART_MR_PAR_EVEN          (0x0<< 9) // Even Parity
#define       _UART_MR_PAR_ODD           (0x1<< 9) // Odd Parity
#define       _UART_MR_PAR_SPACE         (0x2<< 9) // Parity forced to 0 (Space)
#define       _UART_MR_PAR_MARK          (0x3<< 9) // Parity forced to 1 (Mark)
#define       _UART_MR_PAR_NONE          (0x4<< 9) // No Parity
#define       _UART_MR_PAR_MULTI_DROP    (0x6<< 9) // Multi-drop mode
#define    _UART_MR_NBSTOP       (0x3<<12) // Number of Stop bits
#define       _UART_MR_NBSTOP_1_BIT      (0x0<<12) // 1 stop bit
#define       _UART_MR_NBSTOP_15_BIT     (0x1<<12) // Asynchronous (SYNC=0) 2 stop bits 
                                                   // Synchronous (SYNC=1) 2 stop bits
#define       _UART_MR_NBSTOP_2_BIT      (0x2<<12) // 2 stop bits
#define    _UART_MR_CHMODE       (0x3<<14) // Channel Mode
#define       _UART_MR_CHMODE_NORMAL     (0x0<<14) // Normal Mode: The USART channel operates as an RX/TX USART.
#define       _UART_MR_CHMODE_AUTO       (0x1<<14) // Automatic Echo: Rx Data Input is connected to the TXD pin.
#define       _UART_MR_CHMODE_LOCAL      (0x2<<14) // Local Loopback: Tx Output is connected to Rx Input
#define       _UART_MR_CHMODE_REMOTE     (0x3<<14) // Remote Loopback: RXD pin is internally connected to TXD pin.
#define    _UART_MR_MSBF         (0x1<<16) // Bit Order
#define    _UART_MR_MODE9        (0x1<<17) // 9-bit Character length
#define    _UART_MR_CKLO         (0x1<<18) // Clock Output Select
#define    _UART_MR_OVER         (0x1<<19) // Over Sampling Mode
#define    _UART_MR_INACK        (0x1<<20) // Inhibit Non Acknowledge
#define    _UART_MR_DSNACK       (0x1<<21) // Disable Successive NACK
#define    _UART_MR_MAX_ITER     (0x1<<24) // Number of Repetitions
#define    _UART_MR_FILTER       (0x1<<28) // Receive Line Filter
#define _UART_IER           0x0008  // Interrupt enable
#define _UART_IDR           0x000C  // Interrupt diable
#define _UART_IMR           0x0010  // Interrupt mask
#define    _UART_IER_RXRDY        (0x1<< 0) // RXRDY Interrupt
#define    _UART_IER_TXRDY        (0x1<< 1) // TXRDY Interrupt
#define    _UART_IER_RXBRK        (0x1<< 2) // Break Received/End of Break
#define    _UART_IER_ENDRX        (0x1<< 3) // End of Receive Transfer Interrupt
#define    _UART_IER_ENDTX        (0x1<< 4) // End of Transmit Interrupt
#define    _UART_IER_OVRE         (0x1<< 5) // Overrun Interrupt
#define    _UART_IER_FRAME        (0x1<< 6) // Framing Error Interrupt
#define    _UART_IER_PARE         (0x1<< 7) // Parity Error Interrupt
#define    _UART_IER_TIMEOUT      (0x1<< 8) // Receiver Time-out
#define    _UART_IER_TXEMPTY      (0x1<< 9) // TXEMPTY Interrupt
#define    _UART_IER_ITERATION    (0x1<<10) // Max number of Repetitions Reached
#define    _UART_IER_TXBUFE       (0x1<<11) // TXBUFE Interrupt
#define    _UART_IER_RXBUFF       (0x1<<12) // RXBUFF Interrupt
#define    _UART_IER_NACK         (0x1<<13) // Non Acknowledge
#define    _UART_IER_RIIC         (0x1<<16) // Ring INdicator Input Change Flag
#define    _UART_IER_DSRIC        (0x1<<17) // Data Set Ready Input Change Flag
#define    _UART_IER_DCDIC        (0x1<<18) // Data Carrier Flag
#define    _UART_IER_CTSIC        (0x1<<19) // Clear To Send Input Change Flag
#define    _UART_IER_COMM_TX      (0x1<<30) // COMM_TX Interrupt
#define    _UART_IER_COMM_RX      (0x1<<31) // COMM_RX Interrupt
#define _UART_CSR           0x0014  // Status
#define    _UART_CSR_CTS      (1<<23)
#define    _UART_CSR_DCD      (1<<22)
#define    _UART_CSR_DSR      (1<<21)
#define    _UART_CSR_RI       (1<<20)
#define    _UART_CSR_CTSIC    (1<<19)
#define    _UART_CSR_DCDIC    (1<<18)
#define    _UART_CSR_DSRIC    (1<<17)
#define    _UART_CSR_RIIC     (1<<16)
#define    _UART_CSR_NACK     (1<<13)
#define    _UART_CSR_RxBUFF   (1<<12)
#define    _UART_CSR_TxBUFE   (1<<11)
#define    _UART_CSR_ITER     (1<<10)
#define    _UART_CSR_TxEMPTY   (1<<9)
#define    _UART_CSR_TIMEOUT   (1<<8)
#define    _UART_CSR_PARE      (1<<7)
#define    _UART_CSR_FRAME     (1<<6)
#define    _UART_CSR_OVRE      (1<<5)
#define    _UART_CSR_ENDTx     (1<<4)
#define    _UART_CSR_ENDRx     (1<<3)
#define    _UART_CSR_RxBRK     (1<<2)
#define    _UART_CSR_TxRDY     (1<<1)
#define    _UART_CSR_RxRDY     (1<<0)
#define _UART_RHR           0x0018  // Receiver holding register
#define _UART_THR           0x001C  // Transmitter holding register
#define _UART_BRG           0x0020  // Baud rate generator
#define _UART_RTO           0x0024  // Receiver time-out
#define _UART_TTG           0x0028  // Transmit timeguard
#define _UART_FRR           0x0040  // FI/DI ratio
#define _UART_NER           0x0044  // Error counter
#define _UART_IF            0x004C  // IrDA filter

//=============================================================================
// The following are aliases of the UART definitions for the benefit
// of the AT91 serial device driver.

#define AT91_DEBUG      SAM9_DEBUG
#define AT91_USART0     SAM9_UART0
#define AT91_USART1     SAM9_UART1
#define AT91_USART2     SAM9_UART2
#define AT91_USART3     SAM9_UART3

#define AT91_US_CR  _UART_CR
#define AT91_US_CR_RxRESET (1<<2)
#define AT91_US_CR_TxRESET (1<<3)
#define AT91_US_CR_RxENAB  (1<<4)
#define AT91_US_CR_RxDISAB (1<<5)
#define AT91_US_CR_TxENAB  (1<<6)
#define AT91_US_CR_TxDISAB (1<<7)
#define AT91_US_CR_RSTATUS (1<<8)
#define AT91_US_CR_STTTO   (1<<11)
#define AT91_US_CR_RTSEN   (1<<18)
#define AT91_US_CR_RTSDIS  (1<<19)
#define AT91_US_MR  _UART_MR  // Mode register
#define AT91_US_MR_USMODE 0      // USART mode
#define AT91_US_MR_USMODE_NORMAL      _UART_MR_USMODE_NORMAL     // Normal
#define AT91_US_MR_USMODE_RS485       _UART_MR_USMODE_RS485      // RS485
#define AT91_US_MR_USMODE_HWHSH       _UART_MR_USMODE_HWHSH      // Hardware Handshaking
#define AT91_US_MR_USMODE_MODEM       _UART_MR_USMODE_MODEM      // Modem
#define AT91_US_MR_USMODE_ISO7816_0   _UART_MR_USMODE_ISO7816_0  // ISO7816 protocol: T = 0
#define AT91_US_MR_USMODE_ISO7816_1   _UART_MR_USMODE_ISO7816_1  // ISO7816 protocol: T = 1
#define AT91_US_MR_USMODE_IRDA        _UART_MR_USMODE_IRDA       // IrDA
#define AT91_US_MR_CLOCK   4
#define AT91_US_MR_CLOCK_MCK  (0<<AT91_US_MR_CLOCK)
#define AT91_US_MR_CLOCK_MCK8 (1<<AT91_US_MR_CLOCK)
#define AT91_US_MR_CLOCK_SCK  (2<<AT91_US_MR_CLOCK)
#define AT91_US_MR_LENGTH  6
#define AT91_US_MR_LENGTH_5   (0<<AT91_US_MR_LENGTH)
#define AT91_US_MR_LENGTH_6   (1<<AT91_US_MR_LENGTH)
#define AT91_US_MR_LENGTH_7   (2<<AT91_US_MR_LENGTH)
#define AT91_US_MR_LENGTH_8   (3<<AT91_US_MR_LENGTH)
#define AT91_US_MR_SYNC    8
#define AT91_US_MR_SYNC_ASYNC (0<<AT91_US_MR_SYNC)
#define AT91_US_MR_SYNC_SYNC  (1<<AT91_US_MR_SYNC)
#define AT91_US_MR_PARITY  9
#define AT91_US_MR_PARITY_EVEN  (0<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_ODD   (1<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_SPACE (2<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_MARK  (3<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_NONE  (4<<AT91_US_MR_PARITY)
#define AT91_US_MR_PARITY_MULTI (6<<AT91_US_MR_PARITY)
#define AT91_US_MR_STOP   12
#define AT91_US_MR_STOP_1       (0<<AT91_US_MR_STOP)
#define AT91_US_MR_STOP_1_5     (1<<AT91_US_MR_STOP)
#define AT91_US_MR_STOP_2       (2<<AT91_US_MR_STOP)
#define AT91_US_MR_MODE   14
#define AT91_US_MR_MODE_NORMAL  (0<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE_ECHO    (1<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE_LOCAL   (2<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE_REMOTE  (3<<AT91_US_MR_MODE)
#define AT91_US_MR_MODE9  17
#define AT91_US_MR_CLKO   18
#define AT91_US_IER _UART_IER  // Interrupt enable register
#define AT91_US_IER_RxRDY   (1<<0)  // Receive data ready
#define AT91_US_IER_TxRDY   (1<<1)  // Transmitter ready
#define AT91_US_IER_RxBRK   (1<<2)  // Break received
#define AT91_US_IER_ENDRX   (1<<3)  // Rx end
#define AT91_US_IER_ENDTX   (1<<4)  // Tx end
#define AT91_US_IER_OVRE    (1<<5)  // Rx overflow
#define AT91_US_IER_FRAME   (1<<6)  // Rx framing error
#define AT91_US_IER_PARITY  (1<<7)  // Rx parity
#define AT91_US_IER_TIMEOUT (1<<8)  // Rx timeout
#define AT91_US_IER_TxEMPTY (1<<9)  // Tx empty
#define AT91_US_IER_CTSIC   (1<<19)  // CTS change
#define AT91_US_IDR _UART_IDR  // Interrupt disable register
#define AT91_US_IMR _UART_IMR  // Interrupt mask register
#define AT91_US_CSR _UART_CSR  // Channel status register
#define AT91_US_CSR_RxRDY 0x01 // Receive data ready
#define AT91_US_CSR_TxRDY 0x02 // Transmit ready
#define AT91_US_CSR_OVRE  0x20 // Overrun error
#define AT91_US_CSR_FRAME 0x40 // Framing error
#define AT91_US_CSR_CTS   (1<<23)  // CTS value
#define AT91_US_RHR _UART_RHR  // Receive holding register
#define AT91_US_THR _UART_THR  // Transmit holding register
#define AT91_US_BRG _UART_BRG  // Baud rate generator
#define AT91_US_RTO _UART_RTO  // Receive time out
#define AT91_US_TTG _UART_TTG  // Transmit timer guard
#define AT91_US_RPR 0x100      // Receive pointer register
#define AT91_US_RCR 0x104      // Receive counter register
#define AT91_US_TPR 0x108      // Transmit pointer register
#define AT91_US_TCR 0x10C      // Transmit counter register
#define AT91_US_RNPR 0x110      // Receive pointer register
#define AT91_US_RNCR 0x114      // Receive counter register
#define AT91_US_PTCR 0x120     // Transfer control register

#define AT91_US_BAUD(n) (((CYGARC_HAL_ARM_ARM9_SAM9_MCK)/16)/n)

#define CYGNUM_HAL_INTERRUPT_USART0 CYGNUM_HAL_INTERRUPT_US0
#define CYGNUM_HAL_INTERRUPT_USART1 CYGNUM_HAL_INTERRUPT_US1
#define CYGNUM_HAL_INTERRUPT_USART2 CYGNUM_HAL_INTERRUPT_US2
#define CYGNUM_HAL_INTERRUPT_USART3 CYGNUM_HAL_INTERRUPT_US3

// The following macros are also used by the SPI and MMC drivers
#define AT91_PDC_RX_ENABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0001 )
#define AT91_PDC_RX_DISABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0002 )
#define AT91_PDC_TX_ENABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0100 )
#define AT91_PDC_TX_DISABLE( __base ) HAL_WRITE_UINT32( (__base)+AT91_US_PTCR, 0x0200 )

//=============================================================================
// MultiMedia Card Interface (MCI)

#define _MCI_CR                        (SAM9_MCI+0x00)
#define    _MCI_CR_MCIEN                  (1<<0)
#define    _MCI_CR_MCIDIS                 (1<<1)
#define    _MCI_CR_PWSEN                  (1<<2)
#define    _MCI_CR_PWSDIS                 (1<<3)
#define    _MCI_CR_SWRST                  (1<<7)
#define _MCI_MR                        (SAM9_MCI+0x04)
#define    _MCI_MR_CLKDIV(__mr)           ((__mr) & 0xff)
#define    _MCI_MR_PWSDIV(__mr)           (((__mr)>>8) & 0x7)
#define    _MCI_MR_PWSDIV_SET(__pws)      (((__pws)& 0x7) << 8)
#define    _MCI_MR_PDCPADV                (1<<14)
#define    _MCI_MR_PDCMODE                (1<<15)
#define    _MCI_MR_BLKLEN(__mr)           (((__mr) >> 16) & 0x3fff)
#define    _MCI_MR_BLKLEN_SET(__blklen)   (((__blklen) & 0x3fff) << 16)
#define _MCI_DTOR                      (SAM9_MCI+0x08)
#define    _MCI_DTOR_DTOCYC(__dtor)       ((__dtor) & 0xf)
#define    _MCI_DTOR_DTOMUL_1             (0 << 4)
#define    _MCI_DTOR_DTOMUL_16            (1 << 4)
#define    _MCI_DTOR_DTOMUL_128           (2 << 4)
#define    _MCI_DTOR_DTOMUL_256           (3 << 4)
#define    _MCI_DTOR_DTOMUL_1024          (4 << 4)
#define    _MCI_DTOR_DTOMUL_4096          (5 << 4)
#define    _MCI_DTOR_DTOMUL_65536         (6 << 4)
#define    _MCI_DTOR_DTOMUL_1048576       (7 << 4)
#define _MCI_SDCR                      (SAM9_MCI+0x0C)
#define    _MCI_SDCR_SDCSEL_A             (0)
#define    _MCI_SDCR_SDCSEL_B             (1)
#define    _MCI_SDCBUS_1BIT               (0 << 7)
#define    _MCI_SDCBUS_4BIT               (1 << 7)
#define _MCI_ARGR                      (SAM9_MCI+0x10)
#define _MCI_CMDR                      (SAM9_MCI+0x14)
#define    _MCI_CMDR_CMDNB(__cmdr)        ((__cmdr) & 0x3f)
#define    _MCI_CMDR_RSPTYP_N             (0 << 6)
#define    _MCI_CMDR_RSPTYP_48            (1 << 6)
#define    _MCI_CMDR_RSPTYP_136           (2 << 6)
#define    _MCI_CMDR_SPCMD_N              (0 << 8)
#define    _MCI_CMDR_SPCMD_INIT           (1 << 8)
#define    _MCI_CMDR_SPCMD_SYNC           (2 << 8)
#define    _MCI_CMDR_SPCMD_INTC           (4 << 8)
#define    _MCI_CMDR_SPCMD_INTR           (5 << 8)
#define    _MCI_CMDR_OPDCMD               (1 << 11)
#define    _MCI_CMDR_MAXLAT_5             (0 << 12)
#define    _MCI_CMDR_MAXLAT_64            (1 << 12)
#define    _MCI_CMDR_TRCMD_N              (0 << 16)
#define    _MCI_CMDR_TRCMD_START          (1 << 16)
#define    _MCI_CMDR_TRCMD_STOP           (2 << 16)
#define    _MCI_CMDR_TRDIR_WRITE          (0 << 18)
#define    _MCI_CMDR_TRDIR_READ           (1 << 18)
#define    _MCI_CMDR_TRTYPE_BLOCK         (0 << 19)
#define    _MCI_CMDR_TRTYPE_MBLOCK        (1 << 19)
#define    _MCI_CMDR_TRTYPE_STREAM        (2 << 19)
#define _MCI_RSPR                      (SAM9_MCI+0x20)
#define _MCI_RSPR1                     (SAM9_MCI+0x24)
#define _MCI_RSPR2                     (SAM9_MCI+0x28)
#define _MCI_RSPR3                     (SAM9_MCI+0x2C)
#define _MCI_RDR                       (SAM9_MCI+0x30)
#define _MCI_TDR                       (SAM9_MCI+0x34)
#define _MCI_SR                        (SAM9_MCI+0x40)
#define    _MCI_SR_CMDRDY                 (1 << 0)
#define    _MCI_SR_RXRDY                  (1 << 1)
#define    _MCI_SR_TXRDY                  (1 << 2)
#define    _MCI_SR_BLKE                   (1 << 3)
#define    _MCI_SR_DTIP                   (1 << 4)
#define    _MCI_SR_NOTBUSY                (1 << 5)
#define    _MCI_SR_ENDRX                  (1 << 6)
#define    _MCI_SR_ENDTX                  (1 << 7)
#define    _MCI_SR_RXBUFF                 (1 << 14)
#define    _MCI_SR_TXBUFE                 (1 << 15)
#define    _MCI_SR_RINDE                  (1 << 16)
#define    _MCI_SR_RDIRE                  (1 << 17)
#define    _MCI_SR_RCRCE                  (1 << 18)
#define    _MCI_SR_RENDE                  (1 << 19)
#define    _MCI_SR_RTOE                   (1 << 20)
#define    _MCI_SR_DCRCE                  (1 << 21)
#define    _MCI_SR_DTOE                   (1 << 22)
#define    _MCI_SR_OVRE                   (1 << 30)
#define    _MCI_SR_UNRE                   (1 << 31)
#define _MCI_IER                       (SAM9_MCI+0x44)
#define _MCI_IDR                       (SAM9_MCI+0x48)
#define _MCI_IMR                       (SAM9_MCI+0x4C)

// PDC registers for MCI
#define _MCI_PDC_RPR           0x100             // Receive Pointer Register
#define _MCI_PDC_RCR           0x104             // Receive Counter Register
#define _MCI_PDC_TPR           0x108             // Transmit Pointer Register
#define _MCI_PDC_TCR           0x10C             // Transmit Counter Register
#define _MCI_PDC_PTCR          0x120             // Transfer control register

//=============================================================================
// Two Wire Interface

#define _TWI_CR                 (SAM9_TWI+0x00)
#define    _TWI_CR_START        (1<<0)
#define    _TWI_CR_STOP         (1<<1)
#define    _TWI_CR_MSEN         (1<<2)
#define    _TWI_CR_MDIS         (1<<3)
#define    _TWI_CR_SWRST        (1<<7)
#define _TWI_MMR                (SAM9_TWI+0x04)
#define    _TWI_MMR_IADRSZ_0    (0<<8)
#define    _TWI_MMR_IADRSZ_1    (1<<8)
#define    _TWI_MMR_IADRSZ_2    (2<<8)
#define    _TWI_MMR_IADRSZ_3    (3<<8)
#define    _TWI_MMR_MREAD       (1<<12)
#define    _TWI_MMR_DADR(__daddr)    (((__daddr)&0x7f)<<16)
#define _TWI_IADR               (SAM9_TWI+0x0c)
#define _TWI_CWGR               (SAM9_TWI+0x10)
#define    _TWI_CWGR_CLDIV(__cldiv)  (((__cldiv)&0xff)<<0)
#define    _TWI_CWGR_CHDIV(__chdiv)  (((__chdiv)&0xff)<<8)
#define    _TWI_CWGR_CKDIV(__ckdiv)  (((__ckdiv)&0x7)<<16)
#define _TWI_SR                 (SAM9_TWI+0x20)
#define    _TWI_SR_TXCOMP       (1<<0)
#define    _TWI_SR_RXRDY        (1<<1)
#define    _TWI_SR_TXRDY        (1<<2)
#define    _TWI_SR_OVRE         (1<<6)
#define    _TWI_SR_UNRE         (1<<7)
#define    _TWI_SR_NACK         (1<<8)
#define _TWI_IER                (SAM9_TWI+0x24)
#define _TWI_IDR                (SAM9_TWI+0x28)
#define _TWI_IMR                (SAM9_TWI+0x2c)
#define _TWI_RHR                (SAM9_TWI+0x30)
#define _TWI_THR                (SAM9_TWI+0x34)


#define AT91_TWI                SAM9_TWI

#define AT91_TWI_CR   0x00 // Control
#define AT91_TWI_CR_START (1 << 0) // Send a Start
#define AT91_TWI_CR_STOP  (1 << 1) // Send a Stop
#define AT91_TWI_CR_MSEN  (1 << 2) // Master Transfer Enable
#define AT91_TWI_CR_MSDIS (1 << 3) // Master Transfer Disable
#define AT91_TWI_CR_SVEN  (1 << 4) // Slave Transfer Enable
#define AT91_TWI_CR_SDIS  (1 << 5) // Slave Transfer Disable
#define AT91_TWI_CR_SWRST (1 << 7) // Software Reset
#define AT91_TWI_MMR  0x04 // Master Mode
#define AT91_TWI_MMR_IADRZ_NO (0 <<  8) // Internal Device Address size 0Bytes
#define AT91_TWI_MMR_IADRZ_1  (1 <<  8) // Internal Device Address size 1Byte
#define AT91_TWI_MMR_IADRZ_2  (2 <<  8) // Internal Device Address size 2Bytes
#define AT91_TWI_MMR_IADRZ_3  (3 <<  8) // Internal Device Address size 3Bytes
#define AT91_TWI_MMR_MWRITE   (0 << 12) // Master Write
#define AT91_TWI_MMR_MREAD    (1 << 12) // Master Read
#define AT91_TWI_MMR_DADR_MASK  (0x7f << 16) // Device Address Mask
#define AT91_TWI_MMR_DADR_SHIFT (16)         // Device Address Shift
#define AT91_TWI_MMR_DADR(__daddr)    (((__daddr)&0x7f)<<16)
#define AT91_TWI_SMR  0x08 // Slave Mode
#define AT91_TWI_SMR_SADR_MASK  (0x3f << 16) // Slave Device Address Mask
#define AT91_TWI_SMR_SADR_SHIFT (16)         // Slave Device Address Shift
#define AT91_TWI_IADR 0x0C // Internal Address
#define AT91_TWI_CWGR 0x10 // Clock Waveform Generator
#define AT91_TWI_CWGR_CLDIV_MASK  (0xff <<  0) // Clock Low Divider Mask
#define AT91_TWI_CWGR_CLDIV_SHIFT (00)        // Clock Low Divider Shift
#define AT91_TWI_CWGR_CHDIV_MASK  (0xff <<  8) // Clock High Divider Mask
#define AT91_TWI_CWGR_CHDIV_SHIFT (08)        // Clock High Divider Shift
#define AT91_TWI_CWGR_CKDIV_MASK  (0x07 << 16) // Clock Divider Mask
#define AT91_TWI_CWGR_CKDIV_SHIFT (16)        // Clock Divider Shift
#define AT91_TWI_CWGR_CLDIV(__cldiv)  (((__cldiv)&0xff)<<0)
#define AT91_TWI_CWGR_CHDIV(__chdiv)  (((__chdiv)&0xff)<<8)
#define AT91_TWI_CWGR_CKDIV(__ckdiv)  (((__ckdiv)&0x7)<<16)
#define AT91_TWI_SR   0x20 // Status
#define AT91_TWI_SR_TXCOMP (1 << 0) // Transmission Completed
#define AT91_TWI_SR_RXRDY  (1 << 1) // Receiver Holding Register Ready
#define AT91_TWI_SR_TXRDY  (1 << 2) // Transmit Holding Register Ready
#define AT91_TWI_SR_SVREAD (1 << 3) // Slave Read
#define AT91_TWI_SR_SVACC  (1 << 4) // Slave Access
#define AT91_TWI_SR_GCACC  (1 << 5) // General Call Access
#define AT91_TWI_SR_OVRE   (1 << 6) // Overrun Error
#define AT91_TWI_SR_UNRE   (1 << 7) // Underrun Error
#define AT91_TWI_SR_NACK   (1 << 8) // Not Acknowledged
#define AT91_TWI_SR_ARBLST (1 << 9) // Arbitration Lost
#define AT91_TWI_IER  0x24 // Interrupt Enable
#define AT91_TWI_IDR  0x28 // Interrupt Disable
#define AT91_TWI_IMR  0x2C // Interrupt Mask
#define AT91_TWI_RHR  0x30 // Receiver Holding
#define AT91_TWI_THR  0x34 // Transmit Holding


//=============================================================================
// Ethernet
//
// These are named to match the requirements of the AT91 ethernet
// controller, which is shared with the SAM7X.

#define AT91_EMAC       SAM9_EMAC

#define AT91_EMAC_NCR  (0x00) // Network Control
#define AT91_EMAC_NCR_LB     (1 <<  0) // Loopback
#define AT91_EMAC_NCR_LBL    (1 <<  1) // Loopback Local 
#define AT91_EMAC_NCR_RE     (1 <<  2) // Receiver Enable
#define AT91_EMAC_NCR_TX     (1 <<  3) // Transmit Enable
#define AT91_EMAC_NCR_MPE    (1 <<  4) // Management Port Enable
#define AT91_EMAC_NCR_CSR    (1 <<  5) // Clear Statistics Registers
#define AT91_EMAC_NCR_ISR    (1 <<  6) // Increment Statistics Registers
#define AT91_EMAC_NCR_WES    (1 <<  7) // Write Enable for Statistics Registers
#define AT91_EMAC_NCR_BP     (1 <<  8) // Back Pressure 
#define AT91_EMAC_NCR_TSTART (1 <<  9) // Start Transmitter
#define AT91_EMAC_NCR_THALT  (1 << 10) // Halt Transmitter

#define AT91_EMAC_NCFG  (0x04) // Network Configuration
#define AT91_EMAC_NCFG_SPD_10Mbps  (0 <<  0) // 10Mbps line speed
#define AT91_EMAC_NCFG_SPD_100Mbps (1 <<  0) // 100Mbps line speed
#define AT91_EMAC_NCFG_FD          (1 <<  1) // Full Deplex
#define AT91_EMAC_NCFG_BR          (1 <<  2) // Bit Rate
#define AT91_EMAC_NCFG_CAF         (1 <<  4) // Copy All Frames
#define AT91_EMAC_NCFG_NBC         (1 <<  5) // Don't receiver Broadcasts
#define AT91_EMAC_NCFG_MTI         (1 <<  6) // Multicast Hash Enable
#define AT91_EMAC_NCFG_UNI         (1 <<  7) // Unicast hash enable
#define AT91_EMAC_NCFG_BIG         (1 <<  8) // Receive upto 1522 byte frames
#define AT91_EMAC_NCFG_EAE         (1 <<  9) // External Address match Enable
#define AT91_EMAC_NCFG_CLK_HCLK_8  (0 << 10) // HCLK divided by 8
#define AT91_EMAC_NCFG_CLK_HCLK_16 (1 << 10) // HCLK divided by 16
#define AT91_EMAC_NCFG_CLK_HCLK_32 (2 << 10) // HCLK divided by 32
#define AT91_EMAC_NCFG_CLK_HCLK_64 (3 << 10) // HCLK divided by 64
#define AT91_EMAC_NCFG_CLK_MASK    (3 << 10) // HCLK mask
#define AT91_EMAC_NCFG_CLK_RTY     (1 << 12) // Retry Test
#define AT91_EMAC_NCFG_CLK_RMII    (1 << 13) // Enable RMII mode
#define AT91_EMAC_NCFG_CLK_MII     (0 << 13) // Enable MII mode
#define AT91_EMAC_NCFG_RLCE        (1 << 16) // Receive Length Check Enable
#define AT91_EMAC_NCFG_DRFCS       (1 << 17) // Discard Received FCS

#define AT91_EMAC_NSR   (0x08) // Network Status
#define AT91_EMAC_NSR_MDIO_MASK (1 << 1) // MDIO Pin status
#define AT91_EMAC_NSR_IDLE      (1 << 2) // PHY logical is idle

#define AT91_EMAC_TSR  (0x14) // Transmit Status
#define AT91_EMAC_TSR_UBR    (1 << 0) // Used Bit Read
#define AT91_EMAC_TSR_COL    (1 << 1) // Collision occurred
#define AT91_EMAC_TSR_RLE    (1 << 2) // Retry Limit Exceeded
#define AT91_EMAC_TSR_TGO    (1 << 3) // Transmitter Idle
#define AT91_EMAC_TSR_BEX    (1 << 4) // Buffer Exhausted
#define AT91_EMAC_TSR_COMP   (1 << 5) // Transmission Complete
#define AT91_EMAC_TSR_UND    (1 << 6) // Transmit Underrun

#define AT91_EMAC_RBQP (0x18) // Receiver Buffer Queue Pointer
#define AT91_EMAC_TBQP (0x1c) // Transmit Buffer Queue Pointer

#define AT91_EMAC_RSR  (0x20) // Receiver Status
#define AT91_EMAC_RSR_BNA (1 << 0) // Buffer Not Available
#define AT91_EMAC_RSR_REC (1 << 1) // Frame Received
#define AT91_EMAC_RSR_OVR (1 << 2) // Transmit Buffer Overrun

#define AT91_EMAC_ISR  (0x24) // Interrupt Status
#define AT91_EMAC_ISR_DONE  (1 <<  0) // Management Done
#define AT91_EMAC_ISR_RCOM  (1 <<  1) // Receiver Complete
#define AT91_EMAC_ISR_RBNA  (1 <<  2) // Receiver Buffer Not Available
#define AT91_EMAC_ISR_TOVR  (1 <<  3) // Transmit Buffer Overrun
#define AT91_EMAC_ISR_TUND  (1 <<  4) // Transmit Error: Buffer under run
#define AT91_EMAC_ISR_RTRY  (1 <<  5) // Transmit Error: Retry Limit Exceeded
#define AT91_EMAC_ISR_TBRE  (1 <<  6) // Transmit Buffer Register Empty
#define AT91_EMAC_ISR_TCOM  (1 <<  7) // Transmit Complete
#define AT91_EMAC_ISR_TIDLE (1 <<  8) // Transmitter Idle
#define AT91_EMAC_ISR_LINK  (1 <<  9) // Link pin changed state
#define AT91_EMAC_ISR_ROVR  (1 << 10) // Receiver Overrun
#define AT91_EMAC_ISR_HRESP (1 << 11) // HRESP not OK
#define AT91_EMAC_IER  (0x28) // Interrupt Enable
#define AT91_EMAC_IDR  (0x2c) // Interrupt Disable
#define AT91_EMAC_IMR  (0x30) // Interrupt Mask

#define AT91_EMAC_MAN  (0x34) // PHY Maintenance
#define AT91_EMAC_MAN_DATA_MASK  (0xffff<<0)    // Data to/from PHY
#define AT91_EMAC_MAN_CODE       (2<<16)        // Code
#define AT91_EMAC_MAN_REGA_MASK  (0x1f<<18)     // Register Address Mask
#define AT91_EMAC_MAN_REGA_SHIFT (18)           // Register Address Shift
#define AT91_EMAC_MAN_PHY_MASK   (0x1f<<23)     // PHY Address Mask
#define AT91_EMAC_MAN_PHY_SHIFT  (23)           // PHY Address Shift
#define AT91_EMAC_MAN_RD         (2<<28)        // Read operation
#define AT91_EMAC_MAN_WR         (1<<28)        // Write Operation
#define AT91_EMAC_MAN_SOF        (1<<30)        // Must be set to 01
#define AT91_EMAC_MAN_PHYA(x)    ((x&0x1f)<<23) // Create a PHY Address
#define AT91_EMAC_MAN_REGA(x)    ((x&0x1f)<<18) // Create a Register Address
#define AT91_EMAC_MAN_DATA(x)    (x&0xffff)     // Create a Data word
                                          

#define AT91_EMAC_PTR  (0x38) // Pause Time Register
#define AT91_EMAC_PFR  (0x3C) // Pause Frames Received
#define AT91_EMAC_FTO  (0x40) // Frames Transmitted OK
#define AT91_EMAC_SCF  (0x44) // Single Collision Frame
#define AT91_EMAC_MCF  (0x48) // Multiple Collision Frame
#define AT91_EMAC_FRO  (0x4c) // Frames Received OK
#define AT91_EMAC_FCSE (0x50) // Frame Check Sequence Error
#define AT91_EMAC_ALE  (0x54) // Alignment Error
#define AT91_EMAC_DTR  (0x58) // Deferred Transmission Frame
#define AT91_EMAC_LCOL (0x5c) // Late Collision
#define AT91_EMAC_XCOL (0x60) // Excessive Collisions - ECOL!!
#define AT91_EMAC_TUND (0x64) // Transmit Underrun Error
#define AT91_EMAC_CSE  (0x68) // Carrier Sense Error
#define AT91_EMAC_RRE  (0x6c) // Receive Resource Errors
#define AT91_EMAC_ROV  (0x70) // Receive Overrun
#define AT91_EMAC_RSE  (0x74) // Receiver Symbol erros 
#define AT91_EMAC_ELE  (0x78) // Excessive Length Errors
#define AT91_EMAC_RJE  (0x7c) // Receive Jabber Errors
#define AT91_EMAC_USF  (0x80) // Undersize Frame Errors
#define AT91_EMAC_STE  (0x84) // SQE Test Errors
#define AT91_EMAC_RLE  (0x88) // Receive Length Field Mismatch
                              
#define AT91_EMAC_HRB  (0x90) // Hash Address Low  [31:0]
#define AT91_EMAC_HRT  (0x94) // Hash Address High [63:32]
#define AT91_EMAC_SA1L (0x98) // Specific Address 1 Low, First 4 bytes
#define AT91_EMAC_SA1H (0x9c) // Specific Address 1 High, Last 2 bytes
#define AT91_EMAC_SA2L (0xa0) // Specific Address 2 Low, First 4 bytes
#define AT91_EMAC_SA2H (0xa4) // Specific Address 2 High, Last 2 bytes
#define AT91_EMAC_SA3L (0xa8) // Specific Address 3 Low, First 4 bytes
#define AT91_EMAC_SA3H (0xac) // Specific Address 3 High, Last 2 bytes
#define AT91_EMAC_SA4L (0xb0) // Specific Address 4 Low, First 4 bytes
#define AT91_EMAC_SA4H (0xb4) // Specific Address 4 High, Last 2 bytes
#define AT91_EMAC_TID  (0xb8) // Type ID Checking Register

#define AT91_EMAC_USRIO  (0xc0) // User IO Register
#define AT91_EMAC_USRIO_RMII   (1<<0) // RMII Mode
#define AT91_EMAC_USRIO_CLKEN  (1<<1) // Clock Enable

// Receiver Buffer Descriptor
#define AT91_EMAC_RBD_ADDR 0x0  // Address to beginning of buffer
#define AT91_EMAC_RBD_ADDR_MASK   (0xFFFFFFFC) // Address Mask masking the reserved bits
#define AT91_EMAC_RBD_ADDR_OWNER_EMAC (0 << 0) // EMAC owns receiver buffer
#define AT91_EMAC_RBD_ADDR_OWNER_SW   (1 << 0) // SW owns receiver buffer
#define AT91_EMAC_RBD_ADDR_WRAP       (1 << 1) // Last receiver buffer
#define AT91_EMAC_RBD_SR   0x1  // Buffer Status
#define AT91_EMAC_RBD_SR_LEN_MASK     (0xfff)   // Length of data
#define AT91_EMAC_RBD_SR_SOF          (1 << 14) // Start of Frame
#define AT91_EMAC_RBD_SR_EOF          (1 << 15) // End of Frame
#define AT91_EMAC_RBD_SR_CFI          (1 << 16) // Concatination Format Ind
#define AT91_EMAC_RDB_SR_VLAN_SHIFT   (17)      // VLAN priority tag 
#define AT91_EMAC_RDB_SR_VLAN_MASK    (7 << 17)
#define AT91_EMAC_RDB_SR_PRIORTY_TAG  (1 << 20) // Priority Tag Detected
#define AT91_EMAC_RDB_SR_VLAN_TAG     (1 << 21) // Priority Tag Detected
#define AT91_EMAC_RBD_SR_TYPE_ID      (1 << 22) // Type ID match
#define AT91_EMAC_RBD_SR_SA4M         (1 << 23) // Specific Address 4 match
#define AT91_EMAC_RBD_SR_SA3M         (1 << 24) // Specific Address 3 match
#define AT91_EMAC_RBD_SR_SA2M         (1 << 25) // Specific Address 2 match
#define AT91_EMAC_RBD_SR_SA1M         (1 << 26) // Specific Address 1 match
#define AT91_EMAC_RBD_SR_EXTNM        (1 << 28) // External Address match
#define AT91_EMAC_RBD_SR_UNICAST      (1 << 29) // Unicast hash match
#define AT91_EMAC_RBD_SR_MULTICAST    (1 << 30) // Multicast hash match
#define AT91_EMAC_RBD_SR_BROADCAST    (1 << 31) // Broadcast

// Transmit Buffer Descriptor
#define AT91_EMAC_TBD_ADDR 0x0  // Address to beginning of buffer
#define AT91_EMAC_TBD_SR   0x1  // Buffer Status
#define AT91_EMAC_TBD_SR_LEN_MASK     (0xfff)   // Length of data
#define AT91_EMAC_TBD_SR_EOF          (1 << 15) // End of Frame
#define AT91_EMAC_TBD_SR_NCRC         (1 << 16) // No CRC added by EMAC
#define AT91_EMAC_TBD_SR_EXHAUST      (1 << 27) // Buffers exhausted
#define AT91_EMAC_TBD_SR_TXUNDER      (1 << 28) // Transmit Underrun
#define AT91_EMAC_TBD_SR_RTRY         (1 << 29) // Retry limit exceeded
#define AT91_EMAC_TBD_SR_WRAP         (1 << 30) // Marks last descriptor
#define AT91_EMAC_TBD_SR_USED         (1 << 31) // Buffer used

//=============================================================================
// Periodic Interval Timer

#define _PITC_PIMR      (SAM9_PIT+0x00)         // Period Interval Mode Register
#define     _PITC_PIMR_PITEN          (1 << 24) // Periodic Interval Timer Enable
#define     _PITC_PIMR_PITIEN         (1 << 25) // Periodic Interval Timer Intr Enable
#define _PITC_PISR      (SAM9_PIT+0x04)         // Period Interval Status Register
#define     _PITC_PISR_PITS           (1 << 0)  // Periodic Interval Timer Status
#define _PITC_PIVR      (SAM9_PIT+0x08)         // Period Interval Value Register
#define _PITC_PIIR      (SAM9_PIT+0x0C)         // Period Interval Image Register

//=============================================================================
// Real Time Timer Controller

#define _RTTC_RTMR      (SAM9_RTTC+0x00)        // Real Time Mode Register
#define     _RTTC_RTMR_RTPRES    0x0000FFFF     // Slow Clock Prescaler
#define     _RTTC_RTMR_ALMIEN    (1 << 16)      // Alarm Interrupt Enable
#define     _RTTC_RTMR_RTTINCIEN (1 << 17)      // Timer Increment Interrupt Enable
#define     _RTTC_RTMR_RTTRST    (1 << 18)      // Timer Reset
#define _RTTC_RTAR      (SAM9_RTTC+0x04)        // Real Time Alarm Register
#define _RTTC_RTVR      (SAM9_RTTC+0x08)        // Real Time Value Register
#define _RTTC_RTSR      (SAM9_RTTC+0x0C)        // Real Time Status Register
#define     _RTTC_RTSR_ALMS      (1 << 0)       // Alarm Status
#define     _RTTC_RTSR_RTTINC    (1 << 1)       // Timer Increment

// The following are named to match the requirements of the AT91RTT
// wallclock driver.

#define AT91_RTTC SAM9_RTTC

#define AT91_RTTC_RTMR          0x00            // Real Time Mode Register
#define AT91_RTTC_RTMR_RTPRES   0x0000FFFF      // Slow Clock Prescaler
#define AT91_RTTC_RTMR_ALMIEN   (1 << 16)       // Alarm Interrupt Enable
#define AT91_RTTC_RTMR_RTTINCIEN (1 << 17)      // Timer Increment Interrupt Enable
#define AT91_RTTC_RTMR_RTTRST   (1 << 18)       // Timer Reset
#define AT91_RTTC_RTAR          0x04            // Real Time Alarm Register
#define AT91_RTTC_RTVR          0x08            // Real Time Value Register
#define AT91_RTTC_RTSR          0x0C            // Real Time Status Register
#define AT91_RTTC_RTSR_ALMS     (1 << 0)        // Alarm Status
#define AT91_RTTC_RTSR_RTTINC   (1 << 1)        // Timer Increment


//=============================================================================
// Watchdog
//
// The following are named to match the requirements of the AT91WDTC
// watchdog driver.


#ifndef AT91_WDTC
#define AT91_WDTC       SAM9_WDTC
#endif

#define AT91_WDTC_WDCR          0x00            // Watchdog Control Register
#define AT91_WDTC_WDCR_RELOAD   (1 << 0)        // Reload the watchdog
#define AT91_WDTC_WDCR_KEY      (0xa5 << 24)    // Password for the write op
#define AT91_WDTC_WDMR          0x04            // Watchdog Mode Register
#define AT91_WDTC_WDMR_FIEN     (1 << 12)       // Fault Interrupt Mode Enable
#define AT91_WDTC_WDMR_RSTEN    (1 << 13)       // Reset Enable
#define AT91_WDTC_WDMR_RPROC    (1 << 14)       // Trigger a processor reset
#define AT91_WDTC_WDMR_DIS      (1 << 15)       // Disable
#define AT91_WDTC_WDMR_WDD_SHIFT (16)           // Delta Value shift
#define AT91_WDTC_WDMR_DBGHLT   (1 << 28)       // Stop when in debug state
#define AT91_WDTC_WDMR_IDLEHLT  (1 << 29)       // Stop when in idle more
#define AT91_WDTC_WDSR          0x08            // Watchdog Status Register
#define AT91_WDTC_WDSR_UNDER    (1 << 0)        // Underflow has occurred
#define AT91_WDTC_WDSR_ERROR    (1 << 1)        // Error has occurred

#define _WDTC_WDMR              (SAM9_WDTC + AT91_WDTC_WDMR)
#define _WDTC_WDMR_FIEN         AT91_WDTC_WDMR_FIEN
#define _WDTC_WDSR_UNDER        AT91_WDTC_WDSR_UNDER
#define _WDTC_WDSR_ERROR        AT91_WDTC_WDSR_ERROR
#define _WDTC_WDSR              (SAM9_WDTC + AT91_WDTC_WDSR)

//=============================================================================
// Reset Controller

#define _RST_RCR        (SAM9_RST+0x00)         // Reset Control Register
#define     _RST_RCR_PROCRST  (1 << 0)          // Processor Reset
#define     _RST_RCR_ICERST   (1 << 1)          // ICE Reset
#define     _RST_RCR_PERRST   (1 << 2)          // Peripheral Reset
#define     _RST_RCR_EXTRST   (1 << 3)          // External Reset
#define     _RST_RCR_KEY      (0xA5 << 24)      // Key
#define _RST_RSR        (SAM9_RST+0x04)         // Reset Status Register
#define     _RST_RSR_USER          (1 << 0)     // User Reset
#define     _RST_RSR_BROWN         (1 << 1)     // Brownout detected
#define     _RST_RSR_TYPE_POWERUP  (0 << 8)     // Power on Reset
#define     _RST_RSR_TYPE_WATCHDOG (2 << 8)     // Watchdog Reset
#define     _RST_RSR_TYPE_SW       (3 << 8)     // Software Reset
#define     _RST_RSR_TYPE_USER     (4 << 8)     // NRST pin Reset
#define     _RST_RSR_TYPE_BROWNOUT (5 << 8)     // Brown-out Reset
#define     _RST_RSR_NRST_SET (1 << 16)         // NRST pin set
#define     _RST_RSR_SRCMP    (1 << 17)         // Software reset in progress
#define _RST_RMR        (SAM9_RST+0x08)         // Reset Mode Register
#define     _RST_RMR_URSTEN  (1 << 0)           // User Reset Enabled
#define     _RST_RMR_URSTIEN (1 << 4)           // User Reset Interrupt Enabled
#define     _RST_RMR_BODIEN  (1 << 16)          // Brownout Dection Interrupt Enabled
#define     _RST_RMR_KEY     (0xA5 << 24)       // Key

//=============================================================================
// Timer Counters - offsets within a timer/counter block

#define _TC_CCR    0x0000   // Channel control register
#define    _TC_CCR_CLKEN        (0x1<< 0) // Counter Clock Enable Command
#define    _TC_CCR_CLKDIS       (0x1<< 1) // Counter Clock Disable Command
#define    _TC_CCR_SWTRG        (0x1<< 2) // Software Trigger Command
#define _TC_CMR    0x0004   // Channel mode register
#define    _TC_CMR_CPCSTOP      (0x1<< 6) // Counter Clock Stopped with RC Compare
#define    _TC_CMR_CPCDIS       (0x1<< 7) // Counter Clock Disable with RC Compare
#define    _TC_CMR_EEVTEDG      (0x3<< 8) // External Event Edge Selection
#define       _TC_CMR_EEVTEDG_NONE     (0x0<< 8) // Edge: None
#define       _TC_CMR_EEVTEDG_RISING   (0x1<< 8) // Edge: rising edge
#define       _TC_CMR_EEVTEDG_FALLING  (0x2<< 8) // Edge: falling edge
#define       _TC_CMR_EEVTEDG_BOTH     (0x3<< 8) // Edge: each edge
#define    _TC_CMR_EEVT         (0x3<<10) // External Event  Selection
#define       _TC_CMR_EEVT_NONE     (0x0<<10) // Signal selected as external event: TIOB TIOB direction: input
#define       _TC_CMR_EEVT_RISING   (0x1<<10) // Signal selected as external event: XC0 TIOB direction: output
#define       _TC_CMR_EEVT_FALLING  (0x2<<10) // Signal selected as external event: XC1 TIOB direction: output
#define       _TC_CMR_EEVT_BOTH     (0x3<<10) // Signal selected as external event: XC2 TIOB direction: output
#define    _TC_CMR_ENETRG       (0x1<<12) // External Event Trigger enable
#define    _TC_CMR_WAVESEL      (0x3<<13) // Waveform  Selection
#define       _TC_CMR_WAVESEL_UP       (0x0<<13) // UP mode without atomatic trigger on RC Compare
#define       _TC_CMR_WAVESEL_UP_AUTO  (0x2<<13) // UP mode with automatic trigger on RC Compare
#define       _TC_CMR_WAVESEL_UPDOWN   (0x1<<13) // UPDOWN mode without automatic trigger on RC Compare
#define       _TC_CMR_WAVESEL_UPDOWN_AUTO          (0x3<<13) // UPDOWN mode with automatic trigger on RC Compare
#define    _TC_CMR_CPCTRG       (0x1<<14) // RC Compare Trigger Enable
#define    _TC_CMR_WAVE         (0x1<<15) // 
#define    _TC_CMR_ACPA         (0x3<<16) // RA Compare Effect on TIOA
#define       _TC_CMR_ACPA_NONE     (0x0<<16) // Effect: none
#define       _TC_CMR_ACPA_SET      (0x1<<16) // Effect: set
#define       _TC_CMR_ACPA_CLEAR    (0x2<<16) // Effect: clear
#define       _TC_CMR_ACPA_TOGGLE   (0x3<<16) // Effect: toggle
#define    _TC_CMR_ACPC         (0x3<<18) // RC Compare Effect on TIOA
#define       _TC_CMR_ACPC_NONE     (0x0<<18) // Effect: none
#define       _TC_CMR_ACPC_SET      (0x1<<18) // Effect: set
#define       _TC_CMR_ACPC_CLEAR    (0x2<<18) // Effect: clear
#define       _TC_CMR_ACPC_TOGGLE   (0x3<<18) // Effect: toggle
#define    _TC_CMR_AEEVT        (0x3<<20) // External Event Effect on TIOA
#define       _TC_CMR_AEEVT_NONE     (0x0<<20) // Effect: none
#define       _TC_CMR_AEEVT_SET      (0x1<<20) // Effect: set
#define       _TC_CMR_AEEVT_CLEAR    (0x2<<20) // Effect: clear
#define       _TC_CMR_AEEVT_TOGGLE   (0x3<<20) // Effect: toggle
#define    _TC_CMR_ASWTRG       (0x3<<22) // Software Trigger Effect on TIOA
#define       _TC_CMR_ASWTRG_NONE     (0x0<<22) // Effect: none
#define       _TC_CMR_ASWTRG_SET      (0x1<<22) // Effect: set
#define       _TC_CMR_ASWTRG_CLEAR    (0x2<<22) // Effect: clear
#define       _TC_CMR_ASWTRG_TOGGLE   (0x3<<22) // Effect: toggle
#define    _TC_CMR_BCPB         (0x3<<24) // RB Compare Effect on TIOB
#define       _TC_CMR_BCPB_NONE     (0x0<<24) // Effect: none
#define       _TC_CMR_BCPB_SET      (0x1<<24) // Effect: set
#define       _TC_CMR_BCPB_CLEAR    (0x2<<24) // Effect: clear
#define       _TC_CMR_BCPB_TOGGLE   (0x3<<24) // Effect: toggle
#define    _TC_CMR_BCPC         (0x3<<26) // RC Compare Effect on TIOB
#define       _TC_CMR_BCPC_NONE     (0x0<<26) // Effect: none
#define       _TC_CMR_BCPC_SET      (0x1<<26) // Effect: set
#define       _TC_CMR_BCPC_CLEAR    (0x2<<26) // Effect: clear
#define       _TC_CMR_BCPC_TOGGLE   (0x3<<26) // Effect: toggle
#define    _TC_CMR_BEEVT        (0x3<<28) // External Event Effect on TIOB
#define       _TC_CMR_BEEVT_NONE     (0x0<<28) // Effect: none
#define       _TC_CMR_BEEVT_SET      (0x1<<28) // Effect: set
#define       _TC_CMR_BEEVT_CLEAR    (0x2<<28) // Effect: clear
#define       _TC_CMR_BEEVT_TOGGLE   (0x3<<28) // Effect: toggle
#define    _TC_CMR_BSWTRG       (0x3<<30) // Software Trigger Effect on TIOB
#define       _TC_CMR_BSWTRG_NONE     (0x0<<30) // Effect: none
#define       _TC_CMR_BSWTRG_SET      (0x1<<30) // Effect: set
#define       _TC_CMR_BSWTRG_CLEAR    (0x2<<30) // Effect: clear
#define       _TC_CMR_BSWTRG_TOGGLE   (0x3<<30) // Effect: toggle
#define _TC_CV     0x0010   // Channel counter value
#define _TC_RA     0x0014   // Channel register A
#define _TC_RB     0x0018   // Channel register B
#define _TC_RC     0x001C   // Channel register C
#define _TC_SR     0x0020   // Channel status register
#define    _TC_SR_COVFS        (0x1<< 0) // Counter Overflow
#define    _TC_SR_LOVRS        (0x1<< 1) // Load Overrun
#define    _TC_SR_CPAS         (0x1<< 2) // RA Compare
#define    _TC_SR_CPBS         (0x1<< 3) // RB Compare
#define    _TC_SR_CPCS         (0x1<< 4) // RC Compare
#define    _TC_SR_LDRAS        (0x1<< 5) // RA Loading
#define    _TC_SR_LDRBS        (0x1<< 6) // RB Loading
#define    _TC_SR_ETRCS        (0x1<< 7) // External Trigger
#define    _TC_SR_ETRGS        (0x1<<16) // Clock Enabling
#define    _TC_SR_MTIOA        (0x1<<17) // TIOA Mirror
#define    _TC_SR_MTIOB        (0x1<<18) // TIOA Mirror
#define _TC_IER    0x0024   // Channel interrupt enable
#define _TC_IDR    0x0028   // Channel interrupt disable
#define _TC_IMR    0x002C   // Channel interrupt mask
#define _TCB_BCR   0x00C0   // Block control register
#define    _TCB_BCR_SYNC        (0x1<< 0) // (TCB) Synchro Command
#define _TCB_BMR   0x00C4   // Block mode register
#define    _TCB_BMR_TC0XC0S     (0x1<< 0) // (TCB) External Clock Signal 0 Selection
#define       _TCB_BMR_TC0XC0S_TCLK0    (0x0) // (TCB) TCLK0 connected to XC0
#define       _TCB_BMR_TC0XC0S_NONE     (0x1) // (TCB) None signal connected to XC0
#define       _TCB_BMR_TC0XC0S_TIOA1    (0x2) // (TCB) TIOA1 connected to XC0
#define       _TCB_BMR_TC0XC0S_TIOA2    (0x3) // (TCB) TIOA2 connected to XC0
#define    _TCB_BMR_TC1XC1S     (0x1<< 2) // (TCB) External Clock Signal 1 Selection
#define       _TCB_BMR_TC1XC1S_TCLK1    (0x0<< 2) // (TCB) TCLK1 connected to XC1
#define       _TCB_BMR_TC1XC1S_NONE     (0x1<< 2) // (TCB) None signal connected to XC1
#define       _TCB_BMR_TC1XC1S_TIOA0    (0x2<< 2) // (TCB) TIOA0 connected to XC1
#define       _TCB_BMR_TC1XC1S_TIOA2    (0x3<< 2) // (TCB) TIOA2 connected to XC1
#define    _TCB_BMR_TC2XC2S     (0x1<< 4) // (TCB) External Clock Signal 2 Selection
#define       _TCB_BMR_TC2XC2S_TCLK2    (0x0<< 4) // (TCB) TCLK2 connected to XC2
#define       _TCB_BMR_TC2XC2S_NONE     (0x1<< 4) // (TCB) None signal connected to XC2
#define       _TCB_BMR_TC2XC2S_TIOA0    (0x2<< 4) // (TCB) TIOA0 connected to XC2
#define       _TCB_BMR_TC2XC2S_TIOA2    (0x3<< 4) // (TCB) TIOA2 connected to XC2

//=============================================================================
// SPI device
//
// These are named to correspond to the names used in the SPI driver.

#ifndef AT91_SPI
#define AT91_SPI               SAM9_SPI
#endif

#define AT91_SPI_CR            0x00              // Control Register 
#define AT91_SPI_CR_SPIEN      0x00000001        // SPI Enable
#define AT91_SPI_CR_SPIDIS     0x00000002        // SPI Disable
#define AT91_SPI_CR_SWRST      0x00000080        // SPI Software reset
#define AT91_SPI_MR            0x04              // Mode Register
#define AT91_SPI_MR_MSTR       0x00000001        // Master/Slave Mode 
#define AT91_SPI_MR_PS         0x00000002        // Peripheral Select
#define AT91_SPI_MR_PCSDEC     0x00000004        // Chip Select Decode
#define AT91_SPI_MR_DIV32      0x00000008        // Clock Selection 
#define AT91_SPI_MR_MODFDIS    0x00000010        // Mode fault disable
#define AT91_SPI_MR_LLB        0x00000080        // Local Loopback Enable
#define AT91_SPI_MR_PCS(x)     (((x)&0x0F)<<16)  // Peripheral Chip Select
#define AT91_SPI_MR_DLYBCS(x)  (((x)&0xFF)<<24)  // Delay Between Chip Selects
#define AT91_SPI_RDR           0x08              // Receive Data Register
#define AT91_SPI_TDR           0x0C              // Transmit Data Register
#define AT91_SPI_SR            0x10              // Status Register
#define AT91_SPI_SR_RDRF       0x00000001        // Receive Data Register Full
#define AT91_SPI_SR_TDRE       0x00000002        // Transmit Data Register Empty
#define AT91_SPI_SR_MODF       0x00000004        // Mode Fault Error
#define AT91_SPI_SR_OVRES      0x00000008        // Overrun Error Status
#define AT91_SPI_SR_ENDRX      0x00000010        // End of Receiver Transfer
#define AT91_SPI_SR_ENDTX      0x00000020        // End of Transmitter Transfer
#define AT91_SPI_SR_SPIENS     0x00010000        // SPI Enable Status
#define AT91_SPI_IER           0x14              // Interrupt Enable Register
#define AT91_SPI_IDR           0x18              // Interrupt Disable Register
#define AT91_SPI_IMR           0x1C              // Interrupt Mask Register
#define AT91_SPI_CSR0          0x30              // Chip Select Register 0
#define AT91_SPI_CSR1          0x34              // Chip Select Register 1
#define AT91_SPI_CSR2          0x38              // Chip Select Register 2
#define AT91_SPI_CSR3          0x3C              // Chip Select Register 3
#define AT91_SPI_CSR_CPOL      0x00000001        // Clock Polarity
#define AT91_SPI_CSR_NCPHA     0x00000002        // Clock Phase
#define AT91_SPI_CSR_BITS(x)   (((x)&0x0F)<<4)   // Bits Per Transfer
#define AT91_SPI_CSR_BITS8     AT91_SPI_CSR_BITS(0)
#define AT91_SPI_CSR_BITS9     AT91_SPI_CSR_BITS(1)
#define AT91_SPI_CSR_BITS10    AT91_SPI_CSR_BITS(2)
#define AT91_SPI_CSR_BITS11    AT91_SPI_CSR_BITS(3)
#define AT91_SPI_CSR_BITS12    AT91_SPI_CSR_BITS(4)
#define AT91_SPI_CSR_BITS13    AT91_SPI_CSR_BITS(5)
#define AT91_SPI_CSR_BITS14    AT91_SPI_CSR_BITS(6)
#define AT91_SPI_CSR_BITS15    AT91_SPI_CSR_BITS(7)
#define AT91_SPI_CSR_BITS16    AT91_SPI_CSR_BITS(8)
#define AT91_SPI_CSR_SCBR(x)   (((x)&0xFF)<<8)   // Serial Clock Baud Rate 
#define AT91_SPI_CSR_DLYBS(x)  (((x)&0xFF)<<16)  // Delay Before SPCK
#define AT91_SPI_CSR_DLYBCT(x) (((x)&0xFF)<<24)  // Delay Between two transfers


#define AT91_SPI_RPR           0x100             // Receive Pointer Register
#define AT91_SPI_RCR           0x104             // Receive Counter Register
#define AT91_SPI_TPR           0x108             // Transmit Pointer Register
#define AT91_SPI_TCR           0x10C             // Transmit Counter Register
#define AT91_SPI_PTCR          0x120             // Transfer control register


#if defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9260)

// SPI0 lines in PIOA
#define AT91_PIO_PSR_SPI_MISO   (1<<0)
#define AT91_PIO_PSR_SPI_MOSI   (1<<1)
#define AT91_PIO_PSR_SPI_SPCK   (1<<2)

// SPI1 lines in PIOB
#define AT91_PIO_PSR_SPI1_MISO  (1<<0)
#define AT91_PIO_PSR_SPI1_MOSI  (1<<1)
#define AT91_PIO_PSR_SPI1_SPCK  (1<<2)

#define AT91_PMC_PCER_SPI       (1<<12)
#define AT91_PMC_PCER_SPI1      (1<<13)

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9261)

// SPI0 lines in PIOA
#define AT91_PIO_PSR_SPI_MISO   (1<<0)
#define AT91_PIO_PSR_SPI_MOSI   (1<<1)
#define AT91_PIO_PSR_SPI_SPCK   (1<<2)

// SPI1 lines in PIOB
#define AT91_PIO_PSR_SPI1_MISO  (1<<30)
#define AT91_PIO_PSR_SPI1_MOSI  (1<<31)
#define AT91_PIO_PSR_SPI1_SPCK  (1<<29)

#define AT91_PMC_PCER_SPI       (1<<12)
#define AT91_PMC_PCER_SPI1      (1<<13)

#elif defined(CYGHWR_HAL_ARM_ARM9_SAM9_SAM9263)

// SPI0 lines in PIOA
#define AT91_PIO_PSR_SPI_MISO   (1<<0)
#define AT91_PIO_PSR_SPI_MOSI   (1<<1)
#define AT91_PIO_PSR_SPI_SPCK   (1<<2)

// SPI1 lines in PIOB
#define AT91_PIO_PSR_SPI1_MISO  (1<<12)
#define AT91_PIO_PSR_SPI1_MOSI  (1<<13)
#define AT91_PIO_PSR_SPI1_SPCK  (1<<14)

#define AT91_PMC_PCER_SPI       (1<<14)
#define AT91_PMC_PCER_SPI1      (1<<15)

#else

#error Unknown SAM9 variant

#endif

/*---------------------------------------------------------------------------*/

#ifndef __ASSEMBLER__

#include <cyg/infra/cyg_type.h>

__externC void _sam9_hardware_init(void);

#endif

/*---------------------------------------------------------------------------*/
/* end of sam9.h                                                          */
#endif /* CYGONCE_SAM9_H */
