//==========================================================================
//
//        powersave.c
//
//        Power saving test
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2005 Free Software Foundation, Inc.                        
// Copyright (C) 2005 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     nickg
// Contributors:  nickg
// Date:          2005-09-21
// Description:   Tests SAM9 power saving support.
// 
//####DESCRIPTIONEND####
//==========================================================================

#include <pkgconf/kernel.h>

#include <cyg/hal/hal_arch.h>

#include <cyg/kernel/kapi.h>

#include <cyg/infra/testcase.h>
#include <cyg/infra/diag.h>

#include <network.h>

//#include <sys/socket.h>
//#include <net/if.h>
//#include <sys/ioctl.h>
//#include <sys/sockio.h>
//#include <netinet/in.h>

#include <ifaddrs.h>
#include <string.h>

//==========================================================================

#define NTHREADS 1
#define STACKSIZE CYGNUM_HAL_STACK_SIZE_TYPICAL

static cyg_handle_t thread[NTHREADS];
static cyg_thread thread_obj[NTHREADS];
static char stack[NTHREADS][STACKSIZE];

//==========================================================================

static void entry0( CYG_ADDRWORD data )
{
    init_all_network_interfaces();

    cyg_thread_delay( 500 );
    
    cyg_hal_sam9_powersave_init( eth0_bootp_data.bp_ciaddr.s_addr );

    CYG_TEST_INFO("Starting");
    
    for(;;)
    {
        CYG_TEST_INFO("cyg_hal_sam9_powerdown calling");
        cyg_hal_sam9_powerdown();
        CYG_TEST_INFO("cyg_hal_sam9_powerdown returned");
    }
    
    CYG_TEST_PASS_FINISH("Powersave OK");
}

//==========================================================================

void powersave_main( void )
{
    CYG_TEST_INIT();

    cyg_thread_create(24, entry0 , (cyg_addrword_t)0, "powersave",
        (void *)stack[0], STACKSIZE, &thread[0], &thread_obj[0]);
    cyg_thread_resume(thread[0]);

    cyg_scheduler_start();
}

//==========================================================================

externC void
cyg_start( void )
{
#ifdef CYGSEM_HAL_STOP_CONSTRUCTORS_ON_FLAG
    cyg_hal_invoke_constructors();
#endif
    powersave_main();
}

//==========================================================================
// EOF powersave.c

