#ifndef CYGONCE_SAM9261EK_H
#define CYGONCE_SAM9261EK_H
/*=============================================================================
//
//      sam9261ek.h
//
//      Platform specific support (register layout, etc)
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2006 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: eCosCentric, jskov
// Date:         2005-07-29
// Purpose:      Atmel SAM9261-EK platform specific support routines
// Description: 
// Usage:        #include <cyg/hal/sam9261ek.h>
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/system.h>
#include CYGBLD_HAL_PLATFORM_H
#include <cyg/hal/sam9.h>        // CPU details

//---------------------------------------------------------------------------
// Memory layout details needed by conversion macros in plf_io.h

#define SAM9261EK_SDRAM_PHYS_BASE               0x20000000
#define SAM9261EK_SDRAM_VIRT_BASE               0x20000000
#define SAM9261EK_SDRAM_UNCACHED_BASE           0x30000000
#define SAM9261EK_SDRAM_SIZE                    0x04000000
#define SAM9261EK_SDRAM_MASK                    (SAM9261EK_SDRAM_SIZE-1)

#define SAM9261EK_IROM_PHYS_BASE                0x00100000
#define SAM9261EK_IROM_VIRT_BASE                0x71000000
#define SAM9261EK_IROM_UNCACHED_OFFSET          0x00800000
#define SAM9261EK_IROM_SIZE                     0x00020000
#define SAM9261EK_IROM_MASK                     (SAM9261EK_IROM_SIZE-1)

#define SAM9261EK_SRAM_PHYS_BASE                0x00200000
#define SAM9261EK_SRAM_VIRT_BASE                0x70000000
#define SAM9261EK_SRAM_UNCACHED_OFFSET          0x00100000
#define SAM9261EK_SRAM_SIZE                     0x00004000
#define SAM9261EK_SRAM_MASK                     (SAM9261EK_SRAM_SIZE-1)

#define SAM9261EK_UHPREG_PHYS_BASE              0x00300000
#define SAM9261EK_UHPREG_VIRT_BASE              0x72000000
#define SAM9261EK_UHPREG_UNCACHED_OFFSET        0x00800000
#define SAM9261EK_UHPREG_SIZE                   0x00100000
#define SAM9261EK_UHPREG_MASK                   (SAM9261EK_UHPREG_SIZE-1)

/*---------------------------------------------------------------------------*/

// When power saving, set PLLA to run at 80MHz, the lowest rate it will
// support.
// 80MHz ~= 18.432MHz/8 * 35
// DIVA      = 8
// PLLACOUNT = 63
// OUTA      = 0 == 80..160MHz
// MULA      = 34 == multiplier-1

#define SAM9_PLF_PLLA_POWERSAVE_80MHZ 0x20223F08

/*---------------------------------------------------------------------------*/
#endif /* CYGONCE_SAM9261EK_H */
/* end of sam9261ek.h                                                        */
