#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2005, 2006, 2008 Free Software Foundation, Inc.
// Copyright (C) 2003, 2005, 2006, 2008 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric, jskov
// Contributors: 
// Date:         2005-07-29
// Purpose:      Atmel SAM9263-EK platform specific registers
// Description: 
// Usage:        #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal_arm_arm9_sam9.h>
#include <pkgconf/hal_arm_arm9_sam9263ek.h>

#include <cyg/hal/sam9263ek.h>

//-----------------------------------------------------------------------------
// Address space translation macros

#define CYGARC_PHYSICAL_ADDRESS(_x_)                                    \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= SAM9263EK_SDRAM_VIRT_BASE &&                                 \
     _p < (SAM9263EK_SDRAM_VIRT_BASE+SAM9263EK_SDRAM_SIZE))             \
     _p = (_p & SAM9263EK_SDRAM_MASK) + SAM9263EK_SDRAM_PHYS_BASE;      \
 else if (_p >= SAM9263EK_SRAM_VIRT_BASE &&                             \
          _p < (SAM9263EK_SRAM_VIRT_BASE+SAM9263EK_SRAM_SIZE))          \
     _p = (_p & SAM9263EK_SRAM_MASK) + SAM9263EK_SRAM_PHYS_BASE;        \
 else if (_p >= SAM9263EK_IROM_VIRT_BASE &&                             \
          _p < (SAM9263EK_IROM_VIRT_BASE+SAM9263EK_IROM_SIZE))          \
     _p = (_p & SAM9263EK_IROM_MASK) + SAM9263EK_IROM_PHYS_BASE;        \
 else if (_p >= SAM9263EK_UHPREG_VIRT_BASE &&                           \
          _p < (SAM9263EK_UHPREG_VIRT_BASE+SAM9263EK_UHPREG_SIZE))      \
     _p = (_p & SAM9263EK_UHPREG_MASK) + SAM9263EK_UHPREG_PHYS_BASE;    \
 _p; })

#define CYGARC_VIRTUAL_ADDRESS(_x_)                                     \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= SAM9263EK_SDRAM_PHYS_BASE &&                                 \
     _p < (SAM9263EK_SDRAM_PHYS_BASE+SAM9263EK_SDRAM_SIZE))             \
     _p = (_p & SAM9263EK_SDRAM_MASK) + SAM9263EK_SDRAM_VIRT_BASE;      \
 else if (_p >= SAM9263EK_SRAM_PHYS_BASE &&                             \
          _p < (SAM9263EK_SRAM_PHYS_BASE+SAM9263EK_SRAM_SIZE))          \
     _p = (_p & SAM9263EK_SRAM_MASK) + SAM9263EK_SRAM_VIRT_BASE;        \
 else if (_p >= SAM9263EK_IROM_PHYS_BASE &&                             \
          _p < (SAM9263EK_IROM_PHYS_BASE+SAM9263EK_IROM_SIZE))          \
     _p = (_p & SAM9263EK_IROM_MASK) + SAM9263EK_IROM_VIRT_BASE;        \
 else if (_p >= SAM9263EK_UHPREG_PHYS_BASE &&                           \
          _p < (SAM9263EK_UHPREG_PHYS_BASE+SAM9263EK_UHPREG_SIZE))      \
     _p = (_p & SAM9263EK_UHPREG_MASK) + SAM9263EK_UHPREG_VIRT_BASE;    \
 _p; })

#define CYGARC_UNCACHED_ADDRESS(_x_)                                    \
({ CYG_ADDRWORD _p = (CYG_ADDRWORD)(_x_);                               \
 if (_p >= SAM9263EK_SDRAM_VIRT_BASE &&                                 \
     _p < (SAM9263EK_SDRAM_VIRT_BASE+SAM9263EK_SDRAM_SIZE))             \
     _p = (_p & SAM9263EK_SDRAM_MASK) + SAM9263EK_SDRAM_UNCACHED_BASE;  \
 else if (_p >= SAM9263EK_SRAM_VIRT_BASE &&                             \
     _p < (SAM9263EK_SRAM_VIRT_BASE+SAM9263EK_SRAM_SIZE))               \
     _p = _p + SAM9263EK_SRAM_UNCACHED_OFFSET;                          \
 else if (_p >= SAM9263EK_IROM_VIRT_BASE &&                             \
          _p < (SAM9263EK_IROM_VIRT_BASE+SAM9263EK_IROM_SIZE))          \
     _p = _p + SAM9263EK_IROM_UNCACHED_OFFSET;                          \
 else if (_p >= SAM9263EK_UHPREG_VIRT_BASE &&                           \
          _p < (SAM9263EK_UHPREG_VIRT_BASE+SAM9263EK_UHPREG_SIZE))      \
     _p = _p + SAM9263EK_UHPREG_UNCACHED_OFFSET;                        \
 _p; })

//-----------------------------------------------------------------------------
// TWI (I2C) bus

#ifdef CYGPKG_HAL_SAM9_TWI
# define HAL_I2C_EXPORTED_DEVICES \
    extern cyg_i2c_bus hal_sam9_i2c_bus;
#endif

//-----------------------------------------------------------------------------
// MMC/SD Interface (MCI) bus

// Only files that need the below defines will have set __MMCSD_DRIVER_PRIVATE before inclusion.
#if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_SAM9_MCI)
#include <cyg/infra/cyg_type.h>

// Only one socket, so ignore card and bus throughout below.

// Platform hook for bus initialisation, independent of socket, e.g.
// socket-independent pin config.
// err only needs to be set if there's an error.
//#define HAL_MMCSD_PLF_INIT_BUS( _bus_, _err_ )

#ifdef CYGIMP_HAL_ARM_ARM9_SAM9_MCI_INTMODE
# define __MCI_INTMODE 1
#else
# define __MCI_INTMODE 0
#endif

#define HAL_MMCSD_PLF_GET_SOCKET_CAPABILITY(_bus_, _socket_, _err_)     \
    CYG_MACRO_START                                                     \
    (_socket_)->sockethw_caps.valid = 1;                                \
    (_socket_)->sockethw_caps.sd = 1;                                   \
    (_socket_)->sockethw_caps.fourbit = 1;                              \
    (_socket_)->sockethw_caps.card_detect = 1;                          \
    (_socket_)->sockethw_caps.card_detect_int = __MCI_INTMODE;          \
    (_socket_)->sockethw_vdd = MMCSD_OCR_REGISTER_VDD_32_33;            \
    (_socket_)->sockethw_caps.multiblock_io = 0;                        \
    CYG_MACRO_END
    

#if SAM9_MCI == SAM9_MCI0

// Platform hook for initialising socket, primarily pin configuration.
// err only needs to be set if there's an error.
// For this platform:
// There is no card detection or write protect switch sensing, so
// nothing needs doing about that here. But the standard MCI pins do
// need setting up. Only slot A is wired up.
//  MCCK      = PA12         (clock)               (periph func. A)
//  MCCDA     = PA1          (command/response)    (periph func. A)
//  MCDA0     = PA0          (data0)               (periph func. A)
//  MCDA1,2,3 = PA3,4,5      (data1,2,3)           (periph func. A)

#define HAL_MMCSD_PLF_INIT_SOCKET( _card_, _err_ )              \
    CYG_MACRO_START                                             \
    const cyg_uint32 pins_a = 0x0000103B;                       \
    /* Disable GPIO interrupt mode: */                          \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_IDR, pins_a );           \
    /* Enable pull-ups */                                       \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_PUER, pins_a );          \
    /* Disable glitch filter: */                                \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_IFDR, pins_a );          \
    /* Disable multi-drive mode: */                             \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_MDDR, pins_a );          \
    /* Set appropriate peripheral function: */                  \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_ASR, pins_a );           \
    /* Disable PIO mode: */                                     \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_PDR, pins_a );           \
    /* CKSEL on PE20 selects whether SPI OR MCI clock is passed on */   \
    HAL_WRITE_UINT32(SAM9_PIOE+_PIO_SODR, 1<<20);                       \
    HAL_WRITE_UINT32(SAM9_PIOE+_PIO_PUDR, 1<<20);                       \
    HAL_WRITE_UINT32(SAM9_PIOE+_PIO_OER,  1<<20);                       \
    HAL_WRITE_UINT32(SAM9_PIOE+_PIO_PER,  1<<20);                       \
    CYG_MACRO_END

#define HAL_MMCSD_PLF_CARD_DETECT_PORT   SAM9_PIOE
#define HAL_MMCSD_PLF_CARD_DETECT_PIN    16
#define HAL_MMCSD_PLF_CARD_DETECT_VECTOR CYGNUM_HAL_INTERRUPT_PIOC

#elif SAM9_MCI == SAM9_MCI1

// Platform hook for initialising socket, primarily pin configuration.
// err only needs to be set if there's an error.
// For this platform:
// There is no card detection or write protect switch sensing, so
// nothing needs doing about that here. But the standard MCI pins do
// need setting up. Only slot A is wired up.
//  MCCK      = PA6          (clock)               (periph func. A)
//  MCCDA     = PA7          (command/response)    (periph func. A)
//  MCDA0     = PA8          (data0)               (periph func. A)
//  MCDA1,2,3 = PA9,10,11    (data1,2,3)           (periph func. A)

#define HAL_MMCSD_PLF_INIT_SOCKET( _card_, _err_ )              \
    CYG_MACRO_START                                             \
    const cyg_uint32 pins_a = 0x00000FC0;                       \
    /* Disable GPIO interrupt mode: */                          \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_IDR, pins_a );           \
    /* Enable pull-ups */                                       \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_PUER, pins_a );          \
    /* Disable glitch filter: */                                \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_IFDR, pins_a );          \
    /* Disable multi-drive mode: */                             \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_MDDR, pins_a );          \
    /* Set appropriate peripheral function: */                  \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_ASR, pins_a );           \
    /* Disable PIO mode: */                                     \
    HAL_WRITE_UINT32( SAM9_PIOA + _PIO_PDR, pins_a );           \
    CYG_MACRO_END

#define HAL_MMCSD_PLF_CARD_DETECT_PORT   SAM9_PIOE
#define HAL_MMCSD_PLF_CARD_DETECT_PIN    18
#define HAL_MMCSD_PLF_CARD_DETECT_VECTOR CYGNUM_HAL_INTERRUPT_PIOC

#endif

// Platform hook for initialising card detection for polling. Usually some PIOs.
// Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT if relevant.
// For this platform:
// Use a PIO pin defined above.
//
#define HAL_MMCSD_PLF_INIT_CARD_DETECT( _bus_, _card_, _err_ )          \
    CYG_MACRO_START                                                     \
    HAL_WRITE_UINT32( HAL_MMCSD_PLF_CARD_DETECT_PORT + _PIO_IDR,  1<<HAL_MMCSD_PLF_CARD_DETECT_PIN );  /* no intr */ \
    HAL_WRITE_UINT32( HAL_MMCSD_PLF_CARD_DETECT_PORT + _PIO_ODR,  1<<HAL_MMCSD_PLF_CARD_DETECT_PIN );  /* input */ \
    HAL_WRITE_UINT32( HAL_MMCSD_PLF_CARD_DETECT_PORT + _PIO_IFER, 1<<HAL_MMCSD_PLF_CARD_DETECT_PIN ); /* glitch filter on */ \
    HAL_WRITE_UINT32( HAL_MMCSD_PLF_CARD_DETECT_PORT + _PIO_PUER, 1<<HAL_MMCSD_PLF_CARD_DETECT_PIN ); /* pull-up on */ \
    HAL_WRITE_UINT32( HAL_MMCSD_PLF_CARD_DETECT_PORT + _PIO_PER,  1<<HAL_MMCSD_PLF_CARD_DETECT_PIN );  /* set PIO mode */ \
    CYG_MACRO_END


// Update card's cardflags field with card presence
#define HAL_MMCSD_PLF_SAMPLE_CARD_DETECT( _card_, _err_ )               \
    CYG_MACRO_START                                                     \
    cyg_uint32 pdsr;                                                    \
    HAL_READ_UINT32( HAL_MMCSD_PLF_CARD_DETECT_PORT + _PIO_PDSR, pdsr ); \
    (_card_)->cardflags.card_present = ( 0 != (pdsr & (1<<HAL_MMCSD_PLF_CARD_DETECT_PIN)) ); \
    CYG_MACRO_END

// Platform hook for initialisation of interrupt handler for card
// insertion/removal detection. Used in addition to HAL_MMCSD_PLF_INIT_CARD_DETECT.
// err only needs to be set if there's an error.
#if defined(CYGFUN_DEVS_DISK_MMCSD_BUS_REMOVABLE_MEDIA_SUPPORT) && \
    defined(CYGIMP_HAL_ARM_ARM9_SAM9_MCI_INTMODE)
struct cyg_mmcsd_card; // forward declaration
__externC void cyg_hal_sam9263ek_init_card_detect_intr(struct cyg_mmcsd_card *socket);

# define HAL_MMCSD_PLF_INIT_CARD_DETECT_INTERRUPT(_bus_, _socket_, _err_) \
    cyg_hal_sam9263ek_init_card_detect_intr(_socket_)
#endif

#endif // if defined(__MMCSD_DRIVER_PRIVATE) && defined(CYGPKG_HAL_ARM_ARM9_SAM9_MCI)

//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
