#ifndef CYGONCE_HAL_VAR_ARCH_H
#define CYGONCE_HAL_VAR_ARCH_H
//=============================================================================
//
//      var_arch.h
//
//      ARM9 variant architecture overrides
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2003, 2008 Free Software Foundation, Inc.                  
// Copyright (C) 2008 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    chris
// Date:         2005-07-05
// Purpose:      ARM9 variant architecture overrides
// Description: 
// Usage:        #include <cyg/hal/hal_arch.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal.h>
#include <cyg/hal/hal_io.h>

__externC void cyg_hal_arm9_wait_for_interrupt(void);
__externC void cyg_hal_arm9_set_fastbus_mode(void);
__externC void cyg_hal_arm9_set_sync_mode(void);
__externC void cyg_hal_arm9_set_async_mode(void);
__externC unsigned int cyg_hal_arm9_get_clock_mode(void);

//--------------------------------------------------------------------------
// Idle thread code.
// This macro is called in the idle thread loop, and gives the HAL the
// chance to insert code. Typical idle thread behaviour might be to halt the
// processor. These implementations halt the system core clock.

#ifndef HAL_IDLE_THREAD_ACTION

//--------------------------------------------------------------------------
// This causes the ARM9 to go into doze mode until an interrupt comes in
//

#define HAL_IDLE_THREAD_ACTION(_count_)			\
CYG_MACRO_START						\
	cyg_hal_arm9_wait_for_interrupt();		\
CYG_MACRO_END

#endif	/* !defined(HAL_IDLE_THREAD_ACTION) */

//-----------------------------------------------------------------------------
// The debug system on the 926E, 926EJ and 946E cores treats the
// standard BKPT instruction specially, so we have to switch to a
// different, known to be undefined, instruction for our breakpoints.
// FIXME: seems likely this will need to be for all "E" cores including 966E
// too. Need to have one to be sure though!

#if defined(CYGPKG_HAL_ARM_ARM9_ARM926E) || \
    defined(CYGPKG_HAL_ARM_ARM9_ARM926EJ) || \
    defined(CYGPKG_HAL_ARM_ARM9_ARM946E)
# define HAL_BREAKINST_THUMB 0xdede
#endif

//-----------------------------------------------------------------------------
// end of var_arch.h
#endif // CYGONCE_HAL_VAR_ARCH_H
