#ifndef CYGONCE_HAL_PLATFORM_INTS_H
#define CYGONCE_HAL_PLATFORM_INTS_H
//==========================================================================
//
//      platform_ints.h
//
//      ARM9 Versatile variant Interrupt and clock support
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
// Copyright (C) 2003, 2004, eCosCentric Limited                            
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    eCosCentric
// Contributors: 
// Date:         2003-09-27
// Purpose:      Define Interrupt support
// Description:  The interrupt details for the VPB926EJS are defined here.
// Usage:
//               #include <cyg/hal/hal_platform_ints.h>
//               ...
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================

// These are interrupts on the primary VIC in the ARM926EJ-S
// development chip.

#define CYGNUM_HAL_INTERRUPT_WATCHDOG           0
#define CYGNUM_HAL_INTERRUPT_SWI                1
#define CYGNUM_HAL_INTERRUPT_COMM_RX            2
#define CYGNUM_HAL_INTERRUPT_COMM_TX            3
#define CYGNUM_HAL_INTERRUPT_TIMER_01           4
#define CYGNUM_HAL_INTERRUPT_TIMER_23           5
#define CYGNUM_HAL_INTERRUPT_GPIO0              6
#define CYGNUM_HAL_INTERRUPT_GPIO1              7
#define CYGNUM_HAL_INTERRUPT_GPIO2              8
#define CYGNUM_HAL_INTERRUPT_GPIO3              9
#define CYGNUM_HAL_INTERRUPT_RTX                10
#define CYGNUM_HAL_INTERRUPT_SSP                11
#define CYGNUM_HAL_INTERRUPT_UART0              12
#define CYGNUM_HAL_INTERRUPT_UART1              13
#define CYGNUM_HAL_INTERRUPT_UART2              14
#define CYGNUM_HAL_INTERRUPT_SCI0               15
#define CYGNUM_HAL_INTERRUPT_CLCD               16
#define CYGNUM_HAL_INTERRUPT_DMA                17
#define CYGNUM_HAL_INTERRUPT_PWRFAIL            18
#define CYGNUM_HAL_INTERRUPT_MBX                19
#define CYGNUM_HAL_INTERRUPT_RESERVED_20        20
#define CYGNUM_HAL_INTERRUPT_DOC                21
#define CYGNUM_HAL_INTERRUPT_MCI0A              22
#define CYGNUM_HAL_INTERRUPT_MCI1A              23
#define CYGNUM_HAL_INTERRUPT_AACI               24
#define CYGNUM_HAL_INTERRUPT_ETHERNET           25
#define CYGNUM_HAL_INTERRUPT_USB                26
#define CYGNUM_HAL_INTERRUPT_PCI0               27
#define CYGNUM_HAL_INTERRUPT_PCI1               28
#define CYGNUM_HAL_INTERRUPT_PCI2               29
#define CYGNUM_HAL_INTERRUPT_PCI3               30
#define CYGNUM_HAL_INTERRUPT_FPGA               31

// These interrupts are on the FPGA interrupt controller which is
// cascaded into the primary VIC at vector 31.

#define CYGNUM_HAL_INTERRUPT_FPGA_BASE          32
#define CYGNUM_HAL_INTERRUPT_SOFTINT            32
#define CYGNUM_HAL_INTERRUPT_MMCI0B             33
#define CYGNUM_HAL_INTERRUPT_MMCI1B             34
#define CYGNUM_HAL_INTERRUPT_KMI0               35
#define CYGNUM_HAL_INTERRUPT_KMI1               36
#define CYGNUM_HAL_INTERRUPT_SCI1               37
#define CYGNUM_HAL_INTERRUPT_UART3              38
#define CYGNUM_HAL_INTERRUPT_LCD                39
#define CYGNUM_HAL_INTERRUPT_TOUCHSCREEN        40
#define CYGNUM_HAL_INTERRUPT_KEYPAD             41
// 42..52 reserved
#define CYGNUM_HAL_INTERRUPT_FPGA_DOC           53
#define CYGNUM_HAL_INTERRUPT_FPGA_MCI0A         54
#define CYGNUM_HAL_INTERRUPT_FPGA_MCI1A         55
#define CYGNUM_HAL_INTERRUPT_FPGA_AACI          56
#define CYGNUM_HAL_INTERRUPT_FPGA_ETHERNET      57
#define CYGNUM_HAL_INTERRUPT_FPGA_USB           58
#define CYGNUM_HAL_INTERRUPT_FPGA_PCI0          59
#define CYGNUM_HAL_INTERRUPT_FPGA_PCI1          60
#define CYGNUM_HAL_INTERRUPT_FPGA_PCI2          61
#define CYGNUM_HAL_INTERRUPT_FPGA_PCI3          62
#define CYGNUM_HAL_INTERRUPT_RESERVED_64        64

#define CYGNUM_HAL_ISR_MIN            0
#define CYGNUM_HAL_ISR_MAX           63

#define CYGNUM_HAL_ISR_COUNT         (CYGNUM_HAL_ISR_MAX-CYGNUM_HAL_ISR_MIN+1)

// The vector used by the Real time clock
#define CYGNUM_HAL_INTERRUPT_RTC      CYGNUM_HAL_INTERRUPT_TIMER_01

//----------------------------------------------------------------------------
// Reset.

externC void cyg_hal_vpb926ejs_reset(void);
#define HAL_PLATFORM_RESET() cyg_hal_vpb926ejs_reset()

#define HAL_PLATFORM_RESET_ENTRY 0x00000000

//----------------------------------------------------------------------------
#endif // CYGONCE_HAL_PLATFORM_INTS_H
