//==========================================================================
//
//      eb40_misc.c
//
//      HAL misc board support code for Atmel EB40 eval board
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    gthomas
// Contributors: gthomas, jskov, tkoeller, nickg, jlarmour
// Date:         2002-05-30
// Purpose:      HAL board support
// Description:  Implementations of HAL board interfaces
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/system.h>
#include <pkgconf/hal.h>

#include <cyg/infra/cyg_type.h>         // base types
#include <cyg/hal/hal_io.h>             // low level i/o
#include <cyg/hal/var_io.h>             // common registers
#include <cyg/hal/plf_io.h>             // platform registers

// 
// Diagnostic LEDs - there are three colored LEDs which can be used
// to send a simple diagnostic value (8 bits)
//

void 
hal_at91_led(int val)
{
    int i, to;

    HAL_WRITE_UINT32(AT91_PIO+AT91_PIO_CODR, 0x06);  // DATA+CLOCK LEDs off
    for (to = 0;  to < 0x200000; to++) ;
    for (i = 0;  i < 8;  i++) {        
        HAL_WRITE_UINT32(AT91_PIO+AT91_PIO_SODR, ((val>>(7-i)) & 0x01)<<2);  // DATA LED
        HAL_WRITE_UINT32(AT91_PIO+AT91_PIO_SODR, 0x02);  // CLOCK LED on
        for (to = 0;  to < 0x80000; to++) ;
        HAL_WRITE_UINT32(AT91_PIO+AT91_PIO_CODR, 0x02);  // CLOCK LED off
        for (to = 0;  to < 0x40000; to++) ;
        HAL_WRITE_UINT32(AT91_PIO+AT91_PIO_CODR, 0x04);  // DATA LED off
    }
}

void
hal_at91_set_leds(int val)
{
    hal_at91_led(val);
}

#ifdef CYGPKG_REDBOOT
#include <redboot.h>
#include CYGHWR_MEMORY_LAYOUT_H

void
cyg_plf_memory_segment(int seg, unsigned char **start, unsigned char **end)
{
    switch (seg) {
    case 0:
        *start = (unsigned char *)CYGMEM_REGION_ram;
        *end = (unsigned char *)(CYGMEM_REGION_ram + CYGMEM_REGION_ram_SIZE);
        break;
    case 1:
        *start = (unsigned char *)CYGMEM_REGION_sram;
        *end = (unsigned char *)(CYGMEM_REGION_sram + CYGMEM_REGION_sram_SIZE);
        break;
    case 2:
        {
#ifdef CYGHWR_HAL_ARM_AT91_EB40_MEC01_RAM
            // With this option set, we already know we've already got the MEC01 expansion
            // RAM, so we just return the 512K board ram info
            *start = (unsigned char *)CYGMEM_REGION_boardram;
            *end = (unsigned char *)(CYGMEM_REGION_boardram + CYGMEM_REGION_boardram_SIZE);
            break;
#elif !defined(CYG_HAL_STARTUP_RAM)
            // Probe to see if MEC01 memory expansion card is fitted
            // Don't do it for RAM startup RedBoot because we don't know if the ROM boot initialised
            // the memory controller - if Angel then it wouldn't have.
            volatile cyg_uint32 *mecp = (volatile cyg_uint32 *)CYGMEM_REGION_mec01ram;
            cyg_uint32 savedmem = *mecp;
            cyg_bool got_mec01 = false;

            // we've mapped the MEC01 memory into the (simple) memory controller whether
            // it's there or not, so we should not get a fault
            *mecp = 0x12345678;
            if (*mecp == 0x12345678)
            {
                // double check (the memory pattern appears to be consistent: 0xa0e1a0e1, but
                // let's avoid any risk it happened to be random and 0x12345678) 
                *mecp = 0xDEADBEEF;
                if (*mecp == 0xDEADBEEF)
                    got_mec01 = true;
            }
            *mecp = savedmem; // just in case
            if (got_mec01)
            {
                *start = (unsigned char *)CYGMEM_REGION_mec01ram;
                *end = (unsigned char *)(CYGMEM_REGION_mec01ram + CYGMEM_REGION_mec01ram_SIZE);
            } else {
                *start = *end = NO_MEMORY;
            }
#else
            *start = *end = NO_MEMORY;
#endif            
        }
        break;
    default:
        *start = *end = NO_MEMORY;
        break;
    }
} // cyg_plf_memory_segment()
#endif

//--------------------------------------------------------------------------
// EOF eb40_misc.c
