//==========================================================================
//
//      mcb2387_spi.c
//
//      Support for the SPI devices on KwikByte MCB2387
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008 Free Software Foundation, Inc.                        
// Copyright (C) 2008 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2008-02-27
//
//####DESCRIPTIONEND####
//=============================================================================

#include <pkgconf/hal.h>
#include <pkgconf/io_spi.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/io/spi.h>
#include <cyg/io/spi_nxpssp.h>

// -------------------------------------------------------------------------
// Aardvark SPI test board, with AT2050A connected on Bus 0, chip select 0

#ifdef CYGPKG_IO_TESTING_AARDVARK
# include <pkgconf/io_testing_aardvark.h>
# ifdef CYGHWR_IO_TESTING_AARDVARK_SPI

cyg_spi_nxpssp_device_t cyg_aardvark_at25080 CYG_SPI_DEVICE_ON_BUS(0) = 
{
    .spi_device.spi_bus = &cyg_spi_nxpssp_bus0.spi_bus,

    .dev_num     = 0,       // Device number
    .cl_pol      = 0,       // Clock polarity (0 or 1)
    .cl_pha      = 0,       // Clock phase (0 or 1)
    .cl_brate    = 10000000, // Clock baud rate. At 3.3v 10MHz is allowed for this part.
    .cs_up_udly  = 1,       // Delay in usec between CS up and transfer start.
                            // Tcss (CS setup time) for this part at 3.3V is 250ns.
    .cs_dw_udly  = 1,       // Delay in usec between transfer end and CS down
                            // Tcsh (CS hold time) for this part at 3.3V is 250ns.
    .tr_bt_udly  = 1        // Delay in usec between two transfers
                            // Tcs (CS high time) for this part at 3.3V is 250ns.
};
# endif
#endif

//=============================================================================
// EOF at91rm9200_kits_dataflash.c
