#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      ST STR710-EVAL specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2005, 2006 Free Software Foundation, Inc.            
// Copyright (C) 2004, 2005, 2006 eCosCentric Limited                       
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    nickg
// Contributors: 
// Date:         2006-03-20
// Purpose:      ST STR710-EVAL specific registers
// Description:
// Usage:       #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

//-----------------------------------------------------------------------------
// Power management definitions

#ifndef __ASSEMBLER__

__externC const hal_str7xx_clock_params hal_str7xx_clock_param_table[];

#endif

// The following definitions correspond to indexes into the above
// table and define offsets for particular well-defined regimes.

#define CYGARC_HAL_STR7XX_CLOCK_32KHz   0
#define CYGARC_HAL_STR7XX_CLOCK_CLK2_16 1
#define CYGARC_HAL_STR7XX_CLOCK_CLK2    2
#define CYGARC_HAL_STR7XX_CLOCK_DEFAULT 8

//-----------------------------------------------------------------------------

#define HAL_STRATA_UNCACHED_ADDRESS(__x) (__x)

//-----------------------------------------------------------------------------
// I2C devices

#if defined(CYGPKG_HAL_STR7XX_I2C)

# define HAL_I2C_EXPORTED_DEVICES \
__externC cyg_i2c_device cyg_i2c_str710eval_m24c08_0; \
__externC cyg_i2c_device cyg_i2c_str710eval_m24c08_1; \
__externC cyg_i2c_device cyg_i2c_str710eval_m24c08_2; \
__externC cyg_i2c_device cyg_i2c_str710eval_m24c08_3; 

#endif

//-----------------------------------------------------------------------------
#endif // CYGONCE_HAL_PLF_IO_H
// end of plf_io.h
