#ifndef CYGONCE_HAL_PLF_IO_H
#define CYGONCE_HAL_PLF_IO_H
//=============================================================================
//
//      plf_io.h
//
//      Platform specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008, 2009 Free Software Foundation, Inc.                        
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2009-07-30
// Purpose:     LM3S8962 EVAL platform specific registers
// Description: 
// Usage:       #include <cyg/hal/plf_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal.h>
#include <pkgconf/hal_cortexm_lm3s_lm3s8962_eval.h>

//=============================================================================
// Memory access checks.
//
// Accesses to areas not backed by real devices or memory can cause
// the CPU to hang. These macros allow the GDB stubs to avoid making
// accidental accesses to these areas.

__externC int cyg_hal_stub_permit_data_access( CYG_ADDRESS addr, cyg_uint32 count );

#define CYG_HAL_STUB_PERMIT_DATA_READ(_addr_, _count_) cyg_hal_stub_permit_data_access( _addr_, _count_ )

#define CYG_HAL_STUB_PERMIT_DATA_WRITE(_addr_, _count_ ) cyg_hal_stub_permit_data_access( _addr_, _count_ )

//=============================================================================
// SPI device definitions

#define CYGHWR_PL022_SPI_CONFIGURE( __spi_bus )                 \
{                                                               \
    CYGHWR_HAL_LM3S_CLOCK_ENABLE( (__spi_bus)->enable );        \
    CYGHWR_HAL_LM3S_GPIO_SET( (__spi_bus)->sclk_pin );          \
    CYGHWR_HAL_LM3S_GPIO_SET( (__spi_bus)->miso_pin );          \
    CYGHWR_HAL_LM3S_GPIO_SET( (__spi_bus)->mosi_pin );          \
}

#define CYGHWR_PL022_SPI_CLOCK_SPEED hal_lm3s_sysclk


#define CYGHWR_PL022_SPI_CS_CONFIGURE( __cs_pio )       \
{                                                       \
    CYGHWR_HAL_LM3S_GPIO_OUT( __cs_pio, 1 );            \
    CYGHWR_HAL_LM3S_GPIO_SET( __cs_pio );               \
    CYGHWR_HAL_LM3S_GPIO_OUT( __cs_pio, 1 );            \
}

#define CYGHWR_PL022_SPI_CS_ASSERT( __cs_pio )  \
{                                               \
    CYGHWR_HAL_LM3S_GPIO_OUT( __cs_pio, 0 );    \
}

#define CYGHWR_PL022_SPI_CS_DROP( __cs_pio )    \
{                                               \
    CYGHWR_HAL_LM3S_GPIO_OUT( __cs_pio, 1 );    \
}

#define SPI_CS( __port, __pin ) CYGHWR_HAL_LM3S_GPIO( __port, __pin, 2mA, OUT_PUSHPULL )

//-----------------------------------------------------------------------------
// end of plf_io.h
#endif // CYGONCE_HAL_PLF_IO_H
