#ifndef CYGONCE_HAL_VAR_IO_H
#define CYGONCE_HAL_VAR_IO_H
//=============================================================================
//
//      var_io.h
//
//      Variant specific registers
//
//=============================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2008, 2009 Free Software Foundation, Inc.                        
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   nickg
// Date:        2009-11-20
// Purpose:     LPC1XXX variant specific registers
// Description: 
// Usage:       #include <cyg/hal/var_io.h>
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal_cortexm_lpc1xxx.h>

#include <cyg/hal/plf_io.h>

//=============================================================================
// Calculated clock frequencies

__externC cyg_uint32 hal_lpc1xxx_sysclk;
__externC cyg_uint32 hal_lpc1xxx_cclk;

__externC cyg_uint8 const hal_lpc1xxx_pclock_divider[4];

//=============================================================================
// Peripherals

#define CYGHWR_HAL_LPC1XXX_FGPIO                        0x2009C000

#define CYGHWR_HAL_LPC1XXX_WATCHDOG                     0x40000000
#define CYGHWR_HAL_LPC1XXX_TIMER0                       0x40004000
#define CYGHWR_HAL_LPC1XXX_TIMER1                       0x40008000
#define CYGHWR_HAL_LPC1XXX_UART0                        0x4000C000
#define CYGHWR_HAL_LPC1XXX_UART1                        0x40010000
#define CYGHWR_HAL_LPC1XXX_PWM1                         0x40018000
#define CYGHWR_HAL_LPC1XXX_I2C0                         0x4001C000
#define CYGHWR_HAL_LPC1XXX_SPI                          0x40020000
#define CYGHWR_HAL_LPC1XXX_RTC                          0x40024000
#define CYGHWR_HAL_LPC1XXX_GPIO_INT                     0x40028000
#define CYGHWR_HAL_LPC1XXX_PCB                          0x4002C000
#define CYGHWR_HAL_LPC1XXX_SSP1                         0x40030000
#define CYGHWR_HAL_LPC1XXX_ADC                          0x40034000
#define CYGHWR_HAL_LPC1XXX_CAN_AFRAM                    0x40038000
#define CYGHWR_HAL_LPC1XXX_CAN_AFREG                    0x4003C000
#define CYGHWR_HAL_LPC1XXX_CAN_COMMON                   0x40040000
#define CYGHWR_HAL_LPC1XXX_CAN1                         0x40044000
#define CYGHWR_HAL_LPC1XXX_CAN2                         0x40048000
#define CYGHWR_HAL_LPC1XXX_I2C1                         0x40050000

#define CYGHWR_HAL_LPC1XXX_SSP0                         0x40088000
#define CYGHWR_HAL_LPC1XXX_DAC                          0x4008C000
#define CYGHWR_HAL_LPC1XXX_TIMER2                       0x40090000
#define CYGHWR_HAL_LPC1XXX_TIMER3                       0x40094000
#define CYGHWR_HAL_LPC1XXX_UART2                        0x40098000
#define CYGHWR_HAL_LPC1XXX_UART3                        0x4009C000
#define CYGHWR_HAL_LPC1XXX_I2C2                         0x400A0000
#define CYGHWR_HAL_LPC1XXX_I2S                          0x400A8000
#define CYGHWR_HAL_LPC1XXX_RIT                          0x400B0000
#define CYGHWR_HAL_LPC1XXX_MCPWM                        0x400B8000
#define CYGHWR_HAL_LPC1XXX_QEI                          0x400C0000
#define CYGHWR_HAL_LPC1XXX_SCB                          0x400FC000

#define CYGHWR_HAL_LPC1XXX_ETH                          0x50000000
#define CYGHWR_HAL_LPC1XXX_DMA                          0x50004000
#define CYGHWR_HAL_LPC1XXX_USB                          0x5000C000

//=============================================================================
// System Control Block

#define CYGHWR_HAL_LPC1XXX_SCB_PLL0CON                  0x080
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0CFG                  0x084
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0STAT                 0x088
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0FEED                 0x08C

#define CYGHWR_HAL_LPC1XXX_SCB_PLL1CON                  0x0A0
#define CYGHWR_HAL_LPC1XXX_SCB_PLL1CFG                  0x0A4
#define CYGHWR_HAL_LPC1XXX_SCB_PLL1STAT                 0x0A8
#define CYGHWR_HAL_LPC1XXX_SCB_PLL1FEED                 0x0AC

#define CYGHWR_HAL_LPC1XXX_SCB_PCON                     0x0C0
#define CYGHWR_HAL_LPC1XXX_SCB_PCONP                    0x0C4

#define CYGHWR_HAL_LPC1XXX_SCB_CCLKCFG                  0x104
#define CYGHWR_HAL_LPC1XXX_SCB_USBCLKCFG                0x108
#define CYGHWR_HAL_LPC1XXX_SCB_CLKSRCSEL                0x10C

#define CYGHWR_HAL_LPC1XXX_SCB_EXTINT                   0x140
#define CYGHWR_HAL_LPC1XXX_SCB_EXTMODE                  0x148
#define CYGHWR_HAL_LPC1XXX_SCB_EXTPOLAR                 0x14C

#define CYGHWR_HAL_LPC1XXX_SCB_RSID                     0x180

#define CYGHWR_HAL_LPC1XXX_SCB_SCS                      0x1A0
#define CYGHWR_HAL_LPC1XXX_SCB_IRCTRIM                  0x1A4
#define CYGHWR_HAL_LPC1XXX_SCB_PCLKSEL0                 0x1A8
#define CYGHWR_HAL_LPC1XXX_SCB_PCLKSEL1                 0x1AC

#define CYGHWR_HAL_LPC1XXX_SCB_CLKOUTCFG                0x1C8


// SCS register
#define CYGHWR_HAL_LPC1XXX_SCB_SCS_OSCRANGE             BIT_(4)
#define CYGHWR_HAL_LPC1XXX_SCB_SCS_OSCEN                BIT_(5)
#define CYGHWR_HAL_LPC1XXX_SCB_SCS_OSCSTAT              BIT_(6)

// PLL0 registers
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0CON_PLLE             BIT_(0)
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0CON_PLLC             BIT_(1)

#define CYGHWR_HAL_LPC1XXX_SCB_PLL0CFG_MSEL(__x)        VALUE_(0,__x)
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0CFG_NSEL(__x)        VALUE_(16,__x)

#define CYGHWR_HAL_LPC1XXX_SCB_PLL0STAT_MSEL            MASK_(0,15)
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0STAT_NSEL            MASK_(16,8)
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0STAT_PLLE            BIT_(24)
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0STAT_PLLC            BIT_(25)
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0STAT_PLOCK           BIT_(26)

#define CYGHWR_HAL_LPC1XXX_SCB_PLL0FEED_KEY0            0xAA
#define CYGHWR_HAL_LPC1XXX_SCB_PLL0FEED_KEY1            0x55

// CLKSRCSEL
#define CYGHWR_HAL_LPC1XXX_SCB_CLKSRCSEL_IRC            VALUE_(0,0)
#define CYGHWR_HAL_LPC1XXX_SCB_CLKSRCSEL_MAIN           VALUE_(0,1)
#define CYGHWR_HAL_LPC1XXX_SCB_CLKSRCSEL_RTC            VALUE_(0,2)
#define CYGHWR_HAL_LPC1XXX_SCB_CLKSRCSEL_RESV           VALUE_(0,3)

//=============================================================================
// Power and clock control.
//
// The following pack clock control and power controls for each
// peripheral into a 32 bit value.
// bits
// 0:7          PCLKSEL register field bit offset, or 32 for none
// 8            PCLKSEL register number, 0 or 1
// 16:23        PCONP register bit number, or 32 for none
// 24:25        Clock divider value

#define CYGHWR_HAL_LPC1XXX_CLOCK_WDT      VALUE_(0, 0)|VALUE_(8,0)|VALUE_(16,32)
#define CYGHWR_HAL_LPC1XXX_CLOCK_TIMER0   VALUE_(0, 2)|VALUE_(8,0)|VALUE_(16, 1)
#define CYGHWR_HAL_LPC1XXX_CLOCK_TIMER1   VALUE_(0, 4)|VALUE_(8,0)|VALUE_(16, 2)
#define CYGHWR_HAL_LPC1XXX_CLOCK_UART0    VALUE_(0, 6)|VALUE_(8,0)|VALUE_(16, 3)
#define CYGHWR_HAL_LPC1XXX_CLOCK_UART1    VALUE_(0, 8)|VALUE_(8,0)|VALUE_(16, 4)
#define CYGHWR_HAL_LPC1XXX_CLOCK_PWM1     VALUE_(0,12)|VALUE_(8,0)|VALUE_(16, 6)
#define CYGHWR_HAL_LPC1XXX_CLOCK_I2C0     VALUE_(0,14)|VALUE_(8,0)|VALUE_(16, 7)
#define CYGHWR_HAL_LPC1XXX_CLOCK_SPI      VALUE_(0,16)|VALUE_(8,0)|VALUE_(16, 8)
#define CYGHWR_HAL_LPC1XXX_CLOCK_RTC      VALUE_(0,32)|VALUE_(8,0)|VALUE_(16, 9)
#define CYGHWR_HAL_LPC1XXX_CLOCK_SSP1     VALUE_(0,20)|VALUE_(8,0)|VALUE_(16,10)
#define CYGHWR_HAL_LPC1XXX_CLOCK_DAC      VALUE_(0,22)|VALUE_(8,0)|VALUE_(16,32)
#define CYGHWR_HAL_LPC1XXX_CLOCK_ADC      VALUE_(0,24)|VALUE_(8,0)|VALUE_(16,12)
#define CYGHWR_HAL_LPC1XXX_CLOCK_CAN1     VALUE_(0,26)|VALUE_(8,0)|VALUE_(16,13)
#define CYGHWR_HAL_LPC1XXX_CLOCK_CAN2     VALUE_(0,28)|VALUE_(8,0)|VALUE_(16,14)
#define CYGHWR_HAL_LPC1XXX_CLOCK_ACF      VALUE_(0,30)|VALUE_(8,0)|VALUE_(16,32)
#define CYGHWR_HAL_LPC1XXX_CLOCK_GPIO     VALUE_(0,32)|VALUE_(8,0)|VALUE_(16,15)

#define CYGHWR_HAL_LPC1XXX_CLOCK_QEI      VALUE_(0, 0)|VALUE_(8,1)|VALUE_(16,18)
#define CYGHWR_HAL_LPC1XXX_CLOCK_GPIOINT  VALUE_(0, 2)|VALUE_(8,1)|VALUE_(16,32)
#define CYGHWR_HAL_LPC1XXX_CLOCK_PCB      VALUE_(0, 4)|VALUE_(8,1)|VALUE_(16,32)
#define CYGHWR_HAL_LPC1XXX_CLOCK_I2C1     VALUE_(0, 6)|VALUE_(8,1)|VALUE_(16,19)
#define CYGHWR_HAL_LPC1XXX_CLOCK_SSP0     VALUE_(0,10)|VALUE_(8,1)|VALUE_(16,21)
#define CYGHWR_HAL_LPC1XXX_CLOCK_TIMER2   VALUE_(0,12)|VALUE_(8,1)|VALUE_(16,22)
#define CYGHWR_HAL_LPC1XXX_CLOCK_TIMER3   VALUE_(0,14)|VALUE_(8,1)|VALUE_(16,23)
#define CYGHWR_HAL_LPC1XXX_CLOCK_UART2    VALUE_(0,16)|VALUE_(8,1)|VALUE_(16,24)
#define CYGHWR_HAL_LPC1XXX_CLOCK_UART3    VALUE_(0,18)|VALUE_(8,1)|VALUE_(16,25)
#define CYGHWR_HAL_LPC1XXX_CLOCK_I2C2     VALUE_(0,20)|VALUE_(8,1)|VALUE_(16,26)
#define CYGHWR_HAL_LPC1XXX_CLOCK_I2S      VALUE_(0,22)|VALUE_(8,1)|VALUE_(16,27)
#define CYGHWR_HAL_LPC1XXX_CLOCK_RIT      VALUE_(0,26)|VALUE_(8,1)|VALUE_(16,16)
#define CYGHWR_HAL_LPC1XXX_CLOCK_SCB      VALUE_(0,28)|VALUE_(8,1)|VALUE_(16,32)
#define CYGHWR_HAL_LPC1XXX_CLOCK_MCPWM    VALUE_(0,30)|VALUE_(8,1)|VALUE_(16,17)

#define CYGHWR_HAL_LPC1XXX_CLOCK_DMA      VALUE_(0,32)|VALUE_(8,0)|VALUE_(16,29)
#define CYGHWR_HAL_LPC1XXX_CLOCK_ENET     VALUE_(0,32)|VALUE_(8,0)|VALUE_(16,30)
#define CYGHWR_HAL_LPC1XXX_CLOCK_USB      VALUE_(0,32)|VALUE_(8,0)|VALUE_(16,31)

#define CYGHWR_HAL_LPC1XXX_CLOCK_CCLK_4   VALUE_(0,0)
#define CYGHWR_HAL_LPC1XXX_CLOCK_CCLK_1   VALUE_(0,1)
#define CYGHWR_HAL_LPC1XXX_CLOCK_CCLK_2   VALUE_(0,2)
#define CYGHWR_HAL_LPC1XXX_CLOCK_CCLK_8   VALUE_(0,3)
#define CYGHWR_HAL_LPC1XXX_CLOCK_CCLK_6   VALUE_(0,3) // CAN & CAN ACF only

#define CYGHWR_HAL_LPC1XXX_CLOCK_PCLK(__desc)     ((__desc)&MASK_(0,8))
#define CYGHWR_HAL_LPC1XXX_CLOCK_REG(__desc)      (((__desc)&MASK_(8,1))>>8)
#define CYGHWR_HAL_LPC1XXX_CLOCK_PCONP(__desc)    (((__desc)&MASK_(16,8))>>16)
#define CYGHWR_HAL_LPC1XXX_CLOCK_DIV(__desc)      (((__desc)&MASK_(24,8))>>24)

// The following encoded a peripheral clock and power identifier with
// a clock speed into a 32 bit value.
#define CYGHWR_HAL_LPC1XXX_CLOCK( __peri, __div )               \
           ((CYGHWR_HAL_LPC1XXX_CLOCK_##__peri) |               \
            ((CYGHWR_HAL_LPC1XXX_CLOCK_CCLK_##__div)<<24))

// Functions and macros to enable/disable clocks and power

__externC void hal_lpc1xxx_clock_enable( cyg_uint32 desc );
__externC void hal_lpc1xxx_clock_disable( cyg_uint32 desc );

#define CYGHWR_HAL_LPC1XXX_CLOCK_ENABLE( __desc ) hal_lpc1xxx_clock_enable( __desc )
#define CYGHWR_HAL_LPC1XXX_CLOCK_DISABLE( __desc ) hal_lpc1xxx_clock_disable( __desc )

#define CYGHWR_HAL_LPC1XXX_SCB_CLOCK    CYGHWR_HAL_LPC1XXX_CLOCK( SCB, 1 )
#define CYGHWR_HAL_LPC1XXX_PCB_CLOCK    CYGHWR_HAL_LPC1XXX_CLOCK( SCB, 1 )

//=============================================================================
// GPIO ports
//

// Pin function select registers

#define CYGHWR_HAL_LPC1XXX_PCB_PINSEL(__port, __bit)            (0x00+((__port)*8)+(((__bit)&0x10)>>2))
#define CYGHWR_HAL_LPC1XXX_PCB_PINMODE(__port, __bit)           (0x40+((__port)*8)+(((__bit)&0x10)>>2))
#define CYGHWR_HAL_LPC1XXX_PCB_PINMODE_OD(__port, __bit)        (0x68+((__port)*4))
#define CYGHWR_HAL_LPC1XXX_PCB_I2CPAFCFG                        (0x7C)

#define CYGHWR_HAL_LPC1XXX_PCB_PINSEL_FIELD(__bit, __mode)      ((__mode)<<(((__bit)&0xF)*2))
#define CYGHWR_HAL_LPC1XXX_PCB_PINMODE_FIELD(__bit, __mode)     ((__mode)<<(((__bit)&0xF)*2))

// GPIO registers

#define CYGHWR_HAL_LPC1XXX_GPIO_FIODIR(__port)                  (0x00+((__port)*0x20))
#define CYGHWR_HAL_LPC1XXX_GPIO_FIOMASK(__port)                 (0x10+((__port)*0x20))
#define CYGHWR_HAL_LPC1XXX_GPIO_FIOPIN(__port)                  (0x14+((__port)*0x20))
#define CYGHWR_HAL_LPC1XXX_GPIO_FIOSET(__port)                  (0x18+((__port)*0x20))
#define CYGHWR_HAL_LPC1XXX_GPIO_FIOCLR(__port)                  (0x1C+((__port)*0x20))

// GPIO pin mode encoding

#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_GPIO                       VALUE_(0,0)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_ALT1                       VALUE_(0,1)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_ALT2                       VALUE_(0,2)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_ALT3                       VALUE_(0,3)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_PULLUP                     VALUE_(2,0)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_REPEATER                   VALUE_(2,1)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_FLOAT                      VALUE_(2,2)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_PULLDOWN                   VALUE_(2,3)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_OPENDRAIN                  BIT_(4)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_OUTPUT                     BIT_(5)

#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_PINSEL(__mode)             ((__mode)&3)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_PINMODE(__mode)            (((__mode)>>2)&3)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_PINMODE_OD(__mode)         (((__mode)>>4)&1)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE_DIR(__mode)                (((__mode)>>5)&1)

#define CYGHWR_HAL_LPC1XXX_GPIO_IN_PULLUP     (CYGHWR_HAL_LPC1XXX_GPIO_MODE_GPIO|CYGHWR_HAL_LPC1XXX_GPIO_MODE_PULLUP)
#define CYGHWR_HAL_LPC1XXX_GPIO_IN_PULLDOWN   (CYGHWR_HAL_LPC1XXX_GPIO_MODE_GPIO|CYGHWR_HAL_LPC1XXX_GPIO_MODE_PULLDOWN)
#define CYGHWR_HAL_LPC1XXX_GPIO_OUT_OPENDRAIN (CYGHWR_HAL_LPC1XXX_GPIO_MODE_GPIO|CYGHWR_HAL_LPC1XXX_GPIO_MODE_OUTPUT|CYGHWR_HAL_LPC1XXX_GPIO_MODE_OPENDRAIN)

// This macro packs the port number, bit number and mode for a GPIO
// pin into a single word. The packing puts the mode in the ls 8 bits,
// the bit number in 16:20 and the GPIO port number bits 8:10. The
// mode is only specified using the last component of the name to
// keep definitions short.

#define CYGHWR_HAL_LPC1XXX_GPIO(__port, __bit, __mode )                 \
    (((__port)<< 8)                                              |      \
     ((__bit)<<16)                                               |      \
     (CYGHWR_HAL_LPC1XXX_GPIO_MODE_##__mode)                     )

// Macros to extract encoded values
#define CYGHWR_HAL_LPC1XXX_GPIO_PORT(__pin)                     (((__pin)&0x00000700)>>8)
#define CYGHWR_HAL_LPC1XXX_GPIO_BIT(__pin)                      (((__pin)>>16)&0x1F)
#define CYGHWR_HAL_LPC1XXX_GPIO_MODE(__pin)                     ((__pin)&0xFF)

#define CYGHWR_HAL_LPC1XXX_GPIO_NONE      (0xFFFFFFFF)

// Functions and macros to configure GPIO ports.

__externC void hal_lpc1xxx_gpio_set( cyg_uint32 pin );
__externC void hal_lpc1xxx_gpio_out( cyg_uint32 pin, int val );
__externC void hal_lpc1xxx_gpio_in ( cyg_uint32 pin, int *val );

#define CYGHWR_HAL_LPC1XXX_GPIO_SET(__pin )        hal_lpc1xxx_gpio_set( __pin )
#define CYGHWR_HAL_LPC1XXX_GPIO_OUT(__pin, __val ) hal_lpc1xxx_gpio_out( __pin, __val )
#define CYGHWR_HAL_LPC1XXX_GPIO_IN(__pin,  __val ) hal_lpc1xxx_gpio_in( __pin, __val )


#define CYGHWR_HAL_LPC1XXX_GPIO_CLOCK   CYGHWR_HAL_LPC1XXX_CLOCK( GPIO, 1 )

//=============================================================================
// UARTs

#define CYGHWR_HAL_LPC1XXX_UART_RBR                     0x0000 // DLAB=0 read
#define CYGHWR_HAL_LPC1XXX_UART_THR                     0x0000 // DLAB=0 write
#define CYGHWR_HAL_LPC1XXX_UART_DLL                     0x0000 // DLAB=1 r/w
#define CYGHWR_HAL_LPC1XXX_UART_IER                     0x0004 // DLAB=0
#define CYGHWR_HAL_LPC1XXX_UART_DLM                     0x0004 // DLAB=1
#define CYGHWR_HAL_LPC1XXX_UART_IIR                     0x0008 // read
#define CYGHWR_HAL_LPC1XXX_UART_FCR                     0x0008 // write
#define CYGHWR_HAL_LPC1XXX_UART_LCR                     0x000C
#define CYGHWR_HAL_LPC1XXX_UART_MCR                     0x0010 // UART 1 only
#define CYGHWR_HAL_LPC1XXX_UART_LSR                     0x0014
#define CYGHWR_HAL_LPC1XXX_UART_MSR                     0x0018 // UART 1 only
#define CYGHWR_HAL_LPC1XXX_UART_SCR                     0x001C


#define CYGHWR_HAL_LPC1XXX_UART_IER_RXDATA_INT          (1<<0)
#define CYGHWR_HAL_LPC1XXX_UART_IER_THRE_INT            (1<<1)
#define CYGHWR_HAL_LPC1XXX_UART_IER_RXLS_INT            (1<<2)
#define CYGHWR_HAL_LPC1XXX_UART_IER_RXMS_INT            (1<<3) // UART 1 only

#define CYGHWR_HAL_LPC1XXX_UART_IIR_IIR0                (1<<0)
#define CYGHWR_HAL_LPC1XXX_UART_IIR_IIR1                (1<<1)
#define CYGHWR_HAL_LPC1XXX_UART_IIR_IIR2                (1<<2)
#define CYGHWR_HAL_LPC1XXX_UART_IIR_IIR3                (1<<3)
#define CYGHWR_HAL_LPC1XXX_UART_IIR_FIFOS               (0xB0)

#define CYGHWR_HAL_LPC1XXX_UART_FCR_FIFO_ENA            (1<<0)
#define CYGHWR_HAL_LPC1XXX_UART_FCR_RX_FIFO_RESET       (1<<1)
#define CYGHWR_HAL_LPC1XXX_UART_FCR_TX_FIFO_RESET       (1<<2)
#define CYGHWR_HAL_LPC1XXX_UART_FCR_RX_TRIGGER_0        (0x00)
#define CYGHWR_HAL_LPC1XXX_UART_FCR_RX_TRIGGER_1        (0x40)
#define CYGHWR_HAL_LPC1XXX_UART_FCR_RX_TRIGGER_2        (0x80)
#define CYGHWR_HAL_LPC1XXX_UART_FCR_RX_TRIGGER_3        (0xB0)

#define CYGHWR_HAL_LPC1XXX_UART_LCR_WORD_LENGTH_5       (0x00)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_WORD_LENGTH_6       (0x01)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_WORD_LENGTH_7       (0x02)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_WORD_LENGTH_8       (0x03)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_STOP_1              (0x00)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_STOP_2              (0x04)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_PARITY_ENA          (0x08)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_PARITY_ODD          (0x00)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_PARITY_EVEN         (0x10)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_PARITY_ONE          (0x20)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_PARITY_ZERO         (0x30)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_BREAK_ENA           (0x40)
#define CYGHWR_HAL_LPC1XXX_UART_LCR_DLAB                (0x80)


// Modem Control Register is UART1 only
#define CYGHWR_HAL_LPC1XXX_UART_MCR_DTR                 (1<<0)
#define CYGHWR_HAL_LPC1XXX_UART_MCR_RTS                 (1<<1)
#define CYGHWR_HAL_LPC1XXX_UART_MCR_LOOPBACK            (1<<4)

#define CYGHWR_HAL_LPC1XXX_UART_LSR_RDR                 (1<<0)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_OE                  (1<<1)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_PE                  (1<<2)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_FE                  (1<<3)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_BI                  (1<<4)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_THRE                (1<<5)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_TEMT                (1<<6)
#define CYGHWR_HAL_LPC1XXX_UART_LSR_RX_FIFO_ERR         (1<<7)

// Modem Status Register is UART1 only
#define CYGHWR_HAL_LPC1XXX_UART_MSR_DCTS                (1<<0)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_DDSR                (1<<1)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_RI_FALL             (1<<2)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_DDCD                (1<<3)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_CTS                 (1<<4)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_DSR                 (1<<5)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_RI                  (1<<6)
#define CYGHWR_HAL_LPC1XXX_UART_MSR_DCD                 (1<<7)

#define CYGHWR_HAL_LPC1XXX_UART0_TX             CYGHWR_HAL_LPC1XXX_GPIO( 0,  2, ALT1 )
#define CYGHWR_HAL_LPC1XXX_UART0_RX             CYGHWR_HAL_LPC1XXX_GPIO( 0,  3, ALT1 )
#define CYGHWR_HAL_LPC1XXX_UART0_CLOCK          CYGHWR_HAL_LPC1XXX_CLOCK( UART0, 1 )

#define CYGHWR_HAL_LPC1XXX_UART1_TX             CYGHWR_HAL_LPC1XXX_GPIO( 2, 0, ALT2 )
#define CYGHWR_HAL_LPC1XXX_UART1_RX             CYGHWR_HAL_LPC1XXX_GPIO( 2, 1, ALT2 )
#define CYGHWR_HAL_LPC1XXX_UART1_CLOCK          CYGHWR_HAL_LPC1XXX_CLOCK( UART1, 1 )

#define CYGHWR_HAL_LPC1XXX_UART2_TX             CYGHWR_HAL_LPC1XXX_GPIO( 0, 10, ALT1 )
#define CYGHWR_HAL_LPC1XXX_UART2_RX             CYGHWR_HAL_LPC1XXX_GPIO( 0, 11, ALT1 )
#define CYGHWR_HAL_LPC1XXX_UART2_CLOCK          CYGHWR_HAL_LPC1XXX_CLOCK( UART2, 1 )

#define CYGHWR_HAL_LPC1XXX_UART3_TX             CYGHWR_HAL_LPC1XXX_GPIO( 0,  0, ALT2 )
#define CYGHWR_HAL_LPC1XXX_UART3_RX             CYGHWR_HAL_LPC1XXX_GPIO( 0,  1, ALT2 )
#define CYGHWR_HAL_LPC1XXX_UART3_CLOCK          CYGHWR_HAL_LPC1XXX_CLOCK( UART3, 1 )

//=============================================================================
// Timers

#define CYGHWR_HAL_LPC1XXX_TIMER_IR                      0x0000
#define CYGHWR_HAL_LPC1XXX_TIMER_TCR                     0x0004
#define CYGHWR_HAL_LPC1XXX_TIMER_TC                      0x0008
#define CYGHWR_HAL_LPC1XXX_TIMER_PR                      0x000C
#define CYGHWR_HAL_LPC1XXX_TIMER_PC                      0x0010
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR                     0x0014
#define CYGHWR_HAL_LPC1XXX_TIMER_MR0                     0x0018
#define CYGHWR_HAL_LPC1XXX_TIMER_MR1                     0x001C
#define CYGHWR_HAL_LPC1XXX_TIMER_MR2                     0x0020
#define CYGHWR_HAL_LPC1XXX_TIMER_MR3                     0x0024
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR                     0x0028
#define CYGHWR_HAL_LPC1XXX_TIMER_CR0                     0x002C
#define CYGHWR_HAL_LPC1XXX_TIMER_CR1                     0x0030
#define CYGHWR_HAL_LPC1XXX_TIMER_CR2                     0x0034
#define CYGHWR_HAL_LPC1XXX_TIMER_CR3                     0x0038
#define CYGHWR_HAL_LPC1XXX_TIMER_EMR                     0x003C

#define CYGHWR_HAL_LPC1XXX_TIMER_TCR_CTR_ENABLE          (1<<0)
#define CYGHWR_HAL_LPC1XXX_TIMER_TCR_CTR_RESET           (1<<1)

#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR0_INT             (1<<0)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR0_RESET           (1<<1)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR0_STOP            (1<<2)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR1_INT             (1<<3)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR1_RESET           (1<<4)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR1_STOP            (1<<5)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR2_INT             (1<<6)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR2_RESET           (1<<7)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR2_STOP            (1<<8)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR3_INT             (1<<9)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR3_RESET           (1<<10)
#define CYGHWR_HAL_LPC1XXX_TIMER_MCR_MR3_STOP            (1<<11)

#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR0_RISE        (1<<0)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR0_FALL        (1<<1)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR0             (1<<2)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR1_RISE        (1<<3)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR1_FALL        (1<<4)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR1             (1<<5)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR2_RISE        (1<<6)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR2_FALL        (1<<7)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR2             (1<<8)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR3_RISE        (1<<9)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR3_FALL        (1<<10)
#define CYGHWR_HAL_LPC1XXX_TIMER_CCR_INT_CR3             (1<<11)

#define CYGHWR_HAL_LPC1XXX_TIMER_EMR_EM0                 (1<<0)
#define CYGHWR_HAL_LPC1XXX_TIMER_EMR_EM1                 (1<<1)
#define CYGHWR_HAL_LPC1XXX_TIMER_EMR_EM2                 (1<<2)
#define CYGHWR_HAL_LPC1XXX_TIMER_EMR_EM3                 (1<<3)

#define CYGHWR_HAL_LPC1XXX_TIMER0_CLOCK                 CYGHWR_HAL_LPC1XXX_CLOCK( TIMER0, 1 )
#define CYGHWR_HAL_LPC1XXX_TIMER1_CLOCK                 CYGHWR_HAL_LPC1XXX_CLOCK( TIMER1, 1 )
#define CYGHWR_HAL_LPC1XXX_TIMER2_CLOCK                 CYGHWR_HAL_LPC1XXX_CLOCK( TIMER2, 1 )
#define CYGHWR_HAL_LPC1XXX_TIMER3_CLOCK                 CYGHWR_HAL_LPC1XXX_CLOCK( TIMER3, 1 )

//-----------------------------------------------------------------------------
// end of var_io.h
#endif // CYGONCE_HAL_VAR_IO_H
