//==========================================================================
//
//      dumpdisk.c
//
//      Disk driver test
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004, 2005, 2006, 2007 Free Software Foundation, Inc.
// Copyright (C) 2004, 2005, 2006, 2007 eCosCentric Limited                 
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):           nickg
// Contributors:        nickg
// Date:                2005-11-25
// Purpose:             disk dump utility
// Description:
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal.h>
#include <pkgconf/kernel.h>
#include <pkgconf/io_fileio.h>

#include CYGDAT_DEVS_DISK_CFG           // testing config defines

#include <cyg/kernel/ktypes.h>         // base kernel types
#include <cyg/infra/cyg_trac.h>        // tracing macros
#include <cyg/infra/cyg_ass.h>         // assertion macros


#include <cyg/infra/testcase.h>
#include <cyg/infra/diag.h>            // HAL polled output

#include <cyg/io/io.h>
#include <cyg/io/disk.h>

#include <cyg/kernel/kapi.h>

#include <stdlib.h>

#ifdef CYGPKG_NET

#include <network.h>

#include <tftp_support.h>

//==========================================================================
// Config options. Set the size of the dump and the SERVER address
// here. Note that the buffer size needs to be malloc()able.

#define BUFFER_SIZE             (8*(1024*1024))

#define SERVER                  "10.0.1.2"

#ifdef CYGDAT_DEVS_DISK_TEST_DEVICE
# define TEST_DEV CYGDAT_DEVS_DISK_TEST_DEVICE
#else
# define TEST_DEV "/dev/hd0/0"
#endif

#if CYGINT_IO_DISK_ALIGN_BUFS_TO_CACHELINE
# include <cyg/hal/hal_cache.h>
# define BLOCKALIGN     (HAL_DCACHE_LINE_SIZE)
#else
# define BLOCKALIGN     (1)
#endif

//==========================================================================
// main

void dumpdisk_main( CYG_ADDRESS id )
{
    int                 result;
    int                 err;
    cyg_disk_info_t     info;
    cyg_uint32          len = 1;
    char                buf = 1;
    int                 i;
    int                 size;
    char                *buffer;
    cyg_io_handle_t     device;
    cyg_uint32          sector_size;
    cyg_uint32          disk_size;
    cyg_uint32          phys_block_size;
    cyg_uint32          sector = 0;
    
    CYG_TEST_INIT();
    
    result = cyg_io_lookup( "/dev/hd0/0", &device );
    CYG_ASSERT( result == ENOERR, "Unexpected error" );

    result = cyg_io_set_config(device, CYG_IO_SET_CONFIG_DISK_MOUNT, &buf, &len);
    CYG_ASSERT( result == ENOERR, "Unexpected error" );

    len = sizeof(cyg_disk_info_t);
    result = cyg_io_get_config( device, CYG_IO_GET_CONFIG_DISK_INFO, &info, &len );
    CYG_ASSERT( result == ENOERR, "Unexpected error" );
    
    sector_size        = info.block_size;
    disk_size          = info.blocks_num;        
    phys_block_size    = info.phys_block_size;

    buffer = malloc( BUFFER_SIZE + BLOCKALIGN - 1 );
    CYG_ASSERT( buffer != NULL, "Buffer alloc failed" );
    buffer = (cyg_uint8*)(((CYG_ADDRESS)buffer + BLOCKALIGN - 1) & ~(BLOCKALIGN - 1));

    init_all_network_interfaces();
    
    size = BUFFER_SIZE/sector_size;
    result = cyg_io_bread( device, buffer, &size, sector );
    CYG_ASSERT( result == ENOERR, "Unexpected error" );

    result = tftp_client_put( "disk_dump", SERVER, 69, buffer, BUFFER_SIZE, TFTP_OCTET, &err );
    diag_printf("result %d err %d\n", result, err );
        
    CYG_TEST_FINISH( "dumpdisk" );
}

// -------------------------------------------------------------------------


static cyg_handle_t thread_handle;
static cyg_thread thread;
static char stack[CYGNUM_HAL_STACK_SIZE_TYPICAL+1024*4];

externC void
cyg_start( void )
{
    cyg_thread_create(3,                // Priority - just a number
                      dumpdisk_main,    // entry
                      0,                // index
                      0,                // no name
                      &stack[0],        // Stack
                      sizeof(stack),    // Size
                      &thread_handle,   // Handle
                      &thread           // Thread data structure
        );
    cyg_thread_resume(thread_handle);

    cyg_scheduler_start();
}

#else

externC void
cyg_start( void )
{
    CYG_TEST_NA("Not NET support");
}


#endif

// -------------------------------------------------------------------------
// EOF dumpdisk.c
