#include <pkgconf/system.h>
#include <pkgconf/libstdcxx.h> // config header
#ifdef CYGPKG_ISOINFRA
# include <pkgconf/isoinfra.h>
#endif
#include <cyg/infra/testcase.h>

#if !defined(CYGPKG_ISOINFRA)
# define NA_MSG "Requires isoinfra package"
#elif !defined(CYGPKG_LIBSTDCXX_LIBRARY)
# define NA_MSG "Requires libstdc++ library support"
#elif !CYGINT_ISO_MAIN_STARTUP
# define NA_MSG "Requires main() startup"
#endif

#ifdef NA_MSG

externC void
cyg_start()
{
    CYG_TEST_INIT();
    CYG_TEST_NA( NA_MSG );
    CYG_TEST_FINISH("Done");
}
#else

// 2001-02-06  Benjamin Kosnik  <bkoz@redhat.com>

// Copyright (C) 2001 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// 17.4.1.2 Headers, cstdarg

#include <cstdarg>

namespace gnu
{
  void test01()
  { 
    std::va_list list;
#ifndef va_arg
    CYG_TEST_FAIL( "va_arg_must_be_a_macro" );
//    #error "va_arg_must_be_a_macro"
#endif
#ifndef va_end
    CYG_TEST_FAIL( "va_end_must_be_a_macro" );
//    #error "va_end_must_be_a_macro"
#endif
#ifndef va_start
    CYG_TEST_FAIL( "va_start_must_be_a_macro" );
//    #error "va_start_must_be_a_macro"
#endif
  }
}
  
int main()
{
    CYG_TEST_INIT();
  gnu::test01();
  CYG_TEST_PASS_FINISH( "header_cstdarg done" );
  return 0;
}

#endif // !NA_MSG

// EOF
