/*========================================================================
//
//      mathfp/s_acos.c
//
//      Part of the standard mathematical function library
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     jlarmour
// Contributors:  
// Date:          2004-02-30
// Purpose:       
// Description:   Derived from newlib libm
//                http://sources.redhat.com/newlib
//                in turn based on SunSoft fdlibm.
//                See copyright/license information below.
// Usage:         #include <math.h>
//
//####DESCRIPTIONEND####
//======================================================================*/


/* @(#)z_acos.c 1.0 98/08/13 */

/*
FUNCTION
        <<acos>>, <<acosf>>---arc cosine

INDEX
        acos
INDEX
        acosf

ANSI_SYNOPSIS
        #include <math.h>
        double acos(double <[x]>);
        float acosf(float <[x]>);

TRAD_SYNOPSIS
        #include <math.h>
        double acos(<[x]>)
        double <[x]>;

        float acosf(<[x]>)
        float <[x]>;



DESCRIPTION

        <<acos>> computes the inverse cosine (arc cosine) of the input value.
        Arguments to <<acos>> must be in the range @minus{}1 to 1.

        <<acosf>> is identical to <<acos>>, except that it performs
        its calculations on <<floats>>.

RETURNS
        @ifnottex
        <<acos>> and <<acosf>> return values in radians, in the range of 0 to pi
.
        @end ifnottex
        @tex
        <<acos>> and <<acosf>> return values in radians, in the range of <<0>> t
o $\pi$.
        @end tex

        If <[x]> is not between @minus{}1 and 1, the returned value is NaN
        (not a number) the global variable <<errno>> is set to <<EDOM>>, and a
        <<DOMAIN error>> message is sent as standard error output.

        You can modify error handling for these functions using <<matherr>>.


QUICKREF ANSI SVID POSIX RENTRANT
 acos    y,y,y,m
 acosf   n,n,n,m

MATHREF
 acos, [-1,1], acos(arg),,,
 acos, NAN,    arg,DOMAIN,EDOM

MATHREF
 acosf, [-1,1], acosf(arg),,,
 acosf, NAN,    argf,DOMAIN,EDOM

*/

/*****************************************************************
 * Arccosine
 *
 * Input:
 *   x - floating point value
 *
 * Output:
 *   arccosine of x
 *
 * Description:
 *   This routine returns the arccosine of x.
 *
 *****************************************************************/

#include "mathincl/fdlibm.h"
#include "zmath.h"

#ifndef _DOUBLE_IS_32BITS

double
_DEFUN (acos, (double),
        double x)
{
  return (asine (x, 1));
}

#endif /* _DOUBLE_IS_32BITS */

// EOF s_acos.c
