/*========================================================================
//
//      mathfp/sf_ldexp.c
//
//      Part of the standard mathematical function library
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2004 Free Software Foundation, Inc.
// Copyright (C) 2004 eCosCentric Limited                                   
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     jlarmour
// Contributors:  
// Date:          2004-02-30
// Purpose:       
// Description:   Derived from newlib libm
//                http://sources.redhat.com/newlib
//                in turn based on SunSoft fdlibm.
//                See copyright/license information below.
// Usage:         #include <math.h>
//
//####DESCRIPTIONEND####
//======================================================================*/


/* @(#)z_ldexpf.c 1.0 98/08/13 */
/******************************************************************
 * ldexp
 *
 * Input:
 *   d - a floating point value
 *   e - an exponent value
 *
 * Output:
 *   A floating point value f such that f = d * 2 ^ e.
 *
 * Description:
 *   This function creates a floating point number f such that
 *   f = d * 2 ^ e.
 *
 *****************************************************************/

#include <float.h>
#include "mathincl/fdlibm.h"
#include "zmath.h"

#define FLOAT_EXP_OFFS 127

float
_DEFUN (ldexpf, (float, int),
        float d _AND
        int e)
{
  int exp;
  __int32_t wd;

  GET_FLOAT_WORD (wd, d);

  /* Check for special values and then scale d by e. */
  switch (numtestf (wd))
    {
      case NAN:
        errno = EDOM;
        break;

      case INF:
        errno = ERANGE;
        break;

      case 0:
        break;

      default:
        exp = (wd & 0x7f800000) >> 23;
        exp += e;

        if (exp > FLT_MAX_EXP + FLOAT_EXP_OFFS)
         {
           errno = ERANGE;
           d = z_infinity_f.f;
         }
        else if (exp < FLT_MIN_EXP + FLOAT_EXP_OFFS)
         {
           errno = ERANGE;
           d = -z_infinity_f.f;
         }
        else
         {
           wd &= 0x807fffff;
           wd |= exp << 23;
           SET_FLOAT_WORD (d, wd);
         }
    }

    return (d);
}

#ifdef _DOUBLE_IS_32BITS

double ldexp (double x, int e)
{
  return (double) ldexpf ((float) x, e);
}

#endif /* defined(_DOUBLE_IS_32BITS) */

// EOF sf_ldexp.c
