//========================================================================
//
//      sys_timeout.c
//
//      lwIP timeout testing
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 2004, 2006 Free Software Foundation, Inc.                  
// Copyright (C) 2004, 2006 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================

/* Simple test-case for the lwip system timeout functionality  */

#include <pkgconf/net_lwip.h>
#include "lwip/sys.h"
#include <cyg/infra/testcase.h>
#include <cyg/kernel/kapi.h>
#include <cyg/hal/hal_arch.h> // CYGNUM_HAL_STACK_SIZE_TYPICAL

// TIMERS is number of timers to create. We use all timers, less one
// for the implicit timer used for sys_msleep.
#define TIMERS (CYGNUM_LWIP_MEMP_NUM_USER_TIMEOUTS-1)
#if TIMERS <= 0
#define NA_MSG "Not enough user timers available"
#endif


#ifdef NA_MSG
__externC void
cyg_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_NA(NA_MSG);
}
#else

sys_timeout_handler timers[TIMERS];
int intervals[TIMERS];
static int timercalls;

static void
timeout_fn ( void * arg)
{
	int i, j = (int)arg;
//	diag_printf("Timeout #%d called\n", (int)arg);
        diag_printf("INFO:<Call from timer ");
	for (i = 0; i < j; i++)
		diag_printf(" ");
	diag_printf("%d>\n", j);
        timercalls++;
//	sys_timeout( intervals[j], timers[j], arg);	
	sys_timeout( 1000, timers[j], arg);	
}

static void
timeout_thread(cyg_addrword_t arg)
{
  int i;
  
  CYG_TEST_INFO( "Starting lwIP system timeout test");
  cyg_lwip_init();	
  CYG_TEST_PASS( "Completed cyg_lwip_init");
  for (i = 0; i < TIMERS; i++) {
	  diag_printf("INFO:<Adding timer #%d>\n", i);
	  timers[i] = timeout_fn;
	  intervals[i] = 1000+(i);
	  sys_timeout(intervals[i],  timers[i], (void *)i);
  }
  sys_msleep(15000+TIMERS+100);
  for (i = 0; i < TIMERS; i++) {
      sys_untimeout( timers[i], (void *)i );
  }
  CYG_TEST_PASS_FAIL( timercalls == TIMERS*15, "Timers run correct number of times");
  CYG_TEST_EXIT("sys_timeout test");
}


#define STACK_SIZE CYGNUM_HAL_STACK_SIZE_TYPICAL
static char stack[STACK_SIZE] CYGBLD_ATTRIB_ALIGN_MAX;
static cyg_thread thread_data;
static cyg_handle_t thread_handle;

void
cyg_user_start(void)
{
    CYG_TEST_INIT();
    // Create a main thread, so we can run the scheduler and have time 'pass'
    CYG_TEST_INFO("Creating sys_timeout test thread");
    cyg_thread_create(10,                // Priority - just a number
                      timeout_thread,    // entry
                      0,                 // entry parameter
                      "timeout test",        // Name
                      &stack[0],         // Stack
                      STACK_SIZE,        // Size
                      &thread_handle,    // Handle
                      &thread_data       // Thread data structure
            );
    cyg_thread_resume(thread_handle);  // Start it
}
#endif // !defined NA_MSG

// EOF sys_timeout.c
