//========================================================================
//
//      sysheap.cxx
//
//      Provide the system heap used by malloc() etc., if not provided
//      elsewhere. This code works in conjunction with malloc.cxx
//
//========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002, 2005, 2008 Free Software Foundation, Inc.
// Copyright (C) 2005, 2008 eCosCentric Limited                             
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     bartv
// Original code: jlarmour
// Contributors:  
// Date:          2000-04-30
// Purpose:       Provide the system heap if necessary.
//
//####DESCRIPTIONEND####
//
//========================================================================

#include <pkgconf/memalloc.h>

// If malloc() has been configured out, don't do anything.
#ifdef CYGPKG_MEMALLOC_MALLOC_ALLOCATORS

# include <cyg/infra/cyg_type.h>
# include <cyg/infra/cyg_trac.h>
# include <cyg/infra/cyg_ass.h>

// Usually the system heap is generated from the linker script
// by heapgen.tcl. That generates two files, <pkgconf/heaps.hxx>
// and heaps.cxx in the build tree. In some circumstances it
// may be desirable for another package, for example a platform
// HAL, to provide the system heap by other means.
# ifdef CYGBLD_MEMALLOC_MALLOC_EXTERNAL_HEAP_H
#  include CYGBLD_MEMALLOC_MALLOC_EXTERNAL_HEAP_H
# else
#  include <pkgconf/heaps.hxx>       // heap pools information
# endif
# include CYGBLD_MEMALLOC_MALLOC_IMPLEMENTATION_HEADER

# if CYGMEM_HEAP_COUNT == 0

// If the above has not provided any suitable memory pools we need to
// define a fallback pool here. This will be eliminated at link-time
// if the application does not need dynamic memory allocation, directly
// or indirectly.

static cyg_uint8 cyg_memalloc_mallocpool_memory[ CYGNUM_MEMALLOC_FALLBACK_MALLOC_POOL_SIZE ] CYGBLD_ATTRIB_WEAK;
CYGCLS_MEMALLOC_MALLOC_IMPL cyg_memalloc_mallocpool
   CYGBLD_ATTRIB_INIT_PRI( CYG_INIT_MEMALLOC ) =
   CYGCLS_MEMALLOC_MALLOC_IMPL( cyg_memalloc_mallocpool_memory, sizeof( cyg_memalloc_mallocpool_memory ) );

# elif CYGMEM_HEAP_COUNT == 1

// The common case. Nothing to be done here. The malloc code will just
// use cygmem_memalloc_heaps[0]

# else 

// There are multiple pools. Use a Mempool_Joined to combine them
// giving the system heap. This must be run only after the component heaps
// are initialised, hence CYG_INIT_MEMALLOC+1.

#ifdef CYGBLD_MEMALLOC_MALLOC_EXTERNAL_JOIN_H
# include CYGBLD_MEMALLOC_MALLOC_EXTERNAL_JOIN_H
#else
# include <cyg/memalloc/memjoin.hxx>
#endif

Cyg_Mempool_Joined<CYGCLS_MEMALLOC_MALLOC_IMPL> cyg_memalloc_mallocpool
   CYGBLD_ATTRIB_INIT_PRI( CYG_INIT_MEMALLOC+1 ) =
     Cyg_Mempool_Joined<CYGCLS_MEMALLOC_MALLOC_IMPL>(
       CYGMEM_HEAP_COUNT, cygmem_memalloc_heaps
     );

# endif // CYGMEM_HEAP_COUNT == 0/1/many

#endif // ifdef CYGPKG_MEMALLOC_MALLOC_ALLOCATORS

// EOF sysheap.cxx
