#include <config.h>
#include <common.h>
#include <linux-adapter.h>
#include <asm/arch/platform.h>

static void _delay_cl(unsigned long cl)
{
	for(cl=(cl*CFG_CPUCLK_SCALE)>>2; cl!=0; cl--)
		__asm__ __volatile__("nop");
}

void hisi_oem_init(void)
{
	unsigned long base = REG_BASE_SCTL;
	
	//EPLL
	__raw_writel(REG_CONF_PERCTRL6,base + REG_SC_PERCTRL6);
	__raw_writel(REG_CONF_PERCTRL7,base + REG_SC_PERCTRL7);
	_delay_cl(100);
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL7)|(1<<22),base + REG_SC_PERCTRL7);
	
	//VPLL
	__raw_writel(0xAB000000,base + REG_SC_PERCTRL2);
	__raw_writel(0x002c2087,base + REG_SC_PERCTRL3);
	_delay_cl(100);
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL3)|(1<<22),base + REG_SC_PERCTRL3);
	
	 __raw_writel(0xAB000000,base + REG_SC_PERCTRL4);
	 __raw_writel(0x002c2087,base + REG_SC_PERCTRL5);
	 _delay_cl(100);
	 __raw_writel(__raw_readl(base + REG_SC_PERCTRL5)|(1<<22),base + REG_SC_PERCTRL5);

	 //set IOCONFIG for SFV300
	  __raw_writel(0x0 ,REG_BASE_IO + 0xb8);
	  __raw_writel(0x0 ,REG_BASE_IO + 0xbc);

	//set IOCONFIG for SATA
	__raw_writel(0x0 ,REG_BASE_IO + 0x8c);//SATALEDN0
	__raw_writel(0x0 ,REG_BASE_IO + 0x90);//SATALEDN1

	//set IOCINFG for SDIO
	__raw_writel(0x1 ,REG_BASE_IO + 0x60);//GPIO5_4 WPS
	__raw_writel(0x1 ,REG_BASE_IO + 0x64);//GPIO5_5 POWER_ON
	__raw_writel(0x2 ,REG_BASE_IO + 0x70);//CLK
	__raw_writel(0x2 ,REG_BASE_IO + 0x74);//CMD
	__raw_writel(0x2 ,REG_BASE_IO + 0x78);//DAT0
	__raw_writel(0x2 ,REG_BASE_IO + 0x7c);//DAT1
	__raw_writel(0x2 ,REG_BASE_IO + 0x80);//DAT2
	__raw_writel(0x2 ,REG_BASE_IO + 0x84);//DAT3
	__raw_writel(0x2 ,REG_BASE_IO + 0x88);//DETC

	//set IOCONFIG for NAND
	__raw_writel(0x0 ,REG_BASE_IO + 0xb0);//NF_RB

	//set IOCONFIG for USB
	__raw_writel(0x1 ,REG_BASE_IO + 0x54);//GPIO5_1 USB0_POWER_EN
	__raw_writel(0x1 ,REG_BASE_IO + 0x5C);//GPIO5_3 USB1_POWER_EN

}
