/*
 * (C) Copyright 2002
 * Gary Jennejohn, DENX Software Engineering, <gj@denx.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)
SECTIONS
{
	. = 0x00000000;
	. = ALIGN(4);
	.text	:
	{
	  cpu/arm926ejs/start.o	(.text)
	  board/hi3515v100/libhi3515v100.a (.text)
	  common/dlmalloc.o (.text)
	  common/console.o (.text)
	  common/nand_boot.o (.text)
	  drivers/mtd/libmtd.a (.text)
	  drivers/mtd/nand/libnand.a (.text)
	  lib_generic/libgeneric.a (.text)
	  cpu/arm926ejs/libarm926ejs.a (.text)
	  cpu/arm926ejs/hi3515v100/libhi3515v100.a (.text)
	  lib_arm/libarm.a (.text)
	  drivers/serial/libserial.a (.text)
	}
	. = ALIGN(4);
	.rodata : { *(.rodata) }
	. = ALIGN(4);
	.data : { *(.data) }
	. = ALIGN(4);
	.got : { *(.got) }
	. = ALIGN(4);
	.text1 :
	{
	  *(.text)
	}
	. = ALIGN(4);
	. = .;
	__u_boot_cmd_start = .;
	.u_boot_cmd : { *(.u_boot_cmd) }
	__u_boot_cmd_end = .;
	__img_end = .;

	. = _start + 0x100000;
	. = ALIGN(32);
	__bss_start = .;
	.bss1 (NOLOAD) : {*(.bss)}
	_end = .;
}
