/******************************************************************************

  Copyright (C), 2001-2011, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : vou_gfx_hal.h
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2009/03/13
  Description   :
  History       :
  1.Date        : 2009/03/13
    Author      : x00100808
    Modification: Created file

******************************************************************************/

#ifndef __VOU_GFX_HAL_H__
#define __VOU_GFX_HAL_H__

#include "vou_reg.h"
#include "vou_def.h"

#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* End of #ifdef __cplusplus */

HI_VOID HAL_VOU_Init(HI_VOID);
HI_VOID HAL_SYS_Control(HI_VOID);
HI_VOID HAL_WriteReg(HI_U32 Address, HI_U32 Value);
HI_VOID HAL_ReadReg(HI_U32 Address, HI_U32 *pValue);


/*****************************************************************************
 Prototype       : Interface Relative
 Description     :

*****************************************************************************/
HI_BOOL HAL_DISP_SetMux(HAL_DISP_CHANNEL_E enChan, HAL_DISP_MUX_E enMux);
HI_BOOL HAL_DISP_IntfEnable(HAL_DISP_CHANNEL_E enChan, HI_BOOL enIntf);
HI_BOOL HAL_DISP_IntfMode(HI_BOOL bSlave);
HI_BOOL HAL_DISP_GetIntfEnable(HAL_DISP_CHANNEL_E enChan);
HI_BOOL HAL_DATE_SetNorm(HAL_DISP_CHANNEL_E enChan, HAL_DISP_NORM_E enNorm);
HI_BOOL HAL_DISP_SetIntfSync(HAL_DISP_CHANNEL_E enChan, HAL_DISP_SYNCINFO_S stSyncInfo);
HI_BOOL HAL_DISP_GetIntfIoP(HAL_DISP_CHANNEL_E enChan);
HI_BOOL HAL_DISP_SetIntfSyncMode(HAL_DISP_CHANNEL_E enChan, HAL_DISP_SYNC_MODE_E Mode);
HI_BOOL HAL_DISP_SetIntfBitWidth(HAL_DISP_CHANNEL_E enChan, HAL_DISP_BIT_WIDTH_E Width);
HI_BOOL HAL_DISP_SetIntfDataFmt(HAL_DISP_CHANNEL_E enChan, HAL_INTF_DATA_FORMAT_E stIntfDataFmt);
HI_BOOL HAL_DISP_IntfCscEnable(HAL_DISP_CHANNEL_E enChan, HI_BOOL enCSC);
HI_BOOL HAL_DISP_SetIntfCscCoef(HAL_DISP_CHANNEL_E enChan, IntfCscCoef_S stCscCoef);
HI_BOOL HAL_DISP_SetIntfClip(HAL_DISP_CHANNEL_E enChan, HI_BOOL enClip, HAL_DISP_CLIP_S stClipData);
HI_BOOL HAL_DISP_GetIntfSyncSize(HAL_DISP_CHANNEL_E enChan, HI_U32 *pu32Width, HI_U32 *pu32Height);


/*****************************************************************************
 Prototype       : Video Surface Relative
 Description     :

*****************************************************************************/
HI_BOOL HAL_VIDEO_LayerBindMixer(HAL_VIDEO_LAYER_E enLayer, HAL_MIXER_E enMixer);


/*****************************************************************************
 Prototype       : Graphic Surface Relative
 Description     :

*****************************************************************************/
HI_BOOL HAL_GRAPHIC_EnableLayer(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL bEnable);
HI_BOOL HAL_GRAPHIC_GetLayerEnable(HAL_GRAPHIC_LAYER_E enLayer);
HI_BOOL HAL_GRAPHIC_SetLayerPixelFmt(HAL_GRAPHIC_LAYER_E enLayer, HAL_PIXEL_FORMAT_E enPixelFmt);
HI_BOOL HAL_GRAPHIC_SetLayerAddr(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Addr);
HI_BOOL HAL_GRAPHIC_SetLayerStride(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Stride);
HI_BOOL HAL_GRAPHIC_GetLayerStrideAlign(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 *pu32StrideAlign);
HI_BOOL HAL_GRAPHIC_SetLayerInReso(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Width, HI_U32 u32Height);
HI_BOOL HAL_GRAPHIC_SetLayerOutReso(HAL_GRAPHIC_LAYER_E enLayer, HI_U32 u32Width, HI_U32 u32Height);
HI_BOOL HAL_GRAPHIC_SetLayerSrcStart(HAL_GRAPHIC_LAYER_E enLayer, HI_S32 s32SX, HI_S32 s32SY);
HI_BOOL HAL_GRAPHIC_SetLayerDispRect(HAL_GRAPHIC_LAYER_E enLayer, HAL_RECT_S stDispRect);
HI_BOOL HAL_GRAPHIC_SetRegUp(HAL_GRAPHIC_LAYER_E enLayer);
HI_BOOL HAL_GRAPHIC_SetCsc(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL bCscEn, HAL_CSC_MODE_E enMode);
HI_BOOL HAL_GRAPHIC_SetBitExt(HAL_GRAPHIC_LAYER_E enLayer, HAL_GFX_BITEXTEND_E enMode);
HI_BOOL HAL_GRAPHIC_SetPixelAlphaEnable(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL  bAlphaEn);
HI_BOOL HAL_GRAPHIC_SetPixelAlpha(HAL_GRAPHIC_LAYER_E enLayer, HI_U8 u8Alpha0, HI_U8 u8Alpha1);
HI_BOOL HAL_GRAPHIC_SetAlphaMode(HAL_GRAPHIC_LAYER_E enLayer, HAL_GRAPHIC_ALPHA_ARANGE_E enArange);
HI_BOOL HAL_GRAPHIC_SetLayerGalpha(HAL_GRAPHIC_LAYER_E enLayer, HI_U8 u8Alpha);
HI_BOOL HAL_GRAPHIC_SetColorKeyMode(HAL_GRAPHIC_LAYER_E enLayer, HAL_COLORKEY_MODE_E enMode);
HI_BOOL HAL_GRAPHIC_SetColorKeyEnable(HAL_GRAPHIC_LAYER_E enLayer, HI_BOOL bkeyEn);
HI_BOOL HAL_GRAPHIC_SetColorKeyValue(HAL_GRAPHIC_LAYER_E enLayer,HI_U32 u32Min, HI_U32 u32Max);
HI_BOOL HAL_GRAPHIC_LayerBindMixer(HAL_GRAPHIC_LAYER_E enLayer, HAL_MIXER_E enMixer);
HI_BOOL HAL_GRAPHIC_LayerGetBindMixer(HAL_GRAPHIC_LAYER_E enLayer, HAL_MIXER_E *penMixer);



/*****************************************************************************
 Prototype       : Interrupt Relative
 Description     :

*****************************************************************************/
HI_BOOL HAL_DISP_SetIntMask(HI_U32 u32MaskEn);
HI_BOOL HAL_DISP_ClrIntMask(HI_U32 u32MaskEn);
HI_BOOL HAL_DISP_SetVTThd(HAL_DISP_CHANNEL_E enLayer, HI_U16 u16Thd);
HI_BOOL HAL_DISP_SetVTThdMode(HAL_DISP_CHANNEL_E enLayer, HAL_UPDATE_MODE_E enMode);
HI_BOOL HAL_DISP_ClrIntStatus(HI_U32 u32IntMsk);
HI_U32  HAL_DISP_GetIntStatus(HI_VOID);
HI_BOOL HAL_DISP_GetCertainIntStatus(HI_U32 u32IntMsk);


/*****************************************************************************
 Prototype       : Mixer Relative
 Description     :

*****************************************************************************/
HI_BOOL HAL_CMB_SetMixerPriority(HAL_MXIER_LAYER_E enLayer, HAL_MIXER_PRIO_E enPrio);
HI_BOOL HAL_CMB_SetMixer3Priority(HAL_MXIER_LAYER_E enLayer, HI_BOOL bVdoGfx);
HI_BOOL HAL_CMB_SetMixerBackGroud(HAL_MIXER_E enMixer, HI_U32 u32BkGrd);
HI_BOOL HAL_CMB_SetMixerBackGroudByYuv(HAL_MIXER_E enMixer, HAL_DISP_BKCOLOR_S stBkg);


/*****************************************************************************
 Prototype       : Gamma Relative
 Description     :

*****************************************************************************/

HI_BOOL HAL_GAMMA_SetGmmThd(HAL_VIDEO_LAYER_E enLayer);
HI_BOOL HAL_GAMMA_SetGmmTable(HAL_VIDEO_LAYER_E enLayer);
HI_BOOL HAL_GAMMA_GmmCtrl(HAL_VIDEO_LAYER_E enLayer, HI_U32 uGmmEn, HI_U32 uGmmMode);






/*****************************************************************************
 Prototype       : Misc Coefficient Relative
 Description     :

*****************************************************************************/






/*****************************************************************************
 Prototype       : DATE Relative
 Description     : Digitalized Analog TV Encoder


*****************************************************************************/

HI_BOOL HAL_DATE_Enable(HAL_DISP_CHANNEL_E enChan, HI_BOOL bEnable);
HI_BOOL HAL_DATE_PolaCtrl(HAL_DISP_CHANNEL_E enChan);
HI_BOOL HAL_DATE_VideoFmt(HAL_DISP_CHANNEL_E enChan, U_HDATE_VIDEO_FORMAT VFormat);
HI_BOOL HAL_DATE_OutCtrl(HAL_DISP_CHANNEL_E enChan, U_HDATE_OUT_CTRL OutCtrl);


HI_S32 HAL_INTF_DivSel(HI_S32 s32VoDev, HI_U32 u32DivSel, HI_U32 u32Addr);
HI_S32 HAL_INTF_DacEnable(HI_S32 s32DacId, HI_BOOL bEnable, HI_U32 u32Addr);
HI_S32 HAL_SYS_UndoVouSoftRst(HI_U32 u32Addr);

#ifdef __cplusplus

#if __cplusplus
}
#endif
#endif /* End of #ifdef __cplusplus */

#endif /* End of #ifdef __VOU_GFX_HAL_H__ */

