/*
 * (C) Copyright 2006, HISILICON
 * Configuation settings for the Hi3515v100 FPGA board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/arch/platform.h>

#ifndef __CONFIG_Hi3515v100ASIC_H__
#define __CONFIG_Hi3515v100ASIC_H__

/*-----------------------------------------------------------------
 *  System Configuration
 */

#define CONFIG_NO_LOWLEVEL_REGLDR
#define NAND_TEXT_ADRS          (CFG_NAND_BASE)

#define ROM_TEXT_ADRS 		(MEM_BASE_FLASH)	
#define CFG_BOOT_PARAMS		(MEM_BASE_DDR+0x0100)

#define CONFIG_ARM926EJS	1		/* This is an arm926ejs CPU core  */
#define CONFIG_HISILICON	1		/* Hisilicon Platform Board	*/

#ifndef CFG_CLK_MPLLIN 
#define CFG_CLK_MPLLIN		220000000
#endif

#define CFG_CLK_SLOW		220000000

#define CFG_CLK_BUS		220000000

#define CFG_CPUCLK_SCALE	2
#define CFG_CLK_CPU		(CFG_CLK_BUS*CFG_CPUCLK_SCALE)
#define CFG_DEFAULT_CLK_CPU	CFG_CLK_CPU

/*******************************************************************
*       FREF	        24Mhz
*      FOUTVCO	        FREF * ( fbdiv + frac/2^24) / refdiv
*      FOUTPOSTDIV	FOUTVCO / pstdiv1 * pstdiv2
*      FOUT1ph0	        FOUTVCO / (pstdiv1 * 2)
*      FOUT2	        FOUTVCO / (pstdiv1 * 4)
*      FOUT3	        FOUTVCO / (pstdiv1 * 6)
*      FOUT4	        FOUTVCO / (pstdiv1 * 8)
*********************************************************************/

/* config for APLL
*  fbdiv = 200,refdiv = 3,pstdiv1 = 1,pstdiv2 = 1,frac = 0
*  FOUTVCO = 1600MHZ	
*  FOUT2 = 400MHZ ---->arm9
*  FOUT3 = TDE(266M)
*
*/

//#define APLL_FBDIV 0xC8 //200M
#define APLL_FBDIV 0xDC   //220M  
#define APLL_REFDIV 0x3
#define APLL_PSTDIV1 0x1
#define APLL_PSTDIV2 0x1

#define REG_CONF_PERCTRL0 (1<<31) | (APLL_PSTDIV2<<27)|(APLL_PSTDIV1<<24)  //0x89000000
#define REG_CONF_PERCTRL1 (1<<21) | (1<<19) | (1<<18) | (APLL_REFDIV<<12) | (APLL_FBDIV<<0) //0x002c30DC

/* config for EPLL
* fbdiv = 125,refdiv = 3,pstdiv1 = 1,pstdiv2 = 4,frac = 0
* FOUTVCO = 1000MHZ FVCOƵ:1GhzSDIO{50Mhz25Mhz19.2Mhz}SATA{125MHz,25MHz}SIO,ETH
* FOUTPOSTDIV = 
* FOUT1ph0 = 
* FOUT2	   = 
* FOUT4 = 
*/
#define EPLL_FBDIV 0x7D
#define EPLL_REFDIV 0x3
#define EPLL_PSTDIV1 0x1
#define EPLL_PSTDIV2 0x4

#define REG_CONF_PERCTRL6 (1<<31) | (EPLL_PSTDIV2<<27)|(EPLL_PSTDIV1<<24) //0xA1000000
#define REG_CONF_PERCTRL7 (1<<21) | (1<<19) | (1<<18) | (EPLL_REFDIV<<12) | (EPLL_FBDIV<<0) //0x002c307d

/* DDRC Config */
/* You Must Include <asm/arch/ddrc.h> Here! */
#include <asm/arch/ddrc.h>

#define CFG_DDRC_BUSWITH DDRC_BUSWITH_32BITS
#define CFG_DDRC_BANK DDRC_CHIP_8BANK
#define CFG_DDRC_ROW CFG_DDRC_ROW_13
#define CFG_DDRC_COL CFG_DDRC_COL_10
#define CFG_DDRC_WR_DELAY DDR_WR_DELAY_3
#define CFG_DDRC_CAS_DELAY DDR_CAS_DELAY_4
#define CFG_DDRC_CAP CFG_DDRC_CAP_1Gb

#define DDRC_CONFIG_VALUE (0x80000000 | (CFG_DDRC_BUSWITH << 12) | (CFG_DDRC_BANK << 7) | (CFG_DDRC_ROW << 4) | (CFG_DDRC_COL << 0))//0x800070a2
#define DDRC_MRS0_VALUE   (0x00460002 | (CFG_DDRC_WR_DELAY << 9) | (CFG_DDRC_CAS_DELAY << 4))//0x00460642


/* define ddr mem base */
#define MEM_BASE_DDR    0xc0000000

/*============ ATTENTION! YOU MAY MODIFY BELOW CONFIGS WHEN PORTING ========== */

/*-----------------------------------------------------------------------
 * Physical Memory Configuration
 */
#define CONFIG_NR_DRAM_BANKS    1		/* we have 1 bank of DRAM */
#define CFG_DDR_PHYS_OFFSET	MEM_BASE_DDR
#define CFG_DDR_SIZE ((CFG_DDRC_CAP/8)*2)	

#define CONFIG_BOOTUP_CLEAN_RAM

#define CFG_ALT_MEMTEST 1
#define CFG_MEMTEST_START       (CFG_DDR_PHYS_OFFSET + sizeof(unsigned long))
#define CFG_MEMTEST_END         (CFG_DDR_PHYS_OFFSET + CFG_DDR_SIZE)
#define CFG_MEMTEST_SCRATCH     CFG_DDR_PHYS_OFFSET 

/* CONFIG TIMER */
#define CFG_TIMERBASE           REG_BASE_TIMER12
#define CFG_HZ                  (CFG_CLK_BUS / 256)
#define CFG_TIMER_CTRL          0x8A
#define READ_TIMER		(*(volatile unsigned long *)(CFG_TIMERBASE + REG_TIMER_VALUE))

#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs  */
#define CONFIG_INITRD_TAG		1	/* support initrd */
#define CONFIG_SETUP_MEMORY_TAGS	1
#define CONFIG_MISC_INIT_R		1	/* call misc_init_r during start up */

#define CFG_MALLOC_LEN		(CONFIG_ENV_SIZE + 128*1024)
#define CFG_GBL_DATA_SIZE	128		/* size in bytes reserved for initial data */

#define CONFIG_STACKSIZE	(128*1024)	/* regular stack */

#define CONFIG_PL011_SERIAL
#define UART_PERSCAL 2
#define CONFIG_PL011_CLOCK	CFG_CLK_BUS/UART_PERSCAL		
#define CONFIG_PL01x_PORTS	{ (void *)CFG_SERIAL0, (void *)CFG_SERIAL1, (void *)CFG_SERIAL2 }
#define CONFIG_CONS_INDEX       0 	

#define CONFIG_BAUDRATE         115200
#define CFG_BAUDRATE_TABLE      { 9600, 19200, 38400, 57600, 115200 }
#define CFG_SERIAL0		REG_BASE_UART0
#define CFG_SERIAL1		REG_BASE_UART1
#define CFG_SERIAL2             REG_BASE_UART2

#define CONFIG_AUTO_COMPLETE	1
#define CFG_CMDLINE_HISTORYS    8
#define CONFIG_CMDLINE_EDITING

//#define CONFIG_SILENT_CONSOLE   1

/* USB ****************************************************************/
#define CONFIG_CMD_USB			1
#define CONFIG_USB_OHCI			1
#define LITTLEENDIAN			1
#define CONFIG_DOS_PARTITION		1
#define CFG_USB_OHCI_CPU_INIT		1
#define HIUSB_OHCI_BASE			0x100a0000
#define HIUSB_OHCI_DEV_NAME		"hiusb-ohci"
#define CFG_USB_OHCI_MAX_ROOT_PORTS	2
#define CONFIG_USB_STORAGE		1
//#define CONFIG_SUPPORT_VFAT		1
#define CONFIG_CMD_FAT			1
#define CONFIG_CMD_EXT2			1

#define REG_USB_SC_PEREN	0x20050024
#define USB_CLK_EN		(1<<22)

#define REG_SC_PER_CTRL12	0x20050060
#define USB_PORT1_POW_13	(1<<13) 
#define USB_PORT1_POW_12	(1<<12) 
#define USB_PORT0_POW_11	(1<<11) 
#define USB_PORT0_POW_10	(1<<10) 

#define REG_SC_PER_CTRL8	0x20050050
#define USB_PHY_CLK_RESET	(1<<31)
#define USB_BUS_RESET		(1<<30)

/* USB POWER EN REG*/
#define REG_GPIO5_1_REUSE	0x200F0054
#define SET_GPIO5_1_REUSB	(1)

#define REG_GPIO5_3_REUSE	0x200F005c
#define SET_GPIO5_3_REUSB	(1)

#define REG_GPIO5_DIR		0x201a0400
#define SET_GPIO5_1_DIR		(1<<1)
#define SET_GPIO5_3_DIR		(1<<3)

#define REG_GPIO5_1_VAL		0x201a0008
#define SET_GPIO5_1_VAL		(1<<1)

#define REG_GPIO5_3_VAL		0x201a0020
#define SET_GPIO5_3_VAL		(1<<3)
/* automatic software updates (see board/hi3560v200/auto_update.c) */
/*
 * #define CONFIG_AUTO_UPDATE      1
 * */

#define hiusb_ohci_enable_clk()	do{ \
	int reg;\
	\
	reg = readl(REG_USB_SC_PEREN);\
	writel(reg | USB_CLK_EN, REG_USB_SC_PEREN);\
	\
	reg = readl(REG_SC_PER_CTRL12);\
	reg |= USB_PORT0_POW_10;\
	reg &= ~(USB_PORT0_POW_11);\
	reg |= USB_PORT1_POW_12;\
	reg &= ~(USB_PORT1_POW_13);\
	writel(reg,REG_SC_PER_CTRL12);\
	\
	reg = readl(REG_SC_PER_CTRL8);\
	writel(reg | USB_PHY_CLK_RESET,REG_SC_PER_CTRL8);\
	\
	reg = readl(REG_SC_PER_CTRL8);\
	writel(reg | USB_BUS_RESET,REG_SC_PER_CTRL8);\
	\
	reg = readl(REG_GPIO5_1_REUSE);\
	reg |= SET_GPIO5_1_REUSB;\
	writel(reg,REG_GPIO5_1_REUSE);\
	\
	reg = readl(REG_GPIO5_3_REUSE);\
	reg |= SET_GPIO5_3_REUSB;\
	writel(reg,REG_GPIO5_3_REUSE);\
	\
	reg = readl(REG_GPIO5_DIR);\
	writel(reg | SET_GPIO5_1_DIR | SET_GPIO5_3_DIR,REG_GPIO5_DIR);\
	\
	reg = readl(REG_GPIO5_1_VAL);\
	reg &= ~(SET_GPIO5_1_VAL);\
	writel(reg,REG_GPIO5_1_VAL);\
	\
	reg = readl(REG_GPIO5_3_VAL);\
	reg &= ~(SET_GPIO5_3_VAL);\
	writel(reg,REG_GPIO5_3_VAL);\
	\
}while(0)

#define hiusb_ohci_disable_clk() do{ \
}while(0)
/* USB ****************************************************************/

#define CONFIG_COMMANDS ( CFG_CMD_BDI | CFG_CMD_MEMORY | CFG_CMD_FLASH | CFG_CMD_ENV | CONFIG_CMD_LOADB | CONFIG_CMD_LOADS )
#define CONFIG_BOOTP_MASK	CONFIG_BOOTP_DEFAULT

#define CONFIG_CMD_ENV
#define CONFIG_CMD_FLASH

//#include <cmd_confdefs.h>

/* hisfv300 */
#define CONFIG_CMD_PING
#define CONFIG_CMD_MII
#define CONFIG_CMD_NET
#define CONFIG_CMD_MEMORY
#define CONFIG_CMD_LOADB 

#define CONFIG_BOOTDELAY	1
#define CONFIG_ZERO_BOOTDELAY_CHECK 1

#define CONFIG_BOOTARGS "mem=32M console=ttyAMA0,115200"

#define CONFIG_NETMASK	255.255.255.0		/* talk on MY local net */
#define CONFIG_IPADDR	192.168.1.10		/* static IP I currently own */
#define CONFIG_SERVERIP	192.168.1.1		/* current IP of tftp server ip */
#define CONFIG_ETHADDR  00:00:00:00:00:00
#define CONFIG_BOOTFILE	"uImage" 		/* file to load */

#define CFG_LONGHELP	
#define CFG_PROMPT	"hilinux # "		/* Monitor Command Prompt   */
#define CFG_CBSIZE	1024			/* Console I/O Buffer Size  */
#define CFG_PBSIZE	(CFG_CBSIZE+sizeof(CFG_PROMPT)+16)
#define CFG_MAXARGS	16			/* max number of command args   */
#define CFG_BARGSIZE	CFG_CBSIZE		/* Boot Argument Buffer Size    */
#undef	CFG_CLKS_IN_HZ				/* everything, incl board info, in Hz */
#define CFG_LOAD_ADDR	(CFG_DDR_PHYS_OFFSET + 0x08000)		/* default load address */

/*-----------------------------------------------------------------------
 *  * NAND FLASH and Environment Configuration
 *   */
#define CFG_MAX_NAND_DEVICE 1
#define CFG_NAND_BASE 0x70000000
#define CONFIG_NAND_HI
#define CONFIG_CMD_NAND
#define CONFIG_YAFFS2
#define YAFFS2_DEBUG
#define CONFIG_CMD_JFFS2
#define CONFIG_JFFS2_NAND	1
#define CONFIG_JFFS2_DEV		"nand0"
#define CONFIG_JFFS2_PART_SIZE	    0x800000
#define CONFIG_JFFS2_PART_OFFSET    0x0
#define CFG_NAND_U_BOOT_OFFS 0x20000
#define CFG_NAND_U_BOOT_SIZE 0x40000
#define CFG_NAND_U_BOOT_ONE_PART 0x20000
#define CFG_NAND_U_BOOT_DST  (TEXT_BASE + CFG_NAND_U_BOOT_OFFS)


/*-----------------------------------------------------------------------
 * FLASH and Environment Configuration
 */
#define CFG_FLASH_CFI
#define CFG_FLASH_CFI_DRIVER
#define CFG_FLASH_PROTECTION
#define CFG_FLASH_USE_BUFFER_WRITE

#define CFG_FLASH_BASE          MEM_BASE_FLASH

#define CONFIG_ENV_IS_IN_NAND     1            /* env in flash instead of CFG_ENV_IS_NOWHERE */
#define CONFIG_ENV_IS_IN_FLASH     1            /* env in flash instead of CFG_ENV_IS_NOWHERE */
#define CONFIG_ENV_SIZE            0x20000      /* Total Size of Environment Sector */
#define CFG_ENV_OFFSET          0x80000      /* environment starts here  */
#define CONFIG_ENV_ADDR            (CFG_FLASH_BASE + CFG_ENV_OFFSET)
#define CONFIG_ENV_OVERWRITE

#define CFG_MAX_FLASH_BANKS	1	/* max number of memory banks */
#define CFG_MAX_FLASH_SECT	512   

/*-----------------------------------------------------------------------
 * Net Driver Configuration
 */

#define CONFIG_CLEANUP_MEMORY	1


/*-----------------------------------------------------------------------
 * SPI Flash Configuration
 */

/*-----------------------------------------------------------------------
 * NOR Flash Configuration
 */
//#define CFG_FLASH_TIMING_OPT	1
#define FLASH_READ_TIMING_TOE	35	/* Output Enable to Output Delay */
#define FLASH_READ_TIMING_TCE	100	/* Chip Enable to Output Delay */
#define FLASH_READ_TIMING_TRC	100	/* Read Cycle Time */

/*-----------------------------------------------------------------------
 * Switch to uboot by key
 */
 
#define CONFIG_AUTOBOOT_KEYED 1
#define CONFIG_AUTOBOOT_PROMPT "Press CTRL-C to abort autoboot in %d seconds"
#define CONFIG_AUTOBOOT_DELAY_STR "hilinux"
#define CONFIG_AUTOBOOT_STOP_STR "\x03" 


#define CFG_FAULT_ECHO_LINK_DOWN

#define CONFIG_SHOW_BOOT_PROGRESS

#define CONFIG_FLASH_CFI_DRIVER

#define CFG_DIRECT_FLASH_TFTP
#define CONFIG_VERSION_VARIABLE

#endif	/* __CONFIG_H */
