/*
 * GotoEvent.h
 *
 * Copyright (C) 1999 Jean-Hugues Deschenes.
 *
 * This is distributed under GPL.
 *
 * Header for Go to event window.
 *
 * History : 
 *    JH.D, 13/09/1999, Initial typing.
 *
 * Note : The current version of this toolkit is for linux 2.2.0.
 */

#ifndef __TRACE_TOOLKIT_GOTO_EVENT__
#define __TRACE_TOOLKIT_GOTO_EVENT__

#include <gtk/gtk.h>

#include <EventOptions.h>

/* Define Type ID data */
#define EVENT_TYPE_MENU_DATA "Type ID"

typedef enum
{
  GOTO_CPU_ID,
  GOTO_EVENT_TYPE,
  GOTO_PID,
  GOTO_ENTRY_LENGTH,
  GOTO_EVENT_DESC
}SearchTypes;

typedef struct
{
  SearchTypes SearchType; /* What kind of information are we looking for? */

  gint   CPUID;        /* CPU ID sought */
  gint   EventType;    /* Event type ID sought */
  gint   PID;          /* PID sought */
  gint   EntryLength;  /* Entry length sought */
  gchar* SearchString; /* Event description sought */

}GTESearchQuery;

/* Define what the OK and Cancel callbacks look like */
typedef void _GTECBCancel
         (gpointer  /* The system view corresponding to this open trace */);
typedef void _GTECBOK
         (gpointer       /* The system view corresponding to this open trace */,
	  GTESearchQuery /* The search parameters */);

/* View time frame window */
typedef struct _gotoEventWindow
{
  /* The data */
  gpointer      SysView;
  GtkWidget*    ParentWin;          /* Parent window */
  _GTECBOK*     CBOK;   
  _GTECBCancel* CBCancel;

  /* Query parameters, will be passed to the callback */
  GTESearchQuery SearchParameters;

  /* The widgets */
  GtkWidget*    Window;             /* Window to enter search criteria */

  GtkWidget*    MainTable;          /* Main packing table */

  GtkWidget*    SearchLabel;        /* Label asking for search query */

  GSList*       RadioGroup;         /* The radio button group */

  GtkWidget*    CPUIDRadio;         /* Radio button to specify a CPU ID search */
  GtkWidget*    EventTypeRadio;     /* Radio button to specify an event type search */
  GtkWidget*    PIDRadio;           /* Radio button to specify a PID search */
  GtkWidget*    LengthRadio;        /* Radio button to specify an entry length search */
  GtkWidget*    EventDescRadio;     /* Radio button to specify an event description search */

  GtkWidget*    CPUIDEntry;         /* Where CPU ID query is entered */
  GtkWidget*    PIDEntry;           /* Where PID query is entered */
  GtkWidget*    LengthEntry;        /* Where entry length query is entered */
  GtkWidget*    EventDescEntry;     /* Where search string is entered */

  GtkWidget*    EventTypeOptMenu;   /* The Event type option menu */
  GtkWidget*    EventTypeListMenu;  /* The Event type list itself */

  GtkWidget*    OKButton;           /* OK Button */
  GtkWidget*    CancelButton;       /* Cancel Button */
} gotoEventWindow;

_GTECBCancel GTECBCancel;
_GTECBOK     GTECBOK;

/* Function prototypes */
void                 GTEConnectSignals
                      (gotoEventWindow* /* The Go to event window */);
void                 GTEShowGotoEventWindow
                      (gotoEventWindow* /* The Go to event window */);
gotoEventWindow*     GTECreateGotoEventWindow
		      (gpointer         /* The system view */,
		       GtkWidget*       /* The parent window */,
                       _GTECBOK*        /* Function to call in case of OK */,
		       _GTECBCancel*    /* Function to call in case of cancel or close */);
void                 GTEDestroyGotoEventWindow
                      (gotoEventWindow* /* The Go to event  window */);


#endif /* __TRACE_TOOLKIT_GOTO_EVENT__ */
