; Name: xcf-png.scm
; Author: YuGiOhJCJ
; Mail: yugiohjcj@1s.fr
; Web: http://yugiohjcj.1s.fr/
; Version: 20110331
; Description: converts a XCF file to a PNG file
;
; Copyright (C) 2011  YuGiOhJCJ
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http://www.gnu.org/licenses/>.
(define
	(xcf-png
	  	input
		output
	)
	(let*
	  	(
			(image
			  	(car
					(gimp-xcf-load
						RUN-NONINTERACTIVE
						input
						input
					)
				)
			)
			(drawable
			  	(car
				  	(gimp-image-get-active-drawable
						image
					)
				)
			)
		)
		(gimp-image-flatten
		  	image
		)
		(let*
		  	(
			  	(newdrawable
					(car
					  	(gimp-image-get-active-drawable
							image
						)
					)
			   	)
			)
			(file-png-save
				RUN-NONINTERACTIVE
				image
				newdrawable
				output
				output
				0
				9
				0
				0
				0
				0
				0
			)
		)
	)
)
(script-fu-register
  	"xcf-png"
	""
	"Converts a XCF file to a PNG file"
	"YuGiOhJCJ <yugiohjcj@1s.fr>"
	"YuGiOhJCJ"
	"2011/03/23"
	""
	SF-IMAGE "input" 0
	SF-IMAGE "output" 0
)
