#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/etherdevice.h>
static char g_mac[6] = {0};
/*format: mac=XX:XX:XX:XX:XX:XX*/
static void string_to_mac(unsigned char *mac, char* s)
{
    int i;
    char *e;

    for (i=0; i<6; i++) {
        mac[i] = s ? simple_strtoul(s, &e, 16) : 0;
        if (s) {
            s = (*e) ? e+1 : e;
        }
    }
}
static int __init
parse_mac_address_from_cmdline(char *str){
	
    string_to_mac(g_mac, str);
	return 0;
}
__setup("mac=", parse_mac_address_from_cmdline);

static int get_mac_addr_from_cmdline(char* mac,int size){
	if (!is_valid_ether_addr(g_mac))
		return -1;

	if (size != 6)
		return -2;

	memcpy(mac, g_mac, 6);
	return 0;
}
EXPORT_SYMBOL(get_mac_addr_from_cmdline);
