
/*
 * fct test for huss-e4v 
 * mail: YunBin.Chen@honeywell.com
 */

#include <common.h>
#include <post.h>
#include <asm/io.h>
#include <dtt.h>
#include <asm/arch/platform.h>

#include <net.h>
#include <miiphy.h>
#include <gpio_i2c.h>
//#include <ns16550.h>
#include "serial_pl01x.h"


#define CFG_I2C_TW2866_ADDR_BASE 0x50
#define TW2866_ID_H 0xfe
#define TW2866_ID_L 0xff

/*post function for tw2866*/
int board_post_tw2866(int flags)
{
	uchar devid, devidh, devidl;
	int result = 0;
//	post_log("(tw2866) ");

	devidh = gpio_i2c_read(CFG_I2C_TW2866_ADDR_BASE , TW2866_ID_H);
	devidl = gpio_i2c_read(CFG_I2C_TW2866_ADDR_BASE , TW2866_ID_L);

	devid = ((devidh & 0xC0)>>1)|((devidl & 0xf8)>>3);

	if(devid == 0x19)
	{
		result = 0;
	}
	else
	{
		result = -1;
	}

	return result;	/* return -1 on error */
}

int ether_post_test (int flags)
{
	unsigned int oui;
	unsigned char model;
	unsigned char rev;
	char	*devname;

//	post_log("(ethernet) ");
	/* use current device */
	DECLARE_GLOBAL_DATA_PTR;
	eth_init(gd->bd);
	devname = miiphy_get_current_dev();

	/*check eth0 phy info*/
	if (miiphy_info (devname, 3, &oui, &model, &rev) == 0) {
	post_log ("PHY 0x%02X: "
		"%s, "
		"Model = 0x%02X, "
		"Rev = 0x%02X, "
		"%3dbaseT, %s\n",
		3, (oui == 0x732)? "Realtek" : "Unkown", model, rev,
		miiphy_speed (devname, 3),
		(miiphy_duplex (devname, 3) == FULL)
			? "FDX" : "HDX");
	}
	else
	{
		return -1;
	}
	post_log("ethernet: ");
	eth_halt();
	return 0;
}

#define LM96163_I2C_SLAVE_ADDR  (0x98)
#define LM96163_REG_REMOTE_DIODE_SET    0x30
#define LM96163_REG_REMOTE_TEMP_MSB     0x01
#define LM96163_REG_REMOTE_TEMP_LSB     0x10
#define TEMP11_FROM_REG(reg)    ((reg) / 32 * 125)

int lm96163_post_test(int flags)
{
	int result = 1;
	unsigned char data;
	short temp;
	int dtt_temp;

//	post_log("(LM96163) ");

	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, LM96163_REG_REMOTE_DIODE_SET, 0x00);
	udelay(1000000);
	data = gpio_i2c_read(LM96163_I2C_SLAVE_ADDR, LM96163_REG_REMOTE_DIODE_SET);
	if(data != 0x0)
	{
		return -1;
	}

	data = gpio_i2c_read(LM96163_I2C_SLAVE_ADDR, LM96163_REG_REMOTE_TEMP_MSB);
	temp = data << 8;
	data = gpio_i2c_read(LM96163_I2C_SLAVE_ADDR, LM96163_REG_REMOTE_TEMP_LSB);
	temp |= data;

	dtt_temp = TEMP11_FROM_REG(temp)/1000;

	post_log("DTT: %i C\n", dtt_temp);

	if(dtt_temp > 0 && dtt_temp < 70)
	{
		result = 1;
	}
	else
	{
		result = -1;
	}
	return result;
}

int fanon_post_test(int flags)
{
	int result = 1;
	unsigned char fans1, fans2;

	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x03, 0x04);
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x4a, 0x2B);
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x4c, 0xff);
	udelay(1000000);
	fans1 = gpio_i2c_read(LM96163_I2C_SLAVE_ADDR, 0x47);
	fans2 = gpio_i2c_read(LM96163_I2C_SLAVE_ADDR, 0x46);

	//post_log("fans2 %x fans1 %x\n", fans2, fans1);
	if(fans1 == 0xff && fans2 == 0xff)
	{
		result = -1;
	}
	else
	{
		result = 0;
	}

	return result;
}

int fanoff_post_test(int flags)
{
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x03, 0x04);
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x4a, 0x2B);
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x4c, 0x00);

	return 0;
}

void fan_force_start()
{

	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x03, 0x04);
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x4a, 0x2B);
	gpio_i2c_write(LM96163_I2C_SLAVE_ADDR, 0x4c, 0xff);
	return;
}

#define CFG_I2C_AIC3104_ADDR_BASE 0x30
#define PLLPR 0x03

int aic3104_post_test(int flags)
{
	uchar data;
	int result = 0;

//	post_log("(AIC3104) ");
	data = 0x91;
	gpio_i2c_write(CFG_I2C_AIC3104_ADDR_BASE, PLLPR, data);
	data = 0;
	data = gpio_i2c_read(CFG_I2C_AIC3104_ADDR_BASE, PLLPR);

	if(data != 0x91)
	{
		result = -1;
	}
	else
	{
		result = 0;
	}

	return result;
}

#define TLC59108F_I2C_SLAVE_ADDR        (0x86)

void e4v_init_i2c_led_chip(void)
{

	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x00, 0x01);
	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x01, 0x20);
	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x0A, 0x80);
	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x0B, 0x17);

	return;
}

void e4v_video_chn_led_control(int chn, int color, int blink)
{
	int result = 0;
	int offset = 0;
	int reg_addr_color = 0;
	unsigned char value = 0;
	
	reg_addr_color = 0x02 + 2*chn;
	switch (color)
	{
		case LED_BOTH_OFF:
			offset = reg_addr_color;
			value = 0x00;
			gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset, value);
			gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset+1, value);
			break;		
		case LED_RED_ON:
			offset = reg_addr_color;
			value = 0x00;
			gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset, value);
			value = 0xff;
			gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset+1, value);
			break;
		case LED_GREEN_ON:
			offset = reg_addr_color;
			value = 0xff;
			gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset, value);
			value = 0x00;
			gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset+1, value);
		default:
			break;
	}

	if (chn < 2)
	{
		offset = 0x0C;
	}
	else
	{
		offset = 0x0D;
	}

	value = gpio_i2c_read(TLC59108F_I2C_SLAVE_ADDR, offset);

	if (LED_BLINK_OFF == blink)
	{
		if (0 == (chn%2))
		{
			value = ((value&0xF0)|0x0A);
		}
		else
		{
			value = ((value&0x0F)|0xA0);
		}		
	}
	else
	{
		if (0 == (chn%2))
		{
			value = (value|0x0F);
		}
		else
		{
			value = (value|0xF0);
		}	
	}
	
	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, offset, value);
	
	return;
}

int tirledon_post_test(int flags)
{
	uchar data;
	int result = 0;
	int i;

	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x00, 0x01);
	data = gpio_i2c_read(TLC59108F_I2C_SLAVE_ADDR, 0x00);
	if(data != 0x01)
	{
		result = -1;
	}
	else
	{
		result = 1;
	}

	for (i = 0; i < 4; i++)
	{
		e4v_video_chn_led_control(i, LED_RED_ON, LED_BLINK_OFF);
	}
	
	return result;
}

int tigledon_post_test(int flags)
{
	uchar data;
	int result = 0;
	int i;

	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x00, 0x01);
	data = gpio_i2c_read(TLC59108F_I2C_SLAVE_ADDR, 0x00);
	if(data != 0x01)
	{
		result = -1;
	}
	else
	{
		result = 1;
	}

	for (i = 0; i < 4; i++)
	{
		e4v_video_chn_led_control(i, LED_GREEN_ON, LED_BLINK_OFF);
	}
	
	return result;
}

int tiledoff_post_test(int flags)
{
	uchar data;
	int result = 0;
	int i;

	gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x00, 0x01);
	data = gpio_i2c_read(TLC59108F_I2C_SLAVE_ADDR, 0x00);
	if(data != 0x01)
	{
		result = -1;
	}
	else
	{
		result = 1;
	}

	for (i = 0; i < 4; i++)
	{
		e4v_video_chn_led_control(i, LED_BOTH_OFF, LED_BLINK_OFF);
	}	
	
	return result;
}

#define  GPIO_3_BASE_ADDR  0x20180000
#define  GPIO_2_BASE_ADDR  0x20170000
#define  GPIO_3_DIR_ADDR (GPIO_3_BASE_ADDR + 0x400)
#define  GPIO_BUZZ_ADDR  (GPIO_3_BASE_ADDR + (1<<(2+2)))
#define  GPIO_RESET_ADDR  (GPIO_2_BASE_ADDR + (1<<(4+2)))
#define  GPIO_LED_ADDR 	  (GPIO_2_BASE_ADDR + (1<<(5+2)))
#define READ_REG(Addr)         (*(volatile unsigned int *)(Addr))
#define WRITE_REG(Addr, Value) ((*(volatile unsigned int *)(Addr)) = (Value))

int buzzer_post_test(int flags)
{
	u32 tmp; 
	
//	post_log("(buzzer) ");

	tmp = READ_REG(GPIO_3_DIR_ADDR);
	tmp |= (1<<2);
	WRITE_REG(GPIO_3_DIR_ADDR, tmp); 
	WRITE_REG(GPIO_BUZZ_ADDR, 1<<2);
	udelay(500000);
	WRITE_REG(GPIO_BUZZ_ADDR, 0);
	return 1;
}

int gledon_post_test(int flags)
{
	WRITE_REG(GPIO_LED_ADDR, 0);
	return 1;
}

int gledoff_post_test(int flags)
{
	WRITE_REG(GPIO_LED_ADDR, 1<<5);
	return 1;
}

int retfac_post_test(int flags)
{
	u32 tmp = 0;

	tmp = READ_REG(GPIO_RESET_ADDR);
	tmp &= (1 << 4);
	if (0 == tmp)
	{
		return 0;
	}
	else
	{
		return -1;
	}
}

#define  RS485_TIMEOUT (9000000)

int rs485_post_test(int flags)
{
	unsigned int data;
	char testbyte[2];
	int i = 0;
	int j = 0;
	unsigned long base = REG_BASE_SCTL;
	
//	post_log("(RS485) ");
	
	testbyte[0] = 0xAA;
	testbyte[1] = 0x55;

//	post_log("base %08x\n", base);
	data = READ_REG(base + REG_SC_PERCTRL11);
//	post_log("data1 %08x\n", data);
	data &=~(1<<31);
//	post_log("data2 %08x\n", data);
	WRITE_REG(base + REG_SC_PERCTRL11, data);
	udelay(1000);

	for(j = 0; j<3; j++)
	{
	  for(i = 0; i < 2; i++)
	  {
		while (READ_REG (CFG_SERIAL1 + UART_PL01x_FR) & UART_PL01x_FR_TXFF);
		WRITE_REG(CFG_SERIAL1 +  UART_PL01x_DR, testbyte[i]);
	  }
	  udelay(1000);
	}

	data = READ_REG(base + REG_SC_PERCTRL11);
//	post_log("data3 %08x\n", data);
	data |=(1<<31);
//	post_log("data4 %08x\n", data);
	WRITE_REG(base + REG_SC_PERCTRL11, data);
	udelay(1000);

	for(j = RS485_TIMEOUT; j > 0; j--)
	{
		if(READ_REG(CFG_SERIAL1 + UART_PL01x_FR) & UART_PL01x_FR_RXFE){
			continue;
		}
		else
		{
			data = READ_REG(CFG_SERIAL1 + UART_PL01x_DR);
			//post_log("-%x\n", data);
			/* Check for an error flag */
			if (data & 0xFFFFFF00) {
				/* Clear the error */
				 WRITE_REG(CFG_SERIAL1 + UART_PL01x_ECR, 0xFFFFFFFF);
				continue;
			}
			testbyte[0] = data;
			if(testbyte[0]==0x55)
				break;
		}
	}

	if(testbyte[0] != 0x55)
	{
		return -1;
	}
	for(j = RS485_TIMEOUT; j > 0; j--)
	{
		if(READ_REG(CFG_SERIAL1 + UART_PL01x_FR) & UART_PL01x_FR_RXFE){
			continue;
		}
		else
		{
			data = READ_REG(CFG_SERIAL1 + UART_PL01x_DR);
			//post_log("-%x\n", data);
			/* Check for an error flag */
			if (data & 0xFFFFFF00) {
				/* Clear the error */
				 WRITE_REG(CFG_SERIAL1 + UART_PL01x_ECR, 0xFFFFFFFF);
				continue;
			}
			testbyte[1] = data;
			if(testbyte[1]==0xAA)
				break;
		}	
	}

	if(testbyte[1] == 0xAA)
	{
		return 0;
	}
	else
	{
		return -1;
	}
}

void e4v_check_restore_factory(void)
{
	int i = 0;
	int count = 0;
	u32 tmp = 0;
	int result = 0;

	for (i = 0; i < 3; i++)
	{		
		tmp = READ_REG(GPIO_RESET_ADDR);
		tmp &= (1 << 4);
		if (0 == tmp)
		{
			count++;
			udelay(500000);
			printf("Enter restore config to factory mode %d\n", i+1);
		}
		else
		{
			break;
		}
	}
	
	if (3 == i)
	{
		printf("Enter restore config to factory mode !\n");
		gpio_i2c_write(TLC59108F_I2C_SLAVE_ADDR, 0x04, 0x17); //blink fast
		for (i = 0; i < 4; i++)
		{
			e4v_video_chn_led_control(i, LED_RED_ON, LED_BLINK_ON);
		}
		setenv("othbootargs", "facmode=1");	
	}
	else
	{
               for (i = 0; i < 4; i++)
               {
                        e4v_video_chn_led_control(i, LED_RED_ON, LED_BLINK_OFF);
               }		
	}
	
	return;
}


