#include <common.h>
#include <config.h>
#include <environment.h>

extern int flash_env_init(void);
extern int nand_env_init(void);

extern unsigned char flash_env_get_char_spec(int);
extern unsigned char nand_env_get_char_spec(int);

extern int flash_saveenv(void);
extern int nand_saveenv(void);

extern void flash_env_relocate_spec(void);
extern void nand_env_relocate_spec(void);

extern char * flash_env_name_spec;
extern char * nand_env_name_spec;

char *env_name_spec;

static unsigned char boot_flag = -1;

env_t *env_ptr=0;

unsigned char env_get_char_spec(int index)
{
	unsigned char ret;

	if(boot_flag == BOOT_FROM_FLASH1){
		ret = flash_env_get_char_spec(index);
	}
	else if(boot_flag == BOOT_FROM_NAND){
		ret = nand_env_get_char_spec(index);
	}
	return ret;
}

int saveenv(void)
{
	int ret;

	if(boot_flag == BOOT_FROM_FLASH1){
		ret = flash_saveenv();
	}
	else if(boot_flag == BOOT_FROM_NAND){
		ret = nand_saveenv();
	}
	return ret;
}

void env_relocate_spec(void)
{

	if(boot_flag == BOOT_FROM_FLASH1){
		flash_env_relocate_spec();
	}
	else if(boot_flag == BOOT_FROM_NAND){
		nand_env_relocate_spec();
	}
	return;	
}

int env_init(void)
{
	boot_flag = *((volatile unsigned long *)(REG_BASE_SCTL + SC_STARTMOD_OFFSET)) & 0x60;
	boot_flag = boot_flag >> 5;

	if(boot_flag == BOOT_FROM_FLASH1){
		env_ptr = (env_t *)CONFIG_ENV_ADDR;
		flash_env_init();
		env_name_spec = flash_env_name_spec;
	}
	else if(boot_flag == BOOT_FROM_NAND){
		nand_env_init();
		env_name_spec = nand_env_name_spec;
	}

	return 0;
}


