#include <config.h>
#include <common.h>
#include <linux-adapter.h>
#include <asm/arch/platform.h>

/* define for ddr train */
#define DATA0 0xee11dd22
#define DATA1 0xcc33bb44
#define DATA2 0x44bb33cc
#define DATA3 0x22dd11ee
#define DATA4 0x33cc44bb
#define DATA5 0x11ee22dd
#define DATA6 0xdd22ee11
#define DATA7 0xbb44cc33

//typedef unsigned int unsigned long;
void read_8bust(unsigned long *pread, unsigned long *pwrite)
{
        __asm__ __volatile__(
                "ldmia %0,{r2-r8, ip}   \n"
                "stmia %1,{r2-r8, ip}   \n"
        :
        :"r"(pread),"r"(pwrite)
        : "r2", "r3", "r4", "r5", "r6", "r7", "r8", "ip", "memory" );
}


static void _delay_cl(unsigned long cl)
{
	for(cl=(cl*CFG_CPUCLK_SCALE)>>2; cl!=0; cl--)
		__asm__ __volatile__("nop");
}

static void _delay_cl_100(void)
{
	_delay_cl(100);
}

void ddrc_train(unsigned long mem_addr,unsigned long reg_ddr_base) 
{
    static const unsigned long exp_d0[8] = { DATA0, DATA1, DATA2, DATA3, DATA4, DATA5, DATA6, DATA7 };

    unsigned char lat[3],gat[3];
    int cur_lat,cur_gat;
    int train_suc;
    unsigned long lat_reg,gat_reg;
    unsigned long comp_d[8];
    unsigned long pass_cnt;
    unsigned long base;
    unsigned long i;
    unsigned long *ptr, *ptr_src;
    unsigned long delay = 100;

    base = reg_ddr_base;
    
    cur_lat = 0;
    cur_gat = 0;    
    pass_cnt = 0;
    
    ptr = (unsigned long *)mem_addr ;
    ptr_src = exp_d0;

    for (i=8; i!=0; i--)
    {
        *ptr++ = *ptr_src++;
    }
            
    while (cur_lat <=5) 
    {
	    int cmp_result;
        // config the train syslat/gate initial value
        lat_reg = cur_lat + (cur_lat<<4) + (cur_lat<<8) + (cur_lat<<12);
        gat_reg = cur_gat + (cur_gat<<2) + (cur_gat<<4) + (cur_gat<<6);
        
        // config the train/track state
        __raw_writel(DDR_RESET_FIFO,(base + REG_DDRC_TRAIN));/* bit(1) & bit(2) set 0 */
    	__raw_writel( lat_reg,(base + REG_DDRC_LAT));
    	__raw_writel( gat_reg,(base + REG_DDRC_GATE));
       
	_delay_cl_100();

        __raw_writel( DDR_NO_RESET_FIFO ,(base + REG_DDRC_TRAIN));/* bit(1) & bit(2) set 0 */

	/* read date in 8burst */
	read_8bust(mem_addr,comp_d);
		
        // compare data
	cmp_result = 0;
        for (i=0; i<8; i++) 
	{
       		 if(comp_d[i] == exp_d0[i])
			 cmp_result ++;
        }
        
        // get the result
        if (cmp_result == 8)
          	train_suc  = 1;
        else 
          	train_suc  = 0;
          
        // record the pass number
        if (train_suc == 1) 
	{
		pass_cnt ++;
		if(pass_cnt <= 3) {
             		lat[pass_cnt-1]=cur_lat;
		       	gat[pass_cnt-1]=cur_gat;
		}
	}
        
        // move the postion to next.
        if (cur_gat < 3) 
	{ 
         	 cur_gat = cur_gat + 1;
        } 
        else 
	{
         	cur_gat = 0;
          	cur_lat = cur_lat + 1;
        }
    } // end while 
    
    
    if(pass_cnt >4) {
          cur_lat = lat[2];
          cur_gat = gat[2];
    } else if(pass_cnt > 2) {
          cur_lat = lat[1]; 
          cur_gat = gat[1];
    } else {
          cur_lat = lat[0]; 
          cur_gat = gat[0];
    }
    
    // write the result to register.
    lat_reg = cur_lat + (cur_lat<<4) + (cur_lat<<8) + (cur_lat<<12);
    gat_reg = cur_gat + (cur_gat<<2) + (cur_gat<<4) + (cur_gat<<6);
        
    __raw_writel(DDR_RESET_FIFO,(base + REG_DDRC_TRAIN));/* bit(1) & bit(2) set 0 */
   __raw_writel(lat_reg,(base + REG_DDRC_LAT));
   __raw_writel(gat_reg,(base + REG_DDRC_GATE));
    
   _delay_cl_100();

   __raw_writel(DDR_NO_RESET_FIFO,(base + REG_DDRC_TRAIN));/* bit(1) & bit(2) set 0 */
    
}

void cpu_init_sysctrl(void)
{
	unsigned long base = REG_BASE_SCTL;

	__raw_writel(REG_VALUE_SC_NOLOCK, base + REG_SC_PERLOCK);
	__raw_writel( 0x7fff0, base + REG_SC_XTALCTRL);
	__raw_writel( 0xfffffb0, base + REG_SC_PLLCTRL);
	
	/* set arm11 busclk:cpuclk = 1:3 */
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL9) | 0x1,base + REG_SC_PERCTRL9);
	
	/* config ddr phy dll */
	__raw_writel(0x00370000,0x20120200);
	__raw_writel(0x00370000,0x20120204);
	__raw_writel(0x00370000,0x20120208);
	__raw_writel(0x00370000,0x2012020c);
	__raw_writel(0x00370000,0x20120210);
	
	__raw_writel(0x00370000,0x20110200);
	__raw_writel(0x00370000,0x20110204);
	__raw_writel(0x00370000,0x20110208);
	__raw_writel(0x00370000,0x2011020c);
	__raw_writel(0x00370000,0x20110210);
	
	_delay_cl_100();
	
	//APLL
	__raw_writel(REG_CONF_PERCTRL0,base + REG_SC_PERCTRL0);
	__raw_writel(REG_CONF_PERCTRL1,base + REG_SC_PERCTRL1);
	_delay_cl_100();
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL1)|(1<<22),base + REG_SC_PERCTRL1);
	
	//VPLL
	__raw_writel(0xb4000000,base + REG_SC_PERCTRL2);
	__raw_writel(0x002c1036,base + REG_SC_PERCTRL3);
	_delay_cl_100();
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL3)|(1<<22),base + REG_SC_PERCTRL3);
	
	 __raw_writel(0x9c000000,base + REG_SC_PERCTRL4);
	 __raw_writel(0x002c1036,base + REG_SC_PERCTRL5);
	 _delay_cl_100();
	 __raw_writel(__raw_readl(base + REG_SC_PERCTRL5)|(1<<22),base + REG_SC_PERCTRL5);
	 
	 while(((__raw_readl(base + REG_SC_PERCTRL23) >> 0) & 0x1) != 0x1);
	
	 /* change arm to NORMAL */
	__raw_writel(__raw_readl(base + REG_SC_CTRL) | 0x7, base + REG_SC_CTRL);
	
	 while((__raw_readl(base + REG_SC_CTRL)>>3 & 0xf) != 0x4);
	
	/* config SMI for nor and nand */
	__raw_writel(__raw_readl(base + REG_SC_PERCTRL11) | (0x020<<19) | (0x020<<9)  ,REG_BASE_IOCFG + 0x012C);//[28:19]-->0x020,[18:9]-->0x020
		
	/* VI EBI config for UART2 */
	__raw_writel(__raw_readl(REG_BASE_IOCFG + 0x0) | 0x1 ,REG_BASE_IOCFG + 0x0);
	__raw_writel(__raw_readl(REG_BASE_IOCFG + 0x0004) | 0x1 ,REG_BASE_IOCFG + 0x0004);
	
	/* SMI EBI config for nandc */
	__raw_writel(__raw_readl(REG_BASE_IOCFG + 0x0120) | 0x1 ,REG_BASE_IOCFG + 0x0120);
		

}

void cpu_enable_wdg(void)
{
	/* set watchdog */
	unsigned long base = REG_BASE_WDG;
	__raw_writel(REG_VALUE_WC_NOLOCK,base + REG_WDG_LOCK );
	__raw_writel(15000000,base + REG_WDG_LOAD);//>5S
	__raw_writel(__raw_readl(base + REG_WDG_CONTROL)|0x3,base + REG_WDG_CONTROL);
	__raw_writel(REG_VALUE_WC_LOCKED,base + REG_WDG_LOCK);
}

void cpu_disable_wdg(void)
{
	/* disable watchdog */
	unsigned long base = REG_BASE_WDG;
	__raw_writel(REG_VALUE_WC_NOLOCK,base + REG_WDG_LOCK );
	__raw_writel(__raw_readl(base + REG_WDG_CONTROL) & 0xfffffffc,base + REG_WDG_CONTROL);
	__raw_writel(~0,base + REG_WDG_INTCLR);
	__raw_writel(REG_VALUE_WC_LOCKED,base + REG_WDG_LOCK);
}

void cpu_init_smi(void)
{

	unsigned long base = REG_BASE_SMI;	
	__raw_writel(0x0F, base + REG_SMI_BWSTWENR0);

}

void lowlevel_memzero_8burst(unsigned long start, unsigned long end); 
#define memzero_8burst(start, end) do{ \
		__asm__ __volatile__("stmdb sp!, {r4-r12, lr}"); \
		lowlevel_memzero_8burst(start, end); \
		__asm__ __volatile__("ldmia sp!, {r4-r12, lr}"); \
	} while(0)

void cpu_init_ddrca(void)
{
	
	unsigned long base = REG_BASE_DDRCA;
	unsigned long mem_base_addr = MEM_BASE_TRAINA;

	__raw_writel(0x00000000,base+DDRC_DDRC_DLL_RST); _delay_cl_100();
	__raw_writel(0x00000001,base+DDRC_DDRC_DLL_RST);

	_delay_cl(10000);
	__raw_writel(0x00000000,base+REG_DDRC_CTRL);
	_delay_cl(10000);

	__raw_writel(DDRCA_MRS0_VALUE,base+REG_DDRC_EMRS01); _delay_cl_100();
	__raw_writel(0x000000c0,base+DDRC_DDRC_IO_CONFIG); _delay_cl_100();
	__raw_writel(DDRCA_CONFIG_VALUE,base+REG_DDRC_CONFIG); _delay_cl_100();
	__raw_writel(0x54661812,base+REG_DDRC_TIMING0); _delay_cl_100();
	__raw_writel(0xc8315633,base+REG_DDRC_TIMING1); _delay_cl_100();
	__raw_writel(0x33612061,base+REG_DDRC_TIMING2); _delay_cl_100();
	__raw_writel(0x00000083,base+REG_DDRC_TIMING3); _delay_cl_100();
	
	__raw_writel(0x00000001,base+REG_DDRC_TRAIN); _delay_cl_100();
	__raw_writel(0x000000ff,base+0x40); _delay_cl_100();

	//* config port pri
	__raw_writel(0x00009876,base+0x104); _delay_cl_100();
	__raw_writel(0x00000000,base+0x108); _delay_cl_100();
	__raw_writel(0x00000001,base+0x10C); _delay_cl_100();
	__raw_writel(0x00000002,base+0x110); _delay_cl_100();
	__raw_writel(0x00000003,base+0x114); _delay_cl_100();
	__raw_writel(0x00000005,base+0x118); _delay_cl_100();
	__raw_writel(0x00000006,base+0x11C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x120); _delay_cl_100();
	__raw_writel(0x00000004,base+0x124); _delay_cl_100();
	__raw_writel(0x00000007,base+0x128); _delay_cl_100();
	__raw_writel(0x00000007,base+0x12C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x130); _delay_cl_100();
	__raw_writel(0x00000007,base+0x134); _delay_cl_100();
	__raw_writel(0x00000007,base+0x138); _delay_cl_100();
	__raw_writel(0x00000007,base+0x13C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x140); _delay_cl_100();
	__raw_writel(0x00000002,base+REG_DDRC_CTRL); _delay_cl_100();
	
	ddrc_train(mem_base_addr,base);
}

void cpu_init_ddrcb(void)
{
	
	unsigned long base = REG_BASE_DDRCB;
	unsigned long mem_base_addr = MEM_BASE_TRAINB;

	__raw_writel(0x00000000,base+DDRC_DDRC_DLL_RST);  _delay_cl_100();
	__raw_writel(0x00000001,base+DDRC_DDRC_DLL_RST);
	
	_delay_cl(10000);
	__raw_writel(0x00000000,base+REG_DDRC_CTRL);
	_delay_cl(10000);

	__raw_writel(DDRCB_MRS0_VALUE,base+REG_DDRC_EMRS01); _delay_cl_100();
	__raw_writel(0x000000c0,base+DDRC_DDRC_IO_CONFIG); _delay_cl_100();
	__raw_writel(DDRCB_CONFIG_VALUE,base+REG_DDRC_CONFIG); _delay_cl_100();
	__raw_writel(0x54661812,base+REG_DDRC_TIMING0); _delay_cl_100();
	__raw_writel(0xc8315633,base+REG_DDRC_TIMING1); _delay_cl_100();
	__raw_writel(0x33612061,base+REG_DDRC_TIMING2); _delay_cl_100();
	__raw_writel(0x00000083,base+REG_DDRC_TIMING3); _delay_cl_100();
	
	__raw_writel(0x00000001,base+REG_DDRC_TRAIN); _delay_cl_100();
	__raw_writel(0x000000ff,base+0x40); _delay_cl_100();
	
	__raw_writel(0x00009876,base+0x104); _delay_cl_100();
	__raw_writel(0x00000000,base+0x108); _delay_cl_100();
	__raw_writel(0x00000001,base+0x10C); _delay_cl_100();
	__raw_writel(0x00000002,base+0x110); _delay_cl_100();
	__raw_writel(0x00000003,base+0x114); _delay_cl_100();
	__raw_writel(0x00000005,base+0x118); _delay_cl_100();
	__raw_writel(0x00000006,base+0x11C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x120); _delay_cl_100();
	__raw_writel(0x00000004,base+0x124); _delay_cl_100();
	__raw_writel(0x00000007,base+0x128); _delay_cl_100();
	__raw_writel(0x00000007,base+0x12C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x130); _delay_cl_100();
	__raw_writel(0x00000007,base+0x134); _delay_cl_100();
	__raw_writel(0x00000007,base+0x138); _delay_cl_100();
	__raw_writel(0x00000007,base+0x13C); _delay_cl_100();
	__raw_writel(0x00000007,base+0x140); _delay_cl_100();
	__raw_writel(0x00000002,base+REG_DDRC_CTRL); _delay_cl_100();

	/* software train */
	ddrc_train(mem_base_addr,base);
}

#ifdef CONFIG_RANDOM_ETHADDR
int random_init_r(void)
{
	unsigned long seed;
	unsigned long *base = MEM_BASE_ITCM;
	unsigned int size = ((MEM_BASE_ITCM + MEM_SIZE_ITCM) >> 2);
	for(; base < size; base++){
		seed ^= *base;
	}
	srandom(seed);
	return 0;
}
#endif
