#ifndef __CTL_H__
#define __CTL_H__

#include <config.h>
#include <common.h>
#include <command.h>

#define H2GMAC_IO_BASE          (0x10090000)    /*FIXME!*/
#define H2GMAC_IO_SIZE          (0x10000)       /*FIXME!*/
#define H2GMAC_IRQ_NUM          (14)             /*FIXME!*/

#define H2GMAC_MDIO_IO_BASE       H2GMAC_IO_BASE 
#define H2GMAC_MDIO_IO_SIZE        (0x10000)
#define H2GMAC_MDIO_FRQDIV 			(0)
#define H2GMAC_SYS_CTL_IO_BASE	(0x20050000)
#define H2GMAC_SYS_CTL_IO_SIZE	(0x10000)
//#define PERIPHCTR10				(0x001c)
//#define PERIPHCTR18				(0x0050)
#define SC_PEREN                0x24    /*clock enable reg*/
#define SC_PERDIS               0x28
#define SC_PERCTRL8             0x50    /*soft reset reg*/
#define SC_PERCTRL9             0x54    /*clock mode reg*/
#define FRQ_DIV_MASK			(~((1 << 24) - 1))
#define FRQ_DIV					(1 << 12)
#define MDIO_RESET				(1 << 19)


#define H2GMAC_LINKED       (1 << 0)
#define H2GMAC_DUP_FULL     (1 << 1)
#define H2GMAC_SPD_10M      (1 << 2)
#define H2GMAC_SPD_100M     (1 << 3)
#define H2GMAC_SPD_1000M    (1 << 4)

static inline void h2gmac_sys_init(void){
    unsigned int val = 0 ;

    /*enable clock.*/
    val |= (1 << 21);
    writel(val,H2GMAC_SYS_CTL_IO_BASE + SC_PEREN);

    /*cancle soft reset*/
	val = readl(H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);	
    val |= (7 << 18);
    writel(val, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);
}

static inline void h2gmac_sys_exit(void){
    unsigned int val = 0;

    /*disable clock.*/
    val |= (1 << 21);
    writel(val, H2GMAC_SYS_CTL_IO_BASE + SC_PERDIS);

    /*soft reset*/
	val = readl(H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);	
    val &= (~(7 << 18));
    writel(val, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);

}

static inline void h2gmac_sys_shutdown(void){
}

static inline void h2gmac_sys_resume(void){

}

#if 0
static inline void h2gmac_sys_switch2rgmii1(void){

}
static inline void h2gmac_sys_switch2normal(void){
}
#endif


void h2gmac_config_hw_fifo(struct h2gmac_netdev_local* ld, unsigned int rx_fifo_depth);

int h2gmac_clear_int(struct h2gmac_netdev_local* ld, int irq);

int h2gmac_disable_int(struct h2gmac_netdev_local* ld, int irq);

int h2gmac_enable_int(struct h2gmac_netdev_local* ld, int irq);

int h2gmac_config_hw_int(struct  h2gmac_netdev_local*ld,int pkg_cnt,int timeout);

int h2gmac_read_hw_tx_cnt(struct h2gmac_netdev_local* ld);

int    h2gmac_write_tx_data(struct h2gmac_netdev_local* ld, unsigned char* data);
int    h2gmac_write_tx_len(struct h2gmac_netdev_local* ld,unsigned int len);


#define h2gmac_enable_multi_cast(ld)    \
do{                                     \
    h2gmac_writel_bits(ld, 0, REC_FILT_CONTROL, BITS_NAME(mc_match_en));    \
}while(0)

#define h2gmac_disable_multi_cast(ld)   \
do{                                     \
    h2gmac_writel_bits(ld, 1, REC_FILT_CONTROL, BITS_NAME(mc_match_en));    \
}while(0)

#define h2gmac_enable_broad_cast(ld)    \
do{                                     \
    h2gmac_writel_bits(ld, 0, REC_FILT_CONTROL, BITS_NAME(bc_drop_en));      \
}while(0)

#define h2gmac_disable_broad_cast(ld)   \
do{                         \
    h2gmac_writel_bits(ld,1, REC_FILT_CONTROL, BITS_NAME(bc_drop_en));  \
}while(0)

/*uni cast with da mismatch will be received to cpu*/
#define h2gmac_enable_uni_cast_dismatch_da(ld)      \
do{                                     \
    h2gmac_writel_bits(ld,0, REC_FILT_CONTROL, BITS_NAME(uc_match_en));  \
}while(0)

#define h2gmac_disable_uni_cast_dismatch_da(ld)      \
do{                                     \
    h2gmac_writel_bits(ld,1, REC_FILT_CONTROL, BITS_NAME(uc_match_en));  \
}while(0)

#define h2gmac_enable_vlan(ld)  \
do{                             \
    h2gmac_writel_bits(ld, 0, REC_FILT_CONTROL, BITS_NAME(vlan_drop_en));   \
}while(0)

#define h2gmac_disable_vlan(ld) \
do{                             \
    h2gmac_writel_bits(ld, 1, REC_FILT_CONTROL, BITS_NAME(vlan_drop_en));   \
}while(0)


#define h2gmac_disable_int_all(ld)  \
do{         \
/*    h2gmac_writel_bits((ld), 0, CRF_INTRPT_THRSLD, BITS_NAME(crf_rxint_en));        */\
/*    h2gmac_writel_bits((ld), 0, CRF_INTRPT_THRSLD, BITS_NAME(crf_txint_en));        */\
    h2gmac_writel_bits((ld), 0, CRF_INTRPT_THRSLD, BITS_NAME(crf_pkg_intrpt_en));  \
    h2gmac_writel_bits((ld), 0, CRF_INTRPT_THRSLD, BITS_NAME(crf_time_intrpt_en));  \
}while(0)

#define h2gmac_enable_int_all(ld)  \
do{         \
/*    h2gmac_writel_bits((ld), 1, CRF_INTRPT_THRSLD, BITS_NAME(crf_rxint_en));       */\
/*    h2gmac_writel_bits((ld), 1, CRF_INTRPT_THRSLD, BITS_NAME(crf_txint_en));       */\
    h2gmac_writel_bits((ld), 1, CRF_INTRPT_THRSLD, BITS_NAME(crf_pkg_intrpt_en));  \
    h2gmac_writel_bits((ld), 1, CRF_INTRPT_THRSLD, BITS_NAME(crf_time_intrpt_en)); \
}while(0)

#define h2gmac_clr_int_all(ld)  \
do{                             \
    h2gmac_writel_bits(ld, 1, CRF_INTRPT_CLR, BITS_NAME(mac_fifo_err_int));     \
    h2gmac_writel_bits(ld, 1, CRF_INTRPT_CLR, BITS_NAME(p2a_err_intrpt));       \
/*    h2gmac_writel_bits(ld, 1, CRF_INTRPT_CLR, BITS_NAME(rx_crf_intrpt));       */ \
/*    h2gmac_writel_bits(ld, 1, CRF_INTRPT_CLR, BITS_NAME(tx_crf_intrpt));        */\
    h2gmac_writel_bits(ld, 1, CRF_INTRPT_CLR, BITS_NAME(cfg_fifo_emp_intrpt));  \
}while(0)
#endif


