#include "reg.h"
#include "h2gmac.h"
#include "util.h"
#include "ctl.h"
#include "mdio.h"

typedef enum {
    interface_mode_mii = 0,
    interface_mode_rgmii,
    interface_mode_butt
}interface_mode_e;
typedef enum {
	speed_mode_10M,
	speed_mode_100M,
	speed_mode_1000M,
	speed_mode_butt
}speed_mode_e;
typedef enum {
   	port_mode_10_mii = 0,
    port_mode_100_mii = 1,
    port_mode_10_rgmii = 3,
	port_mode_100_rgmii = 4,
	port_mode_1000_rgmii = 5,
	port_mode_butt
}speed_port_mode_match_value;
	/*
									port mode
					MII 				RGMII
	s 10M		port_mode_10_mii	port_mode_10_rgmii
	p 
	e 100M		port_mode_100_mii	port_mode_100_rgmii
	e 
	d 1000M		port_mode_butt		port_mode_1000_rgmii
	
	*/
static int g_speed_portmode_table[speed_mode_butt][interface_mode_butt] = {
	{port_mode_10_mii, 		port_mode_10_rgmii},
	{port_mode_100_mii, 	port_mode_100_rgmii},
	{port_mode_butt, 		port_mode_1000_rgmii}
};

char PHY_NAME[MAX_PHY_NAME_LEN] = "0:03";
//unsigned char PHY_ADDR = 0x01;
unsigned char PHY_ADDR = 0x03;
struct h2gmac_netdev_local g_h2gmac_ld ;

#define H2GMAC_FIFO_DEPTH_TOTAL (512)

static unsigned int g_hw_tx_fifo_depth = 16; 

static unsigned int g_hw_rx_fifo_depth  ;

static unsigned int g_hw_rx_multi_pkg_cnt = 16;
#define H2GMAC_HW_RX_TIMEOUT_UINT (125) /*us*/
static unsigned int g_hw_rx_multi_timeout = H2GMAC_HW_RX_TIMEOUT_UINT * 24; /*125us *24 = 3000us = 3ms*/

static interface_mode_e g_interface_mode = interface_mode_mii;

static void h2gmac_net_adjust_link(struct h2gmac_netdev_local* ld);

#define MAC_LEN 6

#define print_mac(mac)	 do{ int i;\
	printf("MAC:  ");\
	for (i = 0; i < MAC_LEN; i++)\
		printf("%c%02X", i ? '-' : ' ', *(((unsigned char*)mac)+i));\
	printf("\n");\
}while(0)

void string_to_mac(unsigned char *mac, char* s)
{
	int i;
	char *e;

	for (i=0; i<MAC_LEN; ++i) {
		mac[i] = s ? simple_strtoul(s, &e, 16) : 0;
		if (s) {
			s = (*e) ? e+1 : e;
		}
	}
}
static void h2gmac_soft_open(struct h2gmac_netdev_local* ld);
static void h2gmac_hw_close(struct h2gmac_netdev_local* ld);
static void h2gmac_soft_close(struct h2gmac_netdev_local* ld);
static void set_mac_port_stat(struct h2gmac_netdev_local* ld, speed_port_mode_match_value pmd){
    int val;
    h2gmac_writel_bits(ld, pmd, PORT_MODE, BITS_NAME(port_mode));
    /*set MII OR RGMII || set txclk accord to MII or RGMII interface..*/
    val = readl(H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL9);
    if(pmd <= 1){ /*MII interface*/
        val |= (1 << 29);
        writel(val, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL9);
    }
    else if (pmd >= 3 && pmd <= 5){   /*RGMII interface*/
        val &= (~(1 << 29));
        writel(val, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL9);
    }
    else {  /*gmii interface .do nothing.*/
        h2gmac_error("You say GMII interface?? This may not work....");
    }
    /*set sys ctrl reg.*/
    val = readl(H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL9);
    val &= (~(7 << 26));
    val |= (pmd << 26);
    writel(val, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL9);

}
#define hiusb_dump_buf(buf, len) do{\
        int i;\
        char *p = (void*)(buf);\
        printf("%s->%d,buff:%p:\n", __FUNCTION__, __LINE__,buf); \
        for(i=0;i<(len);i++){\
                printf("0x%.2x ", *(p+i));\
                if( !((i+1) & 0x0F) )\
                        printf("\n");\
        }\
        printf("\n");\
}while(0)

#define MIN_PKG_LEN (42)
#define MAX_PKG_LEN	(2000)
#define H2GMAC_INVALID_RXPKG_LEN(len) (!(((len) >= MIN_PKG_LEN) && ((len) <= MAX_PKG_LEN)))
#define LEN_FLAG_B (1 << 15)
int eth_rx(void){
	int rxrdy, timeout_us = 100000;
	unsigned short len =0;
	struct h2gmac_netdev_local* ld = &g_h2gmac_ld;
	/*check ready for rx*/
    rxrdy = h2gmac_readl_bits(ld, CRF_CFF_DATA_NUM, BITS_NAME(crf_rx_cfg_num));
	if (rxrdy >= g_hw_rx_fifo_depth)
		h2gmac_error("cannot add buffer to hw for rx,left:%d,g_hw_rx_fifo_depth:%d\n",rxrdy,g_hw_rx_fifo_depth);
	/*fill hw*/
	h2gmac_writel(ld, (unsigned long)NetRxPackets[0], RX_CFF_ADDR(0));

	/*enable rx int*/
	h2gmac_enable_int(ld, BITS_NAME(crf_rxint_en));
	/*check int*/
	/*check length*/
	while(--timeout_us && !((len = (*(volatile unsigned short*)NetRxPackets[0])) & LEN_FLAG_B)){
		udelay(1);
	}
	if (!(len & LEN_FLAG_B)){
		h2gmac_trace(7,"rx timeout,len:%x, ddr:%x,addr:%p!\n",len,(*(volatile unsigned short*)NetRxPackets[0]),NetRxPackets[0]);
		return -1;
	}
	len &= (~LEN_FLAG_B);

	/*clear ints*/
	h2gmac_trace(2,"clear int crf_rx_int_en\n");
	h2gmac_clear_int(ld, BITS_NAME(rx_crf_intrpt));
	
	if(H2GMAC_INVALID_RXPKG_LEN(len)){
		h2gmac_error("rx packet len error %x\n",*(volatile unsigned short*)NetRxPackets[0]);
		return -1;
	}
	*(volatile unsigned short*)NetRxPackets[0] = 0;

	/*NetRecive*/
	NetReceive((char*)NetRxPackets[0] + 2, len);
	return 0;
}
int eth_send(volatile void* packet, int length){
	struct h2gmac_netdev_local* ld = &g_h2gmac_ld;
    int pkgs_in_lgc = 0;
	int ints,timeout_us = 1000;	

    pkgs_in_lgc = h2gmac_read_hw_tx_cnt(ld);

    if (pkgs_in_lgc == g_hw_tx_fifo_depth){
		h2gmac_error("cannot send pkg,fifo full1\n");
        return  -1;
    }

  	h2gmac_enable_int(ld, BITS_NAME(crf_txint_en));
	//hiusb_dump_buf(packet, length );
    /*FIXME: IMPLEMENT THIS FUNC*/
    h2gmac_write_tx_len(ld, length);
    h2gmac_write_tx_data(ld, (unsigned char*)packet);

	do {
		udelay(1);
		ints = h2gmac_readl(ld, CRF_INTRPT_CLR); 
	}while(--timeout_us && !(ints & BITS_NAME(tx_intrpt_sta)));

	h2gmac_clear_int(ld, BITS_NAME(tx_intrpt_sta));
	if (! timeout_us){
		h2gmac_error("send time out!\n");
		return -1;
	}
    return 0;
}

static inline int h2gmac_mac_init(struct h2gmac_netdev_local* ld){
    /*set min pkg len as 42*/
    h2gmac_writel_bits(ld, MIN_PKG_LEN, SHORT_RUNTS_THR, BITS_NAME(short_runts_thr));

    /*logic say this need to check whether write a 0 is ok...*/
    h2gmac_writel_bits(ld, 0, CRF_RX_ADDR_NUM, BITS_NAME(crf_rx_addr_num));

    /*config hw tx direction not reserve 2 bytes*/
    h2gmac_writel_bits(ld, 1, CONTROL_WORD, BITS_NAME(crf_remove_0_byte));
//    h2gmac_writel_bits(ld, 1, CONTROL_WORD, BITS_NAME(crf_insert_0_byte));
    
    /*cut off crc data from rx data*/
    h2gmac_writel_bits(ld, 1, CF_CRC_STRIP, BITS_NAME(cf_crc_strip));

    /*enable it that software can change port mode at init time*/
    h2gmac_writel_bits(ld, 1, MODE_CHANGE_EN, BITS_NAME(mode_change_en));

	h2gmac_disable_multi_cast(ld);
	h2gmac_disable_broad_cast(ld);
	h2gmac_disable_vlan(ld);
	h2gmac_disable_uni_cast_dismatch_da(ld);

	h2gmac_writel(ld, 0, CRF_INTRPT_THRSLD);
    return 0;
}
/*FIXME: IMPLEMENT THIS FUNC*/
static void h2gmac_hw_reset(struct h2gmac_netdev_local* ld){
	volatile unsigned int v = 0;
	h2gmac_writel(ld,0, PORT_EN);
	h2gmac_writel(ld, 7, CRF_FIFO_CLR);
	udelay(10);
	h2gmac_writel(ld,0, PORT_EN);
	h2gmac_writel(ld, 7, CRF_FIFO_CLR);
	
#if 0
	v = readl(ld->sys_iobase + PERIPHCTR10);

	v &= (~FRQ_DIV);
	writel(v, ld->sys_iobase + PERIPHCTR10);

	v |= FRQ_DIV;
    writel(v, ld->sys_iobase + PERIPHCTR10);
	v = readl(ld->sys_iobase + PERIPHCTR18);

	v &= (~ MDIO_RESET);
	writel(v, ld->sys_iobase + PERIPHCTR18);

	v |= MDIO_RESET;
	writel(v, ld->sys_iobase + PERIPHCTR18);
#endif
    /*TODO:clock div*/
    /*soft reset*/
    v = readl(H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);
    v &= (~(7 << 18));
    writel(v, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);

	udelay(10);

    v = readl(H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);
    v |= (7 << 18);
    writel(v, H2GMAC_SYS_CTL_IO_BASE + SC_PERCTRL8);
    
	return ;
}
static void h2gmac_hw_open(struct h2gmac_netdev_local* ld){
	h2gmac_disable_int_all(ld);
	h2gmac_clr_int_all(ld);
    
	/*FIXME:hw start!*/
    h2gmac_mac_init(ld);

    /*FIXME:reset hw*/
    /*config fifo*/    
    g_hw_rx_fifo_depth = (H2GMAC_FIFO_DEPTH_TOTAL - g_hw_tx_fifo_depth);
    h2gmac_config_hw_fifo(ld, g_hw_rx_fifo_depth);
		
	h2gmac_writel(ld, 7, CRF_FIFO_CLR);	/*must!*/
	h2gmac_writel(ld, 0, CRF_FIFO_CLR);
	ld->link_stat = 0;
    
	/*enable rx/tx chanel*/
    h2gmac_writel(ld, ~0, PORT_EN);
}
static void h2gmac_soft_open(struct h2gmac_netdev_local* ld){

    h2gmac_config_hw_int(ld,g_hw_rx_multi_pkg_cnt, g_hw_rx_multi_timeout);
    ld->stat.dstat = DEV_STAT_OPENED;
}
int h2gmac_net_open(struct h2gmac_netdev_local* ld ){
    
    /*FIXME:hw start!*/
	h2gmac_hw_open(ld);
	/*disable pause en*/
    h2gmac_writel(ld, 0, PAUSE_EN);

	h2gmac_soft_open(ld);


	ld->link_stat = 0;
	h2gmac_net_adjust_link(ld);
    return 0;
}
static void h2gmac_hw_close(struct h2gmac_netdev_local* ld){

    h2gmac_disable_int_all(ld);

    h2gmac_hw_reset(ld);
	/*disable pause en*/
    h2gmac_writel(ld, 0, PAUSE_EN);
    //h2gmac_mac_exit(ld);
}
static void h2gmac_soft_close(struct h2gmac_netdev_local* ld){

    ld->link_stat = 0;

    ld->stat.dstat = DEV_STAT_CLOSED;
}
int h2gmac_net_close(struct h2gmac_netdev_local* ld){
    if (ld->stat.dstat == DEV_STAT_CLOSED)
        return 0;

	h2gmac_hw_close(ld);
    /*hw reset*/
	h2gmac_soft_close(ld);


    return 0;
}
#define CONFIG_RANDOM_ETHADDR
#ifdef CONFIG_RANDOM_ETHADDR
static unsigned long rstate = 1;
/* trivial congruential random generators. from glibc. */
void srandom(unsigned long seed)
{
    rstate = seed ? seed : 1;  /* dont allow a 0 seed */
}

unsigned long random(void)
{
    unsigned int next = rstate;
    int result;

    next *= 1103515245;
    next += 12345;
    result = (unsigned int) (next / 65536) % 2048;

    next *= 1103515245;
    next += 12345;
    result <<= 10;
    result ^= (unsigned int) (next / 65536) % 1024;

    next *= 1103515245;
    next += 12345;
    result <<= 10;
    result ^= (unsigned int) (next / 65536) % 1024;

    rstate = next;

    return result;
}

void random_ether_addr(char *mac)
{
    unsigned long ethaddr_low, ethaddr_high;

    srandom(get_timer(0) );
    /*
     * setting the 2nd LSB in the most significant byte of
     * the address makes it a locally administered ethernet
     * address
     */
    ethaddr_high = (random() & 0xfeff) | 0x0200;
    ethaddr_low = random();

    mac[0] = ethaddr_high >> 8;
    mac[1] = ethaddr_high & 0xff;
    mac[2] = ethaddr_low >>24;
    mac[3] = (ethaddr_low >> 16) & 0xff;
    mac[4] = (ethaddr_low >> 8) & 0xff;
    mac[5] = ethaddr_low & 0xff;

    mac [0] &= 0xfe;    /* clear multicast bit */
    mac [0] |= 0x02;    /* set local assignment bit (IEEE802) */

}
#endif
static int is_valid_ether_addr(const u8 * addr)
{   
        /* FF:FF:FF:FF:FF:FF is a multicast address so we don't need to
                * explicitly check for it here. */
        return !is_multicast_ether_addr(addr) && !is_zero_ether_addr(addr);
}
static int h2gmac_net_set_mac_address(struct h2gmac_netdev_local* ld){
    unsigned int d = 0;
	char* s;
	unsigned char mac[MAC_LEN];
    s = getenv("ethaddr");
    if (s){
        string_to_mac(mac,s);
    }
    else{
#ifdef CONFIG_RANDOM_ETHADDR
        random_ether_addr(mac);
#else
        return -1;
#endif
    }
    if (!is_valid_ether_addr(mac)){
#ifdef CONFIG_RANDOM_ETHADDR
        random_ether_addr(mac);
#else
        return -1;
#endif 
    }
    print_mac(mac);
    
	d = (mac[0] << 8) | mac[1];
	h2gmac_writel_bits(ld, d, MAC_SA_ADDR_H, BITS_NAME(mac_da_addr_h));    
    h2gmac_writel_bits(ld, d, STATION_ADDR_HIGH, BITS_NAME(station_addr_high));

    d = 0;
    d = (mac[2] << 24) | (mac[3] << 16) | (mac[4] << 8) | mac[5];
    
    h2gmac_writel(ld, d, STATION_ADDR_LOW);
	h2gmac_writel(ld, d, MAC_SA_ADDR_L);
    return 0;
}

static int set_random_mac_address(unsigned char * mac, unsigned char * ethaddr)
{
    random_ether_addr(mac);

    sprintf (ethaddr, "%02X:%02X:%02X:%02X:%02X:%02X",
            mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);

    setenv("ethaddr",ethaddr);
    print_mac(mac);

    return 0;
}

int eth_set_host_mac_address(void)
{
    char* s;
    unsigned char mac[MAC_LEN];
    unsigned char ethaddr[20];
    s=getenv("ethaddr");
    if(!s){
        set_random_mac_address(mac, ethaddr);
        return 0;
    }

    string_to_mac(mac,s);
    if(!is_valid_ether_addr(mac))
    {
        set_random_mac_address(mac, ethaddr);
        return 0;
    }
    return 0;
}
#if 0
static void phy_print_status(struct h2gmac_netdev_local *ld, int stat)
{
	printf("GMAC : phy status change : LINK=%s : DUPLEX=%s : SPEED=%s\n", \
			(stat & H2GMAC_LINKED) ? "UP" : "DOWN", \
			(stat & H2GMAC_DUP_FULL) ? "FULL" : "HALF", \
			(stat & H2GMAC_SPD_100M) ? "100M" : (stat & H2GMAC_SPD_10M)? "10M" : "1000M");
}
#endif
static speed_port_mode_match_value calculate_port_mode(speed_mode_e speed, interface_mode_e interface){
	speed_port_mode_match_value ret = port_mode_butt ;

	if ((speed < speed_mode_butt) && (interface < interface_mode_butt))
		ret =	g_speed_portmode_table[speed][interface];

	if (ret == port_mode_butt){
		h2gmac_error("Invalid speed(%d) & interface(%d) matach.\n", speed, interface);
		h2gmac_error("Please assign which mode our eth module will correctly work at.\n\
				Currently we support 10M MII, 100M MII, 1000M GMII, 10M RGMII, 100M RGMII, 1000M RGMII interface.\n\
				eg: If your board connected by MII interface, please set 10M MII or 100M MII,using module param 'port_mode'.\
				For logic limited, some speed mode will not work with some *MII interface, eg: 10M GMII, 100M GMII, these will not work yet.\n");
		BUG();
	}
	return ret;	
}

static void h2gmac_net_adjust_link(struct h2gmac_netdev_local* ld){
    int stat = 0,speed = 0;
	speed_port_mode_match_value match;

    stat |= miiphy_link(ld->phy_name, PHY_ADDR) ? H2GMAC_LINKED : 0;
    stat |= miiphy_duplex(ld->phy_name, PHY_ADDR) ? H2GMAC_DUP_FULL : 0;
    speed = miiphy_speed(ld->phy_name, PHY_ADDR);
    stat |= (speed == _100BASET ? H2GMAC_SPD_100M : 
        (speed == _10BASET? H2GMAC_SPD_10M : H2GMAC_SPD_1000M));

    if (ld->link_stat != stat){
        //phy_print_status(ld->phy);
		/*calculate port mode.*/
		match = calculate_port_mode(
			((stat & H2GMAC_SPD_100M) ? speed_mode_100M : 
				((stat & H2GMAC_SPD_10M) ? speed_mode_10M : speed_mode_1000M)),
			g_interface_mode);

        /*to set sysctrl gmac work mode.*/
		set_mac_port_stat(ld, match);
        /*reset gmac ip*/
		h2gmac_hw_close(ld);
		h2gmac_soft_close(ld);

		if (stat & H2GMAC_LINKED){
			h2gmac_hw_open(ld);
			h2gmac_soft_open(ld);
		}
		else{
			ld->link_stat = stat;
			return;	
		}
		/*to set gmac internal port mode*/
		set_mac_port_stat(ld, match);

		ld->link_stat = stat;
    }
    return;
}
void merge_mac_to_bootargs(void)
{
#define MAC_BT_HEADER   "mac=" 
#define MAC_FMT         "XX:XX:XX:XX:XX:XX"
    char* ethaddr;
    char* bootargs;
    char* tmp;
    char* org = NULL;
    int is_boot_args_has_mac = 0;
    /*if user say that we will not merge, then stop.*/
    tmp = getenv("merge_mac_to_bootargs");
    if(tmp && (0 == strncmp("no", tmp, 2) || 0 == strncmp("No", tmp, 2) || 0 == strncmp("NO", tmp, 2)))
        return;
    /*get mac string & bootargs string*/
    ethaddr = getenv("ethaddr");
    bootargs = getenv("bootargs");
    /*check if bootargs and ethaddr had been set.
      check if ethaddr length correct.
     */
    if(!ethaddr || !bootargs){
        printf("none ethaddr or bootargs\n\n");
        return;
    }else{
        int digit = 0;
        char* t = ethaddr;
        /*check ethaddr fmt*/
        while(*t != '\0'){
                char* e;
                simple_strtoul(t,&e,16);
                t = *e ? e+1 : e;
                digit++;
                continue;
        }
        /*ethaddr env had been set not correctly.*/
        if (digit != 6)
            return;
    }
    tmp = bootargs;
    do {
        /*check if bootargs constains mac information.*/
        if((tmp = strstr(tmp, MAC_BT_HEADER)) != NULL){
            char mac[MAC_LEN];
            char mac_env[MAC_LEN];

            is_boot_args_has_mac ++;

            string_to_mac(mac, tmp + strlen(MAC_BT_HEADER));
            string_to_mac(mac_env, ethaddr);
            /*if mac is valid && mac in bootargs equals to ethaddr env, exit.*/
            if(is_valid_ether_addr(mac)){
                int i;
                for (i = 0; i < MAC_LEN; i++){
                    if (mac[i] != mac_env[i]){
                        goto merge;
                    }
                }
            }
        }
        /*if bootargs constains more than one mac= prifex. re-merge.*/
        if (is_boot_args_has_mac > 1)
            goto merge;
        /*move tmp pointer.*/
        if(tmp && tmp + strlen(MAC_BT_HEADER) < bootargs + strlen(bootargs))
            tmp += strlen(MAC_BT_HEADER);
    }while(tmp && tmp < bootargs + strlen(bootargs));
    /*reach here,means that bootargs constains only one mac= prifex. 
      and the value of mac= is equals to ethaddr env's value,then we return;
     */
    if (is_boot_args_has_mac == 1)
        return;
merge:
    /*if bootargs constains mac info. we should replace it.*/ 
    if(is_boot_args_has_mac){
        char* n;
        char* p;
        char* t = NULL;
        char* last = NULL;
        /*copy one copy of bootargs to avoid read/write org bootargs.*/
        org = malloc(strlen(bootargs) + 1);
        if(!org){
            printf("%s->%d,alloc mem fail!\n",__func__,__LINE__);
            return;
        }
        strcpy(org,bootargs);
        last = p = strstr(org, MAC_BT_HEADER);
        if(!p){
            printf("Why ???\n");
			free(org);
            return ;
        }
        /*cut off all mac= prefix*/
        while(p){
            /*first, find next split ' ' or '\0'*/
            t = p + 1;
            n = t = strchr(t, ' ');
            /*move args after 'mac=XX:XX:XX:XX:XX:XX' ahead 'mac='*/
            if (t != NULL && *t != '\0' && *(t + 1) != '\0'){
                t++; /*increase t to point at character after ' '*/
                /*then we move strings.*/
                while (t != NULL && *t!= '\0' && (t - org) < strlen(org)){
                    *p++ = *t++;
                }
            }
            *p = '\0';
            last = p;
            /*if there's no args after 'mac=XX:XX:XX:XX:XX:XX' arg, backspace p to avoid ' ' before 'mac=' prefix*/
            /*search next 'mac=' prifex*/
            p = strstr(org, MAC_BT_HEADER);
        }
        /*avoid last ' '*/
        if (* (last - 1) == ' ' && last > org)
            *--last = '\0';
        /*we alloc a tmp buf to load bootargs except mac info.*/
        /*alloc buffer*/
        /*tmp bootargs length of bootargs + ' ' + length of mac + '\0'*/
        tmp = malloc ((last - org) + strlen(MAC_BT_HEADER) + strlen(ethaddr) + 2);
        if(!tmp){
            printf("%s->%d,alloc mem fail, p - org :%d!\n",__func__,__LINE__, p-org);
            return;
        }

        sprintf(tmp, "%s %s%s",org,MAC_BT_HEADER,ethaddr);
        free(org);
    }
    else{
        /*alloc buffer*/
        /*tmp bootargs length of bootargs + ' ' + length of mac + '\0'*/
        tmp = malloc(strlen(bootargs) + strlen(MAC_BT_HEADER) + strlen(ethaddr) + 2);
        if (!tmp){
            printf("merge mac and bootargs fail!\n");
            return ;
        }
        sprintf(tmp, "%s mac=%s", bootargs, ethaddr);
    }
    setenv("bootargs", tmp);
    saveenv();
    free(tmp);
    return;
}

static int h2gmac_dev_probe(void){
    struct h2gmac_netdev_local* ld = &g_h2gmac_ld;

    h2gmac_trace(1, "start probe!\n");
   
	ld->phy_name = PHY_NAME;
    ld->iobase_phys = H2GMAC_IO_BASE;
    ld->iobase = H2GMAC_IO_BASE;

    h2gmac_trace(1, "end probe!\n");
    return 0;
}

static int h2gmac_dev_remove(void){
    //struct h2gmac_netdev_local* ld = &g_h2gmac_ld; 

    //h2gmac_net_close(ld);
    return 0;
}


static int h2gmac_init(void){
    int ret = 0;
    char* mdio_intf;
    char* phyaddr;
    /*get mdio interface from env.FORMAT: mdio_intf=mii or mdio_intf=rgmii*/
    mdio_intf = getenv("mdio_intf");
    if (mdio_intf){
        if((strncmp(mdio_intf,"mii",3) && strncmp(mdio_intf,"rgmii",5))){
            h2gmac_error("Invalid mdio intface assignment(mii or rgmii).Set default to mii\n");
        }else if(!strncmp(mdio_intf,"mii",3)){
            g_interface_mode = interface_mode_mii;
        }else if(!strncmp(mdio_intf,"rgmii",5)){
            g_interface_mode = interface_mode_rgmii;
        }
    }
    /*get phy addr & phy name*/ 
    phyaddr = getenv("phyaddr");
    if(phyaddr){
        unsigned long tmp ;
        tmp = simple_strtoul(phyaddr,0,16);
        if (tmp == 0){
            printf("Dectected phy address set to 0,is it right?\n");
        }
        else if (tmp >= (unsigned long)(~(unsigned char)0)){
            printf("Dectected phy address set to >= %lux.this may not correct.\n",tmp);
            return -1;
        }
        PHY_ADDR = (unsigned char)tmp;
        sprintf(PHY_NAME,"0:%2x",PHY_ADDR);
    }

    h2gmac_sys_init();
    ret = h2gmac_mdiobus_driver_init();
    if (ret){
        h2gmac_error("Init mdio bus fail!\n ");
        h2gmac_sys_exit();
        return -1;
    }
    ret = h2gmac_dev_probe();
    if (ret){
        h2gmac_error("register netdevice driver fail!\n");

        h2gmac_mdiobus_driver_exit();
        h2gmac_sys_exit();
        return -1;
    }
    return 0;
}

static void h2gmac_exit(void){

    h2gmac_dev_remove();
    /*h2gmac_proc_exit()*/
    h2gmac_mdiobus_driver_exit();
    h2gmac_sys_exit();

}

int eth_init(bd_t* bd){
	int ret;
	int count = 10000;
    char* timeout;
    timeout = getenv("phy_link_time");
    if(timeout){
        count = simple_strtoul(timeout, 0, 10);
    }
	ret = h2gmac_init();
	if (ret){
		h2gmac_error("gmac:Init fail!\n");
		return ret;
	}
retry:
	h2gmac_net_open(&g_h2gmac_ld);	
	if (g_h2gmac_ld.link_stat & H2GMAC_LINKED)
		goto link_on;
	if (--count)
		goto retry;
	
	printf("PHY not link!\n");
	h2gmac_net_close(&g_h2gmac_ld);
	h2gmac_exit();
	return -1;
link_on:
	h2gmac_net_set_mac_address(&g_h2gmac_ld);
	return 0;
}
void eth_halt(void){
	h2gmac_net_close(&g_h2gmac_ld);

	h2gmac_exit();
}
