#include "mdio.h"
#include "reg.h"
#include "util.h"
#include "ctl.h"
#define mdio_cmd_read (2)
#define mdio_cmd_write (1)

#define MDIO_RWCTRL     	0x03c0
#define MDIO_RO_DATA        0x1104
#define U_MDIO_PHYADDR      0x0108
#define D_MDIO_PHYADDR      0x2108
#define U_MDIO_RO_STAT      0x010C
#define D_MDIO_RO_STAT      0x210C
#define U_MDIO_ANEG_CTRL    0x0110
#define D_MDIO_ANEG_CTRL    0x2110
#define U_MDIO_IRQENA       0x0114
#define D_MDIO_IRQENA       0x2114

#define MDIO_MK_RWCTL(rw, phy_exaddr, phy_regnum) \
          (((0x1)<<20 ) | \
          (((rw)&0x3)<<16 ) | \
          (((phy_exaddr)&0x3)<<8) | \
          ((phy_regnum)&0xf))

/* hardware set bit'15 of MDIO_REG(0) if mdio ready */

#define mdio_start_phyread(ld, phy_addr, regnum ) \
    h2gmac_writel(ld, MDIO_MK_RWCTL(mdio_cmd_read,phy_addr,regnum), MDIO_RWCTRL)

#define mdio_get_phyread_val(ld) (h2gmac_readl(ld, MDIO_SINGLE_DATA) >> 16)
#define mdio_set_phywrite_val(ld,val) \
do{	\
	int reg = 0;	\
	h2gmac_writel_bits(ld,val, MDIO_SINGLE_DATA,BITS_NAME(mdio_wr_data));\
	reg = h2gmac_readl(ld, MDIO_SINGLE_DATA);	\
	h2gmac_trace(2,"write reg 0x%x, bits:0x%x= 0x%x, then read = 0x%x", MDIO_SINGLE_DATA, BITS_NAME(mdio_wr_data), val, reg);\
}while(0)

#define mdio_phywrite(ld, phy_addr, regnum) \
    h2gmac_writel(ld, MDIO_MK_RWCTL(mdio_cmd_write,phy_addr, regnum), MDIO_RWCTRL)
#if 0
/* write mdio registers reset value */
#define mdio_reg_reset(ld) do{ \
        h2gmac__writel(ld, 0x00008000, MDIO_RWCTRL); \
        h2gmac_writel(ld, 0x00000001, U_MDIO_PHYADDR); \
        h2gmac_writel(ld, 0x00000001, D_MDIO_PHYADDR); \
        h2gmac_writel(ld, 0x04631EA9, U_MDIO_ANEG_CTRL); \
        h2gmac_writel(ld, 0x04631EA9, D_MDIO_ANEG_CTRL); \
        h2gmac_writel(ld, 0x00000000, U_MDIO_IRQENA); \
        h2gmac_writel(ld, 0x00000000, D_MDIO_IRQENA); \
    } while(0)
#endif

#define test_mdio_ready(ld)     (h2gmac_readl_bits((ld), MDIO_SINGLE_CMD, BITS_NAME(mdio_cmd)) == 0)

static int wait_mdio_ready(struct h2gmac_mdio_local* ld){
    int timeout_us = 1000;

    while (--timeout_us && !test_mdio_ready(ld))
    {
        udelay(1);
    }

    return timeout_us;

}

#define test_mdio_read_data_done(ld)    (h2gmac_readl_bits(ld, MDIO_RDATA_STATUS, BITS_NAME(mdio_rdata_status)) == 0)

int h2gmac_mdio_read(struct h2gmac_mdio_local* ld, int phy, int reg){

    int timeout = 1000;
    int val = 0;
    if (!wait_mdio_ready(ld))
        return 0;

	mdio_start_phyread(ld, phy, reg);

    /*FIXME.CHECK DATA READY*/
    //while (! test_mdio_read_data_done(ld) && timeout-- > 0)
    while (!wait_mdio_ready(ld) && timeout-- > 0)
        udelay(1);

    if (timeout <= 0 || !test_mdio_read_data_done(ld)){
        return 0;
    }

    val = mdio_get_phyread_val(ld);
    
    h2gmac_trace(2, "mdio read phy:%x, reg:%x = %x\n",phy,reg, val);
    return val;
}

int h2gmac_mdio_write(struct h2gmac_mdio_local *ld, int phy, int reg, int val){

    if (!wait_mdio_ready(ld))
        return 0;
	h2gmac_trace(2, "mdio write phy:%x, reg:%x = %x\n", phy, reg, val);
	mdio_set_phywrite_val(ld, val);
	mdio_phywrite(ld, phy, reg);
    return val;
}

int  h2gmac_mdio_reset(struct h2gmac_mdio_local *ld){
   	unsigned long p = (unsigned long)H2GMAC_SYS_CTL_IO_BASE;
	volatile unsigned int v = 0;
	
	local_lock(ld);
    /*TODO: clock div*/
    /*mdio reset*/
    v = readl(p + SC_PERCTRL8);
    v &= (~(1 << 19));
    writel(v, p + SC_PERCTRL8);
	local_unlock(ld);
    udelay(10);
	local_lock(ld);
    v = readl(p + SC_PERCTRL8);
    v |= (1 << 19);
    writel(v, p + SC_PERCTRL8);
	local_unlock(ld);
	return 0;
}

int  h2gmac_mdio_init(struct h2gmac_mdio_local *ld){
	return   h2gmac_mdio_reset(ld);
}

void h2gmac_mdio_exit(struct h2gmac_mdio_local *ld){
}

