#include "h2gmac.h"
#include "mdio.h"

#include "ctl.h"
#include "util.h"

extern char PHY_NAME[MAX_PHY_NAME_LEN];
extern unsigned char PHY_ADDR ;
/* MDIO Bus Interface */
struct h2gmac_mdio_local g_mdio_ld;
static int h2gmac_mdiobus_read(char *devname, unsigned char addr,
        unsigned char reg, unsigned short *value)
{
    *value = h2gmac_mdio_read(&g_mdio_ld, addr, reg);

	return 0;
}

static int h2gmac_mdiobus_write(char *devname, unsigned char addr,
        unsigned char reg, unsigned short val)
{
    h2gmac_mdio_write(&g_mdio_ld, addr, reg, val);
	return 0;
}

int h2gmac_mdiobus_driver_init(void)
{
	g_mdio_ld.iobase_phys = H2GMAC_MDIO_IO_BASE;
	g_mdio_ld.iobase = H2GMAC_MDIO_IO_BASE;
	h2gmac_mdio_init(&g_mdio_ld);	

	miiphy_register(PHY_NAME,h2gmac_mdiobus_read,h2gmac_mdiobus_write);

	miiphy_set_current_dev(PHY_NAME);
	miiphy_reset(PHY_NAME, PHY_ADDR);
	
    return 0;
}

void h2gmac_mdiobus_driver_exit(void)
{

    if(!miiphy_get_current_dev())
        return;
	miiphy_reset(PHY_NAME,PHY_ADDR);
	h2gmac_mdio_exit(&g_mdio_ld);
}
