#include "reg.h"
#include "util.h"

void h2gmac_config_hw_fifo(struct h2gmac_netdev_local* ld, unsigned int rx_fifo_depth){
        /*config fifo*/    
	h2gmac_trace(2,"config hw rx fifo reg %x = %x",CRF_RX_BASE_ADDR, rx_fifo_depth);
    h2gmac_writel_bits(ld, rx_fifo_depth, CRF_RX_BASE_ADDR, BITS_NAME(crf_rx_base_addr));

}

int h2gmac_clear_int(struct h2gmac_netdev_local* ld, int irq){
    int stat;
    local_lock(ld);
	h2gmac_trace(2,"clear irq %x,reg = %x\n", irq, CRF_INTRPT_CLR);
    h2gmac_writel_bits(ld, 1, CRF_INTRPT_CLR, irq);
    stat = h2gmac_readl(ld, CRF_INTRPT_CLR);
    h2gmac_trace(2, "then read reg %x = %x\n", CRF_INTRPT_CLR, stat);
    local_unlock(ld);
    return stat;
}

int h2gmac_disable_int(struct h2gmac_netdev_local* ld, int irq){
    int stat;
    local_lock(ld);
	h2gmac_trace(2,"disable irq %x,reg = %x\n", irq, CRF_INTRPT_THRSLD);
    h2gmac_writel_bits(ld, 0, CRF_INTRPT_THRSLD, irq);
    stat = h2gmac_readl(ld, CRF_INTRPT_THRSLD);
    h2gmac_trace(2, "then read reg %x = %x\n", CRF_INTRPT_THRSLD, stat);

    local_unlock(ld);
    return stat;
}
int h2gmac_enable_int(struct h2gmac_netdev_local* ld, int irq){
    int stat;
    local_lock(ld);
	h2gmac_trace(2,"enable irq %x,reg = %x\n", irq,CRF_INTRPT_THRSLD);
    h2gmac_writel_bits(ld, 1, CRF_INTRPT_THRSLD, irq);
    stat = h2gmac_readl(ld, CRF_INTRPT_THRSLD);
    h2gmac_trace(2, "then read reg %x = %x\n", CRF_INTRPT_THRSLD, stat);
    local_unlock(ld);
    return stat;
}
int h2gmac_config_hw_int(struct  h2gmac_netdev_local*ld,int pkg_cnt,int timeout){
    int stat;
    local_lock(ld);

    /*pkg cnt first*/
//    h2gmac_writel_bits(ld, pkg_cnt, CRF_INTRPT_THRSLD, BITS_NAME(crf_intrpt_pkt));
    /*timeout*/
 //   h2gmac_writel_bits(ld, timeout, CRF_INTRPT_THRSLD, BITS_NAME(crf_intrpt_time));

    /*enable int:  rx multi-pkg int,rx timeout int*/
//    h2gmac_enable_int(ld, BITS_NAME(mac_fifoerr_int_en));
//    h2gmac_enable_int(ld, BITS_NAME(p2a_err_intrpt_en));
//    h2gmac_enable_int(ld, BITS_NAME(crf_pkg_intrpt_en));
    h2gmac_enable_int(ld, BITS_NAME(crf_rxint_en));
    h2gmac_enable_int(ld, BITS_NAME(crf_txint_en));
    //h2gmac_enable_int(ld, BITS_NAME(crf_time_intrpt_en));
    
    stat = h2gmac_readl(ld, CRF_INTRPT_THRSLD);
    h2gmac_trace(2, "read reg %x = %x\n", CRF_INTRPT_THRSLD, stat);

    local_unlock(ld);
    return stat;
}
int h2gmac_read_hw_tx_cnt(struct h2gmac_netdev_local* ld){
    return h2gmac_readl_bits(ld, CRF_CFF_DATA_NUM, BITS_NAME(crf_tx_cfg_num));
}

int h2gmac_write_tx_data(struct h2gmac_netdev_local* ld, unsigned char* data){

    h2gmac_writel(ld, (unsigned int)data, TX_CFF_ADDR(0));
    return 0 ;    
}
int h2gmac_write_tx_len(struct h2gmac_netdev_local* ld,unsigned int len){
    h2gmac_writel(ld, len, TX_CFF_LEN(0));
    return 0;
}

