/*
 * (C) Copyright 2006, HISILICON
 * Configuation settings for the Hi3520v100 FPGA board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/arch/platform.h>

#ifndef __CONFIG_Hi3520v100ASIC_H__
#define __CONFIG_Hi3520v100ASIC_H__

/*-----------------------------------------------------------------
 *  System Configuration
 */

#define HUSS_E4V_DDRCB_256MB	(1)

#define CONFIG_NO_LOWLEVEL_REGLDR
#define NAND_TEXT_ADRS          (CFG_NAND_BASE)

#define ROM_TEXT_ADRS 		(MEM_BASE_FLASH)	
#define CFG_BOOT_PARAMS		(MEM_BASE_DDR+0x0100)

//#define CONFIG_ARM926EJS	1		/* This is an arm926ejs CPU core  */
#define CONFIG_HISILICON	1		/* Hisilicon Platform Board	*/

#ifndef CFG_CLK_MPLLIN 
#define CFG_CLK_MPLLIN		24000000
#endif

#define CFG_CLK_SLOW		24000000

#define CFG_CLK_BUS		202000000

#define CFG_CPUCLK_SCALE	3
#define CFG_CLK_CPU		(CFG_CLK_BUS*CFG_CPUCLK_SCALE)
#define CFG_DEFAULT_CLK_CPU	CFG_CLK_CPU

#define CFG_MSEC_XTALSTABLE	10

/*******************************************************************
*       FREF	        24Mhz
*      FOUTVCO	        FREF * ( fbdiv + frac/2^24) / refdiv
*      FOUTPOSTDIV	FOUTVCO / pstdiv1 * pstdiv2
*      FOUT1ph0	        FOUTVCO / (pstdiv1 * 2)
*      FOUT2	        FOUTVCO / (pstdiv1 * 4)
*      FOUT3	        FOUTVCO / (pstdiv1 * 6)
*      FOUT4	        FOUTVCO / (pstdiv1 * 8)
*********************************************************************/

/* config for APLL
*  fbdiv = 100,refdiv = 1,pstdiv1 = 1,pstdiv2 = 1
*  FOUTVCO = 2400MHZ	
*  FOUT2 = 600MHZ ---->arm11
*  FOUT3 = 400MHZ ---->arm9
*
*/

//#define APLL_FBDIV 0x64
#define APLL_FBDIV 0x65    /* 101 * 24M = 2424 for reset */
#define APLL_REFDIV 0x1
#define APLL_PSTDIV1 0x1
#define APLL_PSTDIV2 0x1

#define REG_CONF_PERCTRL0 (1<<31) | (APLL_PSTDIV2<<27)|(APLL_PSTDIV1<<24)  //0x89000000
#define REG_CONF_PERCTRL1 (1<<21) | (1<<19) | (1<<18) | (APLL_REFDIV<<12) | (APLL_FBDIV<<0) //0x002c1064

/* config for EPLL
* fbdiv = 125,refdiv = 2,pstdiv1 = 3,pstdiv2 = 1
* FOUTVCO = 1500MHZ
* FOUTPOSTDIV = 500MHZ
* FOUT1ph0 = 250MHZ
* FOUT2	   = 125MHz
* FOUT4 = 62.5MHZ
*/
#define EPLL_FBDIV 0x7D
#define EPLL_REFDIV 0x2
#define EPLL_PSTDIV1 0x3
#define EPLL_PSTDIV2 0x1

#define REG_CONF_PERCTRL6 (1<<31) | (EPLL_PSTDIV2<<27)|(EPLL_PSTDIV1<<24) //0x8b000000
#define REG_CONF_PERCTRL7 (1<<21) | (1<<19) | (1<<18) | (EPLL_REFDIV<<12) | (EPLL_FBDIV<<0) //0x002c207d

/* DDRC Config */
/* You Must Include <asm/arch/ddrc.h> Here! */
#include <asm/arch/ddrc.h>

#define CFG_DDRCA_BUSWITH DDRC_BUSWITH_32BITS
#define CFG_DDRCA_BANK DDRC_CHIP_8BANK
#define CFG_DDRCA_ROW CFG_DDRC_ROW_13
#define CFG_DDRCA_COL CFG_DDRC_COL_10
#define CFG_DDRCA_WR_DELAY DDR_WR_DELAY_5
#define CFG_DDRCA_CAS_DELAY DDR_CAS_DELAY_6

#define CFG_DDRCB_BUSWITH DDRC_BUSWITH_16BITS
#define CFG_DDRCB_BANK DDRC_CHIP_8BANK

#ifdef HUSS_E4V_DDRCB_256MB
#define CFG_DDRCB_ROW CFG_DDRC_ROW_14
#else
#define CFG_DDRCB_ROW CFG_DDRC_ROW_13
#endif

#define CFG_DDRCB_COL CFG_DDRC_COL_10
#define CFG_DDRCB_WR_DELAY DDR_WR_DELAY_5
#define CFG_DDRCB_CAS_DELAY DDR_CAS_DELAY_6

#ifdef HUSS_E4V_DDRCB_256MB
#define CFG_DDRCB_CAP (CFG_DDRC_CAP_1Gb*2)
#else
#define CFG_DDRCB_CAP CFG_DDRC_CAP_1Gb
#endif

#define DDRCA_CONFIG_VALUE (0x80000000 | (CFG_DDRCA_BUSWITH << 12) | (CFG_DDRCA_BANK << 7) | (CFG_DDRCA_ROW << 4) | (CFG_DDRCA_COL << 0))
#define DDRCA_MRS0_VALUE   (0x00460103 | (CFG_DDRCA_WR_DELAY << 9) | (CFG_DDRCA_CAS_DELAY << 4))

#define DDRCB_CONFIG_VALUE (0x80000000 | (CFG_DDRCB_BUSWITH << 12) | (CFG_DDRCB_BANK << 7) | (CFG_DDRCB_ROW << 4) | (CFG_DDRCB_COL << 0))
#define DDRCB_MRS0_VALUE   (0x00460103 | (CFG_DDRCB_WR_DELAY << 9) | (CFG_DDRCB_CAS_DELAY << 4))

/* define for ddr train */
#define DDR_RESET_FIFO    0x00000000
#define DDR_NO_RESET_FIFO 0x00000001

/* define ddr mem base */
#define MEM_SLAVE_BASE_DDR 0xe0000000
#define MEM_BASE_DDR    (MEM_SLAVE_BASE_DDR + 0x2000000)
#define MEM_SLAVE_RESET ((MEM_SLAVE_BASE_DDR + 0x1000000)>>24)

/*============ ATTENTION! YOU MAY MODIFY BELOW CONFIGS WHEN PORTING ========== */

/*-----------------------------------------------------------------------
 * Physical Memory Configuration
 */
#define CONFIG_NR_DRAM_BANKS    1		/* we have 1 bank of DRAM */
#define CFG_DDR_PHYS_OFFSET	MEM_BASE_DDR
//#define CFG_DDR_SIZE CFG_DDRCB_CAP/8	
#define CFG_DDR_SIZE (256*1024*1024)	

#define CONFIG_BOOTUP_CLEAN_RAM

#define CFG_ALT_MEMTEST 1
#define CFG_MEMTEST_START       (CFG_DDR_PHYS_OFFSET + sizeof(unsigned long))
#define CFG_MEMTEST_END         (CFG_DDR_PHYS_OFFSET + CFG_DDR_SIZE)
#define CFG_MEMTEST_SCRATCH     CFG_DDR_PHYS_OFFSET 

/* CONFIG TIMER */
#define CFG_TIMERBASE           REG_BASE_TIMER12
#define CFG_HZ                  (CFG_CLK_BUS / 256)
#define CFG_TIMER_CTRL          0x8A
#define READ_TIMER		(*(volatile unsigned long *)(CFG_TIMERBASE + REG_TIMER_VALUE))

#define CONFIG_CMDLINE_TAG		1	/* enable passing of ATAGs  */
#define CONFIG_INITRD_TAG		1	/* support initrd */
#define CONFIG_SETUP_MEMORY_TAGS	1
#define CONFIG_MISC_INIT_R		1	/* call misc_init_r during start up */

#define CFG_MALLOC_LEN		(CONFIG_ENV_SIZE + 128*1024)
#define CFG_GBL_DATA_SIZE	128		/* size in bytes reserved for initial data */

#define CONFIG_STACKSIZE	(128*1024)	/* regular stack */

#define CONFIG_PL011_SERIAL
#define UART_PERSCAL 2
#define CONFIG_PL011_CLOCK	CFG_CLK_BUS/UART_PERSCAL		
#define CONFIG_PL01x_PORTS	{ (void *)CFG_SERIAL0, (void *)CFG_SERIAL1, (void *)CFG_SERIAL2 }
#define CONFIG_CONS_INDEX       0 	

#define CONFIG_BAUDRATE         115200
#define CFG_BAUDRATE_TABLE      { 9600, 19200, 38400, 57600, 115200 }
#define CFG_SERIAL0		REG_BASE_UART0
#define CFG_SERIAL1		REG_BASE_UART1
#define CFG_SERIAL2             REG_BASE_UART2

/* gpio i2c RTC */
#define CONFIG_RTC_DS1337		/* Use ds1337 rtc via gpio i2c	*/
#define CFG_I2C_RTC_ADDR	0xD0	/* at address 0xD0		*/

#define CONFIG_AUTO_COMPLETE	1
#define CFG_CMDLINE_HISTORYS    8
#define CONFIG_CMDLINE_EDITING

#define CONFIG_SILENT_CONSOLE   1

/* USB ****************************************************************/
#define CONFIG_CMD_USB			1
#define CONFIG_USB_OHCI			1/* FIXME: CONFIG_USB_OHCI_NEW */
#define LITTLEENDIAN			1/* for hi3520v100 */
#define CONFIG_DOS_PARTITION		1
#define CFG_USB_OHCI_CPU_INIT		1
#define HIUSB_OHCI_BASE			0x100a0000/* FIXME: hi3520 ohci base */
#define HIUSB_OHCI_DEV_NAME		"hiusb-ohci"
#define CFG_USB_OHCI_MAX_ROOT_PORTS	2
#define CONFIG_USB_STORAGE		1
//#define CONFIG_SUPPORT_VFAT		1
#define CONFIG_CMD_FAT			1
#define CONFIG_CMD_EXT2			1

#define REG_USB_SC_PEREN	0x20050024
#define USB_CLK_EN		(1<<22)

#define REG_SC_PER_CTRL12	0x20050060
#define USB_PORT1_POW_13	(1<<13) 
#define USB_PORT1_POW_12	(1<<12) 
#define USB_PORT0_POW_11	(1<<11) 
#define USB_PORT0_POW_10	(1<<10) 

#define REG_SC_PER_CTRL8	0x20050050
#define USB_PHY_CLK_RESET	(1<<31)
#define USB_BUS_RESET		(1<<30)

/* USB POWER EN REG*/
#define REG_GPIO3_7_REUSE	0x200F013C
#define SET_GPIO3_7_REUSB	(1)

#define REG_GPIO7_1_REUSE	0x200F0144
#define SET_GPIO7_1_REUSB	(1)

#define REG_GPIO3_DIR		0x20180400
#define SET_GPIO3_7_DIR		(1<<7)

#define REG_GPIO3_7_VAL		0x20180200
#define SET_GPIO3_7_VAL		(1<<7)

#define REG_GPIO7_DIR		0x201c0400
#define SET_GPIO7_1_DIR		(1<<1)

#define REG_GPIO7_1_VAL		0x201c0008
#define SET_GPIO7_1_VAL		(1<<1)

/* automatic software updates (see board/hi3560v200/auto_update.c) */
/*
 * #define CONFIG_AUTO_UPDATE      1
 * */

#define hiusb_ohci_enable_clk()	do{ \
	int reg;\
	\
	reg = readl(REG_USB_SC_PEREN);\
	writel(reg | USB_CLK_EN, REG_USB_SC_PEREN);\
	\
	reg = readl(REG_SC_PER_CTRL12);\
	reg |= USB_PORT0_POW_10;\
	reg &= ~(USB_PORT0_POW_11);\
	reg |= USB_PORT1_POW_12;\
	reg &= ~(USB_PORT1_POW_13);\
	writel(reg,REG_SC_PER_CTRL12);\
	\
	reg = readl(REG_SC_PER_CTRL8);\
	writel(reg | USB_PHY_CLK_RESET,REG_SC_PER_CTRL8);\
	\
	reg = readl(REG_SC_PER_CTRL8);\
	writel(reg | USB_BUS_RESET,REG_SC_PER_CTRL8);\
	\
	reg = readl(REG_GPIO3_DIR);\
	writel(reg | SET_GPIO3_7_DIR,REG_GPIO3_DIR);\
	\
	reg = readl(REG_GPIO3_7_VAL);\
	reg &= ~(SET_GPIO3_7_VAL);\
	writel(reg,REG_GPIO3_7_VAL);\
	\
	reg = readl(REG_GPIO7_DIR);\
	writel(reg | SET_GPIO7_1_DIR,REG_GPIO7_DIR);\
	\
	reg = readl(REG_GPIO7_1_VAL);\
	reg &= ~(SET_GPIO7_1_VAL);\
	writel(reg,REG_GPIO7_1_VAL);\
	\
}while(0)

#define hiusb_ohci_disable_clk() do{ \
}while(0)
/* USB ****************************************************************/

#define CONFIG_COMMANDS ( CFG_CMD_BDI | CFG_CMD_MEMORY | CFG_CMD_FLASH | CFG_CMD_ENV | CONFIG_CMD_LOADB | CONFIG_CMD_LOADS)
#define CONFIG_BOOTP_MASK	CONFIG_BOOTP_DEFAULT

#define CONFIG_CMD_ENV
#define CONFIG_CMD_FLASH
#define CONFIG_CMD_DIAG
#define CONFIG_CMD_DATE
//#define CONFIG_CMD_SF
//#define CONFIG_CMD_NAND
#define CONFIG_CMD_IMI
#define CONFIG_CMD_RUN
//#include <cmd_confdefs.h>

/* hisfv300 */
#define CONFIG_CMD_PING
#define CONFIG_CMD_MII
#define CONFIG_CMD_NET
#define CONFIG_CMD_MEMORY
#define CONFIG_CMD_LOADB 

/* POST support */
#define CONFIG_POST             (CFG_POST_RTC    | \
				 CFG_POST_MEMORY | \
				 CFG_POST_TW2866 | \
				 CFG_POST_LM96163| \
				 CFG_POST_AIC3104| \
				 CFG_POST_TIRLEDON| \
				 CFG_POST_TIGLEDON| \
				 CFG_POST_TILEDOFF| \
				 CFG_POST_GLEDON | \
				 CFG_POST_GLEDOFF| \
				 CFG_POST_RET_FAC| \
				 CFG_POST_BUZZER | \
				 CFG_POST_ETHER  | \
				 CFG_POST_RS485  | \
				 CFG_POST_FANON  | \
				 CFG_POST_FANOFF)

//#define CONFIG_ZERO_BOOTDELAY_CHECK 1

//#define CONFIG_BOOTARGS "mem=72M console=ttyAMA0,115200 root=/dev/ram rw initrd=0xe3800000,24M ramdisk_size=24576 ramdisk_blocksize=1024"

#define CONFIG_NETMASK	255.255.255.0		/* talk on MY local net */
#define CONFIG_IPADDR	192.168.1.90		/* static IP I currently own */
#define CONFIG_SERVERIP	192.168.1.91		/* current IP of tftp server ip */
#define CONFIG_ETHADDR  00:00:00:00:00:00
#define CONFIG_BOOTFILE	"uImage" 		/* file to load */

#define CFG_LONGHELP	
#define CFG_PROMPT	"HUSS-E4V # "		/* Monitor Command Prompt   */
#define CFG_CBSIZE	1024			/* Console I/O Buffer Size  */
#define CFG_PBSIZE	(CFG_CBSIZE+sizeof(CFG_PROMPT)+16)
#define CFG_MAXARGS	32			/* max number of command args   */
#define CFG_BARGSIZE	CFG_CBSIZE		/* Boot Argument Buffer Size    */
#undef	CFG_CLKS_IN_HZ				/* everything, incl board info, in Hz */
#define CFG_LOAD_ADDR	(CFG_DDR_PHYS_OFFSET + 0x08000)		/* default load address */

/*-----------------------------------------------------------------------
 *  * NAND FLASH and Environment Configuration
 *   */
#define CFG_MAX_NAND_DEVICE 1
#define CFG_NAND_BASE 0x70000000
#define CONFIG_NAND_HI
#define CONFIG_CMD_NAND
#define CONFIG_YAFFS2
#define YAFFS2_DEBUG
//#define CONFIG_CMD_JFFS2
//#define CONFIG_JFFS2_NAND	1
#define CONFIG_JFFS2_DEV		"nand0"
#define CONFIG_JFFS2_PART_SIZE	    0x800000
#define CONFIG_JFFS2_PART_OFFSET    0x0
#define CFG_NAND_U_BOOT_OFFS 0x20000
#define CFG_NAND_U_BOOT_SIZE 0x40000
#define CFG_NAND_U_BOOT_DST  (TEXT_BASE + CFG_NAND_U_BOOT_OFFS)


/*-----------------------------------------------------------------------
 * FLASH and Environment Configuration
 */
#define CFG_FLASH_CFI
#define CFG_FLASH_CFI_DRIVER
#define CFG_FLASH_PROTECTION
#define CFG_FLASH_USE_BUFFER_WRITE

#define CFG_FLASH_BASE          MEM_BASE_FLASH

#define CONFIG_ENV_IS_IN_NAND     1            /* env in flash instead of CFG_ENV_IS_NOWHERE */
#define CONFIG_ENV_IS_IN_SPI_FLASH     1            /* env in flash instead of CFG_ENV_IS_NOWHERE */
#define CONFIG_ENV_IS_IN_FLASH     1            /* env in flash instead of CFG_ENV_IS_NOWHERE */
#define CONFIG_ENV_SIZE            0x20000      /* Total Size of Environment Sector */
#define CFG_ENV_OFFSET          0x80000      /* environment starts here  */
#define CONFIG_ENV_ADDR            (CFG_FLASH_BASE + CFG_ENV_OFFSET)
#define CONFIG_ENV_OVERWRITE

#define CFG_MAX_FLASH_BANKS	1	/* max number of memory banks */
#define CFG_MAX_FLASH_SECT	512   

#define CFG_FLASH_ERASE_TOUT    60000 /* Flash Erase Timeout (ms) */
#define CFG_FLASH_WRITE_TOUT    500 /* Flash Write Timeout (ms) */


/*-----------------------------------------------------------------------
 * Net Driver Configuration
 */

//#define CONFIG_HISILICON_ETH_V100
//#define CONFIG_HI3560V100_LOGO

#define CONFIG_CLEANUP_MEMORY	1

//#define __mem_pci(c) (c)

/*-----------------------------------------------------------------------
 * SPI Flash Configuration
 */
//#define CONFIG_HISFC_FLASH

/*-----------------------------------------------------------------------
 * NOR Flash Configuration
 */
//#define CFG_FLASH_TIMING_OPT	1
#define FLASH_READ_TIMING_TOE	35	/* Output Enable to Output Delay */
#define FLASH_READ_TIMING_TCE	100	/* Chip Enable to Output Delay */
#define FLASH_READ_TIMING_TRC	100	/* Read Cycle Time */

/*Bootflag address*/
#define BOOT_SELECTION_FLAG_ADDR        (0x81F80020)
#define BOOT_SELECTION_FLAG_DATA        (0x55AA55AA)

/*-----------------------------------------------------------------------
 * Switch to uboot by key
 */
 
#define CONFIG_BOOTDELAY	1
#define CONFIG_AUTOBOOT_KEYED   /* Enable password protection */
#define CONFIG_AUTOBOOT_PROMPT	\
	"\nEnter password - autoboot in %d sec...\n", bootdelay
#define CONFIG_AUTOBOOT_DELAY_STR       "hone4v"
#define CONFIG_SILENT_CONSOLE   1

//#define CFG_DMA_MEMCPY	1 

#define CFG_FAULT_ECHO_LINK_DOWN

#define CONFIG_SHOW_BOOT_PROGRESS

#define CONFIG_FLASH_CFI_DRIVER
//#define CFG_MMU_HANDLE 	1

#define CFG_DIRECT_FLASH_TFTP
#define CONFIG_VERSION_VARIABLE
	
/*Slave boot kernel initrd addr*/
#define CFG_SLAVE_BOOT_ADDR    0x81180000
#define CFG_SLAVE_KERNEL_ADDR  0x81280000
#define CFG_SLAVE_INITRD_ADDR  0x81480000
//#define MEM_SLAVE_BASE_DDR 0xe0000000
#define CFG_SLAVE_ENV_ADDR (MEM_SLAVE_BASE_DDR + CFG_ENV_OFFSET)
#define CFG_ENV_SIZE 0x20000
#define CFG_HAS_SLAVE
#define SLAVR_BOOT_DEBUG 0

/* slave h2 config */
#define H2_SLV_KENEL 0xe2a00000
#define H2_SLV_INITRD 0xe3000000

#define CONFIG_EXTRA_ENV_SETTINGS	 \
 "mbootflashaddr=80000000\0"		\
 "mkernelflashaddr=80100000\0"		\
 "mrootfsflashaddr=80300000\0"		\
 "etcflashaddr=80f80000\0"		\
 "sbootflashaddr=81180000\0"		\
 "skernelflashaddr=81280000\0"		\
 "srootfsflashaddr=81480000\0"		\
 "mkernelbackflashaddr=81880000\0"	\
 "mrootfsbackflashaddr=81a80000\0"	\
 "bootflagflashaddr=81f80000\0"		\
 "mbootsize=100000\0"			\
 "mkernelsize=200000\0"			\
 "mrootfssize=c80000\0"			\
 "etcsize=200000\0"			\
 "sbootsize=100000\0"			\
 "skernelsize=200000\0"			\
 "srootfssize=400000\0"			\
 "mkernelbacksize=200000\0"		\
 "mrootfsbacksize=500000\0"		\
 "bootflagsize=80000\0"			\
 "mbootfile=u-boot-master.bin\0"	\
 "mkernelfile=kernel-master.bin\0"	\
 "mrootfsfile=rootfs-master.bin\0"	\
 "etcfile=etc.jffs2\0"			\
 "sbootfile=u-boot-slave.bin\0"		\
 "skernelfile=kernel-slave.bin\0"	\
 "srootfsfile=rootfs-slave.bin\0"	\
 "mrootfsbackfile=rootfs-master-min.bin\0"	\
 "bootflagfile=bootflag.bin\0"		\
 "upmboot=tftp 0xe4000000 ${mbootfile};protect off all;erase ${mbootflashaddr} +${mbootsize};cp.b 0xe4000000 ${mbootflashaddr} ${filesize}\0"	\
 "upmkernel=tftp 0xe4000000 ${mkernelfile};erase ${mkernelflashaddr} +${mkernelsize};cp.b 0xe4000000 ${mkernelflashaddr} ${filesize}\0"     \
 "upmrootfs=tftp 0xe4000000 ${mrootfsfile};erase ${mrootfsflashaddr} +${mrootfssize};cp.b 0xe4000000 ${mrootfsflashaddr} ${filesize}\0"     \
 "upetc=tftp 0xe4000000 ${etcfile};erase ${etcflashaddr} +${etcsize};cp.b 0xe4000000 ${etcflashaddr} ${filesize}\0"     \
 "upsboot=tftp 0xe4000000 ${sbootfile};erase ${sbootflashaddr} +${sbootsize};cp.b 0xe4000000 ${sbootflashaddr} ${filesize}\0"     \
 "upskernel=tftp 0xe4000000 ${skernelfile};erase ${skernelflashaddr} +${skernelsize};cp.b 0xe4000000 ${skernelflashaddr} ${filesize}\0"     \
 "upsrootfs=tftp 0xe4000000 ${srootfsfile};erase ${srootfsflashaddr} +${srootfssize};cp.b 0xe4000000 ${srootfsflashaddr} ${filesize}\0"     \
 "upmkernelback=tftp 0xe4000000 ${mkernelfile};erase ${mkernelbackflashaddr} +${mkernelsize};cp.b 0xe4000000 ${mkernelbackflashaddr} ${filesize}\0"     \
 "upmrootfsback=tftp 0xe4000000 ${mrootfsbackfile};erase ${mrootfsbackflashaddr} +${mrootfsbacksize};cp.b 0xe4000000 ${mrootfsbackflashaddr} ${filesize}\0"     \
 "upbootflag=tftp 0xe4000000 ${bootflagfile};erase ${bootflagflashaddr} +${bootflagsize};cp.b 0xe4000000 ${bootflagflashaddr} ${filesize}\0"     \
 "upall=run upmkernel;run upmrootfs;run upetc;run upsboot;run upskernel;run upsrootfs;run upmkernelback;run upmrootfsback;run upbootflag\0" \
 "mrootfsramaddr=e3800000\0"	\
 "mdio_intf=rgmii\0"		\
 "flashboot=setenv bootargs mem=192M console=ttyAMA0,115200 root=/dev/ram rw initrd=0x${mrootfsramaddr},32M ramdisk_size=32768 ramdisk_blocksize=1024 ${othbootargs};cp.b ${mrootfsflashaddr} ${mrootfsramaddr} ${mrootfssize};bootm ${mkernelflashaddr}\0"	\
 "flashbackboot=setenv bootargs mem=192M console=ttyAMA0,115200 root=/dev/ram rw initrd=0x${mrootfsramaddr},32M ramdisk_size=32768 ramdisk_blocksize=1024 mac=${ethaddr};cp.b ${mrootfsbackflashaddr} ${mrootfsramaddr} ${mrootfsbacksize};bootm ${mkernelbackflashaddr}\0"	\
 "bootcmd=run flashboot\0"	\
 "bootcmdback=run flashbackboot\0"	\
 "slave_bootargs=mem=15M console=ttyAMA0,115200\0"	\
 "slave_autostart=1\0"		\
 ""

#endif	/* __CONFIG_H */
