
#ifndef _GPIO_I2C_H
#define _GPIO_I2C_H


#define GPIO_I2C_READ   0x01
#define GPIO_I2C_WRITE  0x02
#define E2PROM_BYTE_READ 0x03
#define E2PROM_BYTE_WRITE 0x04

enum{
	LED_BOTH_OFF = 0,
	LED_GREEN_ON,
	LED_RED_ON,
	LED_BOTH_ON,
};

enum{
	LED_BLINK_OFF = 0,
	LED_BLINK_ON,
};

unsigned char gpio_i2c_read(unsigned char devaddress, unsigned char address);
void gpio_i2c_write(unsigned char devaddress, unsigned char address, unsigned char value);

void e4v_init_i2c_led_chip(void);
void e4v_video_chn_led_control(int chn, int color, int blink);
void fan_force_start();
int buzzer_post_test(int flags);
void e4v_check_restore_factory(void);

#endif

