/**
 * system/src/bld/trampoline.S
 *
 * History:
 *    2005/01/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <config.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw.h>
#include <asm/arch/hotboot.h>
 
.text

 .globl board_lowlevel_init
board_lowlevel_init: 

    mov     ip, sp
    stmdb   sp!, {ip, lr, pc}
	/* First read in some misc registers */
	mrc	p15, 0, r0, c0, c0, 0	/* Read ID value */
	mrc	p15, 0, r1, c0, c0, 1	/* Read cache type */
	mrc	p15, 0, r2, c0, c0, 2	/* Read TCM status */

	/* Turn on instrucion cache and disable MMU */
	mrc	p15, 0, r0, c1, c0, 0	/* Read control register */
	@orr	r0, r0, #0x1000		@ Turn on bit 12 - I-cache
	bic   r0, r0, #0x1000             @ Turn off bit 12 - I-cache
	bic	r0, r0, #0x2000		@ Turn off bit 13 - HV
	orr	r0, r0, #0xc          @Turn on dcache
	bic	r0, r0, #0x1		@ Turn off bit 1 - MMU
#if defined(__ARM1136JS__)
#if defined(BROKEN_UNALIGNED_ACCESS_SUPPORT)
	@orr	r0, r0, #0x2		@ Turn on bit 1 - Alignment fault
	bic	r0, r0, #0x400000	@ Turn off bit 22 - Unainged support
#else
	bic	r0, r0, #0x2		@ Turn off bit 1 - Alignment fault
	orr	r0, r0, #0x400000	@ Turn on bit 22 - Unainged support
#endif
	bic	r0, r0, #0x800000	@ Turn off bit 23 - XP
#endif
	mcr	p15, 0, r0, c1, c0, 0	/* Write control register */

	/* Give client access to domain 0 */
	mov	r0, #0x1
	mcr	p15, 0, r0, c3, c0, 0

#if defined(__ARM1136JS__)
#if	(PHY_BUS_MAP_TYPE == 1)
	/* -------------------------------------------------- */
	/* Redirect peripheral port 0xe0000000 - 0xefffffff   */
	/* -------------------------------------------------- */
	mov	r0, #AHB_PHYS_BASE
	orr	r0, r0, #0x00000013
	mcr	p15, 0, r0, c15, c2, 4
#else
	/* -------------------------------------------------- */
	/* Redirect peripheral port 0x60000000 - 0x7fffffff   */
	/* -------------------------------------------------- */
	mov	r0, #AHB_PHYS_BASE
	orr	r0, r0, #0x00000014
	mcr	p15, 0, r0, c15, c2, 4
#endif
#endif
  
	/* Some magics to make hw work fine. */
	//#include "gumo.S"

	/* Get & save hotboot info */
	mov	r0, #DRAM_START_ADDR
	orr	r0, r0, #0x80000
	sub	r0, r0, #0x10
	ldr	r1, [r0, #0x0]
	ldr	r2, hotboot_magic0
	cmp	r1, r2
	bne	hotboot_done
	ldr	r1, [r0, #0xc]
	ldr	r2, hotboot_magic1
	bne	hotboot_done
	mov	r1, #0x1
	ldr	r2, hotboot_valid_addr
	str	r1, [r2]
	ldr	r1, [r0, #0x4]
	ldr	r2, hotboot_pattern_addr
	str	r1, [r2]
	mov	r1, #0x0
	str	r1, [r0, #0x0]
	str	r1, [r0, #0x4]
	str	r1, [r0, #0x8]
	str	r1, [r0, #0xc]
hotboot_done: 
 
	/* Set up the page tables and enable MMU */
	bl	mmu_init
	@bl	_enable_dcache

    ldmia   sp, {sp, pc}    

.globl hotboot_valid
hotboot_valid: .word 0
.globl hotboot_pattern
hotboot_pattern: .word 0
_TEXT_BASE: .word   TEXT_BASE

hotboot_magic0:		.word	HOTBOOT_MAGIC0
hotboot_magic1:		.word	HOTBOOT_MAGIC1
hotboot_valid_addr:	.word	hotboot_valid
hotboot_pattern_addr:	.word	hotboot_pattern
