/**
 * boards/a5sipcam/bsp/bsp.c
 *
 * Author: Anthony Ginger <hfjiang@ambarella.com>
 *
 * Copyright (C) 2004-2010, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <ambhw.h>
#include <atag.h>
#include <bldfunc.h>
#include <peripheral/spi.h>
#include <vout.h>

#if defined(SHOW_AMBOOT_SPLASH)

/* LCD TPO489 */
#if defined(CONFIG_LCD_PANEL_TPO489)
#define TPO489_BKL_ON				GPIO(85)
#define TPO489_SPI_ID				(1)
#define TPO489_SPI_MODE				(0)
#define TPO489_SPI_DFS				(15)
#define TPO489_BAUD_RATE			(500000)

static u16 tpo489_data[] = {
	0x0801,
	0x0800,
	0x0200,
	0x0304,
	0x040e,
	0x0903,
	0x0b08,
	0x0c53,
	0x0d01,
	0x0ee0,
	0x0f01,
	0x10f4,
	0x201e,
	0x210a,
	0x220a,
	0x231e,
	0x2532,
	0x2600,
	0x27ac,
	0x2904,
	0x2ae4,
	0x2b45,
	0x2c45,
	0x2d15,
	0x2e5a,
	0x2fff,
	0x306b,
	0x312e,
	0x325e,
	0x338e,
	0x34c8,
	0x35f5,
	0x361e,
	0x3797,
	0x3804,
	0x395c,
	0x3aa8,
	0x3bff,
	0x07c9
	};

static void tpo489_lcd_config_hvga()
{
	gpio_config_sw_out(TPO489_BKL_ON);
	gpio_set(TPO489_BKL_ON);
	spi_init();
	spi_config(TPO489_SPI_ID, TPO489_SPI_MODE,
		TPO489_SPI_DFS, TPO489_BAUD_RATE);
	spi_write(TPO489_SPI_ID, tpo489_data,
		(sizeof(tpo489_data)/sizeof(u16)));
}

static int tpo489_set_vout_ctrl_hvga(lcd_dev_vout_cfg_t * vout_cfg)
{
	/* Fill the Sync Mode and Color space */
	vout_cfg->lcd_sync    = INPUT_FORMAT_601;
	vout_cfg->color_space = CS_RGB;

	/* Fill the HVSync polarity */
	vout_cfg->hs_polarity    = ACTIVE_LO;
	vout_cfg->vs_polarity    = ACTIVE_LO;

	/* Fill the number of VD_CLK per H-Sync, number of H-Sync's per field */
	vout_cfg->ftime_hs     = 500;
	vout_cfg->ftime_vs_top = 600;
	vout_cfg->ftime_vs_bot = 600;

	/* HSync start and end */
	vout_cfg->hs_start = 0;
	vout_cfg->hs_end   = 10;

	/* VSync start and end, use two dimension(x,y) to calculate */
	vout_cfg->vs_start_row_top = 0;
	vout_cfg->vs_start_row_bot = 0;
	vout_cfg->vs_end_row_top   = 2;
	vout_cfg->vs_end_row_bot   = 2;

	vout_cfg->vs_start_col_top = 0;
	vout_cfg->vs_start_col_bot = 0;
	vout_cfg->vs_end_col_top   = 0;
	vout_cfg->vs_end_col_bot   = 0;

	/* Active start and end, use two dimension(x,y) to calculate */
	vout_cfg->act_start_row_top = 4;
	vout_cfg->act_start_row_bot = 4;
	vout_cfg->act_end_row_top   = 483;
	vout_cfg->act_end_row_bot   = 483;

	vout_cfg->act_start_col_top = 14;
	vout_cfg->act_start_col_bot = 14;
	vout_cfg->act_end_col_top   = 333;
	vout_cfg->act_end_col_bot   = 333;

	/* Set default color */
	vout_cfg->bg_color        = BG_BLACK;

	/* LCD paremeters */
	vout_cfg->lcd_display     = LCD_PROG_DISPLAY;
	vout_cfg->lcd_frame_rate  = 0;

	vout_cfg->lcd_data_clk    = 0;
	vout_cfg->lcd_color_mode  = 3; //rgb565
	vout_cfg->lcd_rgb_seq_top = 0; //AMBA_VOUT_LCD_SEQ_R0_G1_B2
	vout_cfg->lcd_rgb_seq_bot = 0; //AMBA_VOUT_LCD_SEQ_R0_G1_B2
	vout_cfg->lcd_hscan       = 0;

	vout_cfg->osd_width       = 320;
	vout_cfg->osd_height      = 480;
	vout_cfg->osd_resolution  = VO_RGB_320_480;

	return 0;
}
#endif /*CONFIG_LCD_PANEL_TPO489*/

/* LCD TD043 */
#if defined (CONFIG_LCD_PANEL_TD043)
#define TD043_BKL_ON       GPIO(16)
static void td043_lcd_config_wvga()
{
  gpio_config_sw_out(TD043_BKL_ON);
  gpio_set(TD043_BKL_ON);
}

static int td043_set_vout_ctrl_wvga(lcd_dev_vout_cfg_t *vout_cfg)
{
  /* Fill the Sync Mode and Color space */
  vout_cfg->lcd_sync    = INPUT_FORMAT_601;
  vout_cfg->color_space     = CS_RGB;

  /* Fill the HVSync polarity */
  vout_cfg->hs_polarity     = ACTIVE_LO;
  vout_cfg->vs_polarity     = ACTIVE_LO;

  /* Fill the number of VD_CLK per H-Sync, number of H-Sync's per field */
  vout_cfg->ftime_hs    = 940;
  vout_cfg->ftime_vs_top    = 504;
  vout_cfg->ftime_vs_bot    = 504;

  /* HSync start and end */
  vout_cfg->hs_start    = 0;
  vout_cfg->hs_end    = 2;

  /* VSync start and end, use two dimension(x,y) to calculate */
  vout_cfg->vs_start_row_top  = 0;
  vout_cfg->vs_start_row_bot  = 0;
  vout_cfg->vs_end_row_top  = 2;
  vout_cfg->vs_end_row_bot  = 2;

  vout_cfg->vs_start_col_top  = 0;
  vout_cfg->vs_start_col_bot  = 0;
  vout_cfg->vs_end_col_top  = 0;
  vout_cfg->vs_end_col_bot  = 0;

  /* Active start and end, use two dimension(x,y) to calculate */
  vout_cfg->act_start_row_top   = 20;
  vout_cfg->act_start_row_bot   = 20;
  vout_cfg->act_end_row_top   = 499;
  vout_cfg->act_end_row_bot   = 499;

  vout_cfg->act_start_col_top   = 120;
  vout_cfg->act_start_col_bot   = 120;
  vout_cfg->act_end_col_top   = 919;
  vout_cfg->act_end_col_bot   = 919;

  /* Set default color */
  vout_cfg->bg_color    = BG_BLACK;

  /* LCD paremeters */
  vout_cfg->lcd_display     = LCD_PROG_DISPLAY;
  vout_cfg->lcd_frame_rate  = 0;

  vout_cfg->lcd_data_clk    = 0;
  vout_cfg->lcd_color_mode  = 6;
  vout_cfg->lcd_rgb_seq_top = 0;
  vout_cfg->lcd_rgb_seq_bot = 0;
  vout_cfg->lcd_hscan   = 0;

  vout_cfg->osd_width   = 800;
  vout_cfg->osd_height    = 480;
  vout_cfg->osd_resolution  = VO_RGB_800_480;

  return 0;
}
#endif /*CONFIG_LCD_PANEL_TD043*/

/* LCD 1P3828 */
#if defined (CONFIG_LCD_PANEL_1P3828)
#define TRULY_1P3828_SPI_INST      (0)
#define TRULY_1P3828_SPI_ID        (1)
#define TRULY_1P3828_SPI_MODE      (0)
#define TRULY_1P3828_SPI_BITS      (8)
#define TRULY_1P3828_SPI_SPEED     (500000)
#define TRULY_1P3828_BKL_ON        GPIO(16)

static u16 truly_1p3828_cmd[] = { 0x00B9, //Set_EXTC
                                  0x01FF,
                                  0x0183,
                                  0x0169,
                                  0x00B1, //Set Power
                                  0x0101,
                                  0x0100,
                                  0x0134,
                                  0x0106,
                                  0x0100,
                                  0x010F,
                                  0x010F,
                                  0x012A,
                                  0x0132,
                                  0x013F,
                                  0x013F,
                                  0x0107,
                                  0x0123,
                                  0x0101,
                                  0x01E6,
                                  0x01E6,
                                  0x01E6,
                                  0x01E6,
                                  0x01E6,
                                  0x00B2, // SET Display  480x800
                                  0x0100,
                                  0x012b,
                                  0x010A,
                                  0x010A,
                                  0x0170,
                                  0x0100,
                                  0x01FF,
                                  0x0100,
                                  0x0100,
                                  0x0100,
                                  0x0100,
                                  0x0103,
                                  0x0103,
                                  0x0100,
                                  0x0101,
                                  0x00B4, // SET Display  480x800
                                  0x0100,
                                  0x0118,
                                  0x0180,
                                  0x0110,
                                  0x0101,
                                  0x00B6, // SET VCOM
                                  0x012C,
                                  0x012C,
                                  0x00D5, //SET GIP
                                  0x0100,
                                  0x0105,
                                  0x0103,
                                  0x0100,
                                  0x0101,
                                  0x0109,
                                  0x0110,
                                  0x0180,
                                  0x0137,
                                  0x0137,
                                  0x0120,
                                  0x0131,
                                  0x0146,
                                  0x018A,
                                  0x0157,
                                  0x019B,
                                  0x0120,
                                  0x0131,
                                  0x0146,
                                  0x018A,
                                  0x0157,
                                  0x019B,
                                  0x0107,
                                  0x010F,
                                  0x0102,
                                  0x0100,
                                  0x00E0, //SET GAMMA
                                  0x0100,
                                  0x0108,
                                  0x010D,
                                  0x012D,
                                  0x0134,
                                  0x013F,
                                  0x0119,
                                  0x0138,
                                  0x0109,
                                  0x010E,
                                  0x010E,
                                  0x0112,
                                  0x0114,
                                  0x0112,
                                  0x0114,
                                  0x0113,
                                  0x0119,
                                  0x0100,
                                  0x0108,
                                  0x010D,
                                  0x012D,
                                  0x0134,
                                  0x013F,
                                  0x0119,
                                  0x0138,
                                  0x0109,
                                  0x010E,
                                  0x010E,
                                  0x0112,
                                  0x0114,
                                  0x0112,
                                  0x0114,
                                  0x0113,
                                  0x0119,
                                  0x00C1, //set DGC
                                  0x0101, //enable DGC function
                                  0x0102, //SET R-GAMMA
                                  0x0108,
                                  0x0112,
                                  0x011A,
                                  0x0122,
                                  0x012A,
                                  0x0131,
                                  0x0136,
                                  0x013F,
                                  0x0148,
                                  0x0151,
                                  0x0158,
                                  0x0160,
                                  0x0168,
                                  0x0170,
                                  0x0178,
                                  0x0180,
                                  0x0188,
                                  0x0190,
                                  0x0198,
                                  0x01A0,
                                  0x01A7,
                                  0x01AF,
                                  0x01B6,
                                  0x01BE,
                                  0x01C7,
                                  0x01CE,
                                  0x01D6,
                                  0x01DE,
                                  0x01E6,
                                  0x01EF,
                                  0x01F5,
                                  0x01FB,
                                  0x01FC,
                                  0x01FE,
                                  0x018C,
                                  0x01A4,
                                  0x0119,
                                  0x01EC,
                                  0x011B,
                                  0x014C,
                                  0x0140,
                                  0x0102, //SET G-Gamma
                                  0x0108,
                                  0x0112,
                                  0x011A,
                                  0x0122,
                                  0x012A,
                                  0x0131,
                                  0x0136,
                                  0x013F,
                                  0x0148,
                                  0x0151,
                                  0x0158,
                                  0x0160,
                                  0x0168,
                                  0x0170,
                                  0x0178,
                                  0x0180,
                                  0x0188,
                                  0x0190,
                                  0x0198,
                                  0x01A0,
                                  0x01A7,
                                  0x01AF,
                                  0x01B6,
                                  0x01BE,
                                  0x01C7,
                                  0x01CE,
                                  0x01D6,
                                  0x01DE,
                                  0x01E6,
                                  0x01EF,
                                  0x01F5,
                                  0x01FB,
                                  0x01FC,
                                  0x01FE,
                                  0x018C,
                                  0x01A4,
                                  0x0119,
                                  0x01EC,
                                  0x011B,
                                  0x014C,
                                  0x0140,
                                  0x0102, //SET B-Gamma
                                  0x0108,
                                  0x0112,
                                  0x011A,
                                  0x0122,
                                  0x012A,
                                  0x0131,
                                  0x0136,
                                  0x013F,
                                  0x0148,
                                  0x0151,
                                  0x0158,
                                  0x0160,
                                  0x0168,
                                  0x0170,
                                  0x0178,
                                  0x0180,
                                  0x0188,
                                  0x0190,
                                  0x0198,
                                  0x01A0,
                                  0x01A7,
                                  0x01AF,
                                  0x01B6,
                                  0x01BE,
                                  0x01C7,
                                  0x01CE,
                                  0x01D6,
                                  0x01DE,
                                  0x01E6,
                                  0x01EF,
                                  0x01F5,
                                  0x01FB,
                                  0x01FC,
                                  0x01FE,
                                  0x018C,
                                  0x01A4,
                                  0x0119,
                                  0x01EC,
                                  0x011B,
                                  0x014C,
                                  0x0140,
                                  0x002D, //Look up table
                                  };
static int truly_1p3828set_vout_ctrl_480x800(lcd_dev_vout_cfg_t *vout_cfg)
{
  /* Fill the Sync Mode and Color space */
  vout_cfg->lcd_sync        = INPUT_FORMAT_601;
  vout_cfg->color_space     = CS_RGB;

  /* Fill the HVSync polarity */
  vout_cfg->hs_polarity     = ACTIVE_LO;
  vout_cfg->vs_polarity     = ACTIVE_LO;

  /* Fill the number of VD_CLK per H-Sync, number of H-Sync's per field */
  vout_cfg->ftime_hs        = 500;
  vout_cfg->ftime_vs_top    = 860;
  vout_cfg->ftime_vs_bot    = 860;

  /* HSync start and end */
  vout_cfg->hs_start  = 0;
  vout_cfg->hs_end    = 2;

  /* VSync start and end, use two dimension(x,y) to calculate */
  vout_cfg->vs_start_row_top  = 0;
  vout_cfg->vs_start_row_bot  = 0;
  vout_cfg->vs_end_row_top    = 2;
  vout_cfg->vs_end_row_bot    = 2;

  vout_cfg->vs_start_col_top  = 0;
  vout_cfg->vs_start_col_bot  = 0;
  vout_cfg->vs_end_col_top    = 0;
  vout_cfg->vs_end_col_bot    = 0;

  /* Active start and end, use two dimension(x,y) to calculate */
  vout_cfg->act_start_row_top = 12;
  vout_cfg->act_start_row_bot = 12;
  vout_cfg->act_end_row_top   = 811;
  vout_cfg->act_end_row_bot   = 811;

  vout_cfg->act_start_col_top = 5;
  vout_cfg->act_start_col_bot = 5;
  vout_cfg->act_end_col_top   = 484;
  vout_cfg->act_end_col_bot   = 484;

  /* Set default color */
  vout_cfg->bg_color          = BG_BLACK;

  /* LCD paremeters */
  vout_cfg->lcd_display     = LCD_PROG_DISPLAY;
  vout_cfg->lcd_frame_rate  = 0;

  vout_cfg->lcd_data_clk    = 0;
  vout_cfg->lcd_color_mode  = 6;
  vout_cfg->lcd_rgb_seq_top = 0;
  vout_cfg->lcd_rgb_seq_bot = 0;
  vout_cfg->lcd_hscan       = 0;

  vout_cfg->osd_width       = 480;
  vout_cfg->osd_height      = 800;
  vout_cfg->osd_resolution  = VO_RGB_480_800;

  return 0;
}

static void truly_1p3828lcd_config_480x800(void)
{
  int i    = 0;
  u16 data = 0;

  timer_init();
  spi_init();

  gpio_config_sw_out(TRULY_1P3828_BKL_ON);
  gpio_set(TRULY_1P3828_BKL_ON);

  spi_config(TRULY_1P3828_SPI_ID,
             TRULY_1P3828_SPI_MODE,
             TRULY_1P3828_SPI_BITS,
             TRULY_1P3828_SPI_SPEED);

  spi_write(TRULY_1P3828_SPI_ID,
            truly_1p3828_cmd,
            (sizeof(truly_1p3828_cmd) / sizeof(u16)));

  for(i = 0; i < 64; ++ i) {
    data = ((8*i) & 0xffff) | 0x0100;
    spi_write(TRULY_1P3828_SPI_ID, &data, 1);
  }
  for(i = 0; i < 64; ++ i) {
    data = ((4*i) & 0xffff) | 0x0100;
    spi_write(TRULY_1P3828_SPI_ID, &data, 1);
  }
  for(i = 0; i < 64; ++ i) {
    data = ((8*i) & 0xffff) | 0x0100;
    spi_write(TRULY_1P3828_SPI_ID, &data, 1);
  }

  data = 0x003A; //Set Color Mode
  spi_write(TRULY_1P3828_SPI_ID, &data, 1);
  data = 0x0177; //RGB888
  spi_write(TRULY_1P3828_SPI_ID, &data, 1);
  data = 0x0011; //Sleep Out
  spi_write(TRULY_1P3828_SPI_ID, &data, 1);
  timer_dly_ms(TIMER2_ID, 120);   //Sleep 120ms
  data = 0x0029; //Display On
  spi_write(TRULY_1P3828_SPI_ID, &data, 1);

  return;
}
#endif /*CONFIG_LCD_PANEL_1P3828*/

#endif /*SHOW_AMBOOT_SPLASH*/

int amboot_bsp_entry(void)
{
	flpart_table_t ptb;
	int rval = 0;

	/* Read the partition table */
	rval = flprog_get_part_table(&ptb);
	if (rval < 0) {
	  return rval;
	}

	/* BIOS boot */
	if (ptb.dev.rsv[0] > 0) {
		putstr("Find BIOS boot flag\r\n");
		rval = ptb.dev.rsv[0];
	}

#if defined(SHOW_AMBOOT_SPLASH)
	{
		lcd_dev_vout_cfg_t cfg = {0};
		int chan = 0;
		amb_set_lcd_clock_source(HAL_BASE_VP,
		                         AMB_PLL_REFERENCE_CLOCK_SOURCE_CLK_REF, 0);

#if defined(CONFIG_LCD_PANEL_1P3828)
		amb_set_lcd_clock_frequency(HAL_BASE_VP, 25800000);
#elif defined(CONFIG_LCD_PANEL_TD043)
		amb_set_lcd_clock_frequency(HAL_BASE_VP, 28397174);
#elif defined(CONFIG_LCD_PANEL_TPO489)
		amb_set_lcd_clock_frequency(HAL_BASE_VP, 17982018);
#endif

#if defined(CONFIG_LCD_PANEL_TPO489)
		/* Setup hvga lcd_dev_vout_cfg_t */
		tpo489_set_vout_ctrl_hvga(&cfg);
#elif defined(CONFIG_LCD_PANEL_TD043)
		/* Setup wvga Lcd_dev_vout_cfg_t */
		td043_set_vout_ctrl_wvga(&cfg);
#elif defined(CONFIG_LCD_PANEL_1P3828)
		truly_1p3828set_vout_ctrl_480x800(&cfg);
#endif
		/* DSP vout init */
		dsp_vout_init();
		/* Setup vout */
		vout_config(chan, &cfg);
		/* DSP vout set */
		dsp_vout_set(chan, cfg.osd_resolution);
#if defined(CONFIG_LCD_PANEL_TPO489)
		/* Initialize LCD panel */
		tpo489_lcd_config_hvga();
		setup_extra_cmdline("video=amb0fb:320x480,320x960,2,0");
#elif defined(CONFIG_LCD_PANEL_TD043)
		td043_lcd_config_wvga();
		setup_extra_cmdline("video=amb0fb:800x480,800x960,2,0");
#elif defined(CONFIG_LCD_PANEL_1P3828)
		truly_1p3828lcd_config_480x800();
		setup_extra_cmdline("video=amb0fb:480x800,480x1600,2,0");
#endif
		setup_extra_cmdline("video=amb1fb:720x480,720x480,1,0");
		setup_extra_cmdline("boot_splash_logo_on");
		setup_extra_cmdline("skip_lcd_qp3831_init");
	}
#else
	setup_extra_cmdline("video=amb0fb:720x480,720x480,1,0");
#endif  /* SHOW_AMBOOT_SPLASH */

	return rval;
}

