/**
 * system/src/bld/hal.c
 *
 * History:
 *    2008/11/18 - [Charles Chiou] created file
 *
 * Copyright (C) 2004-2008, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <asm/types.h>
#include <asm/io.h>
#include <exports.h>

#include <config.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/basedef.h>
#include <asm/arch/ambhw/eth.h>
#include <asm/arch/netdev/tftp.h>
#include <asm/arch/bldnet.h> 

#include <asm/arch/bldfunc.h>
#include <asm/arch/ambhw.h>
#define __FLDRV_IMPL__
#include <asm/arch/fio/firmfl.h>
#include <asm/arch/fio/firmfl_api.h>
#include <asm/arch/hal/hal.h>

#if defined(USE_HAL)
#include "bst_ver.h"
#endif

#define HAL_SIZE (59144)

extern u32  __pagetable_end;
extern u32 __pagetable_main;
extern u32 __pagetable_hal; 
extern int a5s_nand_read_byte(u8 * dst, u32 from, int len);

int hal_init(void)
{
	int rval = 0;
#if defined(USE_HAL)
	amb_hal_header_t *header;

	/* Make sure page table does not overlap with HAL. */
	//printf("%p,%08x\n",&__pagetable_end,HAL_BASE_PHYS);
	K_ASSERT(!((u32)(&__pagetable_end) < HAL_BASE_PHYS)); 

	a5s_nand_read_byte((u8 *)HAL_BASE_PHYS, HAL_NAND_OFFSET, 64*1024);
	
#ifdef AMBARELLA_HAL_REMAP
    {
		/* Remap MMU to point the pages in HAL_BASE_VIRT to */
		/* the physical address */
		u32 pgtbl, base, x, size, val;

		if ((HAL_BASE_VIRT & 0x000fffff) != 0x0) {
			putstr("HAL_BASE_VIRT is not 1MB aligned!\r\n");
			K_ASSERT(0);
		}

		/* Disable the MMU */
		__asm__ __volatile__ ("mrc p15, 0, %0, c1, c0, 0" : "=r " (x));
		x &= ~(0x1);
		__asm__ __volatile__ ("mcr p15, 0, %0, c1, c0, 0": : "r" (x));

		pgtbl = (u32) &__pagetable_main;

		/* Setup HAL_BASE_VIRT to point to a corse page table */
		base = HAL_BASE_VIRT >> 20;
		x = (u32) &__pagetable_hal;
#if defined(__ARM926EJS__)
		x |= 0x11;		/* ARM926EJS */
#endif
#if defined(__ARM1136JS__)
		x |= 0x01;		/* ARM1136JS */
#endif
		writel(x, pgtbl + (base  * 4));

		/* Now setup the 2nd-level pagetable for HAL */
		base = (u32) &__pagetable_hal;
		size = HAL_SIZE;
		val = HAL_BASE_PHYS;
		for (x = 0; x < 256; x++) {
			val &= 0xfffff000;
			if ((x * 4096) <= (size + 4096)) {
				val |= 0xffe;
			}
			writel(val, base + x * 4);
			val += 0x1000;
		}
       
		/* Flush the TLB and re-enable the MMU */
		x = 0x0;
		__asm__ __volatile__ ("mcr p15, 0, %0, c8, c6, 0": : "r" (x));
		__asm__ __volatile__ ("mrc p15, 0, %0, c1, c0, 0" : "=r " (x));
		x |= 0x1;
		__asm__ __volatile__ ("mcr p15, 0, %0, c1, c0, 0": : "r" (x));
		
    }
#endif
	header = (amb_hal_header_t *) HAL_BASE_VIRT;
	if (rval == 0 || (strcmp(header->magic, "Ambarella") == 0)) {
		/* Setup base pointer */
		g_haladdr = HAL_BASE_VIRT;

		/* Hack: write HAL size into the header offset 0xc */
		writel(HAL_SIZE, g_haladdr + 0xc);
#if defined(USE_HAL)
		/* Hack: write BST version into the header offset 0xc + img_len */
		writel(BST_VER, g_haladdr + HAL_SIZE);
#endif
#if (PHY_BUS_MAP_TYPE == 1)
	/* Call the first setup function */
	amb_hal_init((void *)g_haladdr,(void *)APB_BASE, \
	                    (void *)AHB_BASE, (void *)DRAM_VIRT_BASE);
#else
       
		/* Call the first setup function */
		rval = amb_hal_init((void *)g_haladdr,(void *)APB_BASE, (void *)AHB_BASE);
#endif
	} else {
		printf("HAL is not present in system!\r\n");
		K_ASSERT(0);
	}
#endif
    return rval;
}

int hal_call_name(int argc, char **argv)
{
	u32 fid;
	u32 arg0 = 0, arg1 = 0, arg2 = 0, arg3 = 0;
	amb_hal_function_info_t *finfo;

	if (argc <= 0)
		return -1;

	finfo = (amb_hal_function_info_t *) (g_haladdr + 128);

	if ((fid = simple_strtoul(argv[0], 0, 10)) < 0) {
		for (fid = 0; ; fid++) {
			if (finfo[fid].function == NULL)
				return -1;
			if (strcmp(argv[0],
				   (char *) (g_haladdr + (u32) finfo[fid].name))
			    == 0)
				break;
		}
	}

	if (argc >= 3)
		arg0 = simple_strtoul(argv[2], 0, 10);
	if (argc >= 4)
		arg1 = simple_strtoul(argv[3], 0, 10);
	if (argc >= 5)
		arg2 = simple_strtoul(argv[4], 0, 10);
	if (argc >= 6)
		arg3 = simple_strtoul(argv[5], 0, 10);


	return hal_call_fid(fid, arg0, arg1, arg2, arg3);
}

int hal_call_fid(u32 fid, u32 arg0, u32 arg1, u32 arg2, u32 arg3)
{
	amb_hal_function_info_t *finfo;
	int (*f)(u32, u32, u32, u32);

	if (g_haladdr < 0)
		return -1;

	finfo = (amb_hal_function_info_t *) (g_haladdr + 128);
	f = (int (*) (u32, u32, u32, u32))
		(g_haladdr + (u32) finfo[fid].function);

	return f(arg0, arg1, arg2, arg3);
}

void set_dram_arbitration(void)
{
#if !defined(USE_HAL)

#if (DRAM_ARB_SUPPORT_THROTTLE_DL == 0)
#ifndef DRAM_ARB_CFG_VAL
#define DRAM_ARB_CFG_VAL	0x0bb80000
#endif
	writel(DRAM_ARB_CFG_REG, DRAM_ARB_CFG_VAL);
#endif

#if (DRAM_ARB_SUPPORT_THROTTLE_DL == 1)
#ifdef DRAM_ARB_THROTTLE_DL_VAL
	writel(DRAM_ARB_THROTTLE_DL_REG, DRAM_ARB_THROTTLE_DL_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_0_VAL
	writel(DRAM_ARB_SMM_TRANS_0, DRAM_ARB_SMM_TRANS_0_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_1_VAL
	writel(DRAM_ARB_SMM_TRANS_1, DRAM_ARB_SMM_TRANS_1_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_2_VAL
	writel(DRAM_ARB_SMM_TRANS_2, DRAM_ARB_SMM_TRANS_2_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_3_VAL
	writel(DRAM_ARB_SMM_TRANS_3, DRAM_ARB_SMM_TRANS_3_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_4_VAL
	writel(DRAM_ARB_SMM_TRANS_4, DRAM_ARB_SMM_TRANS_4_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_5_VAL
	writel(DRAM_ARB_SMM_TRANS_5, DRAM_ARB_SMM_TRANS_5_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_6_VAL
	writel(DRAM_ARB_SMM_TRANS_6, DRAM_ARB_SMM_TRANS_6_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_7_VAL
	writel(DRAM_ARB_SMM_TRANS_7, DRAM_ARB_SMM_TRANS_7_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_8_VAL
	writel(DRAM_ARB_SMM_TRANS_8, DRAM_ARB_SMM_TRANS_8_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_9_VAL
	writel(DRAM_ARB_SMM_TRANS_9, DRAM_ARB_SMM_TRANS_9_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_10_VAL
	writel(DRAM_ARB_SMM_TRANS_10, DRAM_ARB_SMM_TRANS_10_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_11_VAL
	writel(DRAM_ARB_SMM_TRANS_11, DRAM_ARB_SMM_TRANS_11_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_12_VAL
	writel(DRAM_ARB_SMM_TRANS_12, DRAM_ARB_SMM_TRANS_12_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_13_VAL
	writel(DRAM_ARB_SMM_TRANS_13, DRAM_ARB_SMM_TRANS_13_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_14_VAL
	writel(DRAM_ARB_SMM_TRANS_14, DRAM_ARB_SMM_TRANS_14_VAL);
#endif
#ifdef DRAM_ARB_SMM_TRANS_15_VAL
	writel(DRAM_ARB_SMM_TRANS_15, DRAM_ARB_SMM_TRANS_15_VAL);
#endif
#endif

#endif

#ifdef DRAMARB_PRIORITY_VAL
	amb_set_dram_arbiter_priority(HAL_BASE_VP, DRAMARB_PRIORITY_VAL);
#endif

#if (CHIP_REV == I1)
	writel((DRAM_VIRT_BASE + 0x24), 0x1);
#if !defined(BOARD_DISABLE_ETH)
#if defined(BOARD_USE_INTERNAL_GTX)
	amb_set_gtx_clock_source(HAL_BASE_VP, AMB_GTX_CLOCK_SOURCE_GTX_PLL);
#else
	amb_set_gtx_clock_source(HAL_BASE_VP,
		AMB_GTX_CLOCK_SOURCE_ENET_GTX_CLK);
#endif
#if defined(BOARD_USE_MII_PHY)
	amb_set_gtx_clock_frequency(HAL_BASE_VP, 25000000);
#else
	amb_set_gtx_clock_frequency(HAL_BASE_VP, 125000000);
#endif
#endif
#endif
}

