/*
 * (C) Copyright 2004 Texas Insturments
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Gary Jennejohn, DENX Software Engineering, <garyj@denx.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * CPU specific code
 */

#include <common.h>
#include <command.h>
#include <asm/system.h>

static void cache_flush(void);
static void disable_mmu(void);
static void enter_svc(void);

int cleanup_before_linux (void)
{
	/*
	 * this function is called just before we call linux
	 * it prepares the processor for linux
	 *
	 * we turn off caches etc ...
	 */

    disable_interrupts ();

    cache_flush();/* flush I/D-cache */
    icache_disable();/* turn off I-cache */
    dcache_disable();/* turn off D-cache */
    disable_mmu();
    enter_svc();
    return 0;
}

static void enter_svc(void)
{
    unsigned long reg = 0;
    
    asm ("mrs %0, cpsr": :"r" (reg));         /* read-modify-write to get to SVC mode*/
    asm ("bic %0, %0, #0x1f": :"r" (reg));    /* clear current mode*/
    asm ("orr %0, %0, #0x13": :"r" (reg));    /* set supervisor mode*/
    asm ("msr cpsr, %0": :"r" (reg));         /* now we should be in supervisor mode*/ 
}

static void disable_mmu(void)
{
    unsigned long reg = 0;
    
    asm ("mrc p15, 0, %0, c1, c0, 0": :"r" (reg));/*Read control register*/
    asm ("orr %0, %0, #(1<<12)": :"r" (reg));     /* Turn on bit 12*/
    asm ("bic %0, %0, #(1<<0)": :"r" (reg));      /* Turn off bit 0*/
    asm ("bic %0, %0, #(1<<13)": :"r" (reg));     /* Turn off bit 13*/
    asm ("mcr p15, 0, %0, c1, c0, 0": :"r" (reg));/* Write control register*/
}

static void cache_flush(void)
{
	unsigned long i = 0;

	asm ("mcr p15, 0, %0, c7, c10, 0": :"r" (i)); /* clean entire data cache */
	asm ("mcr p15, 0, %0, c7, c7, 0": :"r" (i));  /* invalidate both caches and flush btb */
	asm ("mcr p15, 0, %0, c7, c10, 4": :"r" (i)); /* mem barrier to sync things */
}
