#ifndef _AMBHALMINI_H_INCLUDED_
#define _AMBHALMINI_H_INCLUDED_

#include "ambhal.h"

typedef union {
  struct  __attribute__((packed)) {
    unsigned int write_enable : 1 ;
    unsigned int enable_fastlock : 1 ;
    unsigned int bypass : 1 ;
    unsigned int fractional_mode : 1 ;
    unsigned int force_pll_reset : 1 ;
    unsigned int powerdown : 1 ;
    unsigned int half_vco : 1 ;
    unsigned int tristate_loop_filter : 1 ;
    unsigned int pll_tout_async : 4 ;
    unsigned int sdiv : 4 ;
    unsigned int sout : 4 ;
    unsigned int force_pll_lock : 1 ;
    unsigned int force_pll_bypass : 1 ;
    unsigned int : 2 ;
    unsigned int intprog : 7 ;
    unsigned int : 1 ;
  } ;
  unsigned int val ;
} amb_pll_ctrl_reg_t ;

amb_hal_success_t amb_mini_set_sd_clock_frequency (amb_clock_frequency_t amb_clock_frequency) ;

amb_clock_frequency_t amb_mini_get_sd_clock_frequency (void) ;

amb_hal_success_t amb_mini_set_uart_clock_frequency (amb_clock_frequency_t amb_clock_frequency) ;

amb_clock_frequency_t amb_mini_get_uart_clock_frequency (void) ;

amb_hal_success_t amb_mini_set_ssi_clock_frequency (amb_clock_frequency_t amb_clock_frequency) ;

amb_clock_frequency_t amb_mini_get_ssi_clock_frequency (void) ;

amb_hal_success_t amb_mini_set_ssi2_clock_frequency (amb_clock_frequency_t amb_clock_frequency) ;

amb_clock_frequency_t amb_mini_get_ssi2_clock_frequency (void) ;

amb_clock_frequency_t amb_mini_get_core_clock_frequency (void) ;

amb_hal_success_t amb_mini_reset_all (void) ;

amb_boot_type_t amb_mini_get_boot_type (void) ;

amb_system_configuration_t amb_mini_get_system_configuration (void) ;

amb_hal_success_t amb_set_low_power_operating_mode_func (void) ;

void amb_mini_fix_spiboot (amb_dram_parameters_t* amb_dram_parameters) ;

#endif // ifndef _AMBHALMINI_H_INCLUDED_

