#ifndef __AMBA_USB_H__
#define __AMBA_USB_H__

/* IRQ functions */
extern void enable_interrupts(void);
extern int disable_interrupts(void);
extern void vic_init(void);
#define VIRQ_RISING_EDGE	0
#define VIRQ_FALLING_EDGE	1
#define VIRQ_BOTH_EDGES		2
#define VIRQ_LEVEL_LOW		3
#define VIRQ_LEVEL_HIGH		4
extern void vic_set_type(u32 line, u32 type);
extern void vic_enable(u32 line);
extern void vic_disable(u32 line);
extern void vic_ackint(u32 line);
extern void vic_sw_set(u32 line);
extern void vic_sw_clr(u32 line);

extern void rct_usb_reset(void);
extern void rct_enable_usb(void);
extern void rct_suspend_usb(void);
extern void rct_x_usb_clksrc(void);
extern void rct_usb_reset(void);
extern void fio_exit_random_mode(void);
extern void enable_fio_dma(void);
extern void clock_source_select(int src);

/* Timer functions */
#define TIMER1_ID	1
#define TIMER2_ID	2
#define TIMER3_ID	3
extern int timer_init(void);
extern void timer_reset_count(int tmr_id);
extern u32  timer_get_count(int tmr_id);
extern void timer_enable(int tmr_id);
extern void timer_disable(int tmr_id);
extern u32 timer_get_tick(int tmr_id);
extern u32 timer_tick2ms(u32 s_tck, u32 e_tck);
extern void timer_dly_ms(int tmr_id, u32 dly_tim);
extern void setup_pagetbl(void);

extern void enable_mmu(void);
extern void disable_mmu(void);
extern void _enable_icache(void);
extern void _disable_icache(void);
extern void _enable_dcache(void);
extern void _disable_dcache(void);
extern void _flush_i_cache(void);
extern void _flush_d_cache(void);
extern void _clean_d_cache(void);
extern void _clean_flush_d_cache(void);
extern void _clean_flush_all_cache(void);
extern void _drain_write_buffer(void);
extern void flush_all_cache_region(void *addr, unsigned int size);
extern void clean_flush_all_cache_region(void *addr, unsigned int size);
extern void flush_i_cache_region(void *addr, unsigned int size);
extern void flush_d_cache_region(void *addr, unsigned int size);
extern void clean_d_cache_region(void *addr, unsigned int size);
extern void clean_flush_d_cache_region(void *addr, unsigned int size);
extern void drain_write_buffer(u32 addr);
extern void clean_d_cache(void *addr, unsigned int size);
extern void flush_d_cache(void *addr, unsigned int size);
extern void clean_flush_d_cache(void *addr, unsigned int size);
extern int lock_i_cache_region(void *addr, unsigned int size);
extern void unlock_i_cache_ways(unsigned int ways);
extern int pli_cache_region(void *addr, unsigned int size);
extern void rct_reset_chip(void);



/* USB functions */
extern u32  usb_download(void *addr, int exec, int flag);
extern int  check_connected(void);
extern void usb_boot(u8 usbdl_mode);
/* Flags used by usb_boot() */
#define USB_DL_NORMAL		0x01
#define USB_DL_DIRECT_USB	0x02
#define USB_MODE_DEFAULT	USB_DL_DIRECT_USB
/* Flags used by usb_download() */
#define USB_FLAG_FW_PROG	0x0001
#define USB_FLAG_KERNEL		0x0002
#define USB_FLAG_MEMORY		0x0004
#define USB_FLAG_UPLOAD		0x0010
#define USB_FLAG_TEST_DOWNLOAD	0x0100
#define USB_FLAG_TEST_PLL	0x0200
#define USB_FLAG_TEST_MASK	(USB_FLAG_TEST_DOWNLOAD | USB_FLAG_TEST_PLL)


/***************************************************/
/* Functions for getting/setting system properties */
/* and anything else that involves the RCT module. */
/***************************************************/
extern u32 get_apb_bus_freq_hz(void);
extern u32 get_ahb_bus_freq_hz(void);
extern u32 get_core_bus_freq_hz(void);
extern u32 get_idsp_freq_hz(void);
extern u32 get_adc_freq_hz(void);
extern u32 get_uart_freq_hz(void);
extern u32 get_ssi_freq_hz(void);
extern u32 get_ssi2_freq_hz(void);
extern u32 get_motor_freq_hz(void);
extern u32 get_ir_freq_hz(void);
extern u32 get_host_freq_hz(void);
extern u32 get_ddr_freq_hz(void);


extern void rct_set_usb_ext_clk(void);
extern void rct_set_usb_int_clk(void);
extern void rct_set_usb_debounce(void);
extern void rct_enable_usb(void);
extern int nand_load(u32 sblk, u32 nblk, u32 mem_addr, u32 img_len);

#endif
