/*
 * ambhw/hdmi.h
 *
 * History:
 *	2010/06/30 - [Allen Wang] created file for HDMI, CEC and HDCP
 *
 * Copyright (C) 2006-2010, Ambarella, Inc.
 */

#ifndef __AMBHW_HDMI_H__
#define __AMBHW_HDMI_H__

#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw/busaddr.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/
#if (CHIP_REV == A1) || (CHIP_REV == A2)
#define VOUT_SUPPORT_HDMI_CSC		0
#define VOUT_SUPPORT_ONCHIP_HDMI	0
#define VOUT_SUPPORT_ONCHIP_CEC		0
#else
#define VOUT_SUPPORT_HDMI_CSC		1
#define VOUT_SUPPORT_ONCHIP_HDMI	1
#define VOUT_SUPPORT_ONCHIP_CEC		1
#endif

#if (CHIP_REV == A5)  || (CHIP_REV == A6)  || (CHIP_REV == A5S) ||	\
    (CHIP_REV == A7)  || (CHIP_REV == I1)  || (CHIP_REV == A7L)
#define VOUT_HDCP_AKSV_FETCH		1
#else
#define VOUT_HDCP_AKSV_FETCH		0
#endif

#if (CHIP_REV == A5)  || (CHIP_REV == A6)  || (CHIP_REV == A5S) ||	\
    (CHIP_REV == A2S) || (CHIP_REV == A2M) || (CHIP_REV == A2Q) ||	\
    (CHIP_REV == A7)  || (CHIP_REV == A5L) || (CHIP_REV == I1)  ||	\
    (CHIP_REV == A7L)
#define VOUT_HDMI_SUPPORT_1P3_GAMUT	1
#define VOUT_HDMI_ONLINE_STATUS		1
#define VOUT_CEC_SUPPORT_CTL_TYPE	2
#else
#define VOUT_HDMI_SUPPORT_1P3_GAMUT	0
#define VOUT_HDMI_ONLINE_STATUS		0
#define VOUT_CEC_SUPPORT_CTL_TYPE	1
#endif

#if (CHIP_REV == A3)
#define VOUT_HDMI_REGS_OFFSET_GROUP	1
#elif (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VOUT_HDMI_REGS_OFFSET_GROUP	3
#else
 /* CHIP_REV == A5)   || (CHIP_REV == A6)  || (CHIP_REV == A5S) ||	\
    (CHIP_REV == A2S) || (CHIP_REV == A2M) || (CHIP_REV == A2Q) ||	\
    (CHIP_REV == A7)  || (CHIP_REV == A5L)  */
#define VOUT_HDMI_REGS_OFFSET_GROUP	2
#endif

#if (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VOUT_HDMI_SUPPORT_3D_FORMAT 		1
#define VOUT_HDMI_SUPPORT_4KX2K_FORMAT		1
#define VOUT_HDMI_SUPPORT_HBR_AUDIO		1
#define VOUT_HDMI_SUPPORT_AUDIO_CHANNELS	8
#define VOUT_HDMI_SUPPORT_VSIF			1
#define VOUT_HDMI_P2P_AFIFO_LEVEL_DEFINE	2
#define VOUT_HDMI_PHY_REGS_OFFSET_GROUP		2
#define VOUT_HDMI_CEC_REGS_OFFSET_GROUP		2
#define VOUT_HDMI_VUNIT_EXTEND_TO_14BITS	1
#define VOUT_HDMI_480I_576I_FORMAT_ENABLE	1
#else
#define VOUT_HDMI_SUPPORT_3D_FORMAT 		0
#define VOUT_HDMI_SUPPORT_4KX2K_FORMAT		0
#define VOUT_HDMI_SUPPORT_HBR_AUDIO		0
#define VOUT_HDMI_SUPPORT_AUDIO_CHANNELS	6
#define VOUT_HDMI_SUPPORT_VSIF			0
#define VOUT_HDMI_P2P_AFIFO_LEVEL_DEFINE	1
#define VOUT_HDMI_PHY_REGS_OFFSET_GROUP		1
#define VOUT_HDMI_CEC_REGS_OFFSET_GROUP		1
#define VOUT_HDMI_VUNIT_EXTEND_TO_14BITS	0
 /* A6 Workarond for HDMI 480i/576i */
#define VOUT_HDMI_480I_576I_FORMAT_ENABLE	0
#endif

#if (CHIP_REV == A6) || (CHIP_REV == I1)
#define VOUT_SUPPORT_ONCHIP_HDCP	1
#else
#define VOUT_SUPPORT_ONCHIP_HDCP	0
#endif

#if (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VOUT_HDCP_REGS_OFFSET_GROUP	2
#else
#define VOUT_HDCP_REGS_OFFSET_GROUP	1
#endif
/****************************************************/
/* Controller registers definitions                 */
/****************************************************/

/* ---------------------------------------------------------------------- */
#if (VOUT_SUPPORT_ONCHIP_HDMI == 1)

/*******************/
/* HDMI Controller */
/*******************/

/* Registers for System */
#define HDMI_INT_ENABLE_OFFSET		0x000
#define HDMI_INT_STS_OFFSET		0x004
#define HDMI_OP_MODE_OFFSET		0x008
#define HDMI_CLOCK_GATED_OFFSET		0x00c
#define HDMI_HDMISE_SOFT_RESET_OFFSET	0x010
#define HDMI_STS_OFFSET			0x014

/* Registers for Data Island Part */
#define HDMI_AUNIT_MCLK_OFFSET		0x100
#define HDMI_AUNIT_NCTS_CTRL_OFFSET	0x104
#define HDMI_AUNIT_N_OFFSET		0x108
#define HDMI_AUNIT_CTS_OFFSET		0x10c
#define HDMI_AUNIT_SRC_OFFSET		0x110
#define HDMI_AUNIT_CS0_OFFSET		0x114
#define HDMI_AUNIT_CS1_OFFSET		0x118
#define HDMI_AUNIT_CS2_OFFSET		0x11c
#define HDMI_AUNIT_CS3_OFFSET		0x120
#define HDMI_AUNIT_CS4_OFFSET		0x124
#define HDMI_AUNIT_CS5_OFFSET		0x128
#define HDMI_AUNIT_LAYOUT_OFFSET	0x12c
#define HDMI_PACKET_TX_CTRL_OFFSET	0x130
#define HDMI_PACKET_GENERAL_CTRL_OFFSET	0x134
#define HDMI_PACKET_ACP0_OFFSET		0x138
#define HDMI_PACKET_ACP1_OFFSET		0x13c
#define HDMI_PACKET_ACP2_OFFSET		0x140
#define HDMI_PACKET_ACP3_OFFSET		0x144
#define HDMI_PACKET_ACP4_OFFSET		0x148
#define HDMI_PACKET_ACP5_OFFSET		0x14c
#define HDMI_PACKET_ACP6_OFFSET		0x150
#define HDMI_PACKET_ACP7_OFFSET		0x154
#define HDMI_PACKET_ACP8_OFFSET		0x158
#define HDMI_PACKET_ISRC1_0_OFFSET	0x15c
#define HDMI_PACKET_ISRC1_1_OFFSET	0x160
#define HDMI_PACKET_ISRC1_2_OFFSET	0x164
#define HDMI_PACKET_ISRC1_3_OFFSET	0x168
#define HDMI_PACKET_ISRC1_4_OFFSET	0x16c
#define HDMI_PACKET_ISRC1_5_OFFSET	0x170
#define HDMI_PACKET_ISRC1_6_OFFSET	0x174
#define HDMI_PACKET_ISRC1_7_OFFSET	0x178
#define HDMI_PACKET_ISRC1_8_OFFSET	0x17c
#define HDMI_PACKET_ISRC2_0_OFFSET	0x180
#define HDMI_PACKET_ISRC2_1_OFFSET	0x184
#define HDMI_PACKET_ISRC2_2_OFFSET	0x188
#define HDMI_PACKET_ISRC2_3_OFFSET	0x18c
#define HDMI_PACKET_ISRC2_4_OFFSET	0x190
#define HDMI_PACKET_ISRC2_5_OFFSET	0x194
#define HDMI_PACKET_ISRC2_6_OFFSET	0x198
#define HDMI_PACKET_ISRC2_7_OFFSET	0x19c
#define HDMI_PACKET_ISRC2_8_OFFSET	0x1a0
#define HDMI_PACKET_AVI0_OFFSET		0x1a4
#define HDMI_PACKET_AVI1_OFFSET		0x1a8
#define HDMI_PACKET_AVI2_OFFSET		0x1ac
#define HDMI_PACKET_AVI3_OFFSET		0x1b0
#define HDMI_PACKET_AVI4_OFFSET		0x1b4
#define HDMI_PACKET_AVI5_OFFSET		0x1b8
#define HDMI_PACKET_AVI6_OFFSET		0x1bc
#define HDMI_PACKET_AVI7_OFFSET		0x1c0
#define HDMI_PACKET_AVI8_OFFSET		0x1c4
#define HDMI_PACKET_SPD0_OFFSET		0x1c8
#define HDMI_PACKET_SPD1_OFFSET		0x1cc
#define HDMI_PACKET_SPD2_OFFSET		0x1d0
#define HDMI_PACKET_SPD3_OFFSET		0x1d4
#define HDMI_PACKET_SPD4_OFFSET		0x1d8
#define HDMI_PACKET_SPD5_OFFSET		0x1dc
#define HDMI_PACKET_SPD6_OFFSET		0x1e0
#define HDMI_PACKET_SPD7_OFFSET		0x1e4
#define HDMI_PACKET_SPD8_OFFSET		0x1e8
#define HDMI_PACKET_AUDIO0_OFFSET	0x1ec
#define HDMI_PACKET_AUDIO1_OFFSET	0x1f0
#define HDMI_PACKET_AUDIO2_OFFSET	0x1f4
#define HDMI_PACKET_AUDIO3_OFFSET	0x1f8
#define HDMI_PACKET_AUDIO4_OFFSET	0x1fc
#define HDMI_PACKET_AUDIO5_OFFSET	0x200
#define HDMI_PACKET_AUDIO6_OFFSET	0x204
#define HDMI_PACKET_AUDIO7_OFFSET	0x208
#define HDMI_PACKET_AUDIO8_OFFSET	0x20c
#define HDMI_PACKET_MPEG0_OFFSET	0x210
#define HDMI_PACKET_MPEG1_OFFSET	0x214
#define HDMI_PACKET_MPEG2_OFFSET	0x218
#define HDMI_PACKET_MPEG3_OFFSET	0x21c
#define HDMI_PACKET_MPEG4_OFFSET	0x220
#define HDMI_PACKET_MPEG5_OFFSET	0x224
#define HDMI_PACKET_MPEG6_OFFSET	0x228
#define HDMI_PACKET_MPEG7_OFFSET	0x22c
#define HDMI_PACKET_MPEG8_OFFSET	0x230

#if (VOUT_HDMI_REGS_OFFSET_GROUP == 1)

/* Registers for I2S */
#define HDMI_I2S_MODE_OFFSET		0x234
#define HDMI_I2S_RX_CTRL_OFFSET		0x238
#define HDMI_I2S_WLEN_OFFSET		0x23c
#define HDMI_I2S_WPOS_OFFSET		0x240
#define HDMI_I2S_SLOT_OFFSET		0x244
#define HDMI_I2S_RX_FIFO_GTH_OFFSET	0x248
#define HDMI_I2S_RX_CLOCK_OFFSET	0x24c
#define HDMI_I2S_INIT_OFFSET		0x250
#define HDMI_I2S_RX_DATA0_OFFSET	0x254
#define HDMI_I2S_RX_DATA1_OFFSET	0x258
#define HDMI_I2S_RX_DATA2_OFFSET	0x25c
#define HDMI_I2S_FIFO_CNTR_OFFSET	0x260
#define HDMI_I2S_GATE_OFF_OFFSET	0x264
#define HDMI_PACKET_MISC_OFFSET		0x268

/* Registers for Video Part */
#define HDMI_VUNIT_VBLANK_OFFSET	0x280
#define HDMI_VUNIT_HBLANK_OFFSET	0x284
#define HDMI_VUNIT_VACTIVE_OFFSET	0x288
#define HDMI_VUNIT_HACTIVE_OFFSET	0x28c
#define HDMI_VUNIT_CTRL_OFFSET		0x290
#define HDMI_VUNIT_VSYNC_DETECT_OFFSET	0x294

/* Registers for HDMISE Test Mode Part */
#define HDMI_HDMISE_TM_OFFSET		0x298

/* Registers for TMDS Asynchronous FIFO Part */
#define HDMI_P2P_AFIFO_LEVEL_OFFSET	0x29c
#define HDMI_P2P_AFIFO_CTRL_OFFSET	0x2a0

#elif (VOUT_HDMI_REGS_OFFSET_GROUP == 3)

/* Registers for Data Island Part */
#define HDMI_PACKET_GAMUT0_OFFSET	0x234
#define HDMI_PACKET_GAMUT1_OFFSET	0x238
#define HDMI_PACKET_GAMUT2_OFFSET	0x23c
#define HDMI_PACKET_GAMUT3_OFFSET	0x240
#define HDMI_PACKET_GAMUT4_OFFSET	0x244
#define HDMI_PACKET_GAMUT5_OFFSET	0x248
#define HDMI_PACKET_GAMUT6_OFFSET	0x24c
#define HDMI_PACKET_GAMUT7_OFFSET	0x250
#define HDMI_PACKET_GAMUT8_OFFSET	0x254
#define HDMI_PACKET_VS0_OFFSET		0x258
#define HDMI_PACKET_VS1_OFFSET		0x25c
#define HDMI_PACKET_VS2_OFFSET		0x260
#define HDMI_PACKET_VS3_OFFSET		0x264
#define HDMI_PACKET_VS4_OFFSET		0x268
#define HDMI_PACKET_VS5_OFFSET		0x26c
#define HDMI_PACKET_VS6_OFFSET		0x270
#define HDMI_PACKET_VS7_OFFSET		0x274
#define HDMI_PACKET_VS8_OFFSET		0x278
/* Registers for I2S */
#define HDMI_I2S_MODE_OFFSET		0x2c4
#define HDMI_I2S_RX_CTRL_OFFSET		0x2c8
#define HDMI_I2S_WLEN_OFFSET		0x2cc
#define HDMI_I2S_WPOS_OFFSET		0x2d0
#define HDMI_I2S_SLOT_OFFSET		0x2d4
#define HDMI_I2S_RX_FIFO_GTH_OFFSET	0x2d8
#define HDMI_I2S_RX_CLOCK_OFFSET	0x2dc
#define HDMI_I2S_INIT_OFFSET		0x2e0
#define HDMI_I2S_RX_DATA0_OFFSET	0x2e4
#define HDMI_I2S_RX_DATA1_OFFSET	0x2e8
#define HDMI_I2S_RX_DATA2_OFFSET	0x2ec
#define HDMI_I2S_RX_DATA3_OFFSET	0x2f0
#define HDMI_I2S_FIFO_CNTR_OFFSET	0x2f4
#define HDMI_I2S_GATE_OFF_OFFSET	0x2f8
#define HDMI_PACKET_MISC_OFFSET		0x2fc

/* Registers for Video Part */
#define HDMI_VUNIT_VBLANK_VFRONT_OFFSET		0x360
#define HDMI_VUNIT_VBLANK_PULSE_WIDTH_OFFSET	0x364
#define HDMI_VUNIT_VBLANK_VBACK_OFFSET		0x368
#define HDMI_VUNIT_HBLANK_HFRONT_OFFSET		0x36c
#define HDMI_VUNIT_HBLANK_PULSE_WIDTH_OFFSET	0x370
#define HDMI_VUNIT_HBLANK_HBACK_OFFSET		0x374
#define HDMI_VUNIT_VACTIVE_OFFSET		0x378
#define HDMI_VUNIT_HACTIVE_OFFSET		0x37c
#define HDMI_VUNIT_CTRL_OFFSET			0x380
#define HDMI_VUNIT_VSYNC_DETECT_OFFSET		0x384

/* Registers for HDMISE Test Mode Part */
#define HDMI_HDMISE_TM_OFFSET		0x388

/* Registers for TMDS Asynchronous FIFO Part */
#define HDMI_P2P_AFIFO_LEVEL_OFFSET	0x38c
#define HDMI_P2P_AFIFO_CTRL_OFFSET	0x390

/* Registers for HDMI Debug mode used */
#define HDMI_HDMISE_DBG_OFFSET		0x394

#else	/* (VOUT_HDMI_REGS_OFFSET_GROUP == 2) */

#define HDMI_PACKET_GAMUT0_OFFSET	0x234
#define HDMI_PACKET_GAMUT1_OFFSET	0x238
#define HDMI_PACKET_GAMUT2_OFFSET	0x23c
#define HDMI_PACKET_GAMUT3_OFFSET	0x240
#define HDMI_PACKET_GAMUT4_OFFSET	0x244
#define HDMI_PACKET_GAMUT5_OFFSET	0x248
#define HDMI_PACKET_GAMUT6_OFFSET	0x24c
#define HDMI_PACKET_GAMUT7_OFFSET	0x250
#define HDMI_PACKET_GAMUT8_OFFSET	0x254
#define HDMI_I2S_MODE_OFFSET		0x258
#define HDMI_I2S_RX_CTRL_OFFSET		0x25c
#define HDMI_I2S_WLEN_OFFSET		0x260
#define HDMI_I2S_WPOS_OFFSET		0x264
#define HDMI_I2S_SLOT_OFFSET		0x268

#define HDMI_I2S_RX_FIFO_GTH_OFFSET	0x26c
#define HDMI_I2S_RX_CLOCK_OFFSET	0x270
#define HDMI_I2S_INIT_OFFSET		0x274
#define HDMI_I2S_RX_DATA0_OFFSET	0x278
#define HDMI_I2S_RX_DATA1_OFFSET	0x27c
#define HDMI_I2S_RX_DATA2_OFFSET	0x280
#define HDMI_I2S_FIFO_CNTR_OFFSET	0x284
#define HDMI_I2S_GATE_OFF_OFFSET	0x288
#define HDMI_PACKET_MISC_OFFSET		0x28c

/* Registers for Video Part */
#define HDMI_VUNIT_VBLANK_OFFSET	0x290
#define HDMI_VUNIT_HBLANK_OFFSET	0x294
#define HDMI_VUNIT_VACTIVE_OFFSET	0x298
#define HDMI_VUNIT_HACTIVE_OFFSET	0x29c
#define HDMI_VUNIT_CTRL_OFFSET		0x2a0
#define HDMI_VUNIT_VSYNC_DETECT_OFFSET	0x2a4

/* Registers for HDMISE Test Mode Part */
#define HDMI_HDMISE_TM_OFFSET		0x2a8

/* Registers for TMDS Asynchronous FIFO Part */
#define HDMI_P2P_AFIFO_LEVEL_OFFSET	0x2ac
#define HDMI_P2P_AFIFO_CTRL_OFFSET	0x2b0

/* Registers for HDMI Debug mode used */
#define HDMI_HDMISE_DBG_OFFSET		0x2b4
#endif

/* ---------------------------------------------------------------------*/
/* Registers for System 						*/
/* ---------------------------------------------------------------------*/
#define HDMI_INT_ENABLE_REG		HDMI_REG(HDMI_INT_ENABLE_OFFSET)
#define HDMI_INT_STS_REG		HDMI_REG(HDMI_INT_STS_OFFSET)
#define HDMI_OP_MODE_REG		HDMI_REG(HDMI_OP_MODE_OFFSET)
#define HDMI_CLOCK_GATED_REG		HDMI_REG(HDMI_CLOCK_GATED_OFFSET)
#define HDMI_HDMISE_SOFT_RESET_REG	HDMI_REG(HDMI_HDMISE_SOFT_RESET_OFFSET)
#define HDMI_STS_REG			HDMI_REG(HDMI_STS_OFFSET)

/* Registers for Data Island Part */
#define HDMI_AUNIT_MCLK_REG		HDMI_REG(HDMI_AUNIT_MCLK_OFFSET)
#define HDMI_AUNIT_NCTS_CTRL_REG	HDMI_REG(HDMI_AUNIT_NCTS_CTRL_OFFSET)
#define HDMI_AUNIT_N_REG		HDMI_REG(HDMI_AUNIT_N_OFFSET)
#define HDMI_AUNIT_CTS_REG		HDMI_REG(HDMI_AUNIT_CTS_OFFSET)
#define HDMI_AUNIT_SRC_REG		HDMI_REG(HDMI_AUNIT_SRC_OFFSET)
#define HDMI_AUNIT_CS0_REG		HDMI_REG(HDMI_AUNIT_CS0_OFFSET)
#define HDMI_AUNIT_CS1_REG		HDMI_REG(HDMI_AUNIT_CS1_OFFSET)
#define HDMI_AUNIT_CS2_REG		HDMI_REG(HDMI_AUNIT_CS2_OFFSET)
#define HDMI_AUNIT_CS3_REG		HDMI_REG(HDMI_AUNIT_CS3_OFFSET)
#define HDMI_AUNIT_CS4_REG		HDMI_REG(HDMI_AUNIT_CS4_OFFSET)
#define HDMI_AUNIT_CS5_REG		HDMI_REG(HDMI_AUNIT_CS5_OFFSET)
#define HDMI_AUNIT_LAYOUT_REG		HDMI_REG(HDMI_AUNIT_LAYOUT_OFFSET)
#define HDMI_PACKET_TX_CTRL_REG		HDMI_REG(HDMI_PACKET_TX_CTRL_OFFSET)
#define HDMI_PACKET_GENERAL_CTRL_REG	HDMI_REG(HDMI_PACKET_GENERAL_CTRL_OFFSET)
#define HDMI_PACKET_ACP0_REG		HDMI_REG(HDMI_PACKET_ACP0_OFFSET)
#define HDMI_PACKET_ACP1_REG		HDMI_REG(HDMI_PACKET_ACP1_OFFSET)
#define HDMI_PACKET_ACP2_REG		HDMI_REG(HDMI_PACKET_ACP2_OFFSET)
#define HDMI_PACKET_ACP3_REG		HDMI_REG(HDMI_PACKET_ACP3_OFFSET)
#define HDMI_PACKET_ACP4_REG		HDMI_REG(HDMI_PACKET_ACP4_OFFSET)
#define HDMI_PACKET_ACP5_REG		HDMI_REG(HDMI_PACKET_ACP5_OFFSET)
#define HDMI_PACKET_ACP6_REG		HDMI_REG(HDMI_PACKET_ACP6_OFFSET)
#define HDMI_PACKET_ACP7_REG		HDMI_REG(HDMI_PACKET_ACP7_OFFSET)
#define HDMI_PACKET_ACP8_REG		HDMI_REG(HDMI_PACKET_ACP8_OFFSET)
#define HDMI_PACKET_ISRC1_0_REG		HDMI_REG(HDMI_PACKET_ISRC1_0_OFFSET)
#define HDMI_PACKET_ISRC1_1_REG		HDMI_REG(HDMI_PACKET_ISRC1_1_OFFSET)
#define HDMI_PACKET_ISRC1_2_REG		HDMI_REG(HDMI_PACKET_ISRC1_2_OFFSET)
#define HDMI_PACKET_ISRC1_3_REG		HDMI_REG(HDMI_PACKET_ISRC1_3_OFFSET)
#define HDMI_PACKET_ISRC1_4_REG		HDMI_REG(HDMI_PACKET_ISRC1_4_OFFSET)
#define HDMI_PACKET_ISRC1_5_REG		HDMI_REG(HDMI_PACKET_ISRC1_5_OFFSET)
#define HDMI_PACKET_ISRC1_6_REG		HDMI_REG(HDMI_PACKET_ISRC1_6_OFFSET)
#define HDMI_PACKET_ISRC1_7_REG		HDMI_REG(HDMI_PACKET_ISRC1_7_OFFSET)
#define HDMI_PACKET_ISRC1_8_REG		HDMI_REG(HDMI_PACKET_ISRC1_8_OFFSET)
#define HDMI_PACKET_ISRC2_0_REG		HDMI_REG(HDMI_PACKET_ISRC2_0_OFFSET)
#define HDMI_PACKET_ISRC2_1_REG		HDMI_REG(HDMI_PACKET_ISRC2_1_OFFSET)
#define HDMI_PACKET_ISRC2_2_REG		HDMI_REG(HDMI_PACKET_ISRC2_2_OFFSET)
#define HDMI_PACKET_ISRC2_3_REG		HDMI_REG(HDMI_PACKET_ISRC2_3_OFFSET)
#define HDMI_PACKET_ISRC2_4_REG		HDMI_REG(HDMI_PACKET_ISRC2_4_OFFSET)
#define HDMI_PACKET_ISRC2_5_REG		HDMI_REG(HDMI_PACKET_ISRC2_5_OFFSET)
#define HDMI_PACKET_ISRC2_6_REG		HDMI_REG(HDMI_PACKET_ISRC2_6_OFFSET)
#define HDMI_PACKET_ISRC2_7_REG		HDMI_REG(HDMI_PACKET_ISRC2_7_OFFSET)
#define HDMI_PACKET_ISRC2_8_REG		HDMI_REG(HDMI_PACKET_ISRC2_8_OFFSET)
#define HDMI_PACKET_AVI0_REG		HDMI_REG(HDMI_PACKET_AVI0_OFFSET)
#define HDMI_PACKET_AVI1_REG		HDMI_REG(HDMI_PACKET_AVI1_OFFSET)
#define HDMI_PACKET_AVI2_REG		HDMI_REG(HDMI_PACKET_AVI2_OFFSET)
#define HDMI_PACKET_AVI3_REG		HDMI_REG(HDMI_PACKET_AVI3_OFFSET)
#define HDMI_PACKET_AVI4_REG		HDMI_REG(HDMI_PACKET_AVI4_OFFSET)
#define HDMI_PACKET_AVI5_REG		HDMI_REG(HDMI_PACKET_AVI5_OFFSET)
#define HDMI_PACKET_AVI6_REG		HDMI_REG(HDMI_PACKET_AVI6_OFFSET)
#define HDMI_PACKET_AVI7_REG		HDMI_REG(HDMI_PACKET_AVI7_OFFSET)
#define HDMI_PACKET_AVI8_REG		HDMI_REG(HDMI_PACKET_AVI8_OFFSET)
#define HDMI_PACKET_SPD0_REG		HDMI_REG(HDMI_PACKET_SPD0_OFFSET)
#define HDMI_PACKET_SPD1_REG		HDMI_REG(HDMI_PACKET_SPD1_OFFSET)
#define HDMI_PACKET_SPD2_REG		HDMI_REG(HDMI_PACKET_SPD2_OFFSET)
#define HDMI_PACKET_SPD3_REG		HDMI_REG(HDMI_PACKET_SPD3_OFFSET)
#define HDMI_PACKET_SPD4_REG		HDMI_REG(HDMI_PACKET_SPD4_OFFSET)
#define HDMI_PACKET_SPD5_REG		HDMI_REG(HDMI_PACKET_SPD5_OFFSET)
#define HDMI_PACKET_SPD6_REG		HDMI_REG(HDMI_PACKET_SPD6_OFFSET)
#define HDMI_PACKET_SPD7_REG		HDMI_REG(HDMI_PACKET_SPD7_OFFSET)
#define HDMI_PACKET_SPD8_REG		HDMI_REG(HDMI_PACKET_SPD8_OFFSET)
#define HDMI_PACKET_AUDIO0_REG		HDMI_REG(HDMI_PACKET_AUDIO0_OFFSET)
#define HDMI_PACKET_AUDIO1_REG		HDMI_REG(HDMI_PACKET_AUDIO1_OFFSET)
#define HDMI_PACKET_AUDIO2_REG		HDMI_REG(HDMI_PACKET_AUDIO2_OFFSET)
#define HDMI_PACKET_AUDIO3_REG		HDMI_REG(HDMI_PACKET_AUDIO3_OFFSET)
#define HDMI_PACKET_AUDIO4_REG		HDMI_REG(HDMI_PACKET_AUDIO4_OFFSET)
#define HDMI_PACKET_AUDIO5_REG		HDMI_REG(HDMI_PACKET_AUDIO5_OFFSET)
#define HDMI_PACKET_AUDIO6_REG		HDMI_REG(HDMI_PACKET_AUDIO6_OFFSET)
#define HDMI_PACKET_AUDIO7_REG		HDMI_REG(HDMI_PACKET_AUDIO7_OFFSET)
#define HDMI_PACKET_AUDIO8_REG		HDMI_REG(HDMI_PACKET_AUDIO8_OFFSET)
#define HDMI_PACKET_MPEG0_REG		HDMI_REG(HDMI_PACKET_MPEG0_OFFSET)
#define HDMI_PACKET_MPEG1_REG		HDMI_REG(HDMI_PACKET_MPEG1_OFFSET)
#define HDMI_PACKET_MPEG2_REG		HDMI_REG(HDMI_PACKET_MPEG2_OFFSET)
#define HDMI_PACKET_MPEG3_REG		HDMI_REG(HDMI_PACKET_MPEG3_OFFSET)
#define HDMI_PACKET_MPEG4_REG		HDMI_REG(HDMI_PACKET_MPEG4_OFFSET)
#define HDMI_PACKET_MPEG5_REG		HDMI_REG(HDMI_PACKET_MPEG5_OFFSET)
#define HDMI_PACKET_MPEG6_REG		HDMI_REG(HDMI_PACKET_MPEG6_OFFSET)
#define HDMI_PACKET_MPEG7_REG		HDMI_REG(HDMI_PACKET_MPEG7_OFFSET)
#define HDMI_PACKET_MPEG8_REG		HDMI_REG(HDMI_PACKET_MPEG8_OFFSET)

#define HDMI_I2S_MODE_REG		HDMI_REG(HDMI_I2S_MODE_OFFSET)
#define HDMI_I2S_RX_CTRL_REG		HDMI_REG(HDMI_I2S_RX_CTRL_OFFSET)
#define HDMI_I2S_WLEN_REG		HDMI_REG(HDMI_I2S_WLEN_OFFSET)
#define HDMI_I2S_WPOS_REG		HDMI_REG(HDMI_I2S_WPOS_OFFSET)
#define HDMI_I2S_SLOT_REG		HDMI_REG(HDMI_I2S_SLOT_OFFSET)
#define HDMI_I2S_RX_FIFO_GTH_REG	HDMI_REG(HDMI_I2S_RX_FIFO_GTH_OFFSET)
#define HDMI_I2S_RX_CLOCK_REG		HDMI_REG(HDMI_I2S_RX_CLOCK_OFFSET)
#define HDMI_I2S_INIT_REG		HDMI_REG(HDMI_I2S_INIT_OFFSET)
#define HDMI_I2S_RX_DATA0_REG		HDMI_REG(HDMI_I2S_RX_DATA0_OFFSET)
#define HDMI_I2S_RX_DATA1_REG		HDMI_REG(HDMI_I2S_RX_DATA1_OFFSET)
#define HDMI_I2S_RX_DATA2_REG		HDMI_REG(HDMI_I2S_RX_DATA2_OFFSET)
#define HDMI_I2S_RX_DATA3_REG		HDMI_REG(HDMI_I2S_RX_DATA3_OFFSET)
#define HDMI_I2S_FIFO_CNTR_REG		HDMI_REG(HDMI_I2S_FIFO_CNTR_OFFSET)
#define HDMI_I2S_GATE_OFF_REG		HDMI_REG(HDMI_I2S_GATE_OFF_OFFSET)
#define HDMI_PACKET_MISC_REG		HDMI_REG(HDMI_PACKET_MISC_OFFSET)

/* Registers for HDMISE Test Mode Part */
#define HDMI_HDMISE_TM_REG		HDMI_REG(HDMI_HDMISE_TM_OFFSET)

/* Registers for TMDS Asynchronous FIFO Part */
#define HDMI_P2P_AFIFO_LEVEL_REG	HDMI_REG(HDMI_P2P_AFIFO_LEVEL_OFFSET)
#define HDMI_P2P_AFIFO_CTRL_REG		HDMI_REG(HDMI_P2P_AFIFO_CTRL_OFFSET)

/* Registers for Data Island Part */
#define HDMI_PACKET_GAMUT0_REG		HDMI_REG(HDMI_PACKET_GAMUT0_OFFSET)
#define HDMI_PACKET_GAMUT1_REG		HDMI_REG(HDMI_PACKET_GAMUT1_OFFSET)
#define HDMI_PACKET_GAMUT2_REG		HDMI_REG(HDMI_PACKET_GAMUT2_OFFSET)
#define HDMI_PACKET_GAMUT3_REG		HDMI_REG(HDMI_PACKET_GAMUT3_OFFSET)
#define HDMI_PACKET_GAMUT4_REG		HDMI_REG(HDMI_PACKET_GAMUT4_OFFSET)
#define HDMI_PACKET_GAMUT5_REG		HDMI_REG(HDMI_PACKET_GAMUT5_OFFSET)
#define HDMI_PACKET_GAMUT6_REG		HDMI_REG(HDMI_PACKET_GAMUT6_OFFSET)
#define HDMI_PACKET_GAMUT7_REG		HDMI_REG(HDMI_PACKET_GAMUT7_OFFSET)
#define HDMI_PACKET_GAMUT8_REG		HDMI_REG(HDMI_PACKET_GAMUT8_OFFSET)


#if (VOUT_HDMI_SUPPORT_VSIF == 0)
#define HDMI_PACKET_VS0_REG		HDMI_PACKET_MPEG0_REG
#define HDMI_PACKET_VS1_REG		HDMI_PACKET_MPEG1_REG
#define HDMI_PACKET_VS2_REG		HDMI_PACKET_MPEG2_REG
#define HDMI_PACKET_VS3_REG		HDMI_PACKET_MPEG3_REG
#define HDMI_PACKET_VS4_REG		HDMI_PACKET_MPEG4_REG
#define HDMI_PACKET_VS5_REG		HDMI_PACKET_MPEG5_REG
#define HDMI_PACKET_VS6_REG		HDMI_PACKET_MPEG6_REG
#define HDMI_PACKET_VS7_REG		HDMI_PACKET_MPEG7_REG
#define HDMI_PACKET_VS8_REG		HDMI_PACKET_MPEG8_REG
#else
#define HDMI_PACKET_VS0_REG		HDMI_REG(HDMI_PACKET_VS0_OFFSET)
#define HDMI_PACKET_VS1_REG		HDMI_REG(HDMI_PACKET_VS1_OFFSET)
#define HDMI_PACKET_VS2_REG		HDMI_REG(HDMI_PACKET_VS2_OFFSET)
#define HDMI_PACKET_VS3_REG		HDMI_REG(HDMI_PACKET_VS3_OFFSET)
#define HDMI_PACKET_VS4_REG		HDMI_REG(HDMI_PACKET_VS4_OFFSET)
#define HDMI_PACKET_VS5_REG		HDMI_REG(HDMI_PACKET_VS5_OFFSET)
#define HDMI_PACKET_VS6_REG		HDMI_REG(HDMI_PACKET_VS6_OFFSET)
#define HDMI_PACKET_VS7_REG		HDMI_REG(HDMI_PACKET_VS7_OFFSET)
#define HDMI_PACKET_VS8_REG		HDMI_REG(HDMI_PACKET_VS8_OFFSET)
#endif

/* Registers for Video Part */
#define HDMI_VUNIT_VBLANK_REG		HDMI_REG(HDMI_VUNIT_VBLANK_OFFSET)
#define HDMI_VUNIT_HBLANK_REG		HDMI_REG(HDMI_VUNIT_HBLANK_OFFSET)
#define HDMI_VUNIT_VACTIVE_REG		HDMI_REG(HDMI_VUNIT_VACTIVE_OFFSET)
#define HDMI_VUNIT_HACTIVE_REG		HDMI_REG(HDMI_VUNIT_HACTIVE_OFFSET)

#define HDMI_VUNIT_VBLANK_VFRONT_REG		\
			HDMI_REG(HDMI_VUNIT_VBLANK_VFRONT_OFFSET)
#define HDMI_VUNIT_VBLANK_PULSE_WIDTH_REG	\
			HDMI_REG(HDMI_VUNIT_VBLANK_PULSE_WIDTH_OFFSET)
#define HDMI_VUNIT_VBLANK_VBACK_REG		\
			HDMI_REG(HDMI_VUNIT_VBLANK_VBACK_OFFSET)
#define HDMI_VUNIT_HBLANK_HFRONT_REG		\
			HDMI_REG(HDMI_VUNIT_HBLANK_HFRONT_OFFSET)
#define HDMI_VUNIT_HBLANK_PULSE_WIDTH_REG	\
			HDMI_REG(HDMI_VUNIT_HBLANK_PULSE_WIDTH_OFFSET)
#define HDMI_VUNIT_HBLANK_HBACK_REG		\
			HDMI_REG(HDMI_VUNIT_HBLANK_HBACK_OFFSET)
#define HDMI_VUNIT_CTRL_REG			\
			HDMI_REG(HDMI_VUNIT_CTRL_OFFSET)

#define HDMI_VUNIT_VSYNC_DETECT_REG	HDMI_REG(HDMI_VUNIT_VSYNC_DETECT_OFFSET)

/* Registers for HDMI Debug mode used */
#define HDMI_HDMISE_DBG_REG		HDMI_REG(HDMI_HDMISE_DBG_OFFSET)

/* ---------------------------------------------------------------------*/
/* Bit\format definitions						*/
/* ---------------------------------------------------------------------*/

/* HDMI_INT_ENABLE_REG */
#define HDMI_INT_ENABLE_PHY_RX_SENSE_REMOVE_EN	0x02000000
#define HDMI_INT_ENABLE_HDMISE_IDLE_EN		0x01000000
#define HDMI_INT_ENABLE_P2P_EXCEED_UB_EN	0x00800000
#define HDMI_INT_ENABLE_P2P_BELOW_LB_EN		0x00400000
#define HDMI_INT_ENABLE_P2P_REMEPTY_EN		0x00200000
#define HDMI_INT_ENABLE_P2P_WFULL_EN		0x00100000
#define HDMI_INT_ENABLE_CTS_CHANGE_EN		0x00080000
#define HDMI_INT_ENABLE_I2S_RX_IDLE_EN		0x00040000
#define HDMI_INT_ENABLE_I2S_RX_GTH_VALID_EN	0x00020000
#define HDMI_INT_ENABLE_I2S_RX_FIFO_OVER_EN	0x00010000
#define HDMI_INT_ENABLE_I2S_RX_FIFO_FULL_EN	0x00008000
#define HDMI_INT_ENABLE_I2S_RX_FIFO_EMPTY_EN	0x00004000
#define HDMI_INT_ENABLE_PHY_RX_SENSE_EN		0x00002000
#define HDMI_INT_ENABLE_HDCP_AKSV_READY_EN	0x00001000
#define HDMI_INT_ENABLE_HDCP_AUTH_STAT_GOT_EN	0x00000800
#define HDMI_INT_ENABLE_HDCP_INVALID_BKSV_EN	0x00000400
#define HDMI_INT_ENABLE_HDCP_PJ_READY_EN	0x00000200
#define HDMI_INT_ENABLE_HDCP_RI_READY_EN	0x00000100
#define HDMI_INT_ENABLE_HDCP_AN_READY_EN	0x00000080
#define HDMI_INT_ENABLE_HDCP_V_READY_EN		0x00000040
#define HDMI_INT_ENABLE_CEC_TX_INT_OK_EN	0x00000020
#define HDMI_INT_ENABLE_CEC_TX_INT_FAIL_EN	0x00000010
#define HDMI_INT_ENABLE_CEC_RX_INT_EN		0x00000008
#define HDMI_INT_ENABLE_HOT_PLUG_LOSS_EN	0x00000004
#define HDMI_INT_ENABLE_HOT_PLUG_DETECT_EN	0x00000002
#define HDMI_INT_ENABLE_VSYNC_ACTIVE_DETECT_EN	0x00000001

/* HDMI_INT_STS_REG */
#define HDMI_INT_STS_PHY_RX_SENSE_REMOVE	0x02000000
#define HDMI_INT_STS_HDMISE_IDLE		0x01000000
#define HDMI_INT_STS_P2P_EXCEED_UB		0x00800000
#define HDMI_INT_STS_P2P_BELOW_LB		0x00400000
#define HDMI_INT_STS_P2P_REMEPTY		0x00200000
#define HDMI_INT_STS_P2P_WFULL			0x00100000
#define HDMI_INT_STS_CTS_CHANGE			0x00080000
#define HDMI_INT_STS_I2S_RX_IDLE		0x00040000
#define HDMI_INT_STS_I2S_RX_GTH_VALID		0x00020000
#define HDMI_INT_STS_I2S_RX_FIFO_OVER		0x00010000
#define HDMI_INT_STS_I2S_RX_FIFO_FULL		0x00008000
#define HDMI_INT_STS_I2S_RX_FIFO_EMPTY		0x00004000
#define HDMI_INT_STS_PHY_RX_SENSE		0x00002000
#define HDMI_INT_STS_HDCP_AKSV_READY		0x00001000
#define HDMI_INT_STS_HDCP_AUTH_STAT_GOT		0x00000800
#define HDMI_INT_STS_HDCP_INVALID_BKSV		0x00000400
#define HDMI_INT_STS_HDCP_PJ_READY		0x00000200
#define HDMI_INT_STS_HDCP_RI_READY		0x00000100
#define HDMI_INT_STS_HDCP_AN_READY		0x00000080
#define HDMI_INT_STS_HDCP_V_READY		0x00000040
#define HDMI_INT_STS_CEC_TX_INTERRUPT_OK	0x00000020
#define HDMI_INT_STS_CEC_TX_INTERRUPT_FAIL	0x00000010
#define HDMI_INT_STS_CEC_RX_INTERRUPT		0x00000008
#define HDMI_INT_STS_HOT_PLUG_LOSS		0x00000004
#define HDMI_INT_STS_HOT_PLUG_DETECT		0x00000002
#define HDMI_INT_STS_VSYNC_ACTIVE_DETECT	0x00000001

/* HDMI_OP_MODE_REG */
#define HDMI_OP_MODE_OP_EN			(0x1 << 1)
#define HDMI_OP_MODE_OP_MODE(x)			((x) & 0x01)
#define HDMI_OP_MODE_OP_MODE_HDMI		0x00000001
#define HDMI_OP_MODE_OP_MODE_DVI		0x00000000

/* HDMI_CLOCK_GATED_REG */
#define HDMI_CLOCK_GATED_CEC_CLOCK_EN		(0x01 << 2)
#define HDMI_CLOCK_GATED_HDCP_CLOCK_EN		(0x01 << 1)
#define HDMI_CLOCK_GATED_HDMISE_CLOCK_EN	(0x01)

/* HDMI_HDMISE_SOFT_RESET_REG */
#define HDMI_HDMISE_SOFT_RESET			0x0

/* HDMI_HDMISE_STS_REG */
#define HDMI_STS_RX_SENSE			0x2000
#define HDMI_STS_HPD_HI				0x0002

/* AUNIT_MCLK_REG */
#define HDMI_AUNIT_MCLK_INPUT_FREQ(x)		((x) & 0x07)
#define HDMI_AUNIT_MCLK_INPUT_FREQ_MODE_768FS	0x00000004
#define HDMI_AUNIT_MCLK_INPUT_FREQ_MODE_512FS	0x00000003
#define HDMI_AUNIT_MCLK_INPUT_FREQ_MODE_384FS	0x00000002
#define HDMI_AUNIT_MCLK_INPUT_FREQ_MODE_256FS	0x00000001
#define HDMI_AUNIT_MCLK_INPUT_FREQ_MODE_128FS	0x00000000

/* AUNIT_NCTS_CTRL_REG */
#define HDMI_AUNIT_NCTS_CTRL_NCTS_EN		(0x01 << 1)
#define HDMI_AUNIT_NCTS_CTRL_CTS_SEL(x)		((x) & 0x01)
#define HDMI_AUNIT_NCTS_CTRL_CTS_SEL_SW_MODE	0x00000001
#define HDMI_AUNIT_NCTS_CTRL_CTS_SEL_HW_MODE	0x00000000

/* AUNIT_N_REG */
#define HDMI_AUNIT_N(x)				((x) & 0x000fffff)

/* AUNIT_CTS_REG */
#define HDMI_AUNIT_CTS(x)			((x) & 0x000fffff)

/* AUNIT_SRC_REG */
#if (VOUT_HDMI_SUPPORT_AUDIO_CHANNELS == 8)
#define HDMI_AUNIT_SRC_FLAT_LINE3		(0x01 << 7)
#define HDMI_AUNIT_SRC_FLAT_LINE2		(0x01 << 6)
#define HDMI_AUNIT_SRC_FLAT_LINE1		(0x01 << 5)
#define HDMI_AUNIT_SRC_FLAT_LINE0		(0x01 << 4)
#define HDMI_AUNIT_SRC_I2S3_EN			(0x01 << 3)
#define HDMI_AUNIT_SRC_I2S2_EN			(0x01 << 2)
#define HDMI_AUNIT_SRC_I2S1_EN			(0x01 << 1)
#define HDMI_AUNIT_SRC_I2S0_EN			(0x01)
#else	/* (VOUT_HDMI_SUPPORT_AUDIO_CHANNELS == 6) */
#define HDMI_AUNIT_SRC_FLAT_LINE2		(0x01 << 5)
#define HDMI_AUNIT_SRC_FLAT_LINE1		(0x01 << 4)
#define HDMI_AUNIT_SRC_FLAT_LINE0		(0x01 << 3)
#define HDMI_AUNIT_SRC_I2S2_EN			(0x01 << 2)
#define HDMI_AUNIT_SRC_I2S1_EN			(0x01 << 1)
#define HDMI_AUNIT_SRC_I2S0_EN			(0x01)
#endif

/* AUNIT_CS0_REG */
/* AUNIT_CS1_REG */
/* AUNIT_CS2_REG */
/* AUNIT_CS3_REG */
/* AUNIT_CS4_REG */
/* AUNIT_CS5_REG */

/* AUNIT_LAYOUT_REG */
#define HDMI_AUNIT_LAYOUT_LAYOUT1		0x00000001
#define HDMI_AUNIT_LAYOUT_LAYOUT0		0x00000000

/* PACKET_TX_CTRL_REG */
#if (VOUT_HDMI_SUPPORT_1P3_GAMUT == 1)
#define HDMI_PACKET_TX_CTRL_BUF_SWITCH_EN	(0x1UL << 31)
#define HDMI_PACKET_TX_CTRL_GAMUT_RPT		(0x1UL << 15)
#define HDMI_PACKET_TX_CTRL_GAMUT_EN		(0x1UL << 14)
#else
#define HDMI_PACKET_TX_CTRL_BUF_SWITCH_EN	(0x1 << 14)
#endif

#define HDMI_PACKET_TX_CTRL_MPEG_RPT		(0x1 << 13)
#define HDMI_PACKET_TX_CTRL_MPEG_EN		(0x1 << 12)
#define HDMI_PACKET_TX_CTRL_AUD_RPT		(0x1 << 11)
#define HDMI_PACKET_TX_CTRL_AUD_EN		(0x1 << 10)
#define HDMI_PACKET_TX_CTRL_SPD_RPT		(0x1 << 9)
#define HDMI_PACKET_TX_CTRL_SPD_EN		(0x1 << 8)
#define HDMI_PACKET_TX_CTRL_AVI_RPT		(0x1 << 7)
#define HDMI_PACKET_TX_CTRL_AVI_EN		(0x1 << 6)
#define HDMI_PACKET_TX_CTRL_ISRC_RPT		(0x1 << 5)
#define HDMI_PACKET_TX_CTRL_ISRC_EN		(0x1 << 4)
#define HDMI_PACKET_TX_CTRL_ACP_RPT		(0x1 << 3)
#define HDMI_PACKET_TX_CTRL_ACP_EN		(0x1 << 2)
#define HDMI_PACKET_TX_CTRL_GEN_RPT		(0x1 << 1)
#define HDMI_PACKET_TX_CTRL_GEN_EN		(0x1)
#if (VOUT_HDMI_SUPPORT_VSIF == 0)
#define HDMI_PACKET_TX_CTRL_VS_RPT		HDMI_PACKET_TX_CTRL_MPEG_RPT
#define HDMI_PACKET_TX_CTRL_VS_EN		HDMI_PACKET_TX_CTRL_MPEG_EN
#else
#define HDMI_PACKET_TX_CTRL_VS_RPT		(0x1UL << 17)
#define HDMI_PACKET_TX_CTRL_VS_EN		(0x1UL << 16)
#endif

/* PACKET_GENERAL_CTRL_REG */
#define HDMI_PACKET_GENERAL_CTRL_CLR_AVMUTE_EN	(0x1 << 4)
#define HDMI_PACKET_GENERAL_CTRL_SET_AVMUTE_EN	(0x1)

/* PACKET_ACP0_REG */
#define HDMI_PACKET_ACP0_ACP_HB2(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP0_ACP_HB1(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP0_ACP_HB0(x)		((x) & 0xff)

/* PACKET_ACP1_REG */
#define HDMI_PACKET_ACP1_ACP_PB3(x)		(((x) & 0xff) << 24)
#define HDMI_PACKET_ACP1_ACP_PB2(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP1_ACP_PB1(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP1_ACP_PB0(x)		((x) & 0xff)

/* PACKET_ACP2_REG */
#define HDMI_PACKET_ACP2_ACP_PB6(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP2_ACP_PB5(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP2_ACP_PB4(x)		((x) & 0xff)

/* PACKET_ACP3_REG */
#define HDMI_PACKET_ACP3_ACP_PB10(x)		(((x) & 0xff) << 24)
#define HDMI_PACKET_ACP3_ACP_PB9(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP3_ACP_PB8(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP3_ACP_PB7(x)		((x) & 0xff)

/* PACKET_ACP4_REG */
#define HDMI_PACKET_ACP4_ACP_PB13(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP4_ACP_PB12(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP4_ACP_PB11(x)		((x) & 0xff)

/* PACKET_ACP5_REG */
#define HDMI_PACKET_ACP5_ACP_PB17(x)		(((x) & 0xff) << 24)
#define HDMI_PACKET_ACP5_ACP_PB16(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP5_ACP_PB15(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP5_ACP_PB14(x)		((x) & 0xff)

/* PACKET_ACP6_REG */
#define HDMI_PACKET_ACP6_ACP_PB20(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP6_ACP_PB19(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP6_ACP_PB18(x)		((x) & 0xff)

/* PACKET_ACP7_REG */
#define HDMI_PACKET_ACP7_ACP_PB24(x)		(((x) & 0xff) << 24)
#define HDMI_PACKET_ACP7_ACP_PB23(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP7_ACP_PB22(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP7_ACP_PB21(x)		((x) & 0xff)

/* PACKET_ACP8_REG */
#define HDMI_PACKET_ACP8_ACP_PB27(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_ACP8_ACP_PB26(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_ACP8_ACP_PB25(x)		((x) & 0xff)

/* PACKET_ISRC1_0_REG */
#define HDMI_PACKET_ISRC1_0_ISRC1_HB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_0_ISRC1_HB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_0_ISRC1_HB0(x)	((x) & 0xff)

/* PACKET_ISRC1_1_REG */
#define HDMI_PACKET_ISRC1_1_ISRC1_PB3(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC1_1_ISRC1_PB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_1_ISRC1_PB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_1_ISRC1_PB0(x)	((x) & 0xff)

/* PACKET_ISRC1_2_REG */
#define HDMI_PACKET_ISRC1_2_ISRC1_PB6(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_2_ISRC1_PB5(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_2_ISRC1_PB4(x)	((x) & 0xff)

/* PACKET_ISRC1_3_REG */
#define HDMI_PACKET_ISRC1_3_ISRC1_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC1_3_ISRC1_PB9(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_3_ISRC1_PB8(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_3_ISRC1_PB7(x)	((x) & 0xff)

/* PACKET_ISRC1_4_REG */
#define HDMI_PACKET_ISRC1_4_ISRC1_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_4_ISRC1_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_4_ISRC1_PB11(x)	((x) & 0xff)

/* PACKET_ISRC1_5_REG */
#define HDMI_PACKET_ISRC1_5_ISRC1_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC1_5_ISRC1_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_5_ISRC1_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_5_ISRC1_PB14(x)	((x) & 0xff)

/* PACKET_ISRC1_6_REG */
#define HDMI_PACKET_ISRC1_6_ISRC1_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_6_ISRC1_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_6_ISRC1_PB18(x)	((x) & 0xff)

/* PACKET_ISRC1_7_REG */
#define HDMI_PACKET_ISRC1_7_ISRC1_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC1_7_ISRC1_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_7_ISRC1_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_7_ISRC1_PB21(x)	((x) & 0xff)

/* PACKET_ISRC1_8_REG */
#define HDMI_PACKET_ISRC1_8_ISRC1_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC1_8_ISRC1_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC1_8_ISRC1_PB25(x)	((x) & 0xff)

/* PACKET_ISRC2_0_REG */
#define HDMI_PACKET_ISRC2_0_ISRC2_HB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_0_ISRC2_HB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_0_ISRC2_HB0(x)	((x) & 0xff)

/* PACKET_ISRC2_1_REG */
#define HDMI_PACKET_ISRC2_1_ISRC2_PB3(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC2_1_ISRC2_PB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_1_ISRC2_PB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_1_ISRC2_PB0(x)	((x) & 0xff)

/* PACKET_ISRC2_2_REG */
#define HDMI_PACKET_ISRC2_2_ISRC2_PB6(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_2_ISRC2_PB5(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_2_ISRC2_PB4(x)	((x) & 0xff)

/* PACKET_ISRC2_3_REG */
#define HDMI_PACKET_ISRC2_3_ISRC2_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC2_3_ISRC2_PB9(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_3_ISRC2_PB8(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_3_ISRC2_PB7(x)	((x) & 0xff)

/* PACKET_ISRC2_4_REG */
#define HDMI_PACKET_ISRC2_4_ISRC2_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_4_ISRC2_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_4_ISRC2_PB11(x)	((x) & 0xff)

/* PACKET_ISRC2_5_REG */
#define HDMI_PACKET_ISRC2_5_ISRC2_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC2_5_ISRC2_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_5_ISRC2_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_5_ISRC2_PB14(x)	((x) & 0xff)

/* PACKET_ISRC2_6_REG */
#define HDMI_PACKET_ISRC2_6_ISRC2_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_6_ISRC2_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_6_ISRC2_PB18(x)	((x) & 0xff)

/* PACKET_ISRC2_7_REG */
#define HDMI_PACKET_ISRC2_7_ISRC2_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_ISRC2_7_ISRC2_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_7_ISRC2_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_7_ISRC2_PB21(x)	((x) & 0xff)

/* PACKET_ISRC2_8_REG */
#define HDMI_PACKET_ISRC2_8_ISRC2_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_ISRC2_8_ISRC2_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_ISRC2_8_ISRC2_PB25(x)	((x) & 0xff)

/* PACKET_AVI0_REG */
#define HDMI_PACKET_AVI0_AVI_HB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI0_AVI_HB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI0_AVI_HB0(x)	((x) & 0xff)

/* PACKET_AVI1_REG */
#define HDMI_PACKET_AVI1_AVI_PB3(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AVI1_AVI_PB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI1_AVI_PB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI1_AVI_PB0(x)	((x) & 0xff)

/* PACKET_AVI2_REG */
#define HDMI_PACKET_AVI2_AVI_PB6(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI2_AVI_PB5(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI2_AVI_PB4(x)	((x) & 0xff)

/* PACKET_AVI3_REG */
#define HDMI_PACKET_AVI3_AVI_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AVI3_AVI_PB9(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI3_AVI_PB8(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI3_AVI_PB7(x)	((x) & 0xff)

/* PACKET_AVI4_REG */
#define HDMI_PACKET_AVI4_AVI_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI4_AVI_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI4_AVI_PB11(x)	((x) & 0xff)

/* PACKET_AVI5_REG */
#define HDMI_PACKET_AVI5_AVI_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AVI5_AVI_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI5_AVI_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI5_AVI_PB14(x)	((x) & 0xff)

/* PACKET_AVI6_REG */
#define HDMI_PACKET_AVI6_AVI_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI6_AVI_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI6_AVI_PB18(x)	((x) & 0xff)

/* PACKET_AVI7_REG */
#define HDMI_PACKET_AVI7_AVI_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AVI7_AVI_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI7_AVI_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI7_AVI_PB21(x)	((x) & 0xff)

/* PACKET_AVI8_REG */
#define HDMI_PACKET_AVI8_AVI_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AVI8_AVI_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AVI8_AVI_PB25(x)	((x) & 0xff)

/* PACKET_SPD0_REG */
#define HDMI_PACKET_SPD0_SPD_HB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD0_SPD_HB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD0_SPD_HB0(x)	((x) & 0xff)

/* PACKET_SPD1_REG */
#define HDMI_PACKET_SPD1_SPD_PB3(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_SPD1_SPD_PB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD1_SPD_PB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD1_SPD_PB0(x)	((x) & 0xff)

/* PACKET_SPD2_REG */
#define HDMI_PACKET_SPD2_SPD_PB6(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD2_SPD_PB5(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD2_SPD_PB4(x)	((x) & 0xff)

/* PACKET_SPD3_REG */
#define HDMI_PACKET_SPD3_SPD_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_SPD3_SPD_PB9(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD3_SPD_PB8(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD3_SPD_PB7(x)	((x) & 0xff)

/* PACKET_SPD4_REG */
#define HDMI_PACKET_SPD4_SPD_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD4_SPD_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD4_SPD_PB11(x)	((x) & 0xff)

/* PACKET_SPD5_REG */
#define HDMI_PACKET_SPD5_SPD_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_SPD5_SPD_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD5_SPD_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD5_SPD_PB14(x)	((x) & 0xff)

/* PACKET_SPD6_REG */
#define HDMI_PACKET_SPD6_SPD_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD6_SPD_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD6_SPD_PB18(x)	((x) & 0xff)

/* PACKET_SPD7_REG */
#define HDMI_PACKET_SPD7_SPD_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_SPD7_SPD_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD7_SPD_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD7_SPD_PB21(x)	((x) & 0xff)

/* PACKET_SPD8_REG */
#define HDMI_PACKET_SPD8_SPD_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_SPD8_SPD_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_SPD8_SPD_PB25(x)	((x) & 0xff)

/* PACKET_AUDIO0_REG */
#define HDMI_PACKET_AUDIO0_AUDIO_HB2(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO0_AUDIO_HB1(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO0_AUDIO_HB0(x)		((x) & 0xff)

/* PACKET_AUDIO1_REG */
#define HDMI_PACKET_AUDIO1_AUDIO_PB3(x)		(((x) & 0xff) << 24)
#define HDMI_PACKET_AUDIO1_AUDIO_PB2(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO1_AUDIO_PB1(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO1_AUDIO_PB0(x)		((x) & 0xff)

/* PACKET_AUDIO2_REG */
#define HDMI_PACKET_AUDIO2_AUDIO_PB6(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO2_AUDIO_PB5(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO2_AUDIO_PB4(x)		((x) & 0xff)

/* PACKET_AUDIO3_REG */
#define HDMI_PACKET_AUDIO3_AUDIO_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AUDIO3_AUDIO_PB9(x)		(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO3_AUDIO_PB8(x)		(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO3_AUDIO_PB7(x)		((x) & 0xff)

/* PACKET_AUDIO4_REG */
#define HDMI_PACKET_AUDIO4_AUDIO_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO4_AUDIO_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO4_AUDIO_PB11(x)	((x) & 0xff)

/* PACKET_AUDIO5_REG */
#define HDMI_PACKET_AUDIO5_AUDIO_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AUDIO5_AUDIO_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO5_AUDIO_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO5_AUDIO_PB14(x)	((x) & 0xff)

/* PACKET_AUDIO6_REG */
#define HDMI_PACKET_AUDIO6_AUDIO_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO6_AUDIO_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO6_AUDIO_PB18(x)	((x) & 0xff)

/* PACKET_AUDIO7_REG */
#define HDMI_PACKET_AUDIO7_AUDIO_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_AUDIO7_AUDIO_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO7_AUDIO_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO7_AUDIO_PB21(x)	((x) & 0xff)

/* PACKET_AUDIO8_REG */
#define HDMI_PACKET_AUDIO8_AUDIO_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_AUDIO8_AUDIO_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_AUDIO8_AUDIO_PB25(x)	((x) & 0xff)

/* PACKET_MPEG0_REG */
#define HDMI_PACKET_MPEG0_MPEG_HB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG0_MPEG_HB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG0_MPEG_HB0(x)	((x) & 0xff)

/* PACKET_MPEG1_REG */
#define HDMI_PACKET_MPEG1_MPEG_PB3(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_MPEG1_MPEG_PB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG1_MPEG_PB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG1_MPEG_PB0(x)	((x) & 0xff)

/* PACKET_MPEG2_REG */
#define HDMI_PACKET_MPEG2_MPEG_PB6(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG2_MPEG_PB5(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG2_MPEG_PB4(x)	((x) & 0xff)

/* PACKET_MPEG3_REG */
#define HDMI_PACKET_MPEG3_MPEG_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_MPEG3_MPEG_PB9(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG3_MPEG_PB8(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG3_MPEG_PB7(x)	((x) & 0xff)

/* PACKET_MPEG4_REG */
#define HDMI_PACKET_MPEG4_MPEG_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG4_MPEG_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG4_MPEG_PB11(x)	((x) & 0xff)

/* PACKET_MPEG5_REG */
#define HDMI_PACKET_MPEG5_MPEG_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_MPEG5_MPEG_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG5_MPEG_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG5_MPEG_PB14(x)	((x) & 0xff)

/* PACKET_MPEG6_REG */
#define HDMI_PACKET_MPEG6_MPEG_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG6_MPEG_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG6_MPEG_PB18(x)	((x) & 0xff)

/* PACKET_MPEG7_REG */
#define HDMI_PACKET_MPEG7_MPEG_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_MPEG7_MPEG_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG7_MPEG_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG7_MPEG_PB21(x)	((x) & 0xff)

/* PACKET_MPEG8_REG */
#define HDMI_PACKET_MPEG8_MPEG_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_MPEG8_MPEG_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_MPEG8_MPEG_PB25(x)	((x) & 0xff)

/* PACKET_VS_REG */
#define HDMI_PACKET_VS0_VS_HB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS0_VS_HB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS0_VS_HB0(x)	((x) & 0xff)

/* PACKET_VS1_REG */
#define HDMI_PACKET_VS1_VS_PB3(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_VS1_VS_PB2(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS1_VS_PB1(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS1_VS_PB0(x)	((x) & 0xff)

/* PACKET_VS2_REG */
#define HDMI_PACKET_VS2_VS_PB6(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS2_VS_PB5(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS2_VS_PB4(x)	((x) & 0xff)

/* PACKET_VS3_REG */
#define HDMI_PACKET_VS3_VS_PB10(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_VS3_VS_PB9(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS3_VS_PB8(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS3_VS_PB7(x)	((x) & 0xff)

/* PACKET_VS4_REG */
#define HDMI_PACKET_VS4_VS_PB13(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS4_VS_PB12(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS4_VS_PB11(x)	((x) & 0xff)

/* PACKET_VS5_REG */
#define HDMI_PACKET_VS5_VS_PB17(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_VS5_VS_PB16(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS5_VS_PB15(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS5_VS_PB14(x)	((x) & 0xff)

/* PACKET_VS6_REG */
#define HDMI_PACKET_VS6_VS_PB20(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS6_VS_PB19(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS6_VS_PB18(x)	((x) & 0xff)

/* PACKET_VS7_REG */
#define HDMI_PACKET_VS7_VS_PB24(x)	(((x) & 0xff) << 24)
#define HDMI_PACKET_VS7_VS_PB23(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS7_VS_PB22(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS7_VS_PB21(x)	((x) & 0xff)

/* PACKET_VS8_REG */
#define HDMI_PACKET_VS8_VS_PB27(x)	(((x) & 0xff) << 16)
#define HDMI_PACKET_VS8_VS_PB26(x)	(((x) & 0xff) << 8)
#define HDMI_PACKET_VS8_VS_PB25(x)	((x) & 0xff)

/* I2S_MODE_REG */
#define HDMI_I2S_MODE_DAI_MODE(x)		((x) & 0x07)
#define HDMI_I2S_MODE_DAI_MODE_I2S		0x00000004
#define HDMI_I2S_MODE_DAI_MODE_MSB_EXT		0x00000002
#define HDMI_I2S_MODE_DAI_MODE_RIGHT_JUSTIFY	0x00000001
#define HDMI_I2S_MODE_DAI_MODE_LEFT_JUSTIFY	0x00000000

/* I2S_RX_CTRL_REG */
#define HDMI_I2S_RX_CTRL_RX_ORDER(x)		(((x) & 0x01) << 2)
#define HDMI_I2S_RX_CTRL_RX_WS_MODE(x)		(((x) & 0x01) << 1)
#define HDMI_I2S_RX_CTRL_RX_WS_INV		(0x1)

/* I2S_WLEN_REG */
#define HDMI_I2S_WLEN_DAI_WLEN(x)		((x) & 0x1f)

/* I2S_WPOS_REG */
#define HDMI_I2S_WPOS_DAI_WPOS(x)		((x) & 0x1f)

/* I2S_SLOT_REG */
#define HDMI_I2S_SLOT_DAI_SLOT(x)		((x) & 0x1f)

/* RX_FIFO_GTH_REG */
#define HDMI_I2S_RX_FIFO_GTH_RX_FIFO_GTH(x)	((x) & 0xff)

/* RX_CLOCK_REG */
#define HDMI_I2S_RX_CLOCK_RX_I2S_CLK_POL(x)	(((x) & 0x01) << 5)
#define HDMI_I2S_RX_CLOCK_DAI_CLOCK_DIV(x)	((x) & 0x1f)

/* I2S_INIT_REG */
#define HDMI_I2S_INIT_RX_ENABLE			(0x1 << 1)
#define HDMI_I2S_INIT_RX_DISABLE		0x00
#define HDMI_I2S_INIT_DAI_RESET(x)		((x) & 0x01)

/* I2S_RX_DATA0_REG */
#define HDMI_I2S_RX_DATA0_RX_FIFO_DOUT0(x)	((x) & 0x00ffffff)

/* I2S_RX_DATA1_REG */
#define HDMI_I2S_RX_DATA1_RX_FIFO_DOUT1(x)	((x) & 0x00ffffff)

/* I2S_RX_DATA2_REG */
#define HDMI_I2S_RX_DATA2_RX_FIFO_DOUT2(x)	((x) & 0x00ffffff)

/* I2S_RX_FIFO_CNTR_REG */
#define HDMI_I2S_RX_FIFO_CNTR_RX_FIFO_CNTR(x)	((x) & 0x00ff)

/* I2S_GATE_OFF_REG */
#define HDMI_I2S_GATE_OFF_RX_GATE_OFF_EN	(0x1)

/* PACKET_MISC_REG */
#if (VOUT_HDMI_SUPPORT_HBR_AUDIO == 1)
#define HDMI_PACKET_MISC_AUDIO_MODE_HBR		(~(0x01 << 6))
#define HDMI_PACKET_MISC_AUDIO_MODE_LPCM	((0x01 << 6))
#endif
/* I2S MODE ??? */
#define HDMI_PACKET_MISC_NCTS_PRIORITY(x)	(((x) & 0x01) << 4)
#define HDMI_PACKET_MISC_BCH_MODE(x)		(((x) & 0x01) << 3)
#define HDMI_PACKET_MISC_SPD_SEND_CTRL(x)	(((x) & 0x01) << 2)
#define HDMI_PACKET_MISC_RIGHT_VALID_BIT(x)	(((x) & 0x01) << 1)
#define HDMI_PACKET_MISC_LEFT_VALID_BIT(x)	(((x) & 0x01) << 0)

#if (VOUT_HDMI_SUPPORT_4KX2K_FORMAT == 0)
/* VUNIT_VBLANK_REG */
#define HDMI_VUNIT_VBLANK_LEFT_OFFSET(x)	(((x) & 0x0000003f) << 12)
#define HDMI_VUNIT_VBLANK_PULSE_WIDTH(x)	(((x) & 0x0000003f) << 6)
#define HDMI_VUNIT_VBLANK_RIGHT_OFFSET(x)	((x) & 0x0000003f)

/* VUNIT_HBLANK_REG */
#define HDMI_VUNIT_HBLANK_LEFT_OFFSET(x)	(((x) & 0x000003ff) << 20)
#define HDMI_VUNIT_HBLANK_PULSE_WIDTH(x)	(((x) & 0x000003ff) << 10)
#define HDMI_VUNIT_HBLANK_RIGHT_OFFSET(x)	((x) & 0x000003ff)

/* VUNIT_VACTIVE_REG */
#define HDMI_VUNIT_VACTIVE_LINES_OF_ONE_FRAME(x)	((x) & 0x000007ff)

/* VUNIT_HACTIVE_REG */
#define HDMI_VUNIT_HACTIVE_PIXELS_PER_ONE_LINE(x)	((x) & 0x00000fff)
#else
/* VUNIT_VBLANK_REG */
#define HDMI_VUNIT_VBLANK_LEFT_OFFSET(x)	(((x) & 0x00003fff))
#define HDMI_VUNIT_VBLANK_PULSE_WIDTH(x)	(((x) & 0x00003fff))
#define HDMI_VUNIT_VBLANK_RIGHT_OFFSET(x)	(((x) & 0x00003fff))

/* VUNIT_HBLANK_REG */
#define HDMI_VUNIT_HBLANK_LEFT_OFFSET(x)	(((x) & 0x00003fff))
#define HDMI_VUNIT_HBLANK_PULSE_WIDTH(x)	(((x) & 0x00003fff))
#define HDMI_VUNIT_HBLANK_RIGHT_OFFSET(x)	(((x) & 0x00003fff))

/* VUNIT_VACTIVE_REG */
#define HDMI_VUNIT_VACTIVE_LINES_OF_ONE_FRAME(x)	((x) & 0x00003fff)

/* VUNIT_HACTIVE_REG */
#define HDMI_VUNIT_HACTIVE_PIXELS_PER_ONE_LINE(x)	((x) & 0x00007fff)
#endif

#if (VOUT_HDMI_SUPPORT_3D_FORMAT == 1)
#define HDMI_VUNIT_3D_MODE_FRAME_PACKING		(~(0x03 << 2))
#define HDMI_VUNIT_3D_MODE_LINE_ALTERNATIVE		(~(0x03 << 2))
#define HDMI_VUNIT_3D_MODE_SIDE_BY_SIDE_FULL		(~(0x03 << 2))
#define HDMI_VUNIT_3D_MODE_SIDE_BY_SIDE_HALF		(~(0x03 << 2))
#define HDMI_VUNIT_PROGRESSIVE				(~(0x03 << 2))
#define HDMI_VUNIT_INTERLACE				(0x01 << 2)
#define HDMI_VUNIT_CTRL_VIDEO_MODE(x)			(((x) & 0x01) << 2)
#define HDMI_VUNIT_3D_MODE_3D_FIELD_ALTERNATIVE		(0x02 << 2)
#define HDMI_VUNIT_3D_MODE_RESERVED			(0x03 << 2)
#define HDMI_VUNIT_CTRL_HSYNC_POL(x)			(((x) & 0x01) << 1)
#define HDMI_VUNIT_CTRL_VSYNC_POL(x)			(((x) & 0x01) << 0)
#else
/* VUNIT_CTRL_REG */
#define HDMI_VUNIT_CTRL_VIDEO_MODE(x)			(((x) & 0x01) << 2)
#define HDMI_VUNIT_CTRL_HSYNC_POL(x)			(((x) & 0x01) << 1)
#define HDMI_VUNIT_CTRL_VSYNC_POL(x)			(((x) & 0x01) << 0)
#endif

/* VUNIT_VSYNC_DETECT_REG */
#define HDMI_VUNIT_VSYNC_DETECT_EN		(0x1)

/* VUNIT_HDMISE_TM_REG */
#define HDMI_VUNIT_HDMISE_TM_VDATA_SRC_MODE(x)		(((x) & 0x01) << 1)
#define HDMI_VUNIT_HDMISE_TM_I2S_OUT_MODE(x)		((x) & 0x01)

/* P2P_AFIFO_LEVEL_REG */
#if (VOUT_HDMI_P2P_AFIFO_LEVEL_DEFINE == 1)
#define HDMI_P2P_AFIFO_LEVEL_UPPER_BOUND(x)		(((x) & 0x0f) << 19)
#define HDMI_P2P_AFIFO_LEVEL_LOWER_BOUND(x)		(((x) & 0x0f) << 15)
#define HDMI_P2P_AFIFO_LEVEL_MAX_USAGE_LEVEL(x)		(((x) & 0x1f) << 10)
#define HDMI_P2P_AFIFO_LEVEL_MIN_USAGE_LEVEL(x)		(((x) & 0x1f) << 5)
#define HDMI_P2P_AFIFO_LEVEL_CURRENT_USAGE_LEVEL(x)	((x) & 0x1f)
#else
#define HDMI_P2P_AFIFO_LEVEL_UPPER_BOUND(x)		(((x) & 0x0f) << 28)
#define HDMI_P2P_AFIFO_LEVEL_LOWER_BOUND(x)		(((x) & 0x0f) << 24)
#define HDMI_P2P_AFIFO_LEVEL_MAX_USAGE_LEVEL(x)		(((x) & 0x1f) << 16)
#define HDMI_P2P_AFIFO_LEVEL_MIN_USAGE_LEVEL(x)		(((x) & 0x1f) << 8)
#define HDMI_P2P_AFIFO_LEVEL_CURRENT_USAGE_LEVEL(x)	((x) & 0x1f)
#endif

/* P2P_AFIFO_CTRL_REG */
#define HDMI_P2P_AFIFO_CTRL_EN				(0x1)

/**************/
/* HDMI PHY */
/**************/
#define HDMI_PHY_BASE			HDMI_BASE
#define HDMI_PHY_REG(x)			(HDMI_PHY_BASE + (x))

#if (VOUT_HDMI_PHY_REGS_OFFSET_GROUP == 2)
#define HDMI_PHY_CTRL_OFFSET		0x700
#define HDMI_PHY_PLL_OFFSET		0x704
#define HDMI_PHY_FRAC_OFFSET		0x708

#define HDMI_PHY_CTRL_REG		HDMI_PHY_REG(HDMI_PHY_CTRL_OFFSET)
#define HDMI_PHY_PLL_REG		HDMI_PHY_REG(HDMI_PHY_PLL_OFFSET)
#define HDMI_PHY_FRAC_REG		HDMI_PHY_REG(HDMI_PHY_FRAC_OFFSET)

/* HDMI_PHY_CTRL_REG */
#define HDMI_PHY_CTRL_RESET_HDMI_PHY		0
#define HDMI_PHY_CTRL_NON_RESET_HDMI_PHY	1

#define HDMI_PHY_CTRL_0_MA_SINK_CURRENT		(0 << 8)
#define HDMI_PHY_CTRL_0P6_MA_SINK_CURRENT	(1 << 8)
#define HDMI_PHY_CTRL_1P2_MA_SINK_CURRENT	(2 << 8)
#define HDMI_PHY_CTRL_1P8_MA_SINK_CURRENT	(3 << 8)

#define HDMI_PHY_CTRL_0_PRE_EMPHASIS		(0 << 16)
#define HDMI_PHY_CTRL_10_PRE_EMPHASIS		(1 << 16)
#define HDMI_PHY_CTRL_20_PRE_EMPHASIS		(2 << 16)
#define HDMI_PHY_CTRL_30_PRE_EMPHASIS		(3 << 16)

#define HDMI_PHY_CTRL_HDMI_PHY_ACTIVE_MODE		(1 << 6)
#define HDMI_PHY_CTRL_BAND_GAP_VOLT_GEN_POWER_DOWN_MODE	(1 << 7)

#define MASK_PRE_EMPHASIS	0x00070000
#define MASK_SINK_CURRENT	0x00000700
#define BIT_PRE_EMPHASIS	16
#define BIT_SINK_CURRENT	8
#else	/* (VOUT_HDMI_PHY_REGS_OFFSET_GROUP == 1) */
#define HDMI_PHY_CTRL_OFFSET		0x600
#define HDMI_PHY_PLL_OFFSET		0x604
#define HDMI_PHY_FRAC_OFFSET		0x608

#define HDMI_PHY_CTRL_REG		HDMI_PHY_REG(HDMI_PHY_CTRL_OFFSET)
#define HDMI_PHY_PLL_REG		HDMI_PHY_REG(HDMI_PHY_PLL_OFFSET)
#define HDMI_PHY_FRAC_REG		HDMI_PHY_REG(HDMI_PHY_FRAC_OFFSET)

/* HDMI_PHY_CTRL_REG */
#define HDMI_PHY_CTRL_RESET_HDMI_PHY		0
#define HDMI_PHY_CTRL_NON_RESET_HDMI_PHY	1

#define HDMI_PHY_CTRL_0_MA_SINK_CURRENT		(0 << 1)
#define HDMI_PHY_CTRL_0P6_MA_SINK_CURRENT	(1 << 1)
#define HDMI_PHY_CTRL_1P2_MA_SINK_CURRENT	(2 << 1)
#define HDMI_PHY_CTRL_1P8_MA_SINK_CURRENT	(3 << 1)

#define HDMI_PHY_CTRL_0_PRE_EMPHASIS		(0 << 3)
#define HDMI_PHY_CTRL_10_PRE_EMPHASIS		(1 << 3)
#define HDMI_PHY_CTRL_20_PRE_EMPHASIS		(2 << 3)
#define HDMI_PHY_CTRL_30_PRE_EMPHASIS		(3 << 3)

#define HDMI_PHY_CTRL_HDMI_PHY_ACTIVE_MODE		(1 << 5)
#define HDMI_PHY_CTRL_BAND_GAP_VOLT_GEN_POWER_DOWN_MODE	(1 << 6)

#define MASK_PRE_EMPHASIS	0x00000018
#define MASK_SINK_CURRENT	0x00000006
#define BIT_PRE_EMPHASIS	3
#define BIT_SINK_CURRENT	1
#endif

#endif

/* ---------------------------------------------------------------------- */
#if (VOUT_HDCP_REGS_OFFSET_GROUP == 1)
#define HDCP_HDCPCE_CTL_OFFSET		0x300
#else
#define HDCP_HDCPCE_CTL_OFFSET		0x400
#endif

#if (VOUT_SUPPORT_ONCHIP_HDCP == 1)

/****************************/
/* HDCP Cryptography Engine */
/****************************/
#define HDCP_BASE			HDMI_BASE
#define HDCP_REG(x)			(HDCP_BASE + (x))

#if (VOUT_HDCP_REGS_OFFSET_GROUP == 1)
//#define HDCP_HDCPCE_CTL_OFFSET		0x300
#define HDCP_AUTH_STAT_CTL_OFFSET	0x304
#define HDCP_HDCPCE_TX_MODE_OFFSET	0x308
#define HDCP_BCONF_OFFSET		0x30c
#define HDCP_HDCPCE_STATUS_OFFSET	0x310
#define HDCP_TRNG_CTL_OFFSET		0x314
#define HDCP_TRNG1_OUT_OFFSET		0x318
#define HDCP_TRNG2_OUT_OFFSET		0x31c
#define HDCP_CASR1_IN_LO_OFFSET		0x320
#define HDCP_CASR1_IN_HI_OFFSET		0x324
#define HDCP_LFSR1_IN_LO_OFFSET		0x328
#define HDCP_LFSR1_IN_HI_OFFSET		0x32c
#define HDCP_CASR2_IN_LO_OFFSET		0x330
#define HDCP_CASR2_IN_HI_OFFSET		0x334
#define HDCP_LFSR2_IN_LO_OFFSET		0x338
#define HDCP_LFSR2_IN_HI_OFFSET		0x33c
#define HDCP_AN_LO_OFFSET		0x340
#define HDCP_AN_HI_OFFSET		0x344
#define HDCP_ANREF_LO_OFFSET		0x348
#define HDCP_ANREF_HI_OFFSET		0x34c
#define HDCP_BKSV_LO_OFFSET		0x350
#define HDCP_BKSV_HI_OFFSET		0x354
#define HDCP_AKSV_LO_OFFSET		0x360
#define HDCP_AKSV_HI_OFFSET		0x364
#define HDCP_RI_OFFSET			0x368
#define HDCP_PJ_OFFSET			0x36c
#define HDCP_SHA_DWORD_IN_OFFSET	0x380
#define HDCP_SHA_DWORD_NUM_OFFSET	0x384
#define HDCP_SHA_DWORD_OUT0_OFFSET	0x388
#define HDCP_SHA_DWORD_OUT1_OFFSET	0x38c
#define HDCP_SHA_DWORD_OUT2_OFFSET	0x390
#define HDCP_SHA_DWORD_OUT3_OFFSET	0x394
#define HDCP_SHA_DWORD_OUT4_OFFSET	0x398
#define HDCP_SHA_STATUS_OFFSET		0x39c
#define HDCP_IROM_DATA_LO_OFFSET	0x3c0
#define HDCP_IROM_DATA_HI_OFFSET	0x3c4
#define HDCP_IROM_ADDR_OFFSET		0x3c8
#define HDCP_IROM_STATUS_OFFSET 	0x3d0
#define HDCP_EROM_DATA_LO_OFFSET	0x3e0
#define HDCP_EROM_DATA_HI_OFFSET	0x3e4
#define HDCP_EROM_ADDR_OFFSET		0x3e8
#define HDCP_EROM_STATUS_OFFSET 	0x3ec
#define HDCP_EROM_CONFIG_OFFSET 	0x3f0
#define HDCP_I2C_PARAMS_OFFSET		0x3f4
#define HDCP_KRAM_DATA_LO_OFFSET	0x400
#define HDCP_KRAM_DATA_HI_OFFSET	0x404
#define HDCP_KRAM_ADDR_OFFSET		0x408
#define HDCP_KRAM_STATUS_OFFSET 	0x40c

#else	/* VOUT_HDCP_REGS_OFFSET_GROUP == 2 */
//#define HDCP_HDCPCE_CTL_OFFSET		0x400
#define HDCP_AUTH_STAT_CTL_OFFSET	0x404
#define HDCP_HDCPCE_TX_MODE_OFFSET	0x408
#define HDCP_BCONF_OFFSET		0x40c
#define HDCP_HDCPCE_STATUS_OFFSET	0x410
#define HDCP_TRNG_CTL_OFFSET		0x414
#define HDCP_TRNG1_OUT_OFFSET		0x418
#define HDCP_TRNG2_OUT_OFFSET		0x41c
#define HDCP_CASR1_IN_LO_OFFSET		0x420
#define HDCP_CASR1_IN_HI_OFFSET		0x424
#define HDCP_LFSR1_IN_LO_OFFSET		0x428
#define HDCP_LFSR1_IN_HI_OFFSET		0x42c
#define HDCP_CASR2_IN_LO_OFFSET		0x430
#define HDCP_CASR2_IN_HI_OFFSET		0x434
#define HDCP_LFSR2_IN_LO_OFFSET		0x438
#define HDCP_LFSR2_IN_HI_OFFSET		0x43c
#define HDCP_AN_LO_OFFSET		0x440
#define HDCP_AN_HI_OFFSET		0x444
#define HDCP_ANREF_LO_OFFSET		0x448
#define HDCP_ANREF_HI_OFFSET		0x44c
#define HDCP_BKSV_LO_OFFSET		0x450
#define HDCP_BKSV_HI_OFFSET		0x454
#define HDCP_AKSV_LO_OFFSET		0x460
#define HDCP_AKSV_HI_OFFSET		0x464
#define HDCP_RI_OFFSET			0x468
#define HDCP_PJ_OFFSET			0x46c
#define HDCP_SHA_DWORD_IN_OFFSET	0x480
#define HDCP_SHA_DWORD_NUM_OFFSET	0x484
#define HDCP_SHA_DWORD_OUT0_OFFSET	0x488
#define HDCP_SHA_DWORD_OUT1_OFFSET	0x48c
#define HDCP_SHA_DWORD_OUT2_OFFSET	0x490
#define HDCP_SHA_DWORD_OUT3_OFFSET	0x494
#define HDCP_SHA_DWORD_OUT4_OFFSET	0x498
#define HDCP_SHA_STATUS_OFFSET		0x49c
#define HDCP_IROM_DATA_LO_OFFSET	0x4c0
#define HDCP_IROM_DATA_HI_OFFSET	0x4c4
#define HDCP_IROM_ADDR_OFFSET		0x4c8
#define HDCP_IROM_STATUS_OFFSET 	0x4cc
#define HDCP_EROM_DATA_LO_OFFSET	0x4e0
#define HDCP_EROM_DATA_HI_OFFSET	0x4e4
#define HDCP_EROM_ADDR_OFFSET		0x4e8
#define HDCP_EROM_STATUS_OFFSET 	0x4ec
#define HDCP_EROM_CONFIG_OFFSET 	0x4f0
#define HDCP_I2C_PARAMS_OFFSET		0x4f4
#define HDCP_KRAM_DATA_LO_OFFSET	0x500
#define HDCP_KRAM_DATA_HI_OFFSET	0x504
#define HDCP_KRAM_ADDR_OFFSET		0x508
#define HDCP_KRAM_STATUS_OFFSET 	0x50c
#endif	/* endif VOUT_HDCP_REGS_OFFSET_GROUP */

#define HDCP_HDCPCE_CTL_REG		HDCP_REG(HDCP_HDCPCE_CTL_OFFSET)
#define HDCP_AUTH_STAT_CTL_REG		HDCP_REG(HDCP_AUTH_STAT_CTL_OFFSET)
#define HDCP_HDCPCE_TX_MODE_REG		HDCP_REG(HDCP_HDCPCE_TX_MODE_OFFSET)
#define HDCP_BCONF_REG			HDCP_REG(HDCP_BCONF_OFFSET)
#define HDCP_HDCPCE_STATUS_REG		HDCP_REG(HDCP_HDCPCE_STATUS_OFFSET)
#define HDCP_TRNG_CTL_REG		HDCP_REG(HDCP_TRNG_CTL_OFFSET)
#define HDCP_TRNG1_OUT_REG		HDCP_REG(HDCP_TRNG1_OUT_OFFSET)
#define HDCP_TRNG2_OUT_REG		HDCP_REG(HDCP_TRNG2_OUT_OFFSET)
#define HDCP_CASR1_IN_LO_REG		HDCP_REG(HDCP_CASR1_IN_LO_OFFSET)
#define HDCP_CASR1_IN_HI_REG		HDCP_REG(HDCP_CASR1_IN_HI_OFFSET)
#define HDCP_LFSR1_IN_LO_REG		HDCP_REG(HDCP_LFSR1_IN_LO_OFFSET)
#define HDCP_LFSR1_IN_HI_REG		HDCP_REG(HDCP_LFSR1_IN_HI_OFFSET)
#define HDCP_CASR2_IN_LO_REG		HDCP_REG(HDCP_CASR2_IN_LO_OFFSET)
#define HDCP_CASR2_IN_HI_REG		HDCP_REG(HDCP_CASR2_IN_HI_OFFSET)
#define HDCP_LFSR2_IN_LO_REG		HDCP_REG(HDCP_LFSR2_IN_LO_OFFSET)
#define HDCP_LFSR2_IN_HI_REG		HDCP_REG(HDCP_LFSR2_IN_HI_OFFSET)
#define HDCP_AN_LO_REG			HDCP_REG(HDCP_AN_LO_OFFSET)
#define HDCP_AN_HI_REG			HDCP_REG(HDCP_AN_HI_OFFSET)
#define HDCP_ANREF_LO_REG		HDCP_REG(HDCP_ANREF_LO_OFFSET)
#define HDCP_ANREF_HI_REG		HDCP_REG(HDCP_ANREF_HI_OFFSET)
#define HDCP_BKSV_LO_REG		HDCP_REG(HDCP_BKSV_LO_OFFSET)
#define HDCP_BKSV_HI_REG		HDCP_REG(HDCP_BKSV_HI_OFFSET)
#define HDCP_AKSV_LO_REG		HDCP_REG(HDCP_AKSV_LO_OFFSET)
#define HDCP_AKSV_HI_REG		HDCP_REG(HDCP_AKSV_HI_OFFSET)
#define HDCP_RI_REG			HDCP_REG(HDCP_RI_OFFSET)
#define HDCP_PJ_REG			HDCP_REG(HDCP_PJ_OFFSET)
#define HDCP_SHA_DWORD_IN_REG		HDCP_REG(HDCP_SHA_DWORD_IN_OFFSET)
#define HDCP_SHA_DWORD_NUM_REG		HDCP_REG(HDCP_SHA_DWORD_NUM_OFFSET)
#define HDCP_SHA_DWORD_OUT0_REG 	HDCP_REG(HDCP_SHA_DWORD_OUT0_OFFSET)
#define HDCP_SHA_DWORD_OUT1_REG 	HDCP_REG(HDCP_SHA_DWORD_OUT1_OFFSET)
#define HDCP_SHA_DWORD_OUT2_REG 	HDCP_REG(HDCP_SHA_DWORD_OUT2_OFFSET)
#define HDCP_SHA_DWORD_OUT3_REG 	HDCP_REG(HDCP_SHA_DWORD_OUT3_OFFSET)
#define HDCP_SHA_DWORD_OUT4_REG 	HDCP_REG(HDCP_SHA_DWORD_OUT4_OFFSET)
#define HDCP_SHA_STATUS_REG		HDCP_REG(HDCP_SHA_STATUS_OFFSET)
#define HDCP_IROM_DATA_LO_REG		HDCP_REG(HDCP_IROM_DATA_LO_OFFSET)
#define HDCP_IROM_DATA_HI_REG		HDCP_REG(HDCP_IROM_DATA_HI_OFFSET)
#define HDCP_IROM_ADDR_REG		HDCP_REG(HDCP_IROM_ADDR_OFFSET)
#define HDCP_IROM_STATUS_REG		HDCP_REG(HDCP_IROM_STATUS_OFFSET)
#define HDCP_EROM_DATA_LO_REG		HDCP_REG(HDCP_EROM_DATA_LO_OFFSET)
#define HDCP_EROM_DATA_HI_REG		HDCP_REG(HDCP_EROM_DATA_HI_OFFSET)
#define HDCP_EROM_ADDR_REG		HDCP_REG(HDCP_EROM_ADDR_OFFSET)
#define HDCP_EROM_STATUS_REG		HDCP_REG(HDCP_EROM_STATUS_OFFSET)
#define HDCP_EROM_CONFIG_REG		HDCP_REG(HDCP_EROM_CONFIG_OFFSET)
#define HDCP_I2C_PARAMS_REG		HDCP_REG(HDCP_I2C_PARAMS_OFFSET)
#define HDCP_KRAM_DATA_LO_REG		HDCP_REG(HDCP_KRAM_DATA_LO_OFFSET)
#define HDCP_KRAM_DATA_HI_REG		HDCP_REG(HDCP_KRAM_DATA_HI_OFFSET)
#define HDCP_KRAM_ADDR_REG		HDCP_REG(HDCP_KRAM_ADDR_OFFSET)
#define HDCP_KRAM_STATUS_REG		HDCP_REG(HDCP_KRAM_STATUS_OFFSET)

/* HDCP_HDCPCE_CTL_REG */
#define HDCP_HDCPCE_CTL_HDCPCE_EN		(0x1UL << 31)
#define HDCP_HDCPCE_CTL_KEY_SPACE(x)		(((x) & 0x03) << 7)
#define HDCP_HDCPCE_CTL_HDCP_ENC_EN		(0x1 << 5)
#define HDCP_HDCPCE_CTL_USE_EESS(x)		(((x) & 0x01) << 4)
#if (VOUT_HDCP_AKSV_FETCH == 1)
#define HDCP_HDCPCE_CTL_AKSV_FETCH		(0x01 << 1)
#endif
#define HDCP_HDCPCE_CTL_AUTH_REQ_DIS		(0x1)

/* HDCP_AUTH_STAT_CTL_REG */
#define HDCP_AUTH_STAT_CTL_HDCPRX_ON(x)		(0x01 << 2)
#define HDCP_AUTH_STAT_CTL_AUTH_RESULT(x)	((x) & 0x03)

/* HDCP_HDCPCE_TX_MODE_REG */
#define HDCP_HDCPCE_TX_MODE_AC_MODE(x)		((x) & 0x01)

/* HDCP_BCONF_REG */
#define HDCP_BCONF_REPEATER			(0x01 << 16)
#define HDCP_BCONF_BSTATUS(x)			((x) & 0x00001fff)

/* HDCP_HDCPCE_STATUS_REG */
#define HDCP_HDCPCE_STATUS_AUTH_STAT(x)		(((x) & 0x000f0000) >> 16)
#define HDCP_HDCPCE_STATUS_READY_AN(x)		(((x) & 0x00000020) >> 5)
#define HDCP_HDCPCE_STATUS_BKSV_INVALID(x)	(((x) & 0x00000010) >> 4)
#define HDCP_HDCPCE_STATUS_READY_AKSV(x)	(((x) & 0x00000008) >> 3)
#define HDCP_HDCPCE_STATUS_READY_RI(x)		(((x) & 0x00000004) >> 2)
#define HDCP_HDCPCE_STATUS_READY_PJ(x)		(((x) & 0x00000002) >> 1)
#define HDCP_HDCPCE_STATUS_READY_V(x)		((x) & 0x01)

/* HDCP_TRNG_CTL_REG */
#define HDCP_TRNG_CTL_TRNG1_EN			(0x01 << 16)
#define HDCP_TRNG_CTL_TRNG2_EN			(0x01)

/* HDCP_CASR1_IN_LO_REG */
#define HDCP_CASR1_IN_LO_LOW_32_BITS(x)		(x)
#define HDCP_CASR1_IN_HI_HI_5_BITS(x)		((x) & 0x1f)

/* HDCP_LFSR1_IN_LO_REG */
#define HDCP_LFSR1_IN_LO_LOW_32_BITS(x)		(x)
#define HDCP_LFSR1_IN_HI_HI_11_BITS(x)		((x) & 0x3ff)

/* HDCP_CASR2_IN_LO_REG */
#define HDCP_CASR2_IN_LO_LOW_32_BITS(x)		(x)
#define HDCP_CASR2_IN_HI_HI_5_BITS(x)		((x) & 0x1f)

/* HDCP_LFSR2_IN_LO_REG */
#define HDCP_LFSR2_IN_LO_LOW_32_BITS(x)		(x)
#define HDCP_LFSR2_IN_HI_HI_11_BITS(x)		((x) & 0x3ff)

/* HDCP_BKSV_LO_REG */
#define HDCP_BKSV_LO_LOW_4_BYTES(x)		(x)
#define HDCP_BKSV_HI_HI_1_BYTE(x)		((x) & 0xff)

/* HDCP_AKSV_LO_REG */
#define HDCP_AKSV_LO_LOW_4_BYTES(x)		(x)
#define HDCP_AKSV_HI_HI_1_BYTE(x)		((x) & 0xff)

/* HDCP_RI_REG */
#define HDCP_RI_HDCP_RI(x)			((x) & 0xffff)

/* HDCP_PJ_REG */
#define HDCP_PJ_HDCP_PJ(x)			((x) & 0x00ff)

/* HDCP_SHA_DWORD_NUM_REG */
#define HDCP_SHA_DWORD_NUM_TTL_BYTE(x)		((x) & 0x3ff)

/* HDCP_SHA_STATUS_REG */
#define HDCP_SHA_STATUS_BYTE_IN_CNT(x)		(((x) & 0x00003ff0) >> 4)
#define HDCP_SHA_STATUS_SHA1_AU_READY		(0x1)

#endif

#define HDMI_EESS_CTL_REG			HDMI_REG(HDCP_HDCPCE_CTL_OFFSET)
#define HDMI_HDCPCE_CTL_HDCPCE_EN		(0x1UL << 31)
#define HDMI_HDCPCE_CTL_HDCP_ENC_EN		(0x1 << 5)
#define HDMI_HDCPCE_CTL_USE_EESS(x)		(((x) & 0x01) << 4)

/* ---------------------------------------------------------------------- */

#if (VOUT_SUPPORT_ONCHIP_CEC == 1)

/**************/
/* CEC Engine */
/**************/
#define CEC_BASE			HDMI_BASE
#define CEC_REG(x)			(CEC_BASE + (x))

#if (VOUT_HDMI_CEC_REGS_OFFSET_GROUP == 1)
#define CEC_INTERRUPT_OFFSET		0x008
#define CEC_CTRL_OFFSET			0x500
#define CEC_CTRL1_OFFSET		0x500
#define CEC_STATUS_OFFSET		0x504
#define CEC_START_PTRN_OFFSET		0x508
#define CEC_ZERO_PTRN_OFFSET		0x50c
#define CEC_ONE_PTRN_OFFSET		0x510
#define CEC_CLK_PTRN_OFFSET		0x514
#define CEC_TX_DATA0_OFFSET		0x518
#define CEC_TX_DATA1_OFFSET		0x51c
#define CEC_TX_DATA2_OFFSET		0x520
#define CEC_TX_DATA3_OFFSET		0x524
#define CEC_RX_DATA0_OFFSET		0x528
#define CEC_RX_DATA1_OFFSET		0x52c
#define CEC_RX_DATA2_OFFSET		0x530
#define CEC_RX_DATA3_OFFSET		0x534
#define CEC_CTRL2_OFFSET		0x538
#define CEC_TOLE_PTRN_LOWER_OFFSET	0x53c
#define CEC_LOW_PTRN_OFFSET		0x540
#define CEC_TOLE_PTRN_UPPER_OFFSET	0x544

#else /* (VOUT_HDMI_CEC_REGS_OFFSET_GROUP == 2) */

#define CEC_INTERRUPT_OFFSET		0x008
#define CEC_CTRL1_OFFSET		0x600
#define CEC_STATUS_OFFSET		0x604
#define CEC_START_PTRN_OFFSET		0x608
#define CEC_ZERO_PTRN_OFFSET		0x60c
#define CEC_ONE_PTRN_OFFSET		0x610
#define CEC_CLK_PTRN_OFFSET		0x614
#define CEC_TX_DATA0_OFFSET		0x618
#define CEC_TX_DATA1_OFFSET		0x61c
#define CEC_TX_DATA2_OFFSET		0x620
#define CEC_TX_DATA3_OFFSET		0x624
#define CEC_RX_DATA0_OFFSET		0x628
#define CEC_RX_DATA1_OFFSET		0x62c
#define CEC_RX_DATA2_OFFSET		0x630
#define CEC_RX_DATA3_OFFSET		0x634
#define CEC_CTRL2_OFFSET		0x638
#define CEC_TOLE_PTRN_LOWER_OFFSET	0x63c
#define CEC_LOW_PTRN_OFFSET		0x640
#define CEC_TOLE_PTRN_UPPER_OFFSET	0x644
#define CEC_MIS_PTRN_OFFSET		0x648
#define CEC_TX_START_PTRN_OFFSET	0x64C
#define CEC_TX_ZERO_PTRN_OFFSET		0x650
#define CEC_TX_ONE_PTRN_OFFSET		0x654
#endif

#define CEC_INTERRUPT_REG		CEC_REG(CEC_INTERRUPT_OFFSET)
#define CEC_CTRL_REG			CEC_REG(CEC_CTRL_OFFSET)
#define CEC_CTRL1_REG			CEC_REG(CEC_CTRL1_OFFSET)
#define CEC_STATUS_REG			CEC_REG(CEC_STATUS_OFFSET)
#define CEC_START_PTRN_REG		CEC_REG(CEC_START_PTRN_OFFSET)
#define CEC_ZERO_PTRN_REG		CEC_REG(CEC_ZERO_PTRN_OFFSET)
#define CEC_ONE_PTRN_REG		CEC_REG(CEC_ONE_PTRN_OFFSET)
#define CEC_CLK_PTRN_REG		CEC_REG(CEC_CLK_PTRN_OFFSET)
#define CEC_TX_DATA0_REG		CEC_REG(CEC_TX_DATA0_OFFSET)
#define CEC_TX_DATA1_REG		CEC_REG(CEC_TX_DATA1_OFFSET)
#define CEC_TX_DATA2_REG		CEC_REG(CEC_TX_DATA2_OFFSET)
#define CEC_TX_DATA3_REG		CEC_REG(CEC_TX_DATA3_OFFSET)
#define CEC_RX_DATA0_REG		CEC_REG(CEC_RX_DATA0_OFFSET)
#define CEC_RX_DATA1_REG		CEC_REG(CEC_RX_DATA1_OFFSET)
#define CEC_RX_DATA2_REG		CEC_REG(CEC_RX_DATA2_OFFSET)
#define CEC_CTRL2_REG			CEC_REG(CEC_CTRL2_OFFSET)
#define CEC_TOLE_PTRN_LOWER_REG		CEC_REG(CEC_TOLE_PTRN_LOWER_OFFSET)
#define CEC_LOW_PTRN_REG		CEC_REG(CEC_LOW_PTRN_OFFSET)
#define CEC_TOLE_PTRN_UPPER_REG		CEC_REG(CEC_TOLE_PTRN_UPPER_OFFSET)
#define CEC_MIS_PTRN_REG		CEC_REG(EC_MIS_PTRN_OFFSET)
#define CEC_TX_START_PTRN_REG		CEC_REG(CEC_TX_START_PTRN_OFFSET)
#define CEC_TX_ZERO_PTRN_REG		CEC_REG(CEC_TX_ZERO_PTRN_OFFSET)
#define CEC_TX_ONE_PTRN_REG		CEC_REG(CEC_TX_ONE_PTRN_OFFSET)

/* CEC_INTERRUPT_REG */
#define CEC_INTERRUPT_TX_OK		0x10
#define CEC_INTERRUPT_TX_FAIL		0x80

#if (VOUT_CEC_SUPPORT_CTL_TYPE == 1)
/* CEC_CTRL_REG */
#define CEC_CTRL_RESET				(0x01UL << 31)
#define CEC_CTRL_TX_EN				(0x01 << 30)
#define CEC_CTRL_TX_BLOCK_NO(x)			(((x) & 0x0f) << 26)
#define CEC_CTRL_RX_BLOCK_NO(x)			(((x) & 0x03c00000) >> 22)
#endif

#if (VOUT_CEC_SUPPORT_CTL_TYPE == 2)
/* CEC_CTRL1_REG */
#define CEC_CTRL1_RESET				(0x01 << 31)
#define CEC_CTRL1_TX_EN				(0x01 << 30)
#define CEC_CTRL1_TX_BLOCK_NO(x)		(((x) & 0x0f) << 26)
#define CEC_CTRL1_RX_BLOCK_NO(x)		(((x) & 0x03c00000) >> 22)
#define CEC_CTRL1_INIT_ADDR_RETRY_EN		(0x01 << 20)
#define CEC_CTRL1_FREE_START_BIT(x)		(((x) & (0x07)) << 17)
#define CEC_CTRL1_CEC_WAIT_FOR_ACK		(0x01 << 16)
#define CEC_CTRL1_NOMINAL_SAMPLE_DISABLE	(0x01 << 14)
#define CEC_CTRL1_CEC_ARBITRATION		(0x01 << 13)
#endif

/* CEC_STATUS_REG */
#define CEC_STATUS_TX_STA_TX_IDLE		(0x01 << 3)
#define CEC_STATUS_TX_STA_TX_SEND_NORMAL_MSG	(0x02 << 3)
#define CEC_STATUS_TX_STA_TX_SEND_ACK_MSG	(0x03 << 3)
#define CEC_STATUS_TX_STA_TX_SEND_LOW_BIT_MSG	(0x04 << 3)
#define CEC_STATUS_TX_STA_TX_PROTECTED		(0x05 << 3)
#define CEC_STATUS_RX_STA_RX_IDLE1		0x01
#define CEC_STATUS_RX_STA_RX_IDLE2		0x02
#define CEC_STATUS_RX_STA_RX_IDLE3		0x03
#define CEC_STATUS_RX_STA_RX_BUSY		0x04
#define CEC_STATUS_RX_STA_RX_PROTECTED		0x05

/* CEC_START_PTRN_REG */
#define CEC_START_PTRN_SET_PERIOD_ALL(x)	(((x) & 0x03ff) << 16)
#define CEC_START_PTRN_SET_PERIOD_0(x)		((x) & 0x03ff)
#define CEC_START_PTRN_GET_PERIOD_ALL(x)	(((x) & 0x03ff0000) >> 16)

/* CEC_ZERO_PTRN_REG */
#define CEC_ZERO_PTRN_SET_PERIOD_ALL(x)		(((x) & 0x03ff) << 16)
#define CEC_ZERO_PTRN_SET_PERIOD_0(x)		((x) & 0x03ff)
#define CEC_ZERO_PTRN_GET_PERIOD_ALL(x)		(((x) & 0x03ff0000) >> 16)

/* CEC_ONE_PTRN_REG */
#define CEC_ONE_PTRN_SET_PERIOD_ALL(x)		(((x) & 0x03ff) << 16)
#define CEC_ONE_PTRN_SET_PERIOD_0(x)		((x) & 0x03ff)
#define CEC_ONE_PTRN_GET_PERIOD_ALL(x)		(((x) & 0x03ff0000) >> 16)

/* CEC_CLK_PTRN_REG */
#define CEC_CLK_PTRN_SET_PERIOD_0(x)		((x) & 0x03ff)

/* CEC_TX_DATA0_REG */
#define CEC_TX_DATA0_BLOCK1x(x)		(((x) & 0xff) << 24)
#define CEC_TX_DATA0_BLOCK2x(x)		(((x) & 0xff) << 16)
#define CEC_TX_DATA0_BLOCK3x(x)		(((x) & 0xff) << 8)
#define CEC_TX_DATA0_BLOCK4x(x)		((x) & 0xff)
#define CEC_TX_DATA0_BLOCK1(x)		(((x) & 0xff000000) >> 24)
#define CEC_TX_DATA0_BLOCK2(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_TX_DATA0_BLOCK3(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_TX_DATA0_BLOCK4(x)		((x) & 0x000000ff)

/* CEC_TX_DATA1_REG */
#define CEC_TX_DATA1_BLOCK5x(x)		(((x) & 0xff) << 24)
#define CEC_TX_DATA1_BLOCK6x(x)		(((x) & 0xff) << 16)
#define CEC_TX_DATA1_BLOCK7x(x)		(((x) & 0xff) << 8)
#define CEC_TX_DATA1_BLOCK8x(x)		((x) & 0xff)
#define CEC_TX_DATA1_BLOCK5(x)		(((x) & 0xff000000) >> 24)
#define CEC_TX_DATA1_BLOCK6(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_TX_DATA1_BLOCK7(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_TX_DATA1_BLOCK8(x)		((x) & 0x000000ff)

/* CEC_TX_DATA2_REG */
#define CEC_TX_DATA2_BLOCK9x(x)		(((x) & 0xff) << 24)
#define CEC_TX_DATA2_BLOCK10x(x)	(((x) & 0xff) << 16)
#define CEC_TX_DATA2_BLOCK11x(x)	(((x) & 0xff) << 8)
#define CEC_TX_DATA2_BLOCK12x(x)	((x) & 0xff)
#define CEC_TX_DATA2_BLOCK9(x)		(((x) & 0xff000000) >> 24)
#define CEC_TX_DATA2_BLOCK10(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_TX_DATA2_BLOCK11(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_TX_DATA2_BLOCK12(x)		((x) & 0x000000ff)

/* CEC_TX_DATA3_REG */
#define CEC_TX_DATA3_BLOCK13x(x)	(((x) & 0xff) << 24)
#define CEC_TX_DATA3_BLOCK14x(x)	(((x) & 0xff) << 16)
#define CEC_TX_DATA3_BLOCK15x(x)	(((x) & 0xff) << 8)
#define CEC_TX_DATA3_BLOCK16x(x)	((x) & 0xff)
#define CEC_TX_DATA3_BLOCK13(x)		(((x) & 0xff000000) >> 24)
#define CEC_TX_DATA3_BLOCK14(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_TX_DATA3_BLOCK15(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_TX_DATA3_BLOCK16(x)		((x) & 0x000000ff)

/* CEC_RX_DATA0_REG */
#define CEC_RX_DATA0_BLOCK1x(x)		(((x) & 0xff) << 24)
#define CEC_RX_DATA0_BLOCK2x(x)		(((x) & 0xff) << 16)
#define CEC_RX_DATA0_BLOCK3x(x)		(((x) & 0xff) << 8)
#define CEC_RX_DATA0_BLOCK4x(x)		((x) & 0xff)
#define CEC_RX_DATA0_BLOCK1(x)		(((x) & 0xff000000) >> 24)
#define CEC_RX_DATA0_BLOCK2(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_RX_DATA0_BLOCK3(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_RX_DATA0_BLOCK4(x)		((x) & 0x000000ff)

/* CEC_RX_DATA1_REG */
#define CEC_RX_DATA1_BLOCK5x(x)		(((x) & 0xff) << 24)
#define CEC_RX_DATA1_BLOCK6x(x)		(((x) & 0xff) << 16)
#define CEC_RX_DATA1_BLOCK7x(x)		(((x) & 0xff) << 8)
#define CEC_RX_DATA1_BLOCK8x(x)		((x) & 0xff)
#define CEC_RX_DATA1_BLOCK5(x)		(((x) & 0xff000000) >> 24)
#define CEC_RX_DATA1_BLOCK6(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_RX_DATA1_BLOCK7(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_RX_DATA1_BLOCK8(x)		((x) & 0x000000ff)

/* CEC_RX_DATA2_REG */
#define CEC_RX_DATA2_BLOCK9x(x)		(((x) & 0xff) << 24)
#define CEC_RX_DATA2_BLOCK10x(x)	(((x) & 0xff) << 16)
#define CEC_RX_DATA2_BLOCK11x(x)	(((x) & 0xff) << 8)
#define CEC_RX_DATA2_BLOCK12x(x)	((x) & 0xff)
#define CEC_RX_DATA2_BLOCK9(x)		(((x) & 0xff000000) >> 24)
#define CEC_RX_DATA2_BLOCK10(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_RX_DATA2_BLOCK11(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_RX_DATA2_BLOCK12(x)		((x) & 0x000000ff)

/* CEC_RX_DATA3_REG */
#define CEC_RX_DATA3_BLOCK13x(x)	(((x) & 0xff) << 24)
#define CEC_RX_DATA3_BLOCK14x(x)	(((x) & 0xff) << 16)
#define CEC_RX_DATA3_BLOCK15x(x)	(((x) & 0xff) << 8)
#define CEC_RX_DATA3_BLOCK16x(x)	((x) & 0xff)
#define CEC_RX_DATA3_BLOCK13(x)		(((x) & 0xff000000) >> 24)
#define CEC_RX_DATA3_BLOCK14(x)		(((x) & 0x00ff0000) >> 16)
#define CEC_RX_DATA3_BLOCK15(x)		(((x) & 0x0000ff00) >> 8)
#define CEC_RX_DATA3_BLOCK16(x)		((x) & 0x000000ff)

#endif /* #if (VOUT_SUPPORT_ONCHIP_CEC == 1) */

/* ---------------------------------------------------------------------- */

#endif


