/*
 * ambhw/vic.h
 *
 * History:
 *	2006/12/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2006-2008, Ambarella, Inc.
 */

#ifndef __AMBHW__VIC_H__
#define __AMBHW__VIC_H__

#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw/busaddr.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/

#if (CHIP_REV == A3) || (CHIP_REV == A5)  || (CHIP_REV == A6) || \
    (CHIP_REV ==A5S) || (CHIP_REV == A7M) || (CHIP_REV == A7) || \
    (CHIP_REV == A7L)
#define VIC_INSTANCES	2
#elif (CHIP_REV == I1)
#define VIC_INSTANCES	3
#else
#define VIC_INSTANCES	1
#endif


#if (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VIC_SUPPORT_CPU_OFFLOAD			1
#define VIC_SUPPORT_REPRIORITIZE_INTR_SRC	1
#else
#define VIC_SUPPORT_CPU_OFFLOAD			0	
#define VIC_SUPPORT_REPRIORITIZE_INTR_SRC	0
#endif


/*
 * VIC trigger types (SW definition).
 */
#define VIRQ_RISING_EDGE	0
#define VIRQ_FALLING_EDGE	1
#define VIRQ_BOTH_EDGES		2
#define VIRQ_LEVEL_LOW		3
#define VIRQ_LEVEL_HIGH		4

/****************************************************/
/* Controller registers definitions                 */
/****************************************************/

#define VIC_IRQ_STA_OFFSET		0x00
#define VIC_FIQ_STA_OFFSET		0x04
#define VIC_RAW_STA_OFFSET		0x08
#define VIC_INT_SEL_OFFSET		0x0c
#define VIC_INTEN_OFFSET		0x10
#define VIC_INTEN_CLR_OFFSET		0x14
#define VIC_SOFTEN_OFFSET		0x18
#define VIC_SOFTEN_CLR_OFFSET		0x1c
#define VIC_PROTEN_OFFSET		0x20
#define VIC_SENSE_OFFSET		0x24
#define VIC_BOTHEDGE_OFFSET		0x28
#define VIC_EVENT_OFFSET		0x2c
#define VIC_EDGE_CLR_OFFSET		0x38

/* CPU offload functions */
#if (VIC_SUPPORT_CPU_OFFLOAD == 1)
#define VIC_INT_SEL_INT_OFFSET			0x3c
#define VIC_INT_SEL_CLR_INT_OFFSET		0x40
#define VIC_INT_EN_INT_OFFSET			0x44
#define VIC_INT_EN_CLR_INT_OFFSET		0x48
#define VIC_SOFT_INT_INT_OFFSET			0x4c
#define VIC_SOFT_INT_CLR_INT_OFFSET		0x50
#define VIC_INT_SENSE_INT_OFFSET		0x54
#define VIC_INT_SENSE_CLR_INT_OFFSET		0x58
#define VIC_INT_BOTHEDGE_INT_OFFSET		0x5c
#define VIC_INT_BOTHEDGE_CLR_INT_OFFSET		0x60
#define VIC_INT_EVT_INT_OFFSET			0x64
#define VIC_INT_EVT_CLR_INT_OFFSET		0x68
#define VIC_INT_PENDING_OFFSET			0x6c
#endif

/* Priority and delay */
#if (VIC_SUPPORT_REPRIORITIZE_INTR_SRC == 1)
#define VIC_INT_RE_PRIORITIZE_EN_OFFSET		0x70
#define VIC_INT_PRIORITY_0_OFFSET		0x74
#define VIC_INT_PRIORITY_1_OFFSET		0x78
#define VIC_INT_PRIORITY_2_OFFSET		0x7c
#define VIC_INT_PRIORITY_3_OFFSET		0x80
#define VIC_INT_PRIORITY_4_OFFSET		0x84
#define VIC_INT_PRIORITY_5_OFFSET		0x88
#define VIC_INT_DELAY_EN_OFFSET			0x8c
#define VIC_INT_DELAY_OFFSET			0x90
#endif

#define VIC_IRQ_STA_REG			VIC_REG(VIC_IRQ_STA_OFFSET)
#define VIC_FIQ_STA_REG			VIC_REG(VIC_FIQ_STA_OFFSET)
#define VIC_RAW_STA_REG			VIC_REG(VIC_RAW_STA_OFFSET)
#define VIC_INT_SEL_REG			VIC_REG(VIC_INT_SEL_OFFSET)
#define VIC_INTEN_REG			VIC_REG(VIC_INTEN_OFFSET)
#define VIC_INTEN_CLR_REG		VIC_REG(VIC_INTEN_CLR_OFFSET)
#define VIC_SOFTEN_REG			VIC_REG(VIC_SOFTEN_OFFSET)
#define VIC_SOFTEN_CLR_REG		VIC_REG(VIC_SOFTEN_CLR_OFFSET)
#define VIC_PROTEN_REG			VIC_REG(VIC_PROTEN_OFFSET)
#define VIC_SENSE_REG			VIC_REG(VIC_SENSE_OFFSET)
#define VIC_BOTHEDGE_REG		VIC_REG(VIC_BOTHEDGE_OFFSET)
#define VIC_EVENT_REG			VIC_REG(VIC_EVENT_OFFSET)
#define VIC_EDGE_CLR_REG		VIC_REG(VIC_EDGE_CLR_OFFSET)


/* CPU offload functions */
#if (VIC_SUPPORT_CPU_OFFLOAD == 1)
#define VIC_INT_SEL_INT_REG		VIC_REG(VIC_INT_SEL_INT_OFFSET)
#define VIC_INT_SEL_CLR_INT_REG		VIC_REG(VIC_INT_SEL_CLR_INT_OFFSET)
#define VIC_INT_EN_INT_REG		VIC_REG(VIC_INT_EN_INT_OFFSET)
#define VIC_INT_EN_CLR_INT_REG		VIC_REG(VIC_INT_EN_CLR_INT_OFFSET)
#define VIC_SOFT_INT_INT_REG		VIC_REG(VIC_SOFT_INT_INT_OFFSET)
#define VIC_SOFT_INT_CLR_INT_REG	VIC_REG(VIC_SOFT_INT_CLR_INT_OFFSET)
#define VIC_INT_SENSE_INT_REG		VIC_REG(VIC_INT_SENSE_INT_OFFSET)
#define VIC_INT_SENSE_CLR_INT_REG	VIC_REG(VIC_INT_SENSE_CLR_INT_OFFSET)
#define VIC_INT_BOTHEDGE_INT_REG	VIC_REG(VIC_INT_BOTHEDGE_INT_OFFSET)
#define VIC_INT_BOTHEDGE_CLR_INT_REG	VIC_REG(VIC_INT_BOTHEDGE_CLR_INT_OFFSET)
#define VIC_INT_EVT_INT_REG		VIC_REG(VIC_INT_EVT_INT_OFFSET)
#define VIC_INT_EVT_CLR_INT_REG		VIC_REG(VIC_INT_EVT_CLR_INT_OFFSET)
#define VIC_INT_PENDING_REG		VIC_REG(VIC_INT_PENDING_OFFSET)
#endif

/* Priority and delay */
#if (VIC_SUPPORT_REPRIORITIZE_INTR_SRC == 1)
#define VIC_INT_RE_PRIORITIZE_EN_REG	VIC_REG(VIC_INT_RE_PRIORITIZE_EN_OFFSET)
#define VIC_INT_PRIORITY_0_REG		VIC_REG(VIC_INT_PRIORITY_0_OFFSET)
#define VIC_INT_PRIORITY_1_REG		VIC_REG(VIC_INT_PRIORITY_1_OFFSET)
#define VIC_INT_PRIORITY_2_REG		VIC_REG(VIC_INT_PRIORITY_2_OFFSET)
#define VIC_INT_PRIORITY_3_REG		VIC_REG(VIC_INT_PRIORITY_3_OFFSET)
#define VIC_INT_PRIORITY_4_REG		VIC_REG(VIC_INT_PRIORITY_4_OFFSET)
#define VIC_INT_PRIORITY_5_REG		VIC_REG(VIC_INT_PRIORITY_5_OFFSET)
#define VIC_INT_DELAY_EN_REG		VIC_REG(VIC_INT_DELAY_EN_OFFSET)
#define VIC_INT_DELAY_REG		VIC_REG(VIC_INT_DELAY_OFFSET)
#endif

#if (VIC_INSTANCES >= 2)

#define VIC2_IRQ_STA_REG		VIC2_REG(VIC_IRQ_STA_OFFSET)
#define VIC2_FIQ_STA_REG		VIC2_REG(VIC_FIQ_STA_OFFSET)
#define VIC2_RAW_STA_REG		VIC2_REG(VIC_RAW_STA_OFFSET)
#define VIC2_INT_SEL_REG		VIC2_REG(VIC_INT_SEL_OFFSET)
#define VIC2_INTEN_REG			VIC2_REG(VIC_INTEN_OFFSET)
#define VIC2_INTEN_CLR_REG		VIC2_REG(VIC_INTEN_CLR_OFFSET)
#define VIC2_SOFTEN_REG			VIC2_REG(VIC_SOFTEN_OFFSET)
#define VIC2_SOFTEN_CLR_REG		VIC2_REG(VIC_SOFTEN_CLR_OFFSET)
#define VIC2_PROTEN_REG			VIC2_REG(VIC_PROTEN_OFFSET)
#define VIC2_SENSE_REG			VIC2_REG(VIC_SENSE_OFFSET)
#define VIC2_BOTHEDGE_REG		VIC2_REG(VIC_BOTHEDGE_OFFSET)
#define VIC2_EVENT_REG			VIC2_REG(VIC_EVENT_OFFSET)
#define VIC2_EDGE_CLR_REG		VIC2_REG(VIC_EDGE_CLR_OFFSET)

/* CPU offload functions */
#if (VIC_SUPPORT_CPU_OFFLOAD == 1)
#define VIC2_INT_SEL_INT_REG		VIC2_REG(VIC_INT_SEL_INT_OFFSET)
#define VIC2_INT_SEL_CLR_INT_REG	VIC2_REG(VIC_INT_SEL_CLR_INT_OFFSET)
#define VIC2_INT_EN_INT_REG		VIC2_REG(VIC_INT_EN_INT_OFFSET)
#define VIC2_INT_EN_CLR_INT_REG		VIC2_REG(VIC_INT_EN_CLR_INT_OFFSET)
#define VIC2_SOFT_INT_INT_REG		VIC2_REG(VIC_SOFT_INT_INT_OFFSET)
#define VIC2_SOFT_INT_CLR_INT_REG	VIC2_REG(VIC_SOFT_INT_CLR_INT_OFFSET)
#define VIC2_INT_SENSE_INT_REG		VIC2_REG(VIC_INT_SENSE_INT_OFFSET)
#define VIC2_INT_SENSE_CLR_INT_REG	VIC2_REG(VIC_INT_SENSE_CLR_INT_OFFSET)
#define VIC2_INT_BOTHEDGE_INT_REG	VIC2_REG(VIC_INT_BOTHEDGE_INT_OFFSET)
#define VIC2_INT_BOTHEDGE_CLR_INT_REG	VIC2_REG(VIC_INT_BOTHEDGE_CLR_INT_OFFSET)
#define VIC2_INT_EVT_INT_REG		VIC2_REG(VIC_INT_EVT_INT_OFFSET)
#define VIC2_INT_EVT_CLR_INT_REG	VIC2_REG(VIC_INT_EVT_CLR_INT_OFFSET)
#define VIC2_INT_PENDING_REG		VIC2_REG(VIC_INT_PENDING_OFFSET)
#endif

/* Priority and delay */
#if (VIC_SUPPORT_REPRIORITIZE_INTR_SRC == 1)
#define VIC2_INT_RE_PRIORITIZE_EN_REG	VIC2_REG(VIC_INT_RE_PRIORITIZE_EN_OFFSET)
#define VIC2_INT_PRIORITY_0_REG		VIC2_REG(VIC_INT_PRIORITY_0_OFFSET)
#define VIC2_INT_PRIORITY_1_REG		VIC2_REG(VIC_INT_PRIORITY_1_OFFSET)
#define VIC2_INT_PRIORITY_2_REG		VIC2_REG(VIC_INT_PRIORITY_2_OFFSET)
#define VIC2_INT_PRIORITY_3_REG		VIC2_REG(VIC_INT_PRIORITY_3_OFFSET)
#define VIC2_INT_PRIORITY_4_REG		VIC2_REG(VIC_INT_PRIORITY_4_OFFSET)
#define VIC2_INT_PRIORITY_5_REG		VIC2_REG(VIC_INT_PRIORITY_5_OFFSET)
#define VIC2_INT_DELAY_EN_REG		VIC2_REG(VIC_INT_DELAY_EN_OFFSET)
#define VIC2_INT_DELAY_REG		VIC2_REG(VIC_INT_DELAY_OFFSET)
#endif

#endif

#if (VIC_INSTANCES >= 3)

#define VIC3_IRQ_STA_REG		VIC3_REG(VIC_IRQ_STA_OFFSET)
#define VIC3_FIQ_STA_REG		VIC3_REG(VIC_FIQ_STA_OFFSET)
#define VIC3_RAW_STA_REG		VIC3_REG(VIC_RAW_STA_OFFSET)
#define VIC3_INT_SEL_REG		VIC3_REG(VIC_INT_SEL_OFFSET)
#define VIC3_INTEN_REG			VIC3_REG(VIC_INTEN_OFFSET)
#define VIC3_INTEN_CLR_REG		VIC3_REG(VIC_INTEN_CLR_OFFSET)
#define VIC3_SOFTEN_REG			VIC3_REG(VIC_SOFTEN_OFFSET)
#define VIC3_SOFTEN_CLR_REG		VIC3_REG(VIC_SOFTEN_CLR_OFFSET)
#define VIC3_PROTEN_REG			VIC3_REG(VIC_PROTEN_OFFSET)
#define VIC3_SENSE_REG			VIC3_REG(VIC_SENSE_OFFSET)
#define VIC3_BOTHEDGE_REG		VIC3_REG(VIC_BOTHEDGE_OFFSET)
#define VIC3_EVENT_REG			VIC3_REG(VIC_EVENT_OFFSET)
#define VIC3_EDGE_CLR_REG		VIC3_REG(VIC_EDGE_CLR_OFFSET)

/* CPU offload functions */
#if (VIC_SUPPORT_CPU_OFFLOAD == 1)
#define VIC3_INT_SEL_INT_REG		VIC3_REG(VIC_INT_SEL_INT_OFFSET)
#define VIC3_INT_SEL_CLR_INT_REG	VIC3_REG(VIC_INT_SEL_CLR_INT_OFFSET)
#define VIC3_INT_EN_INT_REG		VIC3_REG(VIC_INT_EN_INT_OFFSET)
#define VIC3_INT_EN_CLR_INT_REG		VIC3_REG(VIC_INT_EN_CLR_INT_OFFSET)
#define VIC3_SOFT_INT_INT_REG		VIC3_REG(VIC_SOFT_INT_INT_OFFSET)
#define VIC3_SOFT_INT_CLR_INT_REG	VIC3_REG(VIC_SOFT_INT_CLR_INT_OFFSET)
#define VIC3_INT_SENSE_INT_REG		VIC3_REG(VIC_INT_SENSE_INT_OFFSET)
#define VIC3_INT_SENSE_CLR_INT_REG	VIC3_REG(VIC_INT_SENSE_CLR_INT_OFFSET)
#define VIC3_INT_BOTHEDGE_INT_REG	VIC3_REG(VIC_INT_BOTHEDGE_INT_OFFSET)
#define VIC3_INT_BOTHEDGE_CLR_INT_REG	VIC3_REG(VIC_INT_BOTHEDGE_CLR_INT_OFFSET)
#define VIC3_INT_EVT_INT_REG		VIC3_REG(VIC_INT_EVT_INT_OFFSET)
#define VIC3_INT_EVT_CLR_INT_REG	VIC3_REG(VIC_INT_EVT_CLR_INT_OFFSET)
#define VIC3_INT_PENDING_REG		VIC3_REG(VIC_INT_PENDING_OFFSET)
#endif

/* Priority and delay */
#if (VIC_SUPPORT_REPRIORITIZE_INTR_SRC == 1)
#define VIC3_INT_RE_PRIORITIZE_EN_REG	VIC3_REG(VIC_INT_RE_PRIORITIZE_EN_OFFSET)
#define VIC3_INT_PRIORITY_0_REG		VIC3_REG(VIC_INT_PRIORITY_0_OFFSET)
#define VIC3_INT_PRIORITY_1_REG		VIC3_REG(VIC_INT_PRIORITY_1_OFFSET)
#define VIC3_INT_PRIORITY_2_REG		VIC3_REG(VIC_INT_PRIORITY_2_OFFSET)
#define VIC3_INT_PRIORITY_3_REG		VIC3_REG(VIC_INT_PRIORITY_3_OFFSET)
#define VIC3_INT_PRIORITY_4_REG		VIC3_REG(VIC_INT_PRIORITY_4_OFFSET)
#define VIC3_INT_PRIORITY_5_REG		VIC3_REG(VIC_INT_PRIORITY_5_OFFSET)
#define VIC3_INT_DELAY_EN_REG		VIC3_REG(VIC_INT_DELAY_EN_OFFSET)
#define VIC3_INT_DELAY_REG		VIC3_REG(VIC_INT_DELAY_OFFSET)
#endif

#endif

#endif
