 /*
 * ambhw/vout.h
 *
 * History:
 *	2007/01/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2006-2008, Ambarella, Inc.
 */

#ifndef __AMBHW_VOUT_H__
#define __AMBHW_VOUT_H__

#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw/busaddr.h>
#include <asm/arch/ambhw/hdmi.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/
#if (CHIP_REV == A1) || (CHIP_REV == A2) ||	\
    (CHIP_REV == A2S) || (CHIP_REV == A2M) || (CHIP_REV == A2Q)
#define VOUT_SUPPORT_DIGITAL_1080P	0
#define VOUT_LCD_COLOR_SEQ_OUT_WA	0
#elif (CHIP_REV == A5S) || (CHIP_REV == A5L) 
#define VOUT_SUPPORT_DIGITAL_1080P	0
#define VOUT_LCD_COLOR_SEQ_OUT_WA	1
#else
/* (CHIP_REV == A7) || (CHIP_REV == I1) || (CHIP_REV == A7L) */
#define VOUT_SUPPORT_DIGITAL_1080P	1
#define VOUT_LCD_COLOR_SEQ_OUT_WA	1
#endif

#if (CHIP_REV == A1) || (CHIP_REV == A2)
#define VOUT_SUPPORT_HDTV_50HZ		0
#define VOUT_SUPPORT_ANA_PRIM_CSC	0
#define VOUT_SUPPORT_DIGITAL_CSC	0
#define VOUT_SUPPORT_ONCHIP_CEC		0
#define VOUT_SUPPORT_DCLK_ENA		0
#define VOUT_SUPPROT_ANA_HD_SCALING	1
#else
#define VOUT_SUPPORT_HDTV_50HZ		1
#define VOUT_SUPPORT_ANA_PRIM_CSC	1
#define VOUT_SUPPORT_DIGITAL_CSC	1
#define VOUT_SUPPORT_ONCHIP_CEC		1
#define VOUT_SUPPORT_DCLK_ENA		1
#define VOUT_SUPPROT_ANA_HD_SCALING	0
#endif

#if (CHIP_REV == A1)
#define VOUT_SUPPORT_FPS_59P94		0
#define VOUT_SUPPORT_ADV_VBI_CTL	0
#define VOUT_SUPPORT_VBI_LVL_ADJ	0
#define VOUT_SUPPORT_SMEM_PREVIEW	0
#else
#define VOUT_SUPPORT_FPS_59P94		1
#define VOUT_SUPPORT_ADV_VBI_CTL	1
#define VOUT_SUPPORT_VBI_LVL_ADJ	1
#define VOUT_SUPPORT_SMEM_PREVIEW	1
#endif

#if (CHIP_REV == A1)
#define VOUT_SUPPORT_DIGITAL_FMT656     0
#else
#define VOUT_SUPPORT_DIGITAL_FMT656     1
#endif


#if (CHIP_REV == A1)
#define VOUT_SUPPORT_VBI_CTL_TYPE	1
#elif (CHIP_REV == A2) || (CHIP_REV == A2S) || (CHIP_REV == A5L)
#define VOUT_SUPPORT_VBI_CTL_TYPE	2
#else
#define VOUT_SUPPORT_VBI_CTL_TYPE	3
#endif

#if (CHIP_REV == A1)  || (CHIP_REV == A2)  || \
    (CHIP_REV == A2S) || (CHIP_REV == A2M) || (CHIP_REV == A2Q)
#define VOUT_INSTANCES			1
#else
#define VOUT_INSTANCES			2
#endif

#if (CHIP_REV == A6) || (CHIP_REV == A5S) || (CHIP_REV == A7) || \
    (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VOUT_SUPPORT_RGB24			1
#define VOUT_SUPPORT_ANALOG_CSC_SCALER		1
#define VOUT_SUPPORT_DUAL_VOUT_SYNC		1
#define VOUT_SUPPORT_CONFIG_DIGI_FMT656		1
#define VOUT_SUPPORT_OUTPUT_INTERN_DIVIDED_CLK  1
#else
#define VOUT_SUPPORT_RGB24			0
#define VOUT_SUPPORT_ANALOG_CSC_SCALER		0
#define VOUT_SUPPORT_DUAL_VOUT_SYNC		0
#define VOUT_SUPPORT_CONFIG_DIGI_FMT656		0
#define VOUT_SUPPORT_OUTPUT_INTERN_DIVIDED_CLK  0
#endif

#if (CHIP_REV == A6)
#define VOUT_SUPPORT_601_8_BIT_CBYCRY	0
#else
#define VOUT_SUPPORT_601_8_BIT_CBYCRY	1
#endif

#if (CHIP_REV == A6) || (CHIP_REV == A5S) || (CHIP_REV == A7) || \
    (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VOUT_DISPLAY_SECTIONS		2
#define VOUT_DIRECT_DSP_INTERFACE	1
#define VOUT_16B_DVOUT_Y_LOW_BYTE	1
#define VOUT_8_BITS_BLENDING		1
#else
#define VOUT_DISPLAY_SECTIONS		1
#define VOUT_DIRECT_DSP_INTERFACE	0
#define VOUT_16B_DVOUT_Y_LOW_BYTE	0
#define VOUT_8_BITS_BLENDING		0
#endif

#if (CHIP_REV == A2S) || (CHIP_REV == A2M) || (CHIP_REV == A6) || \
    (CHIP_REV == A2Q) || (CHIP_REV == A5S) || (CHIP_REV == A7) || \
    (CHIP_REV == I1)  || (CHIP_REV == A7L)
#define VOUT_SUPPORT_8BIT_SD_DOUT	1
#else
#define VOUT_SUPPORT_8BIT_SD_DOUT	0
#endif

#if (CHIP_REV == A5S) || (CHIP_REV == I1)
#define VOUT_SUPPORT_MIPI		1
#else
#define VOUT_SUPPORT_MIPI		0
#endif

#if (CHIP_REV == A6) || (CHIP_REV == A7) || (CHIP_REV == I1)
#define VOUT_SUPPORT_ORC_MULTI_THREADS	1
#else
#define VOUT_SUPPORT_ORC_MULTI_THREADS	0
#endif

#if (CHIP_REV == A7) || (CHIP_REV == I1) || (CHIP_REV == A7L)
#define VOUT_SUPPORT_DIGITAL_DITHER	1
#define VOUT_SUPPORT_GAMMA_TABLE	1
#else
#define VOUT_SUPPORT_DIGITAL_DITHER	0
#define VOUT_SUPPORT_GAMMA_TABLE	0
#endif

#if (CHIP_REV == I1)
#define VOUT_DCHAN_ANALOG_OUT		1
#define VOUT_HALF_PIXEL_SHIFT		1
#else
#define VOUT_DCHAN_ANALOG_OUT		0
#define VOUT_HALF_PIXEL_SHIFT		0
#endif

#if (CHIP_REV == A5L) || (CHIP_REV == A7L)
#define VOUT_SUPPORT_OSD_16BIT_DIR_MODE 1
#define VOUT_SUPPORT_OSD_CSC		1
#else
#define VOUT_SUPPORT_OSD_16BIT_DIR_MODE 0
#define VOUT_SUPPORT_OSD_CSC		0
#endif

#if (CHIP_REV == A7L)
#define VOUT_HVLD_POLARITY		1
#else
#define VOUT_HVLD_POLARITY		0
#endif

/****************************************************/
/* Controller registers definitions                 */
/****************************************************/

/* ---------------------------------------------------------------------- */

/****************************/
/* VOUT registers           */
/****************************/

/* DVE registers */
#define	VOUT_DVE_PHI_7_0_OFFSET		0x080
#define	VOUT_DVE_PHI_15_8_OFFSET	0x084
#define	VOUT_DVE_PHI_16_23_OFFSET	0x088
#define	VOUT_DVE_PHI_24_31_OFFSET	0x08c
#define	VOUT_DVE_SCTOH_7_0_OFFSET	0x090
#define	VOUT_DVE_SCTOH_15_8_OFFSET	0x094
#define	VOUT_DVE_SCTOH_23_16_OFFSET	0x098
#define	VOUT_DVE_SCTOH_31_24_OFFSET	0x09c
#define	VOUT_DVE_DVE40_OFFSET		0x0a0
#define	VOUT_DVE_BLACK_LVL_OFFSET	0x0a8
#define	VOUT_DVE_BLANK_LVL_OFFSET	0x0ac
#define	VOUT_DVE_CLAMP_LVL_OFFSET	0x0b0
#define	VOUT_DVE_SYNC_LVL_OFFSET	0x0b4
#define	VOUT_DVE_DVE46_OFFSET		0x0b8
#define	VOUT_DVE_DVE47_OFFSET		0x0bc
#define	VOUT_DVE_NBA_OFFSET		0x0c8
#define	VOUT_DVE_PBA_OFFSET		0x0cc
#define	VOUT_DVE_DVE52_OFFSET		0x0d0
#define	VOUT_DVE_DVE56_OFFSET		0x0e0
#define	VOUT_DVE_DVE57_OFFSET		0x0e4
#define	VOUT_DVE_VSO_7_0_OFFSET		0x0e8
#define	VOUT_DVE_HSO_10_8_OFFSET	0x0ec
#define	VOUT_DVE_HSO_7_0_OFFSET		0x0f0
#define	VOUT_DVE_HCL_9_8_OFFSET		0x0f4
#define	VOUT_DVE_HCL_7_0_OFFSET		0x0f8
#define	VOUT_DVE_CCD_ODD_15_8_OFFSET	0x104
#define	VOUT_DVE_CCD_ODD_7_0_OFFSET	0x108
#define	VOUT_DVE_CCD_EVEN_15_8_OFFSET	0x10c
#define	VOUT_DVE_CCD_EVEN_7_0_OFFSET	0x110
#define	VOUT_DVE_CC_ENBL_OFFSET		0x114
#define VOUT_DVE_MVFCR_OFFSET		0x120
#define VOUT_DVE_MVCSL1_5_0_OFFSET	0x124
#define VOUT_DVE_MVCLS1_5_0_OFFSET	0x128
#define VOUT_DVE_MVCSL2_5_0_OFFSET	0x12c
#define VOUT_DVE_MVCLS2_5_0_OFFSET	0x130
#define VOUT_DVE_DVE77_OFFSET		0x134
#define VOUT_DVE_MVPSD_5_0_OFFSET	0x138
#define VOUT_DVE_MVPSL_5_0_OFFSET	0x13c
#define VOUT_DVE_MVPSS_5_0_OFFSET	0x140
#define VOUT_DVE_MVPSLS_14_8_OFFSET	0x144
#define VOUT_DVE_MVPSLS_7_0_OFFSET	0x148
#define VOUT_DVE_MVPSFS_14_8_OFFSET	0x14c
#define VOUT_DVE_MVPSFS_OFFSET		0x150
#define VOUT_DVE_MVPSAGCA_OFFSET	0x154
#define VOUT_DVE_MVPSAGCB_OFFSET	0x158
#define VOUT_DVE_MVEOFBPC_OFFSET	0x15c
#define VOUT_DVE_DVE88_OFFSET		0x160
#define VOUT_DVE_DVE89_OFFSET		0x164
#define VOUT_DVE_MVPCSLIMD_7_0_OFFSET	0x168
#define VOUT_DVE_MVPCSLIMD_9_8_OFFSET	0x16c
#define VOUT_DVE_DVE96_OFFSET		0x180
#define VOUT_DVE_DVE97_OFFSET		0x184
#define VOUT_DVE_DVE99_OFFSET		0x18c
#define VOUT_DVE_MVTMS_3_0_OFFSET	0x190
#define VOUT_DVE_HLR_9_8_OFFSET		0x1b4
#define VOUT_DVE_HLR_7_0_OFFSET		0x1b8
#define VOUT_DVE_VSMR_4_0_OFFSET	0x1bc
#define VOUT_DVE_DVE116_OFFSET		0x1d0
#define VOUT_DVE_DVE117_OFFSET		0x1d4
#define VOUT_DVE_DVE118_OFFSET		0x1d8
#define VOUT_DVE_DVE119_OFFSET		0x1dc
#define VOUT_DVE_DVE120_OFFSET		0x1e0
#define VOUT_DVE_DVE121_OFFSET		0x1e4
#define VOUT_DVE_DVE122_OFFSET		0x1e8
#define VOUT_DVE_DVE123_OFFSET		0x1ec
#define VOUT_DVE_DVE124_OFFSET		0x1f0
#define VOUT_DVE_DVE128_OFFSET		0x200

/* DVE registers */
#define	VOUT_DVE_PHI_7_0_REG		VOUT_REG(0x80)
#define	VOUT_DVE_PHI_15_8_REG		VOUT_REG(0x84)
#define	VOUT_DVE_PHI_16_23_REG		VOUT_REG(0x88)
#define	VOUT_DVE_PHI_24_31_REG		VOUT_REG(0x8c)
#define	VOUT_DVE_SCTOH_7_0_REG		VOUT_REG(0x90)
#define	VOUT_DVE_SCTOH_15_8_REG		VOUT_REG(0x94)
#define	VOUT_DVE_SCTOH_23_16_REG	VOUT_REG(0x98)
#define	VOUT_DVE_SCTOH_31_24_REG	VOUT_REG(0x9c)
#define	VOUT_DVE_DVE40_REG		VOUT_REG(0xa0)
#define	VOUT_DVE_BLACK_LVL_REG		VOUT_REG(0xa8)
#define	VOUT_DVE_BLANK_LVL_REG		VOUT_REG(0xac)
#define	VOUT_DVE_CLAMP_LVL_REG		VOUT_REG(0xb0)
#define	VOUT_DVE_SYNC_LVL_REG		VOUT_REG(0xb4)
#define	VOUT_DVE_DVE46_REG		VOUT_REG(0xb8)
#define	VOUT_DVE_DVE47_REG		VOUT_REG(0xbc)
#define	VOUT_DVE_NBA_REG		VOUT_REG(0xc8)
#define	VOUT_DVE_PBA_REG		VOUT_REG(0xcc)
#define	VOUT_DVE_DVE52_REG		VOUT_REG(0xd0)
#define	VOUT_DVE_DVE56_REG		VOUT_REG(0xe0)
#define	VOUT_DVE_DVE57_REG		VOUT_REG(0xe4)
#define	VOUT_DVE_VSO_7_0_REG		VOUT_REG(0xe8)
#define	VOUT_DVE_HSO_10_8_REG		VOUT_REG(0xec)
#define	VOUT_DVE_HSO_7_0_REG		VOUT_REG(0xf0)
#define	VOUT_DVE_HCL_9_8_REG		VOUT_REG(0xf4)
#define	VOUT_DVE_HCL_7_0_REG		VOUT_REG(0xf8)
#define	VOUT_DVE_CCD_ODD_15_8_REG	VOUT_REG(0x104)
#define	VOUT_DVE_CCD_ODD_7_0_REG	VOUT_REG(0x108)
#define	VOUT_DVE_CCD_EVEN_15_8_REG	VOUT_REG(0x10c)
#define	VOUT_DVE_CCD_EVEN_7_0_REG	VOUT_REG(0x110)
#define	VOUT_DVE_CC_ENBL_REG		VOUT_REG(0x114)
#define VOUT_DVE_MVFCR_REG		VOUT_REG(0x120)
#define VOUT_DVE_MVCSL1_5_0_REG		VOUT_REG(0x124)
#define VOUT_DVE_MVCLS1_5_0_REG		VOUT_REG(0x128)
#define VOUT_DVE_MVCSL2_5_0_REG		VOUT_REG(0x12c)
#define VOUT_DVE_MVCLS2_5_0_REG		VOUT_REG(0x130)
#define VOUT_DVE_DVE77_REG		VOUT_REG(0x134)
#define VOUT_DVE_MVPSD_5_0_REG		VOUT_REG(0x138)
#define VOUT_DVE_MVPSL_5_0_REG		VOUT_REG(0x13c)
#define VOUT_DVE_MVPSS_5_0_REG		VOUT_REG(0x140)
#define VOUT_DVE_MVPSLS_14_8_REG	VOUT_REG(0x144)
#define VOUT_DVE_MVPSLS_7_0_REG		VOUT_REG(0x148)
#define VOUT_DVE_MVPSFS_14_8_REG	VOUT_REG(0x14c)
#define VOUT_DVE_MVPSFS_REG		VOUT_REG(0x150)
#define VOUT_DVE_MVPSAGCA_REG		VOUT_REG(0x154)
#define VOUT_DVE_MVPSAGCB_REG		VOUT_REG(0x158)
#define VOUT_DVE_MVEOFBPC_REG		VOUT_REG(0x15c)
#define VOUT_DVE_DVE88_REG		VOUT_REG(0x160)
#define VOUT_DVE_DVE89_REG		VOUT_REG(0x164)
#define VOUT_DVE_MVPCSLIMD_7_0_REG	VOUT_REG(0x168)
#define VOUT_DVE_MVPCSLIMD_9_8_REG	VOUT_REG(0x16c)
#define VOUT_DVE_DVE96_REG		VOUT_REG(0x180)
#define VOUT_DVE_DVE97_REG		VOUT_REG(0x184)
#define VOUT_DVE_DVE99_REG		VOUT_REG(0x18c)
#define VOUT_DVE_MVTMS_3_0_REG		VOUT_REG(0x190)
#define VOUT_DVE_HLR_9_8_REG		VOUT_REG(0x1b4)
#define VOUT_DVE_HLR_7_0_REG		VOUT_REG(0x1b8)
#define VOUT_DVE_VSMR_4_0_REG		VOUT_REG(0x1bc)
#define VOUT_DVE_DVE116_REG		VOUT_REG(0x1d0)
#define VOUT_DVE_DVE117_REG		VOUT_REG(0x1d4)
#define VOUT_DVE_DVE118_REG		VOUT_REG(0x1d8)
#define VOUT_DVE_DVE119_REG		VOUT_REG(0x1dc)
#define VOUT_DVE_DVE120_REG		VOUT_REG(0x1e0)
#define VOUT_DVE_DVE121_REG		VOUT_REG(0x1e4)
#define VOUT_DVE_DVE122_REG		VOUT_REG(0x1e8)
#define VOUT_DVE_DVE123_REG		VOUT_REG(0x1ec)
#define VOUT_DVE_DVE124_REG		VOUT_REG(0x1f0)
#define VOUT_DVE_DVE128_REG		VOUT_REG(0x200)


#if (VOUT_DISPLAY_SECTIONS == 1)

#define VOUT_CTL_CONTROL_OFFSET		0x400
#define VOUT_CTL_STATUS_OFFSET		0x404
#define VOUT_CTL_HV_OFFSET		0x408
#define VOUT_CTL_HSYNC_OFFSET		0x40c
#define VOUT_CTL_VSYNC0_OFFSET		0x410
#define VOUT_CTL_VSYNC1_OFFSET		0x414
#define VOUT_CTL_ACTSTART_OFFSET	0x418
#define VOUT_CTL_ACTEND_OFFSET		0x41c
#define VOUT_CTL_VIDSTART_OFFSET	0x420
#define VOUT_CTL_VIDEND_OFFSET		0x424
#define VOUT_CTL_BG_OFFSET		0x428
#define VOUT_CTL_THRESH_OFFSET		0x42c
#define VOUT_CTL_VBI_OFFSET		0x430
#define VOUT_CTL_UPSAMPLE_OFFSET	0x434
#define VOUT_LCD_CTRL_OFFSET		0x438
#define VOUT_LCD_CLKPATN0_OFFSET	0x43c
#define VOUT_LCD_CLKPATN1_OFFSET	0x440
#define VOUT_LCD_CLKPATN2_OFFSET	0x444
#define VOUT_LCD_CLKPATN3_OFFSET	0x448
#define VOUT_LCD_CLKPATN4_OFFSET	0x44c
#define VOUT_LCD_CLKPATN5_OFFSET	0x450
#define VOUT_LCD_CLKPATN6_OFFSET	0x454
#define VOUT_LCD_CLKPATN7_OFFSET	0x458
#define VOUT_CTL_OSD0_CTRL_OFFSET	0x45c
#define VOUT_CTL_OSD0_START_OFFSET	0x460
#define VOUT_CTL_OSD0_END_OFFSET	0x464
#define VOUT_CTL_OSD1_CTRL_OFFSET	0x468
#define VOUT_CTL_OSD1_START_OFFSET	0x46c
#define VOUT_CTL_OSD1_END_OFFSET	0x470
#define VOUT_CTL_CUR_OFFSET		0x474
#define VOUT_CTL_V1_OFFSET		0x49c
#define VOUT_CTL_HD_Y_COEF_OFFSET	0x640
#define VOUT_CTL_HD_PB_COEF_OFFSET	0x644
#define VOUT_CTL_HD_PR_COEF_OFFSET	0x648
#define VOUT_CTL_HD_Y_CONST_OFFSET	0x64c
#define VOUT_CTL_HD_PB_CONST_OFFSET	0x650
#define VOUT_CTL_HD_PR_CONST_OFFSET	0x654
#define VOUT_CTL_SD_Y_COEF_OFFSET	0x660
#define VOUT_CTL_SD_PB_COEF_OFFSET	0x664
#define VOUT_CTL_SD_PR_COEF_OFFSET	0x668
#define VOUT_CTL_CLUT_OFFSET		0x800
#define VOUT_CTL_CURSORB_OFFSET		0xc00
#define VOUT_CTL_CURSORP_OFFSET		0xc80
#define VOUT_VBI_RA_OFFSET		0x478

#define VOUT_CTL_CONTROL_REG		VOUT_REG(0x400)
#define VOUT_CTL_STATUS_REG		VOUT_REG(0x404)
#define VOUT_CTL_HV_REG			VOUT_REG(0x408)
#define VOUT_CTL_HSYNC_REG		VOUT_REG(0x40c)
#define VOUT_CTL_VSYNC0_REG		VOUT_REG(0x410)
#define VOUT_CTL_VSYNC1_REG		VOUT_REG(0x414)
#define VOUT_CTL_ACTSTART_REG		VOUT_REG(0x418)
#define VOUT_CTL_ACTEND_REG		VOUT_REG(0x41c)
#define VOUT_CTL_VIDSTART_REG		VOUT_REG(0x420)
#define VOUT_CTL_VIDEND_REG		VOUT_REG(0x424)
#define VOUT_CTL_BG_REG			VOUT_REG(0x428)
#define VOUT_CTL_THRESH_REG		VOUT_REG(0x42c)
#define VOUT_CTL_VBI_REG		VOUT_REG(0x430)
#define VOUT_CTL_UPSAMPLE_REG		VOUT_REG(0x434)
#define VOUT_LCD_CTRL_REG		VOUT_REG(0x438)
#define VOUT_LCD_CLKPATN0_REG		VOUT_REG(0x43c)
#define VOUT_LCD_CLKPATN1_REG		VOUT_REG(0x440)
#define VOUT_LCD_CLKPATN2_REG		VOUT_REG(0x444)
#define VOUT_LCD_CLKPATN3_REG		VOUT_REG(0x448)
#define VOUT_LCD_CLKPATN4_REG		VOUT_REG(0x44c)
#define VOUT_LCD_CLKPATN5_REG		VOUT_REG(0x450)
#define VOUT_LCD_CLKPATN6_REG		VOUT_REG(0x454)
#define VOUT_LCD_CLKPATN7_REG		VOUT_REG(0x458)
#define VOUT_CTL_OSD0_CTRL_REG		VOUT_REG(0x45c)
#define VOUT_CTL_OSD0_START_REG		VOUT_REG(0x460)
#define VOUT_CTL_OSD0_END_REG		VOUT_REG(0x464)
#define VOUT_CTL_OSD1_CTRL_REG		VOUT_REG(0x468)
#define VOUT_CTL_OSD1_START_REG		VOUT_REG(0x46c)
#define VOUT_CTL_OSD1_END_REG		VOUT_REG(0x470)
#define VOUT_CTL_CUR_REG		VOUT_REG(0x474)
#define VOUT_CTL_V1_REG			VOUT_REG(0x49c)
#define VOUT_CTL_HD_Y_COEF_REG		VOUT_REG(0x640)
#define VOUT_CTL_HD_PB_COEF_REG		VOUT_REG(0x644)
#define VOUT_CTL_HD_PR_COEF_REG		VOUT_REG(0x648)
#define VOUT_CTL_HD_Y_CONST_REG		VOUT_REG(0x64c)
#define VOUT_CTL_HD_PB_CONST_REG	VOUT_REG(0x650)
#define VOUT_CTL_HD_PR_CONST_REG	VOUT_REG(0x654)
#define VOUT_CTL_SD_Y_COEF_REG		VOUT_REG(0x660)
#define VOUT_CTL_SD_PB_COEF_REG		VOUT_REG(0x664)
#define VOUT_CTL_SD_PR_COEF_REG		VOUT_REG(0x668)
#define VOUT_CTL_CLUT_REG		VOUT_REG(0x800)
#define VOUT_CTL_CURSORB_REG		VOUT_REG(0xc00)
#define VOUT_CTL_CURSORP_REG		VOUT_REG(0xc80)
#define VOUT_VBI_RA_REG			VOUT_REG(0x478)

#if (VOUT_SUPPORT_ADV_VBI_CTL == 1)
#define VOUT_VBI_END_COL_OFFSET		0x4ac
#define VOUT_VBI_LEVEL_OFFSET		0x4b0
#define VOUT_VBI_END_COL_REG		VOUT_REG(0x4ac)
#define VOUT_VBI_LEVEL_REG		VOUT_REG(0x4b0)
#endif

/* ---------------------------------------------------------------------- */
#if (VOUT_SUPPORT_DIGITAL_CSC == 1)

#define	VOUT_CTL_PRI_CSC_COEF0_OFFSET	0x66c
#define	VOUT_CTL_PRI_CSC_COEF1_OFFSET	0x670
#define	VOUT_CTL_PRI_CSC_COEF2_OFFSET	0x674
#define	VOUT_CTL_PRI_CSC_COEF3_OFFSET	0x678
#define	VOUT_CTL_PRI_CSC_COEF4_OFFSET	0x67c
#define	VOUT_CTL_PRI_CSC_COEF5_OFFSET	0x680
#define	VOUT_CTL_PRI_CSC_CLIP0_OFFSET	0x684
#define	VOUT_CTL_PRI_CSC_CLIP1_OFFSET	0x688
#define	VOUT_CTL_PRI_CSC_CLIP2_OFFSET	0x68c

#define	VOUT_CTL_OSD_CSC_COEF0_OFFSET	0x6b4
#define	VOUT_CTL_OSD_CSC_COEF1_OFFSET	0x6b8
#define	VOUT_CTL_OSD_CSC_COEF2_OFFSET	0x6bc
#define	VOUT_CTL_OSD_CSC_COEF3_OFFSET	0x6c0
#define	VOUT_CTL_OSD_CSC_COEF4_OFFSET	0x6c4
#define	VOUT_CTL_OSD_CSC_COEF5_OFFSET	0x6c8
#define	VOUT_CTL_OSD_CSC_CLIP0_OFFSET	0x6cc
#define	VOUT_CTL_OSD_CSC_CLIP1_OFFSET	0x6d0
#define	VOUT_CTL_OSD_CSC_CLIP2_OFFSET	0x6d4

#define	VOUT_CTL_PRI_CSC_COEF0_REG	VOUT_REG(0x66c)
#define	VOUT_CTL_PRI_CSC_COEF1_REG	VOUT_REG(0x670)
#define	VOUT_CTL_PRI_CSC_COEF2_REG	VOUT_REG(0x674)
#define	VOUT_CTL_PRI_CSC_COEF3_REG	VOUT_REG(0x678)
#define	VOUT_CTL_PRI_CSC_COEF4_REG	VOUT_REG(0x67c)
#define	VOUT_CTL_PRI_CSC_COEF5_REG	VOUT_REG(0x680)
#define	VOUT_CTL_PRI_CSC_CLIP0_REG	VOUT_REG(0x684)
#define	VOUT_CTL_PRI_CSC_CLIP1_REG	VOUT_REG(0x688)
#define	VOUT_CTL_PRI_CSC_CLIP2_REG	VOUT_REG(0x68c)

#define	VOUT_CTL_OSD_CSC_COEF0_REG	VOUT_REG(0x6b4)
#define	VOUT_CTL_OSD_CSC_COEF1_REG	VOUT_REG(0x6b8)
#define	VOUT_CTL_OSD_CSC_COEF2_REG	VOUT_REG(0x6bc)
#define	VOUT_CTL_OSD_CSC_COEF3_REG	VOUT_REG(0x6c0)
#define	VOUT_CTL_OSD_CSC_COEF4_REG	VOUT_REG(0x6c4)
#define	VOUT_CTL_OSD_CSC_COEF5_REG	VOUT_REG(0x6c8)
#define	VOUT_CTL_OSD_CSC_CLIP0_REG	VOUT_REG(0x6cc)
#define	VOUT_CTL_OSD_CSC_CLIP1_REG	VOUT_REG(0x6d0)
#define	VOUT_CTL_OSD_CSC_CLIP2_REG	VOUT_REG(0x6d4)

#endif

#if (VOUT_SUPPORT_HDMI_CSC == 1)

#define	VOUT_CTL_HDMI_CSC_COEF0_OFFSET	0x690
#define	VOUT_CTL_HDMI_CSC_COEF1_OFFSET	0x694
#define	VOUT_CTL_HDMI_CSC_COEF2_OFFSET	0x698
#define	VOUT_CTL_HDMI_CSC_COEF3_OFFSET	0x69c
#define	VOUT_CTL_HDMI_CSC_COEF4_OFFSET	0x6a0
#define	VOUT_CTL_HDMI_CSC_COEF5_OFFSET	0x6a4
#define	VOUT_CTL_HDMI_CSC_CLIP0_OFFSET	0x6a8
#define	VOUT_CTL_HDMI_CSC_CLIP1_OFFSET	0x6ac
#define	VOUT_CTL_HDMI_CSC_CLIP2_OFFSET	0x6b0

#define	VOUT_CTL_HDMI_CSC_COEF0_REG	VOUT_REG(0x690)
#define	VOUT_CTL_HDMI_CSC_COEF1_REG	VOUT_REG(0x694)
#define	VOUT_CTL_HDMI_CSC_COEF2_REG	VOUT_REG(0x698)
#define	VOUT_CTL_HDMI_CSC_COEF3_REG	VOUT_REG(0x69c)
#define	VOUT_CTL_HDMI_CSC_COEF4_REG	VOUT_REG(0x6a0)
#define	VOUT_CTL_HDMI_CSC_COEF5_REG	VOUT_REG(0x6a4)
#define	VOUT_CTL_HDMI_CSC_CLIP0_REG	VOUT_REG(0x6a8)
#define	VOUT_CTL_HDMI_CSC_CLIP1_REG	VOUT_REG(0x6ac)
#define	VOUT_CTL_HDMI_CSC_CLIP2_REG	VOUT_REG(0x6b0)

#endif

/****************************/
/* VOUT2 registers           */
/****************************/

//#if (VOUT_INSTANCES == 2)

#define VOUT2_CTL_CONTROL_REG		VOUT2_REG(0x400)
#define VOUT2_CTL_STATUS_REG		VOUT2_REG(0x404)
#define VOUT2_CTL_HV_REG		VOUT2_REG(0x408)
#define VOUT2_CTL_HSYNC_REG		VOUT2_REG(0x40c)
#define VOUT2_CTL_VSYNC0_REG		VOUT2_REG(0x410)
#define VOUT2_CTL_VSYNC1_REG		VOUT2_REG(0x414)
#define VOUT2_CTL_ACTSTART_REG		VOUT2_REG(0x418)
#define VOUT2_CTL_ACTEND_REG		VOUT2_REG(0x41c)
#define VOUT2_CTL_VIDSTART_REG		VOUT2_REG(0x420)
#define VOUT2_CTL_VIDEND_REG		VOUT2_REG(0x424)
#define VOUT2_CTL_BG_REG		VOUT2_REG(0x428)
#define VOUT2_CTL_THRESH_REG		VOUT2_REG(0x42c)
#define VOUT2_CTL_VBI_REG		VOUT2_REG(0x430)
#define VOUT2_CTL_UPSAMPLE_REG		VOUT2_REG(0x434)
#define VOUT2_LCD_CTRL_REG		VOUT2_REG(0x438)
#define VOUT2_LCD_CLKPATN0_REG		VOUT2_REG(0x43c)
#define VOUT2_LCD_CLKPATN1_REG		VOUT2_REG(0x440)
#define VOUT2_LCD_CLKPATN2_REG		VOUT2_REG(0x444)
#define VOUT2_LCD_CLKPATN3_REG		VOUT2_REG(0x448)
#define VOUT2_LCD_CLKPATN4_REG		VOUT2_REG(0x44c)
#define VOUT2_LCD_CLKPATN5_REG		VOUT2_REG(0x450)
#define VOUT2_LCD_CLKPATN6_REG		VOUT2_REG(0x454)
#define VOUT2_LCD_CLKPATN7_REG		VOUT2_REG(0x458)
#define VOUT2_CTL_OSD0_CTRL_REG		VOUT2_REG(0x45c)
#define VOUT2_CTL_OSD0_START_REG	VOUT2_REG(0x460)
#define VOUT2_CTL_OSD0_END_REG		VOUT2_REG(0x464)
#define VOUT2_CTL_OSD1_CTRL_REG		VOUT2_REG(0x468)
#define VOUT2_CTL_OSD1_START_REG	VOUT2_REG(0x46c)
#define VOUT2_CTL_OSD1_END_REG		VOUT2_REG(0x470)
#define VOUT2_CTL_CUR_REG		VOUT2_REG(0x474)
#define VOUT2_CTL_V1_REG		VOUT2_REG(0x49c)
#define VOUT2_CTL_SD_Y_COEF_REG		VOUT2_REG(0x660)
#define VOUT2_CTL_SD_PB_COEF_REG	VOUT2_REG(0x664)
#define VOUT2_CTL_SD_PR_COEF_REG	VOUT2_REG(0x668)
#define	VOUT2_CTL_PRI_CSC_COEF0_REG	VOUT2_REG(0x66c)
#define	VOUT2_CTL_PRI_CSC_COEF1_REG	VOUT2_REG(0x670)
#define	VOUT2_CTL_PRI_CSC_COEF2_REG	VOUT2_REG(0x674)
#define	VOUT2_CTL_PRI_CSC_COEF3_REG	VOUT2_REG(0x678)
#define	VOUT2_CTL_PRI_CSC_COEF4_REG	VOUT2_REG(0x67c)
#define	VOUT2_CTL_PRI_CSC_COEF5_REG	VOUT2_REG(0x680)
#define	VOUT2_CTL_PRI_CSC_CLIP0_REG	VOUT2_REG(0x684)
#define	VOUT2_CTL_PRI_CSC_CLIP1_REG	VOUT2_REG(0x688)
#define	VOUT2_CTL_PRI_CSC_CLIP2_REG	VOUT2_REG(0x68c)

#define	VOUT2_CTL_OSD_CSC_COEF0_REG	VOUT2_REG(0x6b4)
#define	VOUT2_CTL_OSD_CSC_COEF1_REG	VOUT2_REG(0x6b8)
#define	VOUT2_CTL_OSD_CSC_COEF2_REG	VOUT2_REG(0x6bc)
#define	VOUT2_CTL_OSD_CSC_COEF3_REG	VOUT2_REG(0x6c0)
#define	VOUT2_CTL_OSD_CSC_COEF4_REG	VOUT2_REG(0x6c4)
#define	VOUT2_CTL_OSD_CSC_COEF5_REG	VOUT2_REG(0x6c8)
#define	VOUT2_CTL_OSD_CSC_CLIP0_REG	VOUT2_REG(0x6cc)
#define	VOUT2_CTL_OSD_CSC_CLIP1_REG	VOUT2_REG(0x6d0)
#define	VOUT2_CTL_OSD_CSC_CLIP2_REG	VOUT2_REG(0x6d4)

#define VOUT2_CTL_CLUT_REG		VOUT2_REG(0x800)
#define VOUT2_CTL_CURSORB_REG		VOUT2_REG(0xc00)
#define VOUT2_CTL_CURSORP_REG		VOUT2_REG(0xc80)
#define VOUT2_VBI_RA_REG		VOUT2_REG(0x478)
#define VOUT2_VBI_END_COL_REG		VOUT2_REG(0x4ac)
#define VOUT2_VBI_LEVEL_REG		VOUT2_REG(0x4b0)

//#endif /* (VOUT_INSTANCES == 2) */

/* ---------------------------------------------------------------------- */

#elif (VOUT_DISPLAY_SECTIONS == 2)

#if (CHIP_REV == A6)

/* Display A control regsiters */
#define VOUT_DA_CONTROL_OFFSET				0x400
#define VOUT_DA_STATUS_OFFSET				0x404
#define VOUT_DA_FRAME_SIZE_OFFSET			0x408
#define VOUT_DA_FRAME_HEIGHT_FIELD_1_OFFSET            	0x40c
#define VOUT_DA_ACTIVE_REGION_START_0_OFFSET   		0x410
#define VOUT_DA_ACTIVE_REGION_END_0_OFFSET		0x414
#define VOUT_DA_ACTIVE_REGION_START_1_OFFSET   		0x418
#define VOUT_DA_ACTIVE_REGION_END_1_OFFSET     		0x41c
#define VOUT_DA_OUTPUT_MODES_OFFSET            		0x420
#define VOUT_DA_DIGITAL_HSYNC_CONTROL_OFFSET  		0x424
#define VOUT_DA_DIGITAL_VSYNC_START_0_OFFSET  		0x428
#define VOUT_DA_DIGITAL_VSYNC_END_0_OFFSET    		0x42c
#define VOUT_DA_DIGITAL_VSYNC_START_1_OFFSET  		0x430
#define VOUT_DA_DIGITAL_VSYNC_END_1_OFFSET     		0x434
#define VOUT_DA_DIGITAL_656_VBIT_OFFSET			0x438
#define VOUT_DA_DIGITAL_656_SAV_START_OFFSET		0x43c
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_0_OFFSET 		0x440
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_1_OFFSET 		0x444
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_2_OFFSET 		0x448
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_3_OFFSET 		0x44c
#define VOUT_DA_DIGITAL_CSC_PARAM_0_OFFSET		0x450
#define VOUT_DA_DIGITAL_CSC_PARAM_1_OFFSET		0x454
#define VOUT_DA_DIGITAL_CSC_PARAM_2_OFFSET		0x458
#define VOUT_DA_DIGITAL_CSC_PARAM_3_OFFSET		0x45c
#define VOUT_DA_DIGITAL_CSC_PARAM_4_OFFSET		0x460
#define VOUT_DA_DIGITAL_CSC_PARAM_5_OFFSET		0x464
#define VOUT_DA_DIGITAL_CSC_PARAM_6_OFFSET		0x468
#define VOUT_DA_DIGITAL_CSC_PARAM_7_OFFSET		0x46c
#define VOUT_DA_DIGITAL_CSC_PARAM_8_OFFSET		0x470
#define VOUT_DA_BACKGROUND_OFFSET 			0x474
#define VOUT_DA_VOUT_VOUT_SYNC_OFFSET			0X48c
#define VOUT_DA_INPUT_STREAM_ENABLES_OFFSET		0x490
#define VOUT_DA_INPUT_SYNC_COUNTER_CONTROL_OFFSET	0x494
#define VOUT_DA_OUTPUT_SYNC_COUNTER_CONTROL_OFFSET	0x498
#define VOUT_DA_STREAM_IN_CONTROL_OFFSET		0x49c
#define VOUT_DA_FRAME_ENABLE_OFFSET			0x4a0

/* Display B control regsiters */
#define VOUT_DB_CONTROL_OFFSET				0x600
#define VOUT_DB_STATUS_OFFSET				0x604
#define VOUT_DB_FRAME_SIZE_OFFSET			0x608
#define VOUT_DB_FRAME_HEIGHT_FIELD_1_OFFSET		0x60c
#define VOUT_DB_ACTIVE_REGION_START_0_OFFSET		0x610
#define VOUT_DB_ACTIVE_REGION_END_0_OFFSET		0x614
#define VOUT_DB_ACTIVE_REGION_START_1_OFFSET		0x618
#define VOUT_DB_ACTIVE_REGION_END_1_OFFSET		0x61c
#define VOUT_DB_OUTPUT_MODES_OFFSET			0x620
#define VOUT_DB_DIGITAL_HSYNC_CONTROL_OFFSET		0x624
#define VOUT_DB_DIGITAL_VSYNC_START_0_OFFSET		0x628
#define VOUT_DB_DIGITAL_VSYNC_END_0_OFFSET		0x62c
#define VOUT_DB_DIGITAL_VSYNC_START_1_OFFSET		0x630
#define VOUT_DB_DIGITAL_VSYNC_END_1_OFFSET		0x634
#define VOUT_DB_DIGITAL_656_VBIT_OFFSET			0x638
#define VOUT_DB_DIGITAL_656_SAV_START_OFFSET		0x63c
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_0_OFFSET		0x640
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_1_OFFSET		0x644
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_2_OFFSET		0x648
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_3_OFFSET		0x64c
#define VOUT_DB_DIGITAL_CSC_PARAM_0_OFFSET		0x650
#define VOUT_DB_DIGITAL_CSC_PARAM_1_OFFSET		0x654
#define VOUT_DB_DIGITAL_CSC_PARAM_2_OFFSET		0x658
#define VOUT_DB_DIGITAL_CSC_PARAM_3_OFFSET		0x65c
#define VOUT_DB_DIGITAL_CSC_PARAM_4_OFFSET		0x660
#define VOUT_DB_DIGITAL_CSC_PARAM_5_OFFSET		0x664
#define VOUT_DB_DIGITAL_CSC_PARAM_6_OFFSET		0x668
#define VOUT_DB_DIGITAL_CSC_PARAM_7_OFFSET		0x66c
#define VOUT_DB_DIGITAL_CSC_PARAM_8_OFFSET		0x670
#define VOUT_DB_ANALOG_HSYNC_CONTROL_OFFSET		0x674
#define VOUT_DB_ANALOG_VSYNC_START_0_OFFSET		0x678
#define VOUT_DB_ANALOG_VSYNC_END_0_OFFSET		0x67c
#define VOUT_DB_ANALOG_VSYNC_START_1_OFFSET		0x680
#define VOUT_DB_ANALOG_VSYNC_END_1_OFFSET		0x684
#define VOUT_DB_ANALOG_VBI_CONTROL_OFFSET		0x688
#define VOUT_DB_ANALOG_VBI_START_OFFSET			0x68c
#define VOUT_DB_ANALOG_VBI_END_OFFSET			0x690
#define VOUT_DB_ANALOG_VBI_DATA0_OFFSET			0x694
#define VOUT_DB_ANALOG_VBI_DATA1_OFFSET			0x698
#define VOUT_DB_ANALOG_VBI_DATA2_OFFSET			0x69c
#define VOUT_DB_ANALOG_VBI_DATA3_OFFSET			0x6a0
#define VOUT_DB_ANALOG_VBI_DATA4_OFFSET			0x6a4
#define VOUT_DB_ANALOG_VBI_DATA5_OFFSET			0x6a8
#define VOUT_DB_ANALOG_VBI_DATA6_OFFSET			0x6ac
#define VOUT_DB_ANALOG_VBI_DATA7_OFFSET			0x6b0
#define VOUT_DB_ANALOG_VBI_DATA8_OFFSET			0x6b4
#define VOUT_DB_ANALOG_VBI_DATA9_OFFSET			0x6b8
#define VOUT_DB_ANALOG_VBI_DATA10_OFFSET		0x6bc
#define VOUT_DB_ANALOG_VBI_DATA11_OFFSET		0x6c0
#define VOUT_DB_ANALOG_CSC_PARAM_0_OFFSET		0x6c4
#define VOUT_DB_ANALOG_CSC_PARAM_1_OFFSET		0x6c8
#define VOUT_DB_ANALOG_CSC_PARAM_2_OFFSET		0x6cc
#define VOUT_DB_ANALOG_CSC_PARAM_3_OFFSET		0x6d0
#define VOUT_DB_ANALOG_CSC_PARAM_4_OFFSET		0x6d4
#define VOUT_DB_ANALOG_CSC_PARAM_5_OFFSET		0x6d8
#define VOUT_DB_ANALOG_SCALE_PARAM_0_OFFSET		0x6dc
#define VOUT_DB_ANALOG_SCALE_PARAM_1_OFFSET		0x6e0
#define VOUT_DB_ANALOG_SCALE_PARAM_2_OFFSET		0x6e4
#define VOUT_DB_ANALOG_SCALE_PARAM_3_OFFSET		0x6e8
#define VOUT_DB_ANALOG_SCALE_PARAM_4_OFFSET		0x6ec
#define VOUT_DB_ANALOG_SCALE_PARAM_5_OFFSET		0x6f0
#define VOUT_DB_ANALOG_SD_SCALE_Y_OFFSET		0x6f4
#define VOUT_DB_ANALOG_SD_SCALE_PBPR_OFFSET		0x6f8
#define VOUT_DB_HDMI_HSYNC_CONTROL_OFFSET		0x6fc
#define VOUT_DB_HDMI_VSYNC_START_0_OFFSET		0x700
#define VOUT_DB_HDMI_VSYNC_END_0_OFFSET			0x704
#define VOUT_DB_HDMI_VSYNC_START_1_OFFSET		0x708
#define VOUT_DB_HDMI_VSYNC_END_1_OFFSET			0x70c
#define VOUT_DB_HDMI_CSC_PARAM_0_OFFSET			0x710
#define VOUT_DB_HDMI_CSC_PARAM_1_OFFSET			0x714
#define VOUT_DB_HDMI_CSC_PARAM_2_OFFSET			0x718
#define VOUT_DB_HDMI_CSC_PARAM_3_OFFSET			0x71c
#define VOUT_DB_HDMI_CSC_PARAM_4_OFFSET			0x720
#define VOUT_DB_HDMI_CSC_PARAM_5_OFFSET			0x724
#define VOUT_DB_HDMI_CSC_PARAM_6_OFFSET			0x728
#define VOUT_DB_HDMI_CSC_PARAM_7_OFFSET			0x72c
#define VOUT_DB_HDMI_CSC_PARAM_8_OFFSET			0x730
#define VOUT_DB_BACKGROUND_OFFSET			0x734
#define VOUT_DB_INPUT_STREAM_ENABLES_OFFSET		0x760
#define VOUT_DB_INPUT_SYNC_COUNTER_CONTROL_OFFSET	0x764
#define VOUT_DB_OUTPUT_SYNC_COUNTER_CONTROL_OFFSET	0x768
#define VOUT_DB_STREAM_IN_CONTROL_OFFSET		0x76c
#define VOUT_DB_FRAME_ENABLE_OFFSET			0x770

/* OSD control registers */
#define VOUT_OSD_RESCALE_CONTROL_OFFSET			0x800
#define VOUT_OSD_RESCALE_H_OUTPUT_WIDTH_OFFSET		0x804
#define VOUT_OSD_RESCALE_H_PHASE_INC_OFFSET		0x808
#define VOUT_OSD_RESCALE_H_PHASE_INIT_OFFSET		0x80c
#define VOUT_OSD_RESCALE_V_OUTPUT_HEIGHT_OFFSET		0x810
#define VOUT_OSD_RESCALE_V_PHASE_INC_OFFSET		0x814
#define VOUT_OSD_RESCALE_V_PHASE_INIT_OFFSET		0x818
#define VOUT_OSD_RESCALE_H_NUM				32
#define VOUT_OSD_RESCALE_H_COEF_START_OFFSET		0x81c
#define VOUT_OSD_RESCALE_H_COEF_END_OFFSET		0x898
#define VOUT_OSD_RESCALE_V_NUM				32
#define VOUT_OSD_RESCALE_V_COEF_START_OFFSET		0x89c
#define VOUT_OSD_RESCALE_V_COEF_END_OFFSET		0x918

/* Display A control regsiters */
#define VOUT_DA_CONTROL_REG				VOUT_REG(0x400)
#define VOUT_DA_STATUS_REG				VOUT_REG(0x404)
#define VOUT_DA_FRAME_SIZE_REG				VOUT_REG(0x408)
#define VOUT_DA_FRAME_HEIGHT_FIELD_1_REG            	VOUT_REG(0x40c)
#define VOUT_DA_ACTIVE_REGION_START_0_REG   		VOUT_REG(0x410)
#define VOUT_DA_ACTIVE_REGION_END_0_REG			VOUT_REG(0x414)
#define VOUT_DA_ACTIVE_REGION_START_1_REG   		VOUT_REG(0x418)
#define VOUT_DA_ACTIVE_REGION_END_1_REG     		VOUT_REG(0x41a)
#define VOUT_DA_OUTPUT_MODES_REG            		VOUT_REG(0x420)
#define VOUT_DA_DIGITAL_HSYNC_CONTROL_REG  		VOUT_REG(0x424)
#define VOUT_DA_DIGITAL_VSYNC_START_0_REG  		VOUT_REG(0x428)
#define VOUT_DA_DIGITAL_VSYNC_END_0_REG    		VOUT_REG(0x42c)
#define VOUT_DA_DIGITAL_VSYNC_START_1_REG  		VOUT_REG(0x430)
#define VOUT_DA_DIGITAL_VSYNC_END_1_REG     		VOUT_REG(0x434)
#define VOUT_DA_DIGITAL_656_VBIT_REG			VOUT_REG(0x438)
#define VOUT_DA_DIGITAL_656_SAV_START_REG		VOUT_REG(0x43c)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_0_REG 		VOUT_REG(0x440)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_1_REG 		VOUT_REG(0x444)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_2_REG 		VOUT_REG(0x448)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_3_REG 		VOUT_REG(0x44c)
#define VOUT_DA_DIGITAL_CSC_PARAM_0_REG			VOUT_REG(0x450)
#define VOUT_DA_DIGITAL_CSC_PARAM_1_REG			VOUT_REG(0x454)
#define VOUT_DA_DIGITAL_CSC_PARAM_2_REG			VOUT_REG(0x458)
#define VOUT_DA_DIGITAL_CSC_PARAM_3_REG			VOUT_REG(0x45c)
#define VOUT_DA_DIGITAL_CSC_PARAM_4_REG			VOUT_REG(0x460)
#define VOUT_DA_DIGITAL_CSC_PARAM_5_REG			VOUT_REG(0x464)
#define VOUT_DA_DIGITAL_CSC_PARAM_6_REG			VOUT_REG(0x468)
#define VOUT_DA_DIGITAL_CSC_PARAM_7_REG			VOUT_REG(0x46c)
#define VOUT_DA_DIGITAL_CSC_PARAM_8_REG			VOUT_REG(0x470)
#define VOUT_DA_BACKGROUND_REG 				VOUT_REG(0x474)
#define VOUT_DA_VOUT_VOUT_SYNC_REG                      VOUT_REG(0x48c)
#define VOUT_DA_INPUT_STREAM_ENABLES_REG		VOUT_REG(0x490)
#define VOUT_DA_INPUT_SYNC_COUNTER_CONTROL_REG		VOUT_REG(0x494)
#define VOUT_DA_OUTPUT_SYNC_COUNTER_CONTROL_REG		VOUT_REG(0x498)
#define VOUT_DA_STREAM_IN_CONTROL_REG			VOUT_REG(0x49c)
#define VOUT_DA_FRAME_ENABLE_REG			VOUT_REG(0x4a0)

/* Display B control regsiters */
#define VOUT_DB_CONTROL_REG				VOUT_REG(0x600)
#define VOUT_DB_STATUS_REG				VOUT_REG(0x604)
#define VOUT_DB_FRAME_SIZE_REG				VOUT_REG(0x608)
#define VOUT_DB_FRAME_HEIGHT_FIELD_1_REG		VOUT_REG(0x60c)
#define VOUT_DB_ACTIVE_REGION_START_0_REG		VOUT_REG(0x610)
#define VOUT_DB_ACTIVE_REGION_END_0_REG			VOUT_REG(0x614)
#define VOUT_DB_ACTIVE_REGION_START_1_REG		VOUT_REG(0x618)
#define VOUT_DB_ACTIVE_REGION_END_1_REG			VOUT_REG(0x61c)
#define VOUT_DB_OUTPUT_MODES_REG			VOUT_REG(0x620)
#define VOUT_DB_DIGITAL_HSYNC_CONTROL_REG		VOUT_REG(0x624)
#define VOUT_DB_DIGITAL_VSYNC_START_0_REG		VOUT_REG(0x628)
#define VOUT_DB_DIGITAL_VSYNC_END_0_REG			VOUT_REG(0x62c)
#define VOUT_DB_DIGITAL_VSYNC_START_1_REG		VOUT_REG(0x630)
#define VOUT_DB_DIGITAL_VSYNC_END_1_REG			VOUT_REG(0x634)
#define VOUT_DB_DIGITAL_656_VBIT_REG			VOUT_REG(0x638)
#define VOUT_DB_DIGITAL_656_SAV_START_REG		VOUT_REG(0x63c)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_0_REG		VOUT_REG(0x640)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_1_REG		VOUT_REG(0x644)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_2_REG		VOUT_REG(0x648)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_3_REG		VOUT_REG(0x64c)
#define VOUT_DB_DIGITAL_CSC_PARAM_0_REG			VOUT_REG(0x650)
#define VOUT_DB_DIGITAL_CSC_PARAM_1_REG			VOUT_REG(0x654)
#define VOUT_DB_DIGITAL_CSC_PARAM_2_REG			VOUT_REG(0x658)
#define VOUT_DB_DIGITAL_CSC_PARAM_3_REG			VOUT_REG(0x65c)
#define VOUT_DB_DIGITAL_CSC_PARAM_4_REG			VOUT_REG(0x660)
#define VOUT_DB_DIGITAL_CSC_PARAM_5_REG			VOUT_REG(0x664)
#define VOUT_DB_DIGITAL_CSC_PARAM_6_REG			VOUT_REG(0x668)
#define VOUT_DB_DIGITAL_CSC_PARAM_7_REG			VOUT_REG(0x66c)
#define VOUT_DB_DIGITAL_CSC_PARAM_8_REG			VOUT_REG(0x670)
#define VOUT_DB_ANALOG_HSYNC_CONTROL_REG		VOUT_REG(0x674)
#define VOUT_DB_ANALOG_VSYNC_START_0_REG		VOUT_REG(0x678)
#define VOUT_DB_ANALOG_VSYNC_END_0_REG			VOUT_REG(0x67c)
#define VOUT_DB_ANALOG_VSYNC_START_1_REG		VOUT_REG(0x680)
#define VOUT_DB_ANALOG_VSYNC_END_1_REG			VOUT_REG(0x684)
#define VOUT_DB_ANALOG_VBI_CONTROL_REG			VOUT_REG(0x688)
#define VOUT_DB_ANALOG_VBI_START_REG			VOUT_REG(0x68c)
#define VOUT_DB_ANALOG_VBI_END_REG			VOUT_REG(0x690)
#define VOUT_DB_ANALOG_VBI_DATA0_REG			VOUT_REG(0x694)
#define VOUT_DB_ANALOG_VBI_DATA1_REG			VOUT_REG(0x698)
#define VOUT_DB_ANALOG_VBI_DATA2_REG			VOUT_REG(0x69c)
#define VOUT_DB_ANALOG_VBI_DATA3_REG			VOUT_REG(0x6a0)
#define VOUT_DB_ANALOG_VBI_DATA4_REG			VOUT_REG(0x6a4)
#define VOUT_DB_ANALOG_VBI_DATA5_REG			VOUT_REG(0x6a8)
#define VOUT_DB_ANALOG_VBI_DATA6_REG			VOUT_REG(0x6ac)
#define VOUT_DB_ANALOG_VBI_DATA7_REG			VOUT_REG(0x6b0)
#define VOUT_DB_ANALOG_VBI_DATA8_REG			VOUT_REG(0x6b4)
#define VOUT_DB_ANALOG_VBI_DATA9_REG			VOUT_REG(0x6b8)
#define VOUT_DB_ANALOG_VBI_DATA10_REG			VOUT_REG(0x6bc)
#define VOUT_DB_ANALOG_VBI_DATA11_REG			VOUT_REG(0x6c0)
#define VOUT_DB_ANALOG_CSC_PARAM_0_REG			VOUT_REG(0x6c4)
#define VOUT_DB_ANALOG_CSC_PARAM_1_REG			VOUT_REG(0x6c8)
#define VOUT_DB_ANALOG_CSC_PARAM_2_REG			VOUT_REG(0x6cc)
#define VOUT_DB_ANALOG_CSC_PARAM_3_REG			VOUT_REG(0x6d0)
#define VOUT_DB_ANALOG_CSC_PARAM_4_REG			VOUT_REG(0x6d4)
#define VOUT_DB_ANALOG_CSC_PARAM_5_REG			VOUT_REG(0x6d8)
#define VOUT_DB_ANALOG_SCALE_PARAM_0_REG		VOUT_REG(0x6dc)
#define VOUT_DB_ANALOG_SCALE_PARAM_1_REG		VOUT_REG(0x6e0)
#define VOUT_DB_ANALOG_SCALE_PARAM_2_REG		VOUT_REG(0x6e4)
#define VOUT_DB_ANALOG_SCALE_PARAM_3_REG		VOUT_REG(0x6e8)
#define VOUT_DB_ANALOG_SCALE_PARAM_4_REG		VOUT_REG(0x6ec)
#define VOUT_DB_ANALOG_SCALE_PARAM_5_REG		VOUT_REG(0x6f0)
#define VOUT_DB_ANALOG_SD_SCALE_Y_REG			VOUT_REG(0x6f4)
#define VOUT_DB_ANALOG_SD_SCALE_PBPR_REG		VOUT_REG(0x6f8)
#define VOUT_DB_HDMI_HSYNC_CONTROL_REG			VOUT_REG(0x6fc)
#define VOUT_DB_HDMI_VSYNC_START_0_REG			VOUT_REG(0x700)
#define VOUT_DB_HDMI_VSYNC_END_0_REG			VOUT_REG(0x704)
#define VOUT_DB_HDMI_VSYNC_START_1_REG			VOUT_REG(0x708)
#define VOUT_DB_HDMI_VSYNC_END_1_REG			VOUT_REG(0x70c)
#define VOUT_DB_HDMI_CSC_PARAM_0_REG			VOUT_REG(0x710)
#define VOUT_DB_HDMI_CSC_PARAM_1_REG			VOUT_REG(0x714)
#define VOUT_DB_HDMI_CSC_PARAM_2_REG			VOUT_REG(0x718)
#define VOUT_DB_HDMI_CSC_PARAM_3_REG			VOUT_REG(0x71c)
#define VOUT_DB_HDMI_CSC_PARAM_4_REG			VOUT_REG(0x720)
#define VOUT_DB_HDMI_CSC_PARAM_5_REG			VOUT_REG(0x724)
#define VOUT_DB_HDMI_CSC_PARAM_6_REG			VOUT_REG(0x728)
#define VOUT_DB_HDMI_CSC_PARAM_7_REG			VOUT_REG(0x72c)
#define VOUT_DB_HDMI_CSC_PARAM_8_REG			VOUT_REG(0x730)
#define VOUT_DB_BACKGROUND_REG				VOUT_REG(0x734)
#define VOUT_DB_INPUT_STREAM_ENABLES_REG		VOUT_REG(0x760)
#define VOUT_DB_INPUT_SYNC_COUNTER_CONTROL_REG		VOUT_REG(0x764)
#define VOUT_DB_OUTPUT_SYNC_COUNTER_CONTROL_REG		VOUT_REG(0x768)
#define VOUT_DB_STREAM_IN_CONTROL_REG			VOUT_REG(0x76c)
#define VOUT_DB_FRAME_ENABLE_REG			VOUT_REG(0x770)

/* OSD control registers */
#define VOUT_OSD_RESCALE_CONTROL_REG			VOUT_REG(0x800)
#define VOUT_OSD_RESCALE_H_OUTPUT_WIDTH_REG		VOUT_REG(0x804)
#define VOUT_OSD_RESCALE_H_PHASE_INC_REG		VOUT_REG(0x808)
#define VOUT_OSD_RESCALE_H_PHASE_INIT_REG		VOUT_REG(0x80c)
#define VOUT_OSD_RESCALE_V_OUTPUT_HEIGHT_REG		VOUT_REG(0x810)
#define VOUT_OSD_RESCALE_V_PHASE_INC_REG		VOUT_REG(0x814)
#define VOUT_OSD_RESCALE_V_PHASE_INIT_REG		VOUT_REG(0x818)
#define VOUT_OSD_RESCALE_H_NUM				32
#define VOUT_OSD_RESCALE_H_COEF_START_REG		VOUT_REG(0x81c)
#define VOUT_OSD_RESCALE_H_COEF_END_REG			VOUT_REG(0x898)
#define VOUT_OSD_RESCALE_V_NUM_REG			32
#define VOUT_OSD_RESCALE_V_COEF_START_REG		VOUT_REG(0x89c)
#define VOUT_OSD_RESCALE_V_COEF_END_REG			VOUT_REG(0x918)


/* VOUT CLUTs */
#define VOUT_OSD_CLUT_NUM           			0x3fd
#define VOUT_OSDA_CLUT_START_OFFSET			0x000
#define VOUT_OSDA_CLUT_END_OFFSET			0x3fc
#define VOUT_OSDB_CLUT_START_OFFSET    			0x400
#define VOUT_OSDB_CLUT_END_OFFSET			0x7fc

#define VOUT_OSDA_CLUT_NUM           			0x3fd
#define VOUT_OSDA_CLUT_START_REG			VOUT_CLUT_REG(0x000)
#define VOUT_OSDA_CLUT_END_REG				VOUT_CLUT_REG(0x3fc)
#define VOUT_OSDB_CLUT_NUM_REG    			0x3fd
#define VOUT_OSDB_CLUT_START_REG       			VOUT_CLUT_REG(0x400)
#define VOUT_OSDB_CLUT_END_REG				VOUT_CLUT_REG(0x7fc)

#endif /* CHIP_REV == A6 */


#if (CHIP_REV == A5S) || (CHIP_REV == A7) || (CHIP_REV == I1) || 	\
    (CHIP_REV == A7L)

/* Display A control regsiters */
#define VOUT_DA_CONTROL_OFFSET				0x300
#define VOUT_DA_STATUS_OFFSET				0x304
#define VOUT_DA_FRAME_SIZE_OFFSET			0x308
#define VOUT_DA_FRAME_HEIGHT_FIELD_1_OFFSET            	0x30c
#define VOUT_DA_ACTIVE_REGION_START_0_OFFSET   		0x310
#define VOUT_DA_ACTIVE_REGION_END_0_OFFSET		0x314
#define VOUT_DA_ACTIVE_REGION_START_1_OFFSET   		0x318
#define VOUT_DA_ACTIVE_REGION_END_1_OFFSET     		0x31c
#define VOUT_DA_BACKGROUND_OFFSET	     		0x320
#define VOUT_DA_DIGITAL_OUTPUT_MODES_OFFSET            	0x324
#define VOUT_DA_DIGITAL_HSYNC_CONTROL_OFFSET  		0x328
#define VOUT_DA_DIGITAL_VSYNC_START_0_OFFSET  		0x32c
#define VOUT_DA_DIGITAL_VSYNC_END_0_OFFSET    		0x330
#define VOUT_DA_DIGITAL_VSYNC_START_1_OFFSET  		0x334
#define VOUT_DA_DIGITAL_VSYNC_END_1_OFFSET     		0x338
#define VOUT_DA_DIGITAL_656_VBIT_OFFSET			0x33c
#define VOUT_DA_DIGITAL_656_SAV_START_OFFSET		0x340
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_0_OFFSET 		0x344
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_1_OFFSET 		0x348
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_2_OFFSET 		0x34c
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_3_OFFSET 		0x350
#define VOUT_DA_DIGITAL_CSC_PARAM_0_OFFSET		0x354
#define VOUT_DA_DIGITAL_CSC_PARAM_1_OFFSET		0x358
#define VOUT_DA_DIGITAL_CSC_PARAM_2_OFFSET		0x35c
#define VOUT_DA_DIGITAL_CSC_PARAM_3_OFFSET		0x360
#define VOUT_DA_DIGITAL_CSC_PARAM_4_OFFSET		0x364
#define VOUT_DA_DIGITAL_CSC_PARAM_5_OFFSET		0x368
#define VOUT_DA_DIGITAL_CSC_PARAM_6_OFFSET		0x36c
#define VOUT_DA_DIGITAL_CSC_PARAM_7_OFFSET		0x370
#define VOUT_DA_DIGITAL_CSC_PARAM_8_OFFSET		0x374
#define VOUT_DA_ANALOG_OUTPUT_MODES_OFFSET		0x378
#define VOUT_DA_ANALOG_HSYNC_CONTROL_OFFSET		0x37c
#define VOUT_DA_ANALOG_VSYNC_START_0_OFFSET		0x380
#define VOUT_DA_ANALOG_VSYNC_END_0_OFFSET		0x384
#define VOUT_DA_ANALOG_VSYNC_START_1_OFFSET		0x388
#define VOUT_DA_ANALOG_VSYNC_END_1_OFFSET		0x38c
#define VOUT_DA_ANALOG_VBI_CONTROL_OFFSET		0x390
#define VOUT_DA_ANALOG_VBI_START_V_OFFSET		0x394
#define VOUT_DA_ANALOG_VBI_H_OFFSET			0x398
#define VOUT_DA_ANALOG_VBI_DATA0_OFFSET			0x39c
#define VOUT_DA_ANALOG_VBI_DATA1_OFFSET			0x3a0
#define VOUT_DA_ANALOG_VBI_DATA2_OFFSET			0x3a4
#define VOUT_DA_ANALOG_VBI_DATA3_OFFSET			0x3a8
#define VOUT_DA_ANALOG_VBI_DATA4_OFFSET			0x3ac
#define VOUT_DA_ANALOG_VBI_DATA5_OFFSET			0x3b0
#define VOUT_DA_ANALOG_VBI_DATA6_OFFSET			0x3b4
#define VOUT_DA_ANALOG_VBI_DATA7_OFFSET			0x3b8
#define VOUT_DA_ANALOG_VBI_DATA8_OFFSET			0x3bc
#define VOUT_DA_ANALOG_VBI_DATA9_OFFSET			0x3c0
#define VOUT_DA_ANALOG_VBI_DATA10_OFFSET		0x3c4
#define VOUT_DA_ANALOG_VBI_DATA11_OFFSET		0x3c8
#define VOUT_DA_ANALOG_CSC_PARAM_0_OFFSET		0x3cc
#define VOUT_DA_ANALOG_CSC_PARAM_1_OFFSET		0x3d0
#define VOUT_DA_ANALOG_CSC_PARAM_2_OFFSET		0x3d4
#define VOUT_DA_ANALOG_CSC_PARAM_3_OFFSET		0x3d8
#define VOUT_DA_ANALOG_CSC_PARAM_4_OFFSET		0x3dc
#define VOUT_DA_ANALOG_CSC_PARAM_5_OFFSET		0x3e0
#define VOUT_DA_ANALOG_SCALE_PARAM_0_OFFSET		0x3e4
#define VOUT_DA_ANALOG_SCALE_PARAM_1_OFFSET		0x3e8
#define VOUT_DA_ANALOG_SCALE_PARAM_2_OFFSET		0x3ec
#define VOUT_DA_ANALOG_SCALE_PARAM_3_OFFSET		0x3f0
#define VOUT_DA_ANALOG_SCALE_PARAM_4_OFFSET		0x3f4
#define VOUT_DA_ANALOG_SCALE_PARAM_5_OFFSET		0x3f8
#define VOUT_DA_ANALOG_SD_SCALE_Y_OFFSET		0x3fc
#define VOUT_DA_ANALOG_SD_SCALE_PBPR_OFFSET		0x400
#define VOUT_DA_DIGITAL_DITHER_SETTINGS_OFFSET		0x454
#define VOUT_DA_DIGITAL_DITHER_SEED_OFFSET		0x458
#define VOUT_DA_VOUT_VOUT_SYNC_OFFSET			0x45c
#define VOUT_DA_INPUT_STREAM_ENABLES_OFFSET		0x460
#define VOUT_DA_INPUT_SYNC_CONTROL_OFFSET		0x464
#define VOUT_DA_OUTPUT_SYNC_CONTROL_OFFSET		0x468
#define VOUT_DA_STREAM_CONTROL_OFFSET			0x46c
#define VOUT_DA_FRAME_ENABLE_OFFSET			0x470


/* Display B control regsiters */
#define VOUT_DB_CONTROL_OFFSET				0x600
#define VOUT_DB_STATUS_OFFSET				0x604
#define VOUT_DB_FRAME_SIZE_OFFSET			0x608
#define VOUT_DB_FRAME_HEIGHT_FIELD_1_OFFSET		0x60c
#define VOUT_DB_ACTIVE_REGION_START_0_OFFSET		0x610
#define VOUT_DB_ACTIVE_REGION_END_0_OFFSET		0x614
#define VOUT_DB_ACTIVE_REGION_START_1_OFFSET		0x618
#define VOUT_DB_ACTIVE_REGION_END_1_OFFSET		0x61c
#define VOUT_DB_BACKGROUND_OFFSET			0x620
#define VOUT_DB_DIGITAL_OUTPUT_MODES_OFFSET		0x624
#define VOUT_DB_DIGITAL_HSYNC_CONTROL_OFFSET		0x628
#define VOUT_DB_DIGITAL_VSYNC_START_0_OFFSET		0x62c
#define VOUT_DB_DIGITAL_VSYNC_END_0_OFFSET		0x630
#define VOUT_DB_DIGITAL_VSYNC_START_1_OFFSET		0x634
#define VOUT_DB_DIGITAL_VSYNC_END_1_OFFSET		0x638
#define VOUT_DB_DIGITAL_656_VBIT_OFFSET			0x63c
#define VOUT_DB_DIGITAL_656_SAV_START_OFFSET		0x640
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_0_OFFSET		0x644
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_1_OFFSET		0x648
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_2_OFFSET		0x64c
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_3_OFFSET		0x650
#define VOUT_DB_DIGITAL_CSC_PARAM_0_OFFSET		0x654
#define VOUT_DB_DIGITAL_CSC_PARAM_1_OFFSET		0x658
#define VOUT_DB_DIGITAL_CSC_PARAM_2_OFFSET		0x65c
#define VOUT_DB_DIGITAL_CSC_PARAM_3_OFFSET		0x660
#define VOUT_DB_DIGITAL_CSC_PARAM_4_OFFSET		0x664
#define VOUT_DB_DIGITAL_CSC_PARAM_5_OFFSET		0x668
#define VOUT_DB_DIGITAL_CSC_PARAM_6_OFFSET		0x66c
#define VOUT_DB_DIGITAL_CSC_PARAM_7_OFFSET		0x670
#define VOUT_DB_DIGITAL_CSC_PARAM_8_OFFSET		0x674
#define VOUT_DB_ANALOG_OUTPUT_MODES_OFFSET		0x678
#define VOUT_DB_ANALOG_HSYNC_CONTROL_OFFSET		0x67c
#define VOUT_DB_ANALOG_VSYNC_START_0_OFFSET		0x680
#define VOUT_DB_ANALOG_VSYNC_END_0_OFFSET		0x684
#define VOUT_DB_ANALOG_VSYNC_START_1_OFFSET		0x688
#define VOUT_DB_ANALOG_VSYNC_END_1_OFFSET		0x68c
#define VOUT_DB_ANALOG_VBI_CONTROL_OFFSET		0x690
#define VOUT_DB_ANALOG_VBI_START_V_OFFSET		0x694
#define VOUT_DB_ANALOG_VBI_H_OFFSET			0x698
#define VOUT_DB_ANALOG_VBI_DATA0_OFFSET			0x69c
#define VOUT_DB_ANALOG_VBI_DATA1_OFFSET			0x6a0
#define VOUT_DB_ANALOG_VBI_DATA2_OFFSET			0x6a4
#define VOUT_DB_ANALOG_VBI_DATA3_OFFSET			0x6a8
#define VOUT_DB_ANALOG_VBI_DATA4_OFFSET			0x6ac
#define VOUT_DB_ANALOG_VBI_DATA5_OFFSET			0x6b0
#define VOUT_DB_ANALOG_VBI_DATA6_OFFSET			0x6b4
#define VOUT_DB_ANALOG_VBI_DATA7_OFFSET			0x6b8
#define VOUT_DB_ANALOG_VBI_DATA8_OFFSET			0x6bc
#define VOUT_DB_ANALOG_VBI_DATA9_OFFSET			0x6c0
#define VOUT_DB_ANALOG_VBI_DATA10_OFFSET		0x6c4
#define VOUT_DB_ANALOG_VBI_DATA11_OFFSET		0x6c8
#define VOUT_DB_ANALOG_CSC_PARAM_0_OFFSET		0x6cc
#define VOUT_DB_ANALOG_CSC_PARAM_1_OFFSET		0x6d0
#define VOUT_DB_ANALOG_CSC_PARAM_2_OFFSET		0x6d4
#define VOUT_DB_ANALOG_CSC_PARAM_3_OFFSET		0x6d8
#define VOUT_DB_ANALOG_CSC_PARAM_4_OFFSET		0x6dc
#define VOUT_DB_ANALOG_CSC_PARAM_5_OFFSET		0x6e0
#define VOUT_DB_ANALOG_SCALE_PARAM_0_OFFSET		0x6e4
#define VOUT_DB_ANALOG_SCALE_PARAM_1_OFFSET		0x6e8
#define VOUT_DB_ANALOG_SCALE_PARAM_2_OFFSET		0x6ec
#define VOUT_DB_ANALOG_SCALE_PARAM_3_OFFSET		0x6f0
#define VOUT_DB_ANALOG_SCALE_PARAM_4_OFFSET		0x6f4
#define VOUT_DB_ANALOG_SCALE_PARAM_5_OFFSET		0x6f8
#define VOUT_DB_ANALOG_SD_SCALE_Y_OFFSET		0x6fc
#define VOUT_DB_ANALOG_SD_SCALE_PBPR_OFFSET		0x700
#define VOUT_DB_HDMI_OUTPUT_MODES_OFFSET		0x704
#define VOUT_DB_HDMI_HSYNC_CONTROL_OFFSET		0x708
#define VOUT_DB_HDMI_VSYNC_START_0_OFFSET		0x70c
#define VOUT_DB_HDMI_VSYNC_END_0_OFFSET			0x710
#define VOUT_DB_HDMI_VSYNC_START_1_OFFSET		0x714
#define VOUT_DB_HDMI_VSYNC_END_1_OFFSET			0x718
#define VOUT_DB_HDMI_CSC_PARAM_0_OFFSET			0x71c
#define VOUT_DB_HDMI_CSC_PARAM_1_OFFSET			0x720
#define VOUT_DB_HDMI_CSC_PARAM_2_OFFSET			0x724
#define VOUT_DB_HDMI_CSC_PARAM_3_OFFSET			0x728
#define VOUT_DB_HDMI_CSC_PARAM_4_OFFSET			0x72c
#define VOUT_DB_HDMI_CSC_PARAM_5_OFFSET			0x730
#define VOUT_DB_HDMI_CSC_PARAM_6_OFFSET			0x734
#define VOUT_DB_HDMI_CSC_PARAM_7_OFFSET			0x738
#define VOUT_DB_HDMI_CSC_PARAM_8_OFFSET			0x73c
#define VOUT_DB_DIGITAL_DITHER_SETTINGS_OFFSET		0x754
#define VOUT_DB_DIGITAL_DITHER_SEED_OFFSET		0x758
#define VOUT_DB_VOUT_VOUT_SYNC_OFFSET			0x75c
#define VOUT_DB_INPUT_STREAM_ENABLES_OFFSET		0x760
#define VOUT_DB_INPUT_SYNC_CONTROL_OFFSET		0x764
#define VOUT_DB_OUTPUT_SYNC_CONTROL_OFFSET		0x768
#define VOUT_DB_STREAM_CONTROL_OFFSET			0x76c
#define VOUT_DB_FRAME_ENABLE_OFFSET			0x770

/* OSD control registers */
#define VOUT_OSD_RESCALE_CONTROL_OFFSET				0x800
#define VOUT_OSD_RESCALE_WIDTH_OFFSET				0x804
#define VOUT_OSD_RESCALE_HORIZONTAL_PHASE_INC_OFFSET		0x808
#define VOUT_OSD_RESCALE_HORIZONTAL_PHASE_INIT_EVEN_OFFSET	0x80c
#define VOUT_OSD_RESCALE_HORIZONTAL_PHASE_INIT_ODD_OFFSET	0x810
#define VOUT_OSD_RESCALE_HEIGHT_OFFSET				0x814
#define VOUT_OSD_RESCALE_VERTICAL_PHASE_INC_OFFSET		0x818
#define VOUT_OSD_RESCALE_VERTICAL_PHASE_INIT_OFFSET		0x81c
#define VOUT_OSD_HORIZONTAL_COEFF_0_OFFSET			0x820
#define VOUT_OSD_HORIZONTAL_COEFF_1_OFFSET			0x824
#define VOUT_OSD_HORIZONTAL_COEFF_2_OFFSET			0x828
#define VOUT_OSD_HORIZONTAL_COEFF_3_OFFSET			0x82c
#define VOUT_OSD_HORIZONTAL_COEFF_4_OFFSET			0x830
#define VOUT_OSD_HORIZONTAL_COEFF_5_OFFSET			0x834
#define VOUT_OSD_HORIZONTAL_COEFF_6_OFFSET			0x838
#define VOUT_OSD_HORIZONTAL_COEFF_7_OFFSET			0x83c
#define VOUT_OSD_HORIZONTAL_COEFF_8_OFFSET			0x840
#define VOUT_OSD_HORIZONTAL_COEFF_9_OFFSET			0x844
#define VOUT_OSD_HORIZONTAL_COEFF_10_OFFSET			0x848
#define VOUT_OSD_HORIZONTAL_COEFF_11_OFFSET			0x84c
#define VOUT_OSD_HORIZONTAL_COEFF_12_OFFSET			0x850
#define VOUT_OSD_HORIZONTAL_COEFF_13_OFFSET			0x854
#define VOUT_OSD_HORIZONTAL_COEFF_14_OFFSET			0x858
#define VOUT_OSD_HORIZONTAL_COEFF_15_OFFSET			0x85c
#define VOUT_OSD_HORIZONTAL_COEFF_16_OFFSET			0x860
#define VOUT_OSD_HORIZONTAL_COEFF_17_OFFSET			0x864
#define VOUT_OSD_HORIZONTAL_COEFF_18_OFFSET			0x868
#define VOUT_OSD_HORIZONTAL_COEFF_19_OFFSET			0x86c
#define VOUT_OSD_HORIZONTAL_COEFF_20_OFFSET			0x870
#define VOUT_OSD_HORIZONTAL_COEFF_21_OFFSET			0x874
#define VOUT_OSD_HORIZONTAL_COEFF_22_OFFSET			0x878
#define VOUT_OSD_HORIZONTAL_COEFF_23_OFFSET			0x87c
#define VOUT_OSD_HORIZONTAL_COEFF_24_OFFSET			0x880
#define VOUT_OSD_HORIZONTAL_COEFF_25_OFFSET			0x884
#define VOUT_OSD_HORIZONTAL_COEFF_26_OFFSET			0x888
#define VOUT_OSD_HORIZONTAL_COEFF_27_OFFSET			0x88c
#define VOUT_OSD_HORIZONTAL_COEFF_28_OFFSET			0x890
#define VOUT_OSD_HORIZONTAL_COEFF_29_OFFSET			0x894
#define VOUT_OSD_HORIZONTAL_COEFF_30_OFFSET			0x898
#define VOUT_OSD_HORIZONTAL_COEFF_31_OFFSET			0x89c

#define VOUT_OSD_VERTICAL_COEFF_0_OFFSET			0x8a0
#define VOUT_OSD_VERTICAL_COEFF_1_OFFSET			0x8a4
#define VOUT_OSD_VERTICAL_COEFF_2_OFFSET			0x8a8
#define VOUT_OSD_VERTICAL_COEFF_3_OFFSET			0x8ac
#define VOUT_OSD_VERTICAL_COEFF_4_OFFSET			0x8b0
#define VOUT_OSD_VERTICAL_COEFF_5_OFFSET			0x8b4
#define VOUT_OSD_VERTICAL_COEFF_6_OFFSET			0x8b8
#define VOUT_OSD_VERTICAL_COEFF_7_OFFSET			0x8bc
#define VOUT_OSD_VERTICAL_COEFF_8_OFFSET			0x8c0
#define VOUT_OSD_VERTICAL_COEFF_9_OFFSET			0x8c4
#define VOUT_OSD_VERTICAL_COEFF_10_OFFSET			0x8c8
#define VOUT_OSD_VERTICAL_COEFF_11_OFFSET			0x8cc
#define VOUT_OSD_VERTICAL_COEFF_12_OFFSET			0x8d0
#define VOUT_OSD_VERTICAL_COEFF_13_OFFSET			0x8d4
#define VOUT_OSD_VERTICAL_COEFF_14_OFFSET			0x8d8
#define VOUT_OSD_VERTICAL_COEFF_15_OFFSET			0x8dc
#define VOUT_OSD_VERTICAL_COEFF_16_OFFSET			0x8e0
#define VOUT_OSD_VERTICAL_COEFF_17_OFFSET			0x8e4
#define VOUT_OSD_VERTICAL_COEFF_18_OFFSET			0x8e8
#define VOUT_OSD_VERTICAL_COEFF_19_OFFSET			0x8ec
#define VOUT_OSD_VERTICAL_COEFF_20_OFFSET			0x8f0
#define VOUT_OSD_VERTICAL_COEFF_21_OFFSET			0x8f4
#define VOUT_OSD_VERTICAL_COEFF_22_OFFSET			0x8f8
#define VOUT_OSD_VERTICAL_COEFF_23_OFFSET			0x8fc
#define VOUT_OSD_VERTICAL_COEFF_24_OFFSET			0x900
#define VOUT_OSD_VERTICAL_COEFF_25_OFFSET			0x904
#define VOUT_OSD_VERTICAL_COEFF_26_OFFSET			0x908
#define VOUT_OSD_VERTICAL_COEFF_27_OFFSET			0x90c
#define VOUT_OSD_VERTICAL_COEFF_28_OFFSET			0x910
#define VOUT_OSD_VERTICAL_COEFF_29_OFFSET			0x914
#define VOUT_OSD_VERTICAL_COEFF_30_OFFSET			0x918
#define VOUT_OSD_VERTICAL_COEFF_31_OFFSET			0x91c

#define VOUT_GAMMA_TABLE_BASE_OFFSET                            0x1000

/* Display A control regsiters */
#define VOUT_DA_CONTROL_REG				VOUT_REG(0x300)
#define VOUT_DA_STATUS_REG				VOUT_REG(0x304)
#define VOUT_DA_FRAME_SIZE_REG				VOUT_REG(0x308)
#define VOUT_DA_FRAME_HEIGHT_FIELD_1_REG            	VOUT_REG(0x30c)
#define VOUT_DA_ACTIVE_REGION_START_0_REG   		VOUT_REG(0x310)
#define VOUT_DA_ACTIVE_REGION_END_0_REG			VOUT_REG(0x314)
#define VOUT_DA_ACTIVE_REGION_START_1_REG   		VOUT_REG(0x318)
#define VOUT_DA_ACTIVE_REGION_END_1_REG     		VOUT_REG(0x31c)
#define VOUT_DA_BACKGROUND_REG	     			VOUT_REG(0x320)
#define VOUT_DA_DIGITAL_OUTPUT_MODES_REG            	VOUT_REG(0x324)
#define VOUT_DA_DIGITAL_HSYNC_CONTROL_REG  		VOUT_REG(0x328)
#define VOUT_DA_DIGITAL_VSYNC_START_0_REG  		VOUT_REG(0x32c)
#define VOUT_DA_DIGITAL_VSYNC_END_0_REG    		VOUT_REG(0x330)
#define VOUT_DA_DIGITAL_VSYNC_START_1_REG  		VOUT_REG(0x334)
#define VOUT_DA_DIGITAL_VSYNC_END_1_REG     		VOUT_REG(0x338)
#define VOUT_DA_DIGITAL_656_VBIT_REG			VOUT_REG(0x33c)
#define VOUT_DA_DIGITAL_656_SAV_START_REG		VOUT_REG(0x340)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_0_REG 		VOUT_REG(0x344)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_1_REG 		VOUT_REG(0x348)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_2_REG 		VOUT_REG(0x34c)
#define VOUT_DA_DIGITAL_CLOCK_PATTERN_3_REG 		VOUT_REG(0x350)
#define VOUT_DA_DIGITAL_CSC_PARAM_0_REG			VOUT_REG(0x354)
#define VOUT_DA_DIGITAL_CSC_PARAM_1_REG			VOUT_REG(0x358)
#define VOUT_DA_DIGITAL_CSC_PARAM_2_REG			VOUT_REG(0x35c)
#define VOUT_DA_DIGITAL_CSC_PARAM_3_REG			VOUT_REG(0x360)
#define VOUT_DA_DIGITAL_CSC_PARAM_4_REG			VOUT_REG(0x364)
#define VOUT_DA_DIGITAL_CSC_PARAM_5_REG			VOUT_REG(0x368)
#define VOUT_DA_DIGITAL_CSC_PARAM_6_REG			VOUT_REG(0x36c)
#define VOUT_DA_DIGITAL_CSC_PARAM_7_REG			VOUT_REG(0x370)
#define VOUT_DA_DIGITAL_CSC_PARAM_8_REG			VOUT_REG(0x374)
#define VOUT_DA_ANALOG_OUTPUT_MODE_REG			VOUT_REG(0x378)
#define VOUT_DA_ANALOG_HSYNC_CONTROL_REG		VOUT_REG(0x37c)
#define VOUT_DA_ANALOG_VSYNC_START_0_REG		VOUT_REG(0x380)
#define VOUT_DA_ANALOG_VSYNC_END_0_REG			VOUT_REG(0x384)
#define VOUT_DA_ANALOG_VSYNC_START_1_REG		VOUT_REG(0x388)
#define VOUT_DA_ANALOG_VSYNC_END_1_REG			VOUT_REG(0x38c)
#define VOUT_DA_ANALOG_VBI_CONTROL_REG			VOUT_REG(0x390)
#define VOUT_DA_ANALOG_VBI_START_V_REG			VOUT_REG(0x394)
#define VOUT_DA_ANALOG_VBI_H_REG			VOUT_REG(0x398)
#define VOUT_DA_ANALOG_VBI_DATA0_REG			VOUT_REG(0x39c)
#define VOUT_DA_ANALOG_VBI_DATA1_REG			VOUT_REG(0x3a0)
#define VOUT_DA_ANALOG_VBI_DATA2_REG			VOUT_REG(0x3a4)
#define VOUT_DA_ANALOG_VBI_DATA3_REG			VOUT_REG(0x3a8)
#define VOUT_DA_ANALOG_VBI_DATA4_REG			VOUT_REG(0x3ac)
#define VOUT_DA_ANALOG_VBI_DATA5_REG			VOUT_REG(0x3b0)
#define VOUT_DA_ANALOG_VBI_DATA6_REG			VOUT_REG(0x3b4)
#define VOUT_DA_ANALOG_VBI_DATA7_REG			VOUT_REG(0x3b8)
#define VOUT_DA_ANALOG_VBI_DATA8_REG			VOUT_REG(0x3bc)
#define VOUT_DA_ANALOG_VBI_DATA9_REG			VOUT_REG(0x3c0)
#define VOUT_DA_ANALOG_VBI_DATA10_REG			VOUT_REG(0x3c4)
#define VOUT_DA_ANALOG_VBI_DATA11_REG			VOUT_REG(0x3c8)
#define VOUT_DA_ANALOG_CSC_PARAM_0_REG			VOUT_REG(0x3cc)
#define VOUT_DA_ANALOG_CSC_PARAM_1_REG			VOUT_REG(0x3d0)
#define VOUT_DA_ANALOG_CSC_PARAM_2_REG			VOUT_REG(0x3d4)
#define VOUT_DA_ANALOG_CSC_PARAM_3_REG			VOUT_REG(0x3d8)
#define VOUT_DA_ANALOG_CSC_PARAM_4_REG			VOUT_REG(0x3dc)
#define VOUT_DA_ANALOG_CSC_PARAM_5_REG			VOUT_REG(0x3e0)
#define VOUT_DA_ANALOG_CSC_2_PARAM_0_REG		VOUT_REG(0x3e4)
#define VOUT_DA_ANALOG_CSC_2_PARAM_1_REG		VOUT_REG(0x3e8)
#define VOUT_DA_ANALOG_CSC_2_PARAM_2_REG		VOUT_REG(0x3ec)
#define VOUT_DA_ANALOG_CSC_2_PARAM_3_REG		VOUT_REG(0x3f0)
#define VOUT_DA_ANALOG_CSC_2_PARAM_4_REG		VOUT_REG(0x3f4)
#define VOUT_DA_ANALOG_CSC_2_PARAM_5_REG		VOUT_REG(0x3f8)
#define VOUT_DA_DIGITAL_DITHER_SETTINGS_REG		VOUT_REG(0x454)
#define VOUT_DA_DIGITAL_DITHER_SEED_REG			VOUT_REG(0x458)
#define VOUT_DA_VOUT_VOUT_SYNC_REG			VOUT_REG(0x45c)
#define VOUT_DA_INPUT_STREAM_ENABLES_REG		VOUT_REG(0x460)
#define VOUT_DA_INPUT_SYNC_CONTROL_REG			VOUT_REG(0x464)
#define VOUT_DA_OUTPUT_SYNC_CONTROL_REG			VOUT_REG(0x468)
#define VOUT_DA_STREAM_CONTROL_REG			VOUT_REG(0x46c)
#define VOUT_DA_FRAME_ENABLE_REG			VOUT_REG(0x470)

/* Display B control regsiters */
#define VOUT_DB_CONTROL_REG				VOUT_REG(0x600)
#define VOUT_DB_STATUS_REG				VOUT_REG(0x604)
#define VOUT_DB_FRAME_SIZE_REG				VOUT_REG(0x608)
#define VOUT_DB_FRAME_HEIGHT_FIELD_1_REG		VOUT_REG(0x60c)
#define VOUT_DB_ACTIVE_REGION_START_0_REG		VOUT_REG(0x610)
#define VOUT_DB_ACTIVE_REGION_END_0_REG			VOUT_REG(0x614)
#define VOUT_DB_ACTIVE_REGION_START_1_REG		VOUT_REG(0x618)
#define VOUT_DB_ACTIVE_REGION_END_1_REG			VOUT_REG(0x61c)
#define VOUT_DB_BACKGROUND_REG				VOUT_REG(0x620)
#define VOUT_DB_OUTPUT_MODES_REG			VOUT_REG(0x624)
#define VOUT_DB_DIGITAL_HSYNC_CONTROL_REG		VOUT_REG(0x628)
#define VOUT_DB_DIGITAL_VSYNC_START_0_REG		VOUT_REG(0x62c)
#define VOUT_DB_DIGITAL_VSYNC_END_0_REG			VOUT_REG(0x630)
#define VOUT_DB_DIGITAL_VSYNC_START_1_REG		VOUT_REG(0x634)
#define VOUT_DB_DIGITAL_VSYNC_END_1_REG			VOUT_REG(0x638)
#define VOUT_DB_DIGITAL_656_VBIT_REG			VOUT_REG(0x63c)
#define VOUT_DB_DIGITAL_656_SAV_START_REG		VOUT_REG(0x640)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_0_REG		VOUT_REG(0x644)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_1_REG		VOUT_REG(0x648)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_2_REG		VOUT_REG(0x64c)
#define VOUT_DB_DIGITAL_CLOCK_PATTERN_3_REG		VOUT_REG(0x650)
#define VOUT_DB_DIGITAL_CSC_PARAM_0_REG			VOUT_REG(0x654)
#define VOUT_DB_DIGITAL_CSC_PARAM_1_REG			VOUT_REG(0x658)
#define VOUT_DB_DIGITAL_CSC_PARAM_2_REG			VOUT_REG(0x65c)
#define VOUT_DB_DIGITAL_CSC_PARAM_3_REG			VOUT_REG(0x660)
#define VOUT_DB_DIGITAL_CSC_PARAM_4_REG			VOUT_REG(0x664)
#define VOUT_DB_DIGITAL_CSC_PARAM_5_REG			VOUT_REG(0x668)
#define VOUT_DB_DIGITAL_CSC_PARAM_6_REG			VOUT_REG(0x66c)
#define VOUT_DB_DIGITAL_CSC_PARAM_7_REG			VOUT_REG(0x670)
#define VOUT_DB_DIGITAL_CSC_PARAM_8_REG			VOUT_REG(0x674)
#define VOUT_DB_ANALOG_OUTPUT_MODE_REG			VOUT_REG(0x678)
#define VOUT_DB_ANALOG_HSYNC_CONTROL_REG		VOUT_REG(0x67c)
#define VOUT_DB_ANALOG_VSYNC_START_0_REG		VOUT_REG(0x680)
#define VOUT_DB_ANALOG_VSYNC_END_0_REG			VOUT_REG(0x684)
#define VOUT_DB_ANALOG_VSYNC_START_1_REG		VOUT_REG(0x688)
#define VOUT_DB_ANALOG_VSYNC_END_1_REG			VOUT_REG(0x68c)
#define VOUT_DB_ANALOG_VBI_CONTROL_REG			VOUT_REG(0x690)
#define VOUT_DB_ANALOG_VBI_START_V_REG			VOUT_REG(0x694)
#define VOUT_DB_ANALOG_VBI_H_REG			VOUT_REG(0x698)
#define VOUT_DB_ANALOG_VBI_DATA0_REG			VOUT_REG(0x69c)
#define VOUT_DB_ANALOG_VBI_DATA1_REG			VOUT_REG(0x6a0)
#define VOUT_DB_ANALOG_VBI_DATA2_REG			VOUT_REG(0x6a4)
#define VOUT_DB_ANALOG_VBI_DATA3_REG			VOUT_REG(0x6a8)
#define VOUT_DB_ANALOG_VBI_DATA4_REG			VOUT_REG(0x6ac)
#define VOUT_DB_ANALOG_VBI_DATA5_REG			VOUT_REG(0x6b0)
#define VOUT_DB_ANALOG_VBI_DATA6_REG			VOUT_REG(0x6b4)
#define VOUT_DB_ANALOG_VBI_DATA7_REG			VOUT_REG(0x6b8)
#define VOUT_DB_ANALOG_VBI_DATA8_REG			VOUT_REG(0x6bc)
#define VOUT_DB_ANALOG_VBI_DATA9_REG			VOUT_REG(0x6c0)
#define VOUT_DB_ANALOG_VBI_DATA10_REG			VOUT_REG(0x6c4)
#define VOUT_DB_ANALOG_VBI_DATA11_REG			VOUT_REG(0x6c8)
#define VOUT_DB_ANALOG_CSC_PARAM_0_REG			VOUT_REG(0x6cc)
#define VOUT_DB_ANALOG_CSC_PARAM_1_REG			VOUT_REG(0x6d0)
#define VOUT_DB_ANALOG_CSC_PARAM_2_REG			VOUT_REG(0x6d4)
#define VOUT_DB_ANALOG_CSC_PARAM_3_REG			VOUT_REG(0x6d8)
#define VOUT_DB_ANALOG_CSC_PARAM_4_REG			VOUT_REG(0x6dc)
#define VOUT_DB_ANALOG_CSC_PARAM_5_REG			VOUT_REG(0x6e0)
#define VOUT_DB_ANALOG_CSC_2_PARAM_0_REG		VOUT_REG(0x6e4)
#define VOUT_DB_ANALOG_CSC_2_PARAM_1_REG		VOUT_REG(0x6e8)
#define VOUT_DB_ANALOG_CSC_2_PARAM_2_REG		VOUT_REG(0x6ec)
#define VOUT_DB_ANALOG_CSC_2_PARAM_3_REG		VOUT_REG(0x6f0)
#define VOUT_DB_ANALOG_CSC_2_PARAM_4_REG		VOUT_REG(0x6f4)
#define VOUT_DB_ANALOG_CSC_2_PARAM_5_REG		VOUT_REG(0x6f8)
#define VOUT_DB_ANALOG_SD_SCALE_Y_REG			VOUT_REG(0x6fc)
#define VOUT_DB_ANALOG_SD_SCALE_PBPR_REG		VOUT_REG(0x700)
#define VOUT_DB_HDMI_OUTPUT_MODE_REG			VOUT_REG(0x704)
#define VOUT_DB_HDMI_HSYNC_CONTROL_REG			VOUT_REG(0x708)
#define VOUT_DB_HDMI_VSYNC_START_0_REG			VOUT_REG(0x70c)
#define VOUT_DB_HDMI_VSYNC_END_0_REG			VOUT_REG(0x710)
#define VOUT_DB_HDMI_VSYNC_START_1_REG			VOUT_REG(0x714)
#define VOUT_DB_HDMI_VSYNC_END_1_REG			VOUT_REG(0x718)
#define VOUT_DB_HDMI_CSC_PARAM_0_REG			VOUT_REG(0x71c)
#define VOUT_DB_HDMI_CSC_PARAM_1_REG			VOUT_REG(0x720)
#define VOUT_DB_HDMI_CSC_PARAM_2_REG			VOUT_REG(0x724)
#define VOUT_DB_HDMI_CSC_PARAM_3_REG			VOUT_REG(0x728)
#define VOUT_DB_HDMI_CSC_PARAM_4_REG			VOUT_REG(0x72c)
#define VOUT_DB_HDMI_CSC_PARAM_5_REG			VOUT_REG(0x730)
#define VOUT_DB_HDMI_CSC_PARAM_6_REG			VOUT_REG(0x734)
#define VOUT_DB_HDMI_CSC_PARAM_7_REG			VOUT_REG(0x738)
#define VOUT_DB_HDMI_CSC_PARAM_8_REG			VOUT_REG(0x73c)
#define VOUT_DB_DIGITAL_DITHER_SETTINGS_REG		VOUT_REG(0x754)
#define VOUT_DB_DIGITAL_DITHER_SEED_REG			VOUT_REG(0x758)
#define VOUT_DB_VOUT_VOUT_SYNC_REG			VOUT_REG(0x75c)
#define VOUT_DB_INPUT_STREAM_ENABLES_REG		VOUT_REG(0x760)
#define VOUT_DB_INPUT_SYNC_CONTROL_REG			VOUT_REG(0x764)
#define VOUT_DB_OUTPUT_SYNC_CONTROL_REG			VOUT_REG(0x768)
#define VOUT_DB_STREAM_CONTROL_REG			VOUT_REG(0x76c)
#define VOUT_DB_FRAME_ENABLE_REG			VOUT_REG(0x770)

/* OSD control registers */
#define VOUT_OSD_RESCALE_CONTROL_REG			VOUT_REG(0x800)
#define VOUT_OSD_RESCALE_WIDTH_REG			VOUT_REG(0x804)
#define VOUT_OSD_RESCALE_HORIZONTAL_PHASE_INC_REG	VOUT_REG(0x808)
#define VOUT_OSD_RESCALE_HORIZONTAL_PHASE_INIT_EVEN_REG	VOUT_REG(0x80c)
#define VOUT_OSD_RESCALE_HORIZONTAL_PHASE_INIT_ODD_REG	VOUT_REG(0x810)
#define VOUT_OSD_RESCALE_HEIGHT_REG			VOUT_REG(0x814)
#define VOUT_OSD_RESCALE_VERTICAL_PHASE_INC_REG		VOUT_REG(0x818)
#define VOUT_OSD_RESCALE_VERTICAL_PHASE_INIT_REG	VOUT_REG(0x81c)
#define VOUT_OSD_HORIZONTAL_COEFF_0_REG			VOUT_REG(0x820)
#define VOUT_OSD_HORIZONTAL_COEFF_1_REG			VOUT_REG(0x824)
#define VOUT_OSD_HORIZONTAL_COEFF_2_REG			VOUT_REG(0x828)
#define VOUT_OSD_HORIZONTAL_COEFF_3_REG			VOUT_REG(0x82c)
#define VOUT_OSD_HORIZONTAL_COEFF_4_REG			VOUT_REG(0x830)
#define VOUT_OSD_HORIZONTAL_COEFF_5_REG			VOUT_REG(0x834)
#define VOUT_OSD_HORIZONTAL_COEFF_6_REG			VOUT_REG(0x838)
#define VOUT_OSD_HORIZONTAL_COEFF_7_REG			VOUT_REG(0x83c)
#define VOUT_OSD_HORIZONTAL_COEFF_8_REG			VOUT_REG(0x840)
#define VOUT_OSD_HORIZONTAL_COEFF_9_REG			VOUT_REG(0x844)
#define VOUT_OSD_HORIZONTAL_COEFF_10_REG		VOUT_REG(0x848)
#define VOUT_OSD_HORIZONTAL_COEFF_11_REG		VOUT_REG(0x84c)
#define VOUT_OSD_HORIZONTAL_COEFF_12_REG		VOUT_REG(0x850)
#define VOUT_OSD_HORIZONTAL_COEFF_13_REG		VOUT_REG(0x854)
#define VOUT_OSD_HORIZONTAL_COEFF_14_REG		VOUT_REG(0x858)
#define VOUT_OSD_HORIZONTAL_COEFF_15_REG		VOUT_REG(0x85c)
#define VOUT_OSD_HORIZONTAL_COEFF_16_REG		VOUT_REG(0x860)
#define VOUT_OSD_HORIZONTAL_COEFF_17_REG		VOUT_REG(0x864)
#define VOUT_OSD_HORIZONTAL_COEFF_18_REG		VOUT_REG(0x868)
#define VOUT_OSD_HORIZONTAL_COEFF_19_REG		VOUT_REG(0x86c)
#define VOUT_OSD_HORIZONTAL_COEFF_20_REG		VOUT_REG(0x870)
#define VOUT_OSD_HORIZONTAL_COEFF_21_REG		VOUT_REG(0x874)
#define VOUT_OSD_HORIZONTAL_COEFF_22_REG		VOUT_REG(0x878)
#define VOUT_OSD_HORIZONTAL_COEFF_23_REG		VOUT_REG(0x87c)
#define VOUT_OSD_HORIZONTAL_COEFF_24_REG		VOUT_REG(0x880)
#define VOUT_OSD_HORIZONTAL_COEFF_25_REG		VOUT_REG(0x884)
#define VOUT_OSD_HORIZONTAL_COEFF_26_REG		VOUT_REG(0x888)
#define VOUT_OSD_HORIZONTAL_COEFF_27_REG		VOUT_REG(0x88c)
#define VOUT_OSD_HORIZONTAL_COEFF_28_REG		VOUT_REG(0x890)
#define VOUT_OSD_HORIZONTAL_COEFF_29_REG		VOUT_REG(0x894)
#define VOUT_OSD_HORIZONTAL_COEFF_30_REG		VOUT_REG(0x898)
#define VOUT_OSD_HORIZONTAL_COEFF_31_REG		VOUT_REG(0x89c)

#define VOUT_OSD_VERTICAL_COEFF_0_REG			VOUT_REG(0x8a0)
#define VOUT_OSD_VERTICAL_COEFF_1_REG			VOUT_REG(0x8a4)
#define VOUT_OSD_VERTICAL_COEFF_2_REG			VOUT_REG(0x8a8)
#define VOUT_OSD_VERTICAL_COEFF_3_REG			VOUT_REG(0x8ac)
#define VOUT_OSD_VERTICAL_COEFF_4_REG			VOUT_REG(0x8b0)
#define VOUT_OSD_VERTICAL_COEFF_5_REG			VOUT_REG(0x8b4)
#define VOUT_OSD_VERTICAL_COEFF_6_REG			VOUT_REG(0x8b8)
#define VOUT_OSD_VERTICAL_COEFF_7_REG			VOUT_REG(0x8bc)
#define VOUT_OSD_VERTICAL_COEFF_8_REG			VOUT_REG(0x8c0)
#define VOUT_OSD_VERTICAL_COEFF_9_REG			VOUT_REG(0x8c4)
#define VOUT_OSD_VERTICAL_COEFF_10_REG			VOUT_REG(0x8c8)
#define VOUT_OSD_VERTICAL_COEFF_11_REG			VOUT_REG(0x8cc)
#define VOUT_OSD_VERTICAL_COEFF_12_REG			VOUT_REG(0x8d0)
#define VOUT_OSD_VERTICAL_COEFF_13_REG			VOUT_REG(0x8d4)
#define VOUT_OSD_VERTICAL_COEFF_14_REG			VOUT_REG(0x8d8)
#define VOUT_OSD_VERTICAL_COEFF_15_REG			VOUT_REG(0x8dc)
#define VOUT_OSD_VERTICAL_COEFF_16_REG			VOUT_REG(0x8e0)
#define VOUT_OSD_VERTICAL_COEFF_17_REG			VOUT_REG(0x8e4)
#define VOUT_OSD_VERTICAL_COEFF_18_REG			VOUT_REG(0x8e8)
#define VOUT_OSD_VERTICAL_COEFF_19_REG			VOUT_REG(0x8ec)
#define VOUT_OSD_VERTICAL_COEFF_20_REG			VOUT_REG(0x8f0)
#define VOUT_OSD_VERTICAL_COEFF_21_REG			VOUT_REG(0x8f4)
#define VOUT_OSD_VERTICAL_COEFF_22_REG			VOUT_REG(0x8f8)
#define VOUT_OSD_VERTICAL_COEFF_23_REG			VOUT_REG(0x8fc)
#define VOUT_OSD_VERTICAL_COEFF_24_REG			VOUT_REG(0x900)
#define VOUT_OSD_VERTICAL_COEFF_25_REG			VOUT_REG(0x904)
#define VOUT_OSD_VERTICAL_COEFF_26_REG			VOUT_REG(0x908)
#define VOUT_OSD_VERTICAL_COEFF_27_REG			VOUT_REG(0x90c)
#define VOUT_OSD_VERTICAL_COEFF_28_REG			VOUT_REG(0x910)
#define VOUT_OSD_VERTICAL_COEFF_29_REG			VOUT_REG(0x914)
#define VOUT_OSD_VERTICAL_COEFF_30_REG			VOUT_REG(0x918)
#define VOUT_OSD_VERTICAL_COEFF_31_REG			VOUT_REG(0x91c)

#define VOUT_GAMMA_TABLE_BASE_REG                       VOUT_REG(0x1000)

#endif /* CHIP_REV == A5S */

#endif /* (VOUT_DISPLAY_SECTIONS == 2) */

#endif
