/**
 * system/include/basedef.h
 *
 * History:
 *    2004/10/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __BASEDEF_H__
#define __BASEDEF_H__

//#include <hwio.h>

#ifndef __ASSEMBLY__ //__ASM__

#ifndef NULL
#define NULL ((void *) 0x0)
#endif

#if defined __cplusplus && defined(__GNUC__)
#undef NULL
#define NULL 0x0
#endif

#if defined(__GNUC__)
/* GNU Compiler Setting */
#ifndef __ATTRIB_PACK__
#define __ATTRIB_PACK__  __attribute__ ((packed))
#endif
#ifndef __ARMCC_PACK__
#define __ARMCC_PACK__
#endif
#ifndef __GNU_ALIGN
#define __GNU_ALIGN(x)	__attribute__ ((aligned(x)))
#endif
#ifndef __ARMCC_ALIGN
#define __ARMCC_ALIGN(x)
#endif
#ifndef __ATTRIB_WEAK__
#define __ATTRIB_WEAK__	__attribute__((weak))
#endif
#ifndef __ARMCC_WEAK__
#define __ARMCC_WEAK__
#endif
#elif defined(__arm)
/* RVCT or ADS Compiler setting */
#ifndef __ATTRIB_PACK__
#define __ATTRIB_PACK__
#endif
#ifndef __ARMCC_PACK__
#define __ARMCC_PACK__  __packed
#endif
#ifndef __GNU_ALIGN
#define __GNU_ALIGN(x)
#endif
#ifndef __ARMCC_ALIGN
#define __ARMCC_ALIGN(x) __align(x)
#endif
#define inline __inline
#ifndef __ATTRIB_WEAK__
#define __ATTRIB_WEAK__
#endif
#ifndef __ARMCC_WEAK__
#define __ARMCC_WEAK__	__weak
#endif
#else
/* Unknown compiler */
#ifndef __ATTRIB_PACK__
#define __ATTRIB_PACK__
#endif
#ifndef __ARMCC_PACK__
#define __ARMCC_PACK__
#endif
#ifndef __GNU_ALIGN
#define __GNU_ALIGN(x)
#endif
#ifndef __ARMCC_ALIGN
#define __ARMCC_ALIGN(x)
#endif
#ifndef __ATTRIB_WEAK__
#define __ATTRIB_WEAK__
#endif
#ifndef __ARMCC_WEAK__
#define __ARMCC_WEAK__
#endif
#endif

#ifdef  __cplusplus
#ifndef __BEGIN_C_PROTO__
#define __BEGIN_C_PROTO__ extern "C" {
#endif
#ifndef __END_C_PROTO__
#define __END_C_PROTO__ }
#endif
#else
#ifndef __BEGIN_C_PROTO__
#define __BEGIN_C_PROTO__
#endif
#ifndef __END_C_PROTO__
#define __END_C_PROTO__
#endif
#endif

#endif  /* !__ASM__ */

#ifndef xstr
#define xstr(s) str(s)
#endif

#ifndef str
#define str(s) #s
#endif

#define AMB_VER_NUM(major,minor) ((major << 16) | (minor))
#define AMB_VER_DATE(year,month,day) ((year << 16) | (month << 8) | day)

#endif
