/**
 * @file system/include/flash/slcnand/h27u518s2c.h
 *
 * History:
 *    2010/09/15 - [Evan Chen] created file
 *
 * Copyright (C) 2010-2014, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __H27U518S2C_H__
#define __H27U518S2C_H__

#define __NAND_H27U518S2C_CONTROL						  \
	(NAND_CTR_P3		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_SZ_512M	|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_H27U518S2C_MANID		0xad
#define NAND_H27U518S2C_DEVID		0x76
#define NAND_H27U518S2C_ID3		0x00
#define NAND_H27U518S2C_ID4		0x00

/**
 * define for device info
 */
#define NAND_H27U518S2C_MAIN_SIZE		512
#define NAND_H27U518S2C_SPARE_SIZE		16
#define NAND_H27U518S2C_PAGE_SIZE		528
#define NAND_H27U518S2C_PAGES_PER_BLOCK	32
#define NAND_H27U518S2C_BLOCKS_PER_PLANE	2048
#define NAND_H27U518S2C_BLOCKS_PER_ZONE	1024
#define NAND_H27U518S2C_BLOCKS_PER_BANK	4096
#define NAND_H27U518S2C_PLANES_PER_BANK	(NAND_H27U518S2C_BLOCKS_PER_BANK / NAND_H27U518S2C_BLOCKS_PER_PLANE)
#define NAND_H27U518S2C_BANKS_PER_DEVICE	1
#define NAND_H27U518S2C_TOTAL_BLOCKS	(NAND_H27U518S2C_BLOCKS_PER_BANK * NAND_H27U518S2C_BANKS_PER_DEVICE)
#define NAND_H27U518S2C_TOTAL_ZONES	(NAND_H27U518S2C_TOTAL_BLOCKS / NAND_H27U518S2C_BLOCKS_PER_ZONE)
#define NAND_H27U518S2C_TOTAL_PLANES	(NAND_H27U518S2C_TOTAL_BLOCKS / NAND_H27U518S2C_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_H27U518S2C_BLOCK_ADDR_BIT	14
#define NAND_H27U518S2C_PLANE_ADDR_BIT	25
#define NAND_H27U518S2C_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_H27U518S2C_PLANE_ADDR_MASK	(NAND_H27U518S2C_PLANE_MASK << (NAND_H27U518S2C_PLANE_ADDR_BIT - \
						     NAND_H27U518S2C_BLOCK_ADDR_BIT))

#define NAND_H27U518S2C_PLANE_MAP		NAND_PLANE_MAP_2
#define NAND_H27U518S2C_COLUMN_CYCLES	1
#define NAND_H27U518S2C_PAGE_CYCLES	3
#define NAND_H27U518S2C_ID_CYCLES		2
#define NAND_H27U518S2C_CHIP_WIDTH		8
#define NAND_H27U518S2C_CHIP_SIZE_MB	64
#define NAND_H27U518S2C_BUS_WIDTH		8

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_H27U518S2C	"HYNIX H27U518S2C_64MB_PG512"

#define NAND_H27U518S2C_TOTAL_BANKS	(NAND_DEVICES * NAND_H27U518S2C_BANKS_PER_DEVICE)

#if (NAND_TOTAL_BANKS == 1)
#define NAND_H27U518S2C_CONTROL		(__NAND_H27U518S2C_CONTROL | NAND_CTR_1BANK)
#elif (NAND_H27U518S2C_TOTAL_BANKS == 2)
#define NAND_H27U518S2C_CONTROL		(__NAND_H27U518S2C_CONTROL | NAND_CTR_2BANK)
#elif (NAND_H27U518S2C_TOTAL_BANKS == 4)
#define NAND_H27U518S2C_CONTROL		(__NAND_H27U518S2C_CONTROL | NAND_CTR_4BANK)
#elif (NAND_H27U518S2C_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_H27U518S2C_BB_MARKER_OFFSET	5	/* bad block information */

/**
 * define for partition info
 */
#define NAND_H27U518S2C_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_H27U518S2C_TCLS		15
#define NAND_H27U518S2C_TALS		15
#define NAND_H27U518S2C_TCS		20
#define NAND_H27U518S2C_TDS		15
#define NAND_H27U518S2C_TCLH		5
#define NAND_H27U518S2C_TALH		5
#define NAND_H27U518S2C_TCH		5
#define NAND_H27U518S2C_TDH		5
#define NAND_H27U518S2C_TWP		15
#define NAND_H27U518S2C_TWH		10
#define NAND_H27U518S2C_TWB		100
#define NAND_H27U518S2C_TRR		20
#define NAND_H27U518S2C_TRP		15
#define NAND_H27U518S2C_TREH		10
#define NAND_H27U518S2C_TRB		100
#define NAND_H27U518S2C_TCEH		100
#define NAND_H27U518S2C_TRDELAY		30	/* trea*/
#define NAND_H27U518S2C_TCLR		10
#define NAND_H27U518S2C_TWHR		60
#define NAND_H27U518S2C_TIR		0
#define NAND_H27U518S2C_TWW		25	/* not define */
#define NAND_H27U518S2C_TRHZ		30
#define NAND_H27U518S2C_TAR		50	/* for 3.3V device */

#endif

