/**
 * @file system/include/flash/slcnand/hy27uf084g2b.h
 *
 * History:
 *    2009/11/10 - [Chien-Yang Chen] created file
 *
 * Copyright (C) 2004-2009, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27UF084G2B_H__
#define __HY27UF084G2B_H__

#define __NAND_HY27UF082G2A_CONTROL						  \
	(NAND_CTR_P3		|				  \
	 NAND_CTR_C2		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_4G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27UF082G2A_MANID		0xad
#define NAND_HY27UF082G2A_DEVID		0xdc
#define NAND_HY27UF082G2A_ID3		0x10
#define NAND_HY27UF082G2A_ID4		0x95

/**
 * define for device info
 */
#define NAND_HY27UF082G2A_MAIN_SIZE		2048
#define NAND_HY27UF082G2A_SPARE_SIZE		64
#define NAND_HY27UF082G2A_PAGE_SIZE		2112
#define NAND_HY27UF082G2A_PAGES_PER_BLOCK	64
#define NAND_HY27UF082G2A_BLOCKS_PER_PLANE	2048
#define NAND_HY27UF082G2A_BLOCKS_PER_ZONE	1024
#define NAND_HY27UF082G2A_BLOCKS_PER_BANK	4096
#define NAND_HY27UF082G2A_PLANES_PER_BANK	(NAND_HY27UF082G2A_BLOCKS_PER_BANK / NAND_HY27UF082G2A_BLOCKS_PER_PLANE)
#define NAND_HY27UF082G2A_BANKS_PER_DEVICE	1
#define NAND_HY27UF082G2A_TOTAL_BLOCKS	(NAND_HY27UF082G2A_BLOCKS_PER_BANK * NAND_HY27UF082G2A_BANKS_PER_DEVICE)
#define NAND_HY27UF082G2A_TOTAL_ZONES	(NAND_HY27UF082G2A_TOTAL_BLOCKS / NAND_HY27UF082G2A_BLOCKS_PER_ZONE)
#define NAND_HY27UF082G2A_TOTAL_PLANES	(NAND_HY27UF082G2A_TOTAL_BLOCKS / NAND_HY27UF082G2A_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27UF082G2A_BLOCK_ADDR_BIT	18
#define NAND_HY27UF082G2A_PLANE_ADDR_BIT	18
#define NAND_HY27UF082G2A_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27UF082G2A_PLANE_ADDR_MASK	(NAND_HY27UF082G2A_PLANE_MASK << (NAND_HY27UF082G2A_PLANE_ADDR_BIT - \
						     NAND_HY27UF082G2A_BLOCK_ADDR_BIT))

#define NAND_HY27UF082G2A_PLANE_MAP		NAND_PLANE_MAP_1
#define NAND_HY27UF082G2A_COLUMN_CYCLES	2
#define NAND_HY27UF082G2A_PAGE_CYCLES	3
#define NAND_HY27UF082G2A_ID_CYCLES		4
#define NAND_HY27UF082G2A_CHIP_WIDTH		8
#define NAND_HY27UF082G2A_CHIP_SIZE_MB	512
#define NAND_HY27UF082G2A_BUS_WIDTH		8

#define NAND_HY27UF082G2A	"HYNIX HY27UF084G2B_512MB_PG2K"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27UF082G2A_TOTAL_BANKS	(NAND_DEVICES * NAND_HY27UF082G2A_BANKS_PER_DEVICE)

#if (NAND_HY27UF082G2A_TOTAL_BANKS == 1)
#define NAND_HY27UF082G2A_CONTROL		(__NAND_HY27UF082G2A_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27UF082G2A_TOTAL_BANKS == 2)
#define NAND_HY27UF082G2A_CONTROL		(__NAND_HY27UF082G2A_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27UF082G2A_TOTAL_BANKS == 4)
#define NAND_HY27UF082G2A_CONTROL		(__NAND_HY27UF082G2A_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27UF082G2A_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27UF082G2A_BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27UF082G2A_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27UF082G2A_TCLS		15
#define NAND_HY27UF082G2A_TALS		15
#define NAND_HY27UF082G2A_TCS		25
#define NAND_HY27UF082G2A_TDS		15
#define NAND_HY27UF082G2A_TCLH		5
#define NAND_HY27UF082G2A_TALH		5
#define NAND_HY27UF082G2A_TCH		5
#define NAND_HY27UF082G2A_TDH		5
#define NAND_HY27UF082G2A_TWP		15
#define NAND_HY27UF082G2A_TWH		10
#define NAND_HY27UF082G2A_TWB		100
#define NAND_HY27UF082G2A_TRR		20
#define NAND_HY27UF082G2A_TRP		15
#define NAND_HY27UF082G2A_TREH		10
#define NAND_HY27UF082G2A_TRB		100
#define NAND_HY27UF082G2A_TCEH		30
#define NAND_HY27UF082G2A_TRDELAY		25	/* trea*/
#define NAND_HY27UF082G2A_TCLR		15
#define NAND_HY27UF082G2A_TWHR		60
#define NAND_HY27UF082G2A_TIR		0
#define NAND_HY27UF082G2A_TWW		100	/* not define */
#define NAND_HY27UF082G2A_TRHZ		50	/* use max value */
#define NAND_HY27UF082G2A_TAR		15

#endif

