/**
 * @file system/include/flash/slcnand/hy27us08281a.h
 *
 * History:
 *    2007/02/08 - [Chien-Yang Chen] created file
 *
 * Copyright (C) 2004-2008, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27US08281A_H__
#define __HY27US08281A_H__

#define __NAND_HY27US08281A_CONTROL						  \
	(NAND_CTR_IE		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_SZ_128M	|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27US08281A_MANID		0xad
#define NAND_HY27US08281A_DEVID		0x73
#define NAND_HY27US08281A_ID3		0x00
#define NAND_HY27US08281A_ID4		0x00

/**
 * define for device info
 */
#define NAND_HY27US08281A_MAIN_SIZE		512
#define NAND_HY27US08281A_SPARE_SIZE		16
#define NAND_HY27US08281A_PAGE_SIZE		528
#define NAND_HY27US08281A_PAGES_PER_BLOCK	32
#define NAND_HY27US08281A_BLOCKS_PER_PLANE	1024
#define NAND_HY27US08281A_BLOCKS_PER_ZONE	1024
#define NAND_HY27US08281A_BLOCKS_PER_BANK	1024
#define NAND_HY27US08281A_PLANES_PER_BANK	(NAND_HY27US08281A_BLOCKS_PER_BANK / NAND_HY27US08281A_BLOCKS_PER_PLANE)
#define NAND_HY27US08281A_BANKS_PER_DEVICE	1
#define NAND_HY27US08281A_TOTAL_BLOCKS	(NAND_HY27US08281A_BLOCKS_PER_BANK * NAND_HY27US08281A_BANKS_PER_DEVICE)
#define NAND_HY27US08281A_TOTAL_ZONES	(NAND_HY27US08281A_TOTAL_BLOCKS / NAND_HY27US08281A_BLOCKS_PER_ZONE)
#define NAND_HY27US08281A_TOTAL_PLANES	(NAND_HY27US08281A_TOTAL_BLOCKS / NAND_HY27US08281A_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27US08281A_BLOCK_ADDR_BIT	14
#define NAND_HY27US08281A_PLANE_ADDR_BIT	23
#define NAND_HY27US08281A_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27US08281A_PLANE_ADDR_MASK	(NAND_HY27US08281A_PLANE_MASK << (NAND_HY27US08281A_PLANE_ADDR_BIT - \
						     NAND_HY27US08281A_BLOCK_ADDR_BIT))

#define NAND_HY27US08281A_PLANE_MAP		NAND_HY27US08281A_PLANE_MAP_2
#define NAND_HY27US08281A_COLUMN_CYCLES	1
#define NAND_HY27US08281A_PAGE_CYCLES	2
#define NAND_HY27US08281A_ID_CYCLES		2
#define NAND_HY27US08281A_CHIP_WIDTH		8
#define NAND_HY27US08281A_CHIP_SIZE_MB	16
#define NAND_HY27US08281A_BUS_WIDTH		8

#define NAND_HY27US08281A	"HYNIX HY27US08281A_16MB_PG512"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27US08281A_TOTAL_BANKS	(NAND_DEVICES * NAND_HY27US08281A_BANKS_PER_DEVICE)

#if (NAND_HY27US08281A_TOTAL_BANKS == 1)
#define NAND_HY27US08281A_CONTROL		(__NAND_HY27US08281A_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27US08281A_TOTAL_BANKS == 2)
#define NAND_HY27US08281A_CONTROL		(__NAND_HY27US08281A_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27US08281A_TOTAL_BANKS == 4)
#define NAND_HY27US08281A_CONTROL		(__NAND_HY27US08281A_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27US08281A_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27US08281A_BB_MARKER_OFFSET	5	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27US08281A_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27US08281A_TCLS		0
#define NAND_HY27US08281A_TALS		0
#define NAND_HY27US08281A_TCS		0
#define NAND_HY27US08281A_TDS		20
#define NAND_HY27US08281A_TCLH		10
#define NAND_HY27US08281A_TALH		10
#define NAND_HY27US08281A_TCH		10
#define NAND_HY27US08281A_TDH		10
#define NAND_HY27US08281A_TWP		25
#define NAND_HY27US08281A_TWH		15
#define NAND_HY27US08281A_TWB		100
#define NAND_HY27US08281A_TRR		20
#define NAND_HY27US08281A_TRP		25
#define NAND_HY27US08281A_TREH		15
#define NAND_HY27US08281A_TRB		100
#define NAND_HY27US08281A_TCEH		100
#define NAND_HY27US08281A_TRDELAY		30	/* trea*/
#define NAND_HY27US08281A_TCLR		10
#define NAND_HY27US08281A_TWHR		60
#define NAND_HY27US08281A_TIR		0
#define NAND_HY27US08281A_TWW		25	/* not define */
#define NAND_HY27US08281A_TRHZ		30	/* use max value */
#define NAND_HY27US08281A_TAR		10

#endif

