/**
 * @file system/include/flash/slcnand/hy27us4g86f2d.h
 *
 * History:
 *    2011/06/09 - [Geng Ken Wu] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27US4G86f2D_H__
#define __HY27US4G86f2D_H__

#define __NAND_HY27US4G86f2D_CONTROL						  \
	(NAND_CTR_P3		|				  \
	 NAND_CTR_C2		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_4G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27US4G86f2D_MANID		0xad
#define NAND_HY27US4G86f2D_DEVID		0xdc
#define NAND_HY27US4G86f2D_ID3		0x90
#define NAND_HY27US4G86f2D_ID4		0x95

/**
 * define for device info
 */
#define NAND_HY27US4G86f2D_MAIN_SIZE		2048
#define NAND_HY27US4G86f2D_SPARE_SIZE		64
#define NAND_HY27US4G86f2D_PAGE_SIZE		2112
#define NAND_HY27US4G86f2D_PAGES_PER_BLOCK	64
#define NAND_HY27US4G86f2D_BLOCKS_PER_PLANE	2048
#define NAND_HY27US4G86f2D_BLOCKS_PER_ZONE	1024
#define NAND_HY27US4G86f2D_BLOCKS_PER_BANK	4096
#define NAND_HY27US4G86f2D_PLANES_PER_BANK	(NAND_HY27US4G86f2D_BLOCKS_PER_BANK / NAND_HY27US4G86f2D_BLOCKS_PER_PLANE)
#define NAND_HY27US4G86f2D_BANKS_PER_DEVICE	1
#define NAND_HY27US4G86f2D_TOTAL_BLOCKS	(NAND_HY27US4G86f2D_BLOCKS_PER_BANK * NAND_HY27US4G86f2D_BANKS_PER_DEVICE)
#define NAND_HY27US4G86f2D_TOTAL_ZONES	(NAND_HY27US4G86f2D_TOTAL_BLOCKS / NAND_HY27US4G86f2D_BLOCKS_PER_ZONE)
#define NAND_HY27US4G86f2D_TOTAL_PLANES	(NAND_HY27US4G86f2D_TOTAL_BLOCKS / NAND_HY27US4G86f2D_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27US4G86f2D_BLOCK_ADDR_BIT	18
#define NAND_HY27US4G86f2D_PLANE_ADDR_BIT	18
#define NAND_HY27US4G86f2D_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27US4G86f2D_PLANE_ADDR_MASK	(NAND_HY27US4G86f2D_PLANE_MASK << (NAND_HY27US4G86f2D_PLANE_ADDR_BIT - \
						     NAND_HY27US4G86f2D_BLOCK_ADDR_BIT))

#define NAND_HY27US4G86f2D_PLANE_MAP		NAND_PLANE_MAP_1
#define NAND_HY27US4G86f2D_COLUMN_CYCLES	2
#define NAND_HY27US4G86f2D_PAGE_CYCLES	3
#define NAND_HY27US4G86f2D_ID_CYCLES		4
#define NAND_HY27US4G86f2D_CHIP_WIDTH		8
#define NAND_HY27US4G86f2D_CHIP_SIZE_MB	512
#define NAND_HY27US4G86f2D_BUS_WIDTH		8

#define NAND_HY27US4G86f2D	"HYNIX HY27US4G86F2D_512MB_PG2K"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27US4G86f2D_TOTAL_BANKS	(NAND_DEVICES * NAND_HY27US4G86f2D_BANKS_PER_DEVICE)

#if (NAND_HY27US4G86f2D_TOTAL_BANKS == 1)
#define NAND_HY27US4G86f2D_CONTROL		(__NAND_HY27US4G86f2D_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27US4G86f2D_TOTAL_BANKS == 2)
#define NAND_HY27US4G86f2D_CONTROL		(__NAND_HY27US4G86f2D_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27US4G86f2D_TOTAL_BANKS == 4)
#define NAND_HY27US4G86f2D_CONTROL		(__NAND_HY27US4G86f2D_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27US4G86f2D_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27US4G86f2D_BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27US4G86f2D_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27US4G86f2D_TCLS		12
#define NAND_HY27US4G86f2D_TALS		12
#define NAND_HY27US4G86f2D_TCS		20
#define NAND_HY27US4G86f2D_TDS		12
#define NAND_HY27US4G86f2D_TCLH		5
#define NAND_HY27US4G86f2D_TALH		5
#define NAND_HY27US4G86f2D_TCH		5
#define NAND_HY27US4G86f2D_TDH		5
#define NAND_HY27US4G86f2D_TWP		12
#define NAND_HY27US4G86f2D_TWH		10
#define NAND_HY27US4G86f2D_TWB		100
#define NAND_HY27US4G86f2D_TRR		20
#define NAND_HY27US4G86f2D_TRP		12
#define NAND_HY27US4G86f2D_TREH		10
#define NAND_HY27US4G86f2D_TRB		100
#define NAND_HY27US4G86f2D_TCEH		30	/* not define */
#define NAND_HY27US4G86f2D_TRDELAY		22	/* trea*/
#define NAND_HY27US4G86f2D_TCLR		10
#define NAND_HY27US4G86f2D_TWHR		60
#define NAND_HY27US4G86f2D_TIR		0
#define NAND_HY27US4G86f2D_TWW		100
#define NAND_HY27US4G86f2D_TRHZ		100
#define NAND_HY27US4G86f2D_TAR		10

#endif

