/**
 * @file system/include/flash/slcnand/k9k4g08.h
 *
 * History:
 *    2005/06/23 - [Chien Yang Chen] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __K9F1G08_H__
#define __K9F1G08_H__

/**
 * nand control register initial setting
 */
#define __NAND_K9F1G08_CONTROL						  \
	(NAND_CTR_C2		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_1G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_K9F1G08_MANID		0xec
#define NAND_K9F1G08_DEVID		0xf1
#define NAND_K9F1G08_ID3		0x00
#define NAND_K9F1G08_ID4		0x00

/**
 * define for device info
 */
#define NAND_K9F1G08_MAIN_SIZE		2048
#define NAND_K9F1G08_SPARE_SIZE		64
#define NAND_K9F1G08_PAGE_SIZE		2112
#define NAND_K9F1G08_PAGES_PER_BLOCK	64
#define NAND_K9F1G08_BLOCKS_PER_PLANE	1024
#define NAND_K9F1G08_BLOCKS_PER_ZONE	1024
#define NAND_K9F1G08_BLOCKS_PER_BANK	1024
#define NAND_K9F1G08_PLANES_PER_BANK	(NAND_K9F1G08_BLOCKS_PER_BANK / NAND_K9F1G08_BLOCKS_PER_PLANE)
#define NAND_K9F1G08_BANKS_PER_DEVICE	1
#define NAND_K9F1G08_TOTAL_BLOCKS	(NAND_K9F1G08_BLOCKS_PER_BANK * NAND_K9F1G08_BANKS_PER_DEVICE)
#define NAND_K9F1G08_TOTAL_ZONES	(NAND_K9F1G08_TOTAL_BLOCKS / NAND_K9F1G08_BLOCKS_PER_ZONE)
#define NAND_K9F1G08_TOTAL_PLANES	(NAND_K9F1G08_TOTAL_BLOCKS / NAND_K9F1G08_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_K9F1G08_BLOCK_ADDR_BIT	18
#define NAND_K9F1G08_PLANE_ADDR_BIT	28 /* A28 must be the same for copyback */
#define NAND_K9F1G08_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_K9F1G08_PLANE_ADDR_MASK	(NAND_K9F1G08_PLANE_MASK << (NAND_K9F1G08_PLANE_ADDR_BIT - \
						     NAND_K9F1G08_BLOCK_ADDR_BIT))

#define NAND_K9F1G08_PLANE_MAP		NAND_K9F1G08_PLANE_MAP_2
#define NAND_K9F1G08_COLUMN_CYCLES	2
#define NAND_K9F1G08_PAGE_CYCLES	2
#define NAND_K9F1G08_ID_CYCLES		4
#define NAND_K9F1G08_CHIP_WIDTH		8
#define NAND_K9F1G08_CHIP_SIZE_MB	128
#define NAND_K9F1G08_BUS_WIDTH		8

#define NAND_K9F1G08	"SAMSUNG K9F1G08_128MB_PG2K"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_K9F1G08_TOTAL_BANKS	(NAND_DEVICES * NAND_K9F1G08_BANKS_PER_DEVICE)

#if (NAND_K9F1G08_TOTAL_BANKS == 1)
#define NAND_K9F1G08_CONTROL		(__NAND_K9F1G08_CONTROL | NAND_CTR_1BANK)
#elif (NAND_K9F1G08_TOTAL_BANKS == 2)
#define NAND_K9F1G08_CONTROL		(__NAND_K9F1G08_CONTROL | NAND_CTR_2BANK)
#elif (NAND_K9F1G08_TOTAL_BANKS == 4)
#define NAND_K9F1G08_CONTROL		(__NAND_K9F1G08_CONTROL | NAND_CTR_4BANK)
#elif (NAND_K9F1G08_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_K9F1G08_BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_K9F1G08_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_K9F1G08_TCLS		15
#define NAND_K9F1G08_TALS		15
#define NAND_K9F1G08_TCS		20
#define NAND_K9F1G08_TDS		15
#define NAND_K9F1G08_TCLH		5
#define NAND_K9F1G08_TALH		5
#define NAND_K9F1G08_TCH		5
#define NAND_K9F1G08_TDH		5
#define NAND_K9F1G08_TWP		15
#define NAND_K9F1G08_TWH		10
#define NAND_K9F1G08_TWB		100
#define NAND_K9F1G08_TRR		20
#define NAND_K9F1G08_TRP		15
#define NAND_K9F1G08_TREH		10
#define NAND_K9F1G08_TRB		100 /* not defined in datasheet */
#define NAND_K9F1G08_TCEH		10  /* trhz - tchz = 30 - 20 = 10 */
#define NAND_K9F1G08_TRDELAY		30  /* trea */
#define NAND_K9F1G08_TCLR		10
#define NAND_K9F1G08_TWHR		60
#define NAND_K9F1G08_TIR		0
#define NAND_K9F1G08_TWW		25  /* not defined in datasheet */
#define NAND_K9F1G08_TRHZ		30
#define NAND_K9F1G08_TAR		10

#endif
