/*
 * (C) Copyright 2006-2008
 * Texas Instruments, <www.ti.com>
 * Richard Woodruff <r-woodruff2@ti.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR /PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#ifndef _CLOCKS_TI814X_H_
#define _CLOCKS_TI814X_H_


#include <configs/ti8148_ipnc.h>

#define OSC_0_FREQ	20

/* Put the pll config values over here */
#define AUDIO_N		19
#define AUDIO_M		500
#define AUDIO_M2	2
#define AUDIO_CLKCTRL	0x801

#define MODENA_N	0x1
#define MODENA_M	60
//#define MODENA_M_1G      100//husj@add 2012-2-7
#define MODENA_M2	1
#define MODENA_CLKCTRL	0x1

#define L3_N		19
//#define L3_M		800
#define L3_M2		4
#define L3_CLKCTRL	0x801

#define DDR_N		19


#define DDR_M2		2
#define DDR_CLKCTRL	0x801

#define DSP_N		19
#define DSP_M		500
//#define DSP_M_750      750
#define DSP_M2		1
#define DSP_CLKCTRL	0x801

#define DSS_N		19


#define DSS_M2		4
#define DSS_CLKCTRL	0x801

#define IVA_N		19



#define IVA_M2		2
#define IVA_CLKCTRL	0x801
#define ISS_N		19

#define ISS_M2		(pg_val_ti814x(2, 2))
#define ISS_CLKCTRL	0x801

#define USB_N		19
#define USB_M		960
#define USB_M2		(pg_val_ti814x(1, 5))
#define USB_CLKCTRL	0x200a0801

#define HDMI_N		19
#define HDMI_M		1485
#define HDMI_M2		10
#define HDMI_CLKCTRL	0x290a1001

#define VIDEO0_N		19
#define VIDEO0_M		540
#define VIDEO0_M2		10
#define VIDEO0_CLKCTRL	0x09000801

#define VIDEO1_N		19
#define VIDEO1_M		1485
#define VIDEO1_M2		10
#define VIDEO1_CLKCTRL	0x290a1001

#if defined(CONFIG_DDR_SPEED_533)
#if 1
#define MODENA_M_1G      100//husj@add 2012-2-7

#define  DDR_M	       1066  
#define  DSS_M            (pg_val_ti814x(800, 880))
//#define  IVA_M	      (pg_val_ti814x(612, 820))
//#define  ISS_M            960
#define  L3_M		880
#define DSP_M_750      750

#define  IVA_M	      (pg_val_ti814x(612, 920))
#define  IVA_M_450    (pg_val_ti814x(612, 900))
#define  ISS_M             1120
#else
#define  DDR_M            1066
#define  DSS_M		(pg_val_ti814x(800, 800))
#define  IVA_M		(pg_val_ti814x(532, 612))  //(pg_val_ti814x(612, 532))
#define  ISS_M		800
#define  L3_M		        800
#endif
#else

#if 0
#define  DDR_M            800
#define  DSS_M		(pg_val_ti814x(800, 800))
#define  IVA_M		(pg_val_ti814x(612, 532))  //(pg_val_ti814x(612, 532))
#define  ISS_M		800
#define  L3_M		800
#else

#define MODENA_M_1G      60//husj@add 2012-2-7

#define  DDR_M             800
#define  DSS_M		(pg_val_ti814x(800, 800))
#define  IVA_M		(pg_val_ti814x(532, 612))  //(pg_val_ti814x(612, 532))
#define  ISS_M		800
#define  L3_M		        800

#define DSP_M_750      600
#endif
#endif

#endif	/* endif _CLOCKS_TI814X_H_ */

